/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty4;

import io.netty.channel.Channel;
import io.netty.util.concurrent.Future;
import java.net.InetSocketAddress;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.concurrent.ListenableFuture;
import org.elasticsearch.http.HttpServerChannel;
import org.elasticsearch.transport.netty4.Netty4Utils;

public class Netty4HttpServerChannel
implements HttpServerChannel {
    private final Channel channel;
    private final ListenableFuture<Void> closeContext = new ListenableFuture();

    Netty4HttpServerChannel(Channel channel) {
        this.channel = channel;
        Netty4Utils.addListener((Future<Void>)this.channel.closeFuture(), this.closeContext);
    }

    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.channel.localAddress();
    }

    public void addCloseListener(ActionListener<Void> listener) {
        this.closeContext.addListener(listener);
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public void close() {
        this.channel.close();
    }

    public String toString() {
        return "Netty4HttpChannel{localAddress=" + this.getLocalAddress() + "}";
    }
}

