/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty4;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.AdaptiveRecvByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.TcpTransport;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.netty4.Netty4MessageChannelHandler;
import org.elasticsearch.transport.netty4.Netty4OpenChannelsHandler;
import org.elasticsearch.transport.netty4.Netty4SizeHeaderFrameDecoder;
import org.elasticsearch.transport.netty4.Netty4Utils;

public class Netty4Transport
extends TcpTransport<Channel> {
    public static final Setting<Integer> WORKER_COUNT;
    public static final Setting<ByteSizeValue> NETTY_MAX_CUMULATION_BUFFER_CAPACITY;
    public static final Setting<Integer> NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS;
    public static final Setting<ByteSizeValue> NETTY_RECEIVE_PREDICTOR_SIZE;
    public static final Setting<ByteSizeValue> NETTY_RECEIVE_PREDICTOR_MIN;
    public static final Setting<ByteSizeValue> NETTY_RECEIVE_PREDICTOR_MAX;
    public static final Setting<Integer> NETTY_BOSS_COUNT;
    protected final ByteSizeValue maxCumulationBufferCapacity;
    protected final int maxCompositeBufferComponents;
    protected final RecvByteBufAllocator recvByteBufAllocator;
    protected final int workerCount;
    protected final ByteSizeValue receivePredictorMin;
    protected final ByteSizeValue receivePredictorMax;
    volatile Netty4OpenChannelsHandler serverOpenChannels;
    protected volatile Bootstrap bootstrap;
    protected final Map<String, ServerBootstrap> serverBootstraps = ConcurrentCollections.newConcurrentMap();

    public Netty4Transport(Settings settings, ThreadPool threadPool, NetworkService networkService, BigArrays bigArrays, NamedWriteableRegistry namedWriteableRegistry, CircuitBreakerService circuitBreakerService) {
        super("netty", settings, threadPool, bigArrays, circuitBreakerService, namedWriteableRegistry, networkService);
        Netty4Utils.setAvailableProcessors((Integer)EsExecutors.PROCESSORS_SETTING.get(settings));
        this.workerCount = (Integer)WORKER_COUNT.get(settings);
        this.maxCumulationBufferCapacity = (ByteSizeValue)NETTY_MAX_CUMULATION_BUFFER_CAPACITY.get(settings);
        this.maxCompositeBufferComponents = (Integer)NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS.get(settings);
        this.receivePredictorMin = (ByteSizeValue)NETTY_RECEIVE_PREDICTOR_MIN.get(settings);
        this.receivePredictorMax = (ByteSizeValue)NETTY_RECEIVE_PREDICTOR_MAX.get(settings);
        this.recvByteBufAllocator = this.receivePredictorMax.getBytes() == this.receivePredictorMin.getBytes() ? new FixedRecvByteBufAllocator((int)this.receivePredictorMax.getBytes()) : new AdaptiveRecvByteBufAllocator((int)this.receivePredictorMin.getBytes(), (int)this.receivePredictorMin.getBytes(), (int)this.receivePredictorMax.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() {
        boolean success = false;
        try {
            this.bootstrap = this.createBootstrap();
            if (((Boolean)NetworkService.NETWORK_SERVER.get(this.settings)).booleanValue()) {
                Netty4OpenChannelsHandler openChannels;
                this.serverOpenChannels = openChannels = new Netty4OpenChannelsHandler(this.logger);
                for (TcpTransport.ProfileSettings profileSettings : this.profileSettings) {
                    this.createServerBootstrap(profileSettings);
                    this.bindServer(profileSettings);
                }
            }
            super.doStart();
            success = true;
        }
        finally {
            if (!success) {
                this.doStop();
            }
        }
    }

    private Bootstrap createBootstrap() {
        ByteSizeValue tcpReceiveBufferSize;
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group((EventLoopGroup)new NioEventLoopGroup(this.workerCount, EsExecutors.daemonThreadFactory((Settings)this.settings, (String)"transport_client_boss")));
        bootstrap.channel(NioSocketChannel.class);
        bootstrap.handler(this.getClientChannelInitializer());
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)Math.toIntExact(this.defaultConnectionProfile.getConnectTimeout().millis()));
        bootstrap.option(ChannelOption.TCP_NODELAY, TCP_NO_DELAY.get(this.settings));
        bootstrap.option(ChannelOption.SO_KEEPALIVE, TCP_KEEP_ALIVE.get(this.settings));
        ByteSizeValue tcpSendBufferSize = (ByteSizeValue)TCP_SEND_BUFFER_SIZE.get(this.settings);
        if (tcpSendBufferSize.getBytes() > 0L) {
            bootstrap.option(ChannelOption.SO_SNDBUF, (Object)Math.toIntExact(tcpSendBufferSize.getBytes()));
        }
        if ((tcpReceiveBufferSize = (ByteSizeValue)TCP_RECEIVE_BUFFER_SIZE.get(this.settings)).getBytes() > 0L) {
            bootstrap.option(ChannelOption.SO_RCVBUF, (Object)Math.toIntExact(tcpReceiveBufferSize.getBytes()));
        }
        bootstrap.option(ChannelOption.RCVBUF_ALLOCATOR, (Object)this.recvByteBufAllocator);
        boolean reuseAddress = (Boolean)TCP_REUSE_ADDRESS.get(this.settings);
        bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)reuseAddress);
        bootstrap.validate();
        return bootstrap;
    }

    private void createServerBootstrap(TcpTransport.ProfileSettings profileSettings) {
        String name = profileSettings.profileName;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("using profile[{}], worker_count[{}], port[{}], bind_host[{}], publish_host[{}], compress[{}], connect_timeout[{}], connections_per_node[{}/{}/{}/{}/{}], receive_predictor[{}->{}]", new Object[]{name, this.workerCount, profileSettings.portOrRange, profileSettings.bindHosts, profileSettings.publishHosts, this.compress, this.defaultConnectionProfile.getConnectTimeout(), this.defaultConnectionProfile.getNumConnectionsPerType(TransportRequestOptions.Type.RECOVERY), this.defaultConnectionProfile.getNumConnectionsPerType(TransportRequestOptions.Type.BULK), this.defaultConnectionProfile.getNumConnectionsPerType(TransportRequestOptions.Type.REG), this.defaultConnectionProfile.getNumConnectionsPerType(TransportRequestOptions.Type.STATE), this.defaultConnectionProfile.getNumConnectionsPerType(TransportRequestOptions.Type.PING), this.receivePredictorMin, this.receivePredictorMax});
        }
        ThreadFactory workerFactory = EsExecutors.daemonThreadFactory((Settings)this.settings, (String[])new String[]{"transport_server_worker", name});
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        serverBootstrap.group((EventLoopGroup)new NioEventLoopGroup(this.workerCount, workerFactory));
        serverBootstrap.channel(NioServerSocketChannel.class);
        serverBootstrap.childHandler(this.getServerChannelInitializer(name));
        serverBootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)profileSettings.tcpNoDelay);
        serverBootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)profileSettings.tcpKeepAlive);
        if (profileSettings.sendBufferSize.getBytes() != -1L) {
            serverBootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)Math.toIntExact(profileSettings.sendBufferSize.getBytes()));
        }
        if (profileSettings.receiveBufferSize.getBytes() != -1L) {
            serverBootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)Math.toIntExact(profileSettings.receiveBufferSize.bytesAsInt()));
        }
        serverBootstrap.option(ChannelOption.RCVBUF_ALLOCATOR, (Object)this.recvByteBufAllocator);
        serverBootstrap.childOption(ChannelOption.RCVBUF_ALLOCATOR, (Object)this.recvByteBufAllocator);
        serverBootstrap.option(ChannelOption.SO_REUSEADDR, (Object)profileSettings.reuseAddress);
        serverBootstrap.childOption(ChannelOption.SO_REUSEADDR, (Object)profileSettings.reuseAddress);
        serverBootstrap.validate();
        this.serverBootstraps.put(name, serverBootstrap);
    }

    protected ChannelHandler getServerChannelInitializer(String name) {
        return new ServerChannelInitializer(name);
    }

    protected ChannelHandler getClientChannelInitializer() {
        return new ClientChannelInitializer();
    }

    protected final void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Throwable unwrapped = ExceptionsHelper.unwrap((Throwable)cause, (Class[])new Class[]{ElasticsearchException.class});
        Throwable t = unwrapped != null ? unwrapped : cause;
        this.onException(ctx.channel(), t instanceof Exception ? (Exception)t : new ElasticsearchException(t));
    }

    public long getNumOpenServerConnections() {
        Netty4OpenChannelsHandler channels = this.serverOpenChannels;
        return channels == null ? 0L : channels.numberOfOpenChannels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TcpTransport.NodeChannels connectToChannels(DiscoveryNode node, ConnectionProfile profile, Consumer<Channel> onChannelClose) {
        Object[] channels = new Channel[profile.getNumConnections()];
        TcpTransport.NodeChannels nodeChannels = new TcpTransport.NodeChannels((TcpTransport)this, node, channels, profile);
        boolean success = false;
        try {
            TimeValue connectTimeout;
            Bootstrap bootstrap;
            TimeValue defaultConnectTimeout = this.defaultConnectionProfile.getConnectTimeout();
            if (profile.getConnectTimeout() != null && !profile.getConnectTimeout().equals((Object)defaultConnectTimeout)) {
                bootstrap = this.bootstrap.clone(this.bootstrap.config().group());
                bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)Math.toIntExact(profile.getConnectTimeout().millis()));
                connectTimeout = profile.getConnectTimeout();
            } else {
                connectTimeout = defaultConnectTimeout;
                bootstrap = this.bootstrap;
            }
            ArrayList<ChannelFuture> connections = new ArrayList<ChannelFuture>(channels.length);
            InetSocketAddress address = node.getAddress().address();
            for (int i = 0; i < channels.length; ++i) {
                connections.add(bootstrap.connect((SocketAddress)address));
            }
            Iterator iterator = connections.iterator();
            ChannelFutureListener closeListener = future -> onChannelClose.accept(future.channel());
            try {
                for (int i = 0; i < channels.length; ++i) {
                    assert (iterator.hasNext());
                    ChannelFuture future2 = (ChannelFuture)iterator.next();
                    future2.awaitUninterruptibly((long)((double)connectTimeout.millis() * 1.5));
                    if (!future2.isSuccess()) {
                        throw new ConnectTransportException(node, "connect_timeout[" + connectTimeout + "]", future2.cause());
                    }
                    channels[i] = future2.channel();
                    channels[i].closeFuture().addListener((GenericFutureListener)closeListener);
                }
                assert (!iterator.hasNext()) : "not all created connection have been consumed";
            }
            catch (RuntimeException e) {
                for (ChannelFuture future3 : Collections.unmodifiableList(connections)) {
                    FutureUtils.cancel((java.util.concurrent.Future)future3);
                    if (future3.channel() == null || !future3.channel().isOpen()) continue;
                    try {
                        future3.channel().close();
                    }
                    catch (Exception inner) {
                        e.addSuppressed(inner);
                    }
                }
                throw e;
            }
            success = true;
        }
        finally {
            if (!success) {
                try {
                    nodeChannels.close();
                }
                catch (IOException e) {
                    this.logger.trace("exception while closing channels", (Throwable)e);
                }
            }
        }
        return nodeChannels;
    }

    protected void sendMessage(Channel channel, BytesReference reference, ActionListener<Channel> listener) {
        ChannelFuture future = channel.writeAndFlush((Object)Netty4Utils.toByteBuf(reference));
        future.addListener(f -> {
            if (f.isSuccess()) {
                listener.onResponse((Object)channel);
            } else {
                Throwable cause = f.cause();
                if (cause instanceof Exception) {
                    listener.onFailure((Exception)cause);
                }
            }
        });
    }

    protected void closeChannels(List<Channel> channels, boolean blocking) throws IOException {
        if (blocking) {
            Netty4Utils.closeChannels(channels);
        } else {
            for (Channel channel : channels) {
                if (channel == null || !channel.isOpen()) continue;
                ChannelFuture closeFuture = channel.close();
                closeFuture.addListener(f -> {
                    if (!f.isSuccess()) {
                        this.logger.warn("failed to close channel", f.cause());
                    }
                });
            }
        }
    }

    protected InetSocketAddress getLocalAddress(Channel channel) {
        return (InetSocketAddress)channel.localAddress();
    }

    protected Channel bind(String name, InetSocketAddress address) {
        return this.serverBootstraps.get(name).bind((SocketAddress)address).syncUninterruptibly().channel();
    }

    TcpTransport.ScheduledPing getPing() {
        return this.scheduledPing;
    }

    protected boolean isOpen(Channel channel) {
        return channel.isOpen();
    }

    @SuppressForbidden(reason="debug")
    protected void stopInternal() {
        Releasables.close((Releasable[])new Releasable[]{this.serverOpenChannels, () -> {
            ArrayList<Tuple> serverBootstrapCloseFutures = new ArrayList<Tuple>(this.serverBootstraps.size());
            for (Map.Entry<String, ServerBootstrap> entry : this.serverBootstraps.entrySet()) {
                serverBootstrapCloseFutures.add(Tuple.tuple((Object)entry.getKey(), (Object)entry.getValue().config().group().shutdownGracefully(0L, 5L, TimeUnit.SECONDS)));
            }
            for (Tuple future : serverBootstrapCloseFutures) {
                ((Future)future.v2()).awaitUninterruptibly();
                if (((Future)future.v2()).isSuccess()) continue;
                this.logger.debug(() -> new ParameterizedMessage("Error closing server bootstrap for profile [{}]", future.v1()), ((Future)future.v2()).cause());
            }
            this.serverBootstraps.clear();
            if (this.bootstrap != null) {
                this.bootstrap.config().group().shutdownGracefully(0L, 5L, TimeUnit.SECONDS).awaitUninterruptibly();
                this.bootstrap = null;
            }
        }});
    }

    static {
        Netty4Utils.setup();
        WORKER_COUNT = new Setting("transport.netty.worker_count", s -> Integer.toString(EsExecutors.numberOfProcessors((Settings)s) * 2), s -> Setting.parseInt((String)s, (int)1, (String)"transport.netty.worker_count"), new Setting.Property[]{Setting.Property.NodeScope});
        NETTY_MAX_CUMULATION_BUFFER_CAPACITY = Setting.byteSizeSetting((String)"transport.netty.max_cumulation_buffer_capacity", (ByteSizeValue)new ByteSizeValue(-1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS = Setting.intSetting((String)"transport.netty.max_composite_buffer_components", (int)-1, (int)-1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        NETTY_RECEIVE_PREDICTOR_SIZE = Setting.byteSizeSetting((String)"transport.netty.receive_predictor_size", (ByteSizeValue)new ByteSizeValue(64L, ByteSizeUnit.KB), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        NETTY_RECEIVE_PREDICTOR_MIN = Setting.byteSizeSetting((String)"transport.netty.receive_predictor_min", NETTY_RECEIVE_PREDICTOR_SIZE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        NETTY_RECEIVE_PREDICTOR_MAX = Setting.byteSizeSetting((String)"transport.netty.receive_predictor_max", NETTY_RECEIVE_PREDICTOR_SIZE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        NETTY_BOSS_COUNT = Setting.intSetting((String)"transport.netty.boss_count", (int)1, (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    }

    protected class ServerChannelInitializer
    extends ChannelInitializer<Channel> {
        protected final String name;

        protected ServerChannelInitializer(String name) {
            this.name = name;
        }

        protected void initChannel(Channel ch) throws Exception {
            ch.pipeline().addLast("open_channels", (ChannelHandler)Netty4Transport.this.serverOpenChannels);
            ch.pipeline().addLast("size", (ChannelHandler)new Netty4SizeHeaderFrameDecoder());
            ch.pipeline().addLast("dispatcher", (ChannelHandler)new Netty4MessageChannelHandler(Netty4Transport.this, this.name));
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            Netty4Utils.maybeDie(cause);
            super.exceptionCaught(ctx, cause);
        }
    }

    protected class ClientChannelInitializer
    extends ChannelInitializer<Channel> {
        protected ClientChannelInitializer() {
        }

        protected void initChannel(Channel ch) throws Exception {
            ch.pipeline().addLast("size", (ChannelHandler)new Netty4SizeHeaderFrameDecoder());
            ch.pipeline().addLast("dispatcher", (ChannelHandler)new Netty4MessageChannelHandler(Netty4Transport.this, ".client"));
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            Netty4Utils.maybeDie(cause);
            super.exceptionCaught(ctx, cause);
        }
    }
}

