/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.security.AccessController;
import java.security.Permission;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.network.NetworkModule;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.http.netty4.Netty4HttpServerTransport;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.transport.netty4.Netty4Transport;

public class Netty4Plugin
extends Plugin {
    public static final String NETTY_TRANSPORT_NAME = "netty4";
    public static final String NETTY_HTTP_TRANSPORT_NAME = "netty4";

    public Netty4Plugin(Settings settings) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        AccessController.doPrivileged(() -> {
            try {
                Class.forName("io.netty.channel.nio.NioEventLoop");
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError((Object)e);
            }
            return null;
        });
        if (settings.getAsBoolean("netty.assert.buglevel", Boolean.valueOf(true)).booleanValue()) assert (System.getProperty("sun.nio.ch.bugLevel") != null) : "sun.nio.ch.bugLevel is null somebody pulls in SelectorUtil without doing stuff in a doPrivileged block?";
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(Netty4HttpServerTransport.SETTING_HTTP_NETTY_MAX_CUMULATION_BUFFER_CAPACITY, Netty4HttpServerTransport.SETTING_HTTP_NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS, Netty4HttpServerTransport.SETTING_HTTP_WORKER_COUNT, Netty4HttpServerTransport.SETTING_HTTP_TCP_NO_DELAY, Netty4HttpServerTransport.SETTING_HTTP_TCP_KEEP_ALIVE, Netty4HttpServerTransport.SETTING_HTTP_TCP_BLOCKING_SERVER, Netty4HttpServerTransport.SETTING_HTTP_TCP_REUSE_ADDRESS, Netty4HttpServerTransport.SETTING_HTTP_TCP_SEND_BUFFER_SIZE, Netty4HttpServerTransport.SETTING_HTTP_TCP_RECEIVE_BUFFER_SIZE, Netty4Transport.WORKER_COUNT, Netty4Transport.NETTY_MAX_CUMULATION_BUFFER_CAPACITY, Netty4Transport.NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS, Netty4Transport.NETTY_RECEIVE_PREDICTOR_SIZE, Netty4Transport.NETTY_RECEIVE_PREDICTOR_MIN, Netty4Transport.NETTY_RECEIVE_PREDICTOR_MAX, Netty4Transport.NETTY_BOSS_COUNT);
    }

    public Settings additionalSettings() {
        return Settings.builder().put(NetworkModule.HTTP_DEFAULT_TYPE_SETTING.getKey(), "netty4").put(NetworkModule.TRANSPORT_DEFAULT_TYPE_SETTING.getKey(), "netty4").build();
    }

    public void onModule(NetworkModule networkModule) {
        if (networkModule.canRegisterHttpExtensions()) {
            networkModule.registerHttpTransport("netty4", Netty4HttpServerTransport.class);
        }
        networkModule.registerTransport("netty4", Netty4Transport.class);
    }
}

