/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.replication.ReplicationRequest;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.ParseFieldMatcherSupplier;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.reindex.AbstractBaseReindexRestHandler;
import org.elasticsearch.index.reindex.AbstractBulkByScrollRequest;
import org.elasticsearch.index.reindex.ReindexAction;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.index.reindex.remote.RemoteInfo;
import org.elasticsearch.indices.query.IndicesQueriesRegistry;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.aggregations.AggregatorParsers;
import org.elasticsearch.search.suggest.Suggesters;

public class RestReindexAction
extends AbstractBaseReindexRestHandler<ReindexRequest, ReindexAction> {
    static final ObjectParser<ReindexRequest, ReindexParseContext> PARSER = new ObjectParser("reindex");
    private static final Pattern HOST_PATTERN = Pattern.compile("(?<scheme>[^:]+)://(?<host>[^:]+):(?<port>\\d+)");

    @Inject
    public RestReindexAction(Settings settings, RestController controller, IndicesQueriesRegistry indicesQueriesRegistry, AggregatorParsers aggParsers, Suggesters suggesters, ClusterService clusterService) {
        super(settings, indicesQueriesRegistry, aggParsers, suggesters, clusterService, ReindexAction.INSTANCE);
        controller.registerHandler(RestRequest.Method.POST, "/_reindex", (RestHandler)this);
    }

    public void handleRequest(RestRequest request, RestChannel channel, NodeClient client) throws IOException {
        if (!request.hasContent()) {
            throw new ElasticsearchException("_reindex requires a request body", new Object[0]);
        }
        this.handleRequest(request, channel, client, true, true);
    }

    @Override
    protected ReindexRequest buildRequest(RestRequest request) throws IOException {
        ReindexRequest internal = new ReindexRequest(new SearchRequest(), new IndexRequest());
        try (XContentParser xcontent = XContentFactory.xContent((BytesReference)request.content()).createParser(request.content());){
            PARSER.parse(xcontent, (Object)internal, (ParseFieldMatcherSupplier)new ReindexParseContext(this.indicesQueriesRegistry, this.aggParsers, this.suggesters, this.parseFieldMatcher));
        }
        return internal;
    }

    static RemoteInfo buildRemoteInfo(Map<String, Object> source) throws IOException {
        Map remote = (Map)source.remove("remote");
        if (remote == null) {
            return null;
        }
        String username = RestReindexAction.extractString(remote, "username");
        String password = RestReindexAction.extractString(remote, "password");
        String hostInRequest = Objects.requireNonNull(RestReindexAction.extractString(remote, "host"), "[host] must be specified to reindex from a remote cluster");
        Matcher hostMatcher = HOST_PATTERN.matcher(hostInRequest);
        if (!hostMatcher.matches()) {
            throw new IllegalArgumentException("[host] must be of the form [scheme]://[host]:[port] but was [" + hostInRequest + "]");
        }
        String scheme = hostMatcher.group("scheme");
        String host = hostMatcher.group("host");
        int port = Integer.parseInt(hostMatcher.group("port"));
        Map<String, String> headers = RestReindexAction.extractStringStringMap(remote, "headers");
        if (!remote.isEmpty()) {
            throw new IllegalArgumentException("Unsupported fields in [remote]: [" + Strings.collectionToCommaDelimitedString(remote.keySet()) + "]");
        }
        return new RemoteInfo(scheme, host, port, RestReindexAction.queryForRemote(source), username, password, headers);
    }

    private static String[] extractStringArray(Map<String, Object> source, String name) {
        Object value = source.remove(name);
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            List list = (List)value;
            return list.toArray(new String[list.size()]);
        }
        if (value instanceof String) {
            return new String[]{(String)value};
        }
        throw new IllegalArgumentException("Expected [" + name + "] to be a list of a string but was [" + value + ']');
    }

    private static String extractString(Map<String, Object> source, String name) {
        Object value = source.remove(name);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        throw new IllegalArgumentException("Expected [" + name + "] to be a string but was [" + value + "]");
    }

    private static Map<String, String> extractStringStringMap(Map<String, Object> source, String name) {
        Object value = source.remove(name);
        if (value == null) {
            return Collections.emptyMap();
        }
        if (!(value instanceof Map)) {
            throw new IllegalArgumentException("Expected [" + name + "] to be an object containing strings but was [" + value + "]");
        }
        Map map = (Map)value;
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getKey() instanceof String && entry.getValue() instanceof String) continue;
            throw new IllegalArgumentException("Expected [" + name + "] to be an object containing strings but has [" + entry + "]");
        }
        Map safe = map;
        return safe;
    }

    private static BytesReference queryForRemote(Map<String, Object> source) throws IOException {
        XContentBuilder builder = JsonXContent.contentBuilder().prettyPrint();
        Object query = source.remove("query");
        if (query == null) {
            return QueryBuilders.matchAllQuery().toXContent(builder, ToXContent.EMPTY_PARAMS).bytes();
        }
        if (!(query instanceof Map)) {
            throw new IllegalArgumentException("Expected [query] to be an object but was [" + query + "]");
        }
        Map map = (Map)query;
        return builder.map(map).bytes();
    }

    static {
        ObjectParser.Parser sourceParser = (parser, request, context) -> {
            String[] types;
            Map source = parser.map();
            String[] indices = RestReindexAction.extractStringArray(source, "index");
            if (indices != null) {
                request.getSearchRequest().indices(indices);
            }
            if ((types = RestReindexAction.extractStringArray(source, "type")) != null) {
                request.getSearchRequest().types(types);
            }
            request.setRemoteInfo(RestReindexAction.buildRemoteInfo(source));
            XContentBuilder builder = XContentFactory.contentBuilder((XContentType)parser.contentType());
            builder.map(source);
            try (XContentParser innerParser = parser.contentType().xContent().createParser(builder.bytes());){
                request.getSearchRequest().source().parseXContent(context.queryParseContext(innerParser), ((ReindexParseContext)context).aggParsers, ((ReindexParseContext)context).suggesters);
            }
        };
        ObjectParser destParser = new ObjectParser("dest");
        destParser.declareString(ReplicationRequest::index, new ParseField("index", new String[0]));
        destParser.declareString(IndexRequest::type, new ParseField("type", new String[0]));
        destParser.declareString(IndexRequest::routing, new ParseField("routing", new String[0]));
        destParser.declareString(IndexRequest::opType, new ParseField("op_type", new String[0]));
        destParser.declareString(IndexRequest::setPipeline, new ParseField("pipeline", new String[0]));
        destParser.declareString((s, i) -> s.versionType(VersionType.fromString((String)i)), new ParseField("version_type", new String[0]));
        destParser.declareString(IndexRequest::timestamp, new ParseField("timestamp", new String[0]));
        destParser.declareString((i, ttl) -> i.ttl(TimeValue.parseTimeValue((String)ttl, (TimeValue)TimeValue.timeValueMillis((long)-1L), (String)"ttl").millis()), new ParseField("ttl", new String[0]));
        PARSER.declareField((p, v, c) -> sourceParser.parse(p, (Object)v, c), new ParseField("source", new String[0]), ObjectParser.ValueType.OBJECT);
        PARSER.declareField((p, v, c) -> {
            IndexRequest cfr_ignored_0 = (IndexRequest)destParser.parse(p, (Object)v.getDestination(), (ParseFieldMatcherSupplier)c);
        }, new ParseField("dest", new String[0]), ObjectParser.ValueType.OBJECT);
        PARSER.declareInt(AbstractBulkByScrollRequest::setSize, new ParseField("size", new String[0]));
        PARSER.declareField((p, v, c) -> {
            ReindexRequest cfr_ignored_0 = (ReindexRequest)((Object)((Object)v.setScript(Script.parse((XContentParser)p, (ParseFieldMatcher)c.getParseFieldMatcher()))));
        }, new ParseField("script", new String[0]), ObjectParser.ValueType.OBJECT);
        PARSER.declareString(AbstractBulkByScrollRequest::setConflicts, new ParseField("conflicts", new String[0]));
    }

    static class ReindexParseContext
    implements ParseFieldMatcherSupplier {
        private final IndicesQueriesRegistry indicesQueryRegistry;
        private final ParseFieldMatcher parseFieldMatcher;
        private final AggregatorParsers aggParsers;
        private final Suggesters suggesters;

        public ReindexParseContext(IndicesQueriesRegistry indicesQueryRegistry, AggregatorParsers aggParsers, Suggesters suggesters, ParseFieldMatcher parseFieldMatcher) {
            this.indicesQueryRegistry = indicesQueryRegistry;
            this.aggParsers = aggParsers;
            this.suggesters = suggesters;
            this.parseFieldMatcher = parseFieldMatcher;
        }

        public QueryParseContext queryParseContext(XContentParser parser) {
            return new QueryParseContext(this.indicesQueryRegistry, parser, this.parseFieldMatcher);
        }

        public ParseFieldMatcher getParseFieldMatcher() {
            return this.parseFieldMatcher;
        }
    }
}

