/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.io.IOException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;

public class BulkByScrollTask
extends CancellableTask {
    private static final ESLogger logger = ESLoggerFactory.getLogger((String)BulkByScrollTask.class.getPackage().getName());
    private final AtomicLong total = new AtomicLong(0L);
    private final AtomicLong updated = new AtomicLong(0L);
    private final AtomicLong created = new AtomicLong(0L);
    private final AtomicLong deleted = new AtomicLong(0L);
    private final AtomicLong noops = new AtomicLong(0L);
    private final AtomicInteger batch = new AtomicInteger(0);
    private final AtomicLong versionConflicts = new AtomicLong(0L);
    private final AtomicLong bulkRetries = new AtomicLong(0L);
    private final AtomicLong searchRetries = new AtomicLong(0L);
    private final AtomicLong throttledNanos = new AtomicLong();
    private volatile float requestsPerSecond;
    private final AtomicReference<DelayedPrepareBulkRequest> delayedPrepareBulkRequestReference = new AtomicReference();

    public BulkByScrollTask(long id, String type, String action, String description, TaskId parentTask, float requestsPerSecond) {
        super(id, type, action, description, parentTask);
        this.setRequestsPerSecond(requestsPerSecond);
    }

    protected void onCancelled() {
        this.rethrottle(0.0f);
    }

    public Status getStatus() {
        return new Status(this.total.get(), this.updated.get(), this.created.get(), this.deleted.get(), this.batch.get(), this.versionConflicts.get(), this.noops.get(), this.bulkRetries.get(), this.searchRetries.get(), TimeValue.timeValueNanos((long)this.throttledNanos.get()), this.getRequestsPerSecond(), this.getReasonCancelled(), this.throttledUntil());
    }

    private TimeValue throttledUntil() {
        DelayedPrepareBulkRequest delayed = this.delayedPrepareBulkRequestReference.get();
        if (delayed == null) {
            return TimeValue.timeValueNanos((long)0L);
        }
        if (delayed.future == null) {
            return TimeValue.timeValueNanos((long)0L);
        }
        return TimeValue.timeValueNanos((long)Math.max(0L, delayed.future.getDelay(TimeUnit.NANOSECONDS)));
    }

    public long getSuccessfullyProcessed() {
        return this.updated.get() + this.created.get() + this.deleted.get();
    }

    void setTotal(long totalHits) {
        this.total.set(totalHits);
    }

    void countBatch() {
        this.batch.incrementAndGet();
    }

    void countNoop() {
        this.noops.incrementAndGet();
    }

    void countCreated() {
        this.created.incrementAndGet();
    }

    void countUpdated() {
        this.updated.incrementAndGet();
    }

    void countDeleted() {
        this.deleted.incrementAndGet();
    }

    void countVersionConflict() {
        this.versionConflicts.incrementAndGet();
    }

    void countBulkRetry() {
        this.bulkRetries.incrementAndGet();
    }

    void countSearchRetry() {
        this.searchRetries.incrementAndGet();
    }

    float getRequestsPerSecond() {
        return this.requestsPerSecond;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delayPrepareBulkRequest(ThreadPool threadPool, TimeValue lastBatchStartTime, int lastBatchSize, AbstractRunnable prepareBulkRequestRunnable) {
        AtomicReference<DelayedPrepareBulkRequest> atomicReference = this.delayedPrepareBulkRequestReference;
        synchronized (atomicReference) {
            TimeValue delay = this.throttleWaitTime(lastBatchStartTime, lastBatchSize);
            this.delayedPrepareBulkRequestReference.set(new DelayedPrepareBulkRequest(threadPool, this.getRequestsPerSecond(), delay, new RunOnce(prepareBulkRequestRunnable)));
        }
    }

    TimeValue throttleWaitTime(TimeValue lastBatchStartTime, int lastBatchSize) {
        long earliestNextBatchStartTime = lastBatchStartTime.nanos() + (long)this.perfectlyThrottledBatchTime(lastBatchSize);
        return TimeValue.timeValueNanos((long)Math.max(0L, earliestNextBatchStartTime - System.nanoTime()));
    }

    float perfectlyThrottledBatchTime(int lastBatchSize) {
        if (this.requestsPerSecond == Float.POSITIVE_INFINITY) {
            return 0.0f;
        }
        float targetBatchTimeInSeconds = (float)lastBatchSize / this.requestsPerSecond;
        return (float)TimeUnit.SECONDS.toNanos(1L) * targetBatchTimeInSeconds;
    }

    private void setRequestsPerSecond(float requestsPerSecond) {
        this.requestsPerSecond = requestsPerSecond;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rethrottle(float newRequestsPerSecond) {
        AtomicReference<DelayedPrepareBulkRequest> atomicReference = this.delayedPrepareBulkRequestReference;
        synchronized (atomicReference) {
            if (logger.isDebugEnabled()) {
                logger.debug("[{}]: Rethrottling to [{}] requests per second", new Object[]{this.getId(), Float.valueOf(newRequestsPerSecond)});
            }
            this.setRequestsPerSecond(newRequestsPerSecond);
            DelayedPrepareBulkRequest delayedPrepareBulkRequest = this.delayedPrepareBulkRequestReference.get();
            if (delayedPrepareBulkRequest == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("[{}]: Skipping rescheduling because there is no scheduled task", new Object[]{this.getId()});
                }
                return;
            }
            this.delayedPrepareBulkRequestReference.set(delayedPrepareBulkRequest.rethrottle(newRequestsPerSecond));
        }
    }

    private static class RunOnce
    extends AbstractRunnable {
        private final AtomicBoolean hasRun = new AtomicBoolean(false);
        private final AbstractRunnable delegate;

        public RunOnce(AbstractRunnable delegate) {
            this.delegate = delegate;
        }

        protected void doRun() throws Exception {
            if (this.hasRun.compareAndSet(false, true)) {
                this.delegate.run();
            }
        }

        public void onFailure(Exception e) {
            this.delegate.onFailure(e);
        }
    }

    class DelayedPrepareBulkRequest {
        private final ThreadPool threadPool;
        private final AbstractRunnable command;
        private final float requestsPerSecond;
        private final ScheduledFuture<?> future;

        DelayedPrepareBulkRequest(ThreadPool threadPool, float requestsPerSecond, final TimeValue delay, final AbstractRunnable command) {
            this.threadPool = threadPool;
            this.requestsPerSecond = requestsPerSecond;
            this.command = command;
            this.future = threadPool.schedule(delay, "generic", (Runnable)new AbstractRunnable(){

                protected void doRun() throws Exception {
                    BulkByScrollTask.this.throttledNanos.addAndGet(delay.nanos());
                    command.run();
                }

                public void onFailure(Exception e) {
                    command.onFailure(e);
                }
            });
        }

        DelayedPrepareBulkRequest rethrottle(float newRequestsPerSecond) {
            if (newRequestsPerSecond != 0.0f && newRequestsPerSecond < this.requestsPerSecond) {
                if (logger.isDebugEnabled()) {
                    logger.debug("[{}]: Skipping rescheduling because the new throttle [{}] is slower than the old one [{}].", new Object[]{BulkByScrollTask.this.getId(), Float.valueOf(newRequestsPerSecond), Float.valueOf(this.requestsPerSecond)});
                }
                return this;
            }
            long remainingDelay = this.future.getDelay(TimeUnit.NANOSECONDS);
            if (!FutureUtils.cancel(this.future)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("[{}]: Skipping rescheduling we couldn't cancel the task.", new Object[]{BulkByScrollTask.this.getId()});
                }
                return this;
            }
            TimeValue newDelay = this.newDelay(remainingDelay, newRequestsPerSecond);
            if (logger.isDebugEnabled()) {
                logger.debug("[{}]: Rescheduling for [{}] in the future.", new Object[]{BulkByScrollTask.this.getId(), newDelay});
            }
            return new DelayedPrepareBulkRequest(this.threadPool, this.requestsPerSecond, newDelay, this.command);
        }

        TimeValue newDelay(long remainingDelay, float newRequestsPerSecond) {
            if (remainingDelay < 0L || newRequestsPerSecond == 0.0f) {
                return TimeValue.timeValueNanos((long)0L);
            }
            return TimeValue.timeValueNanos((long)Math.round((float)remainingDelay * this.requestsPerSecond / newRequestsPerSecond));
        }
    }

    public static class Status
    implements Task.Status {
        public static final String NAME = "bulk-by-scroll";
        public static final String INCLUDE_CREATED = "include_created";
        public static final String INCLUDE_UPDATED = "include_updated";
        private final long total;
        private final long updated;
        private final long created;
        private final long deleted;
        private final int batches;
        private final long versionConflicts;
        private final long noops;
        private final long bulkRetries;
        private final long searchRetries;
        private final TimeValue throttled;
        private final float requestsPerSecond;
        private final String reasonCancelled;
        private final TimeValue throttledUntil;

        public Status(long total, long updated, long created, long deleted, int batches, long versionConflicts, long noops, long bulkRetries, long searchRetries, TimeValue throttled, float requestsPerSecond, @Nullable String reasonCancelled, TimeValue throttledUntil) {
            this.total = this.checkPositive(total, "total");
            this.updated = this.checkPositive(updated, "updated");
            this.created = this.checkPositive(created, "created");
            this.deleted = this.checkPositive(deleted, "deleted");
            this.batches = this.checkPositive(batches, "batches");
            this.versionConflicts = this.checkPositive(versionConflicts, "versionConflicts");
            this.noops = this.checkPositive(noops, "noops");
            this.bulkRetries = this.checkPositive(bulkRetries, "bulkRetries");
            this.searchRetries = this.checkPositive(searchRetries, "searchRetries");
            this.throttled = throttled;
            this.requestsPerSecond = requestsPerSecond;
            this.reasonCancelled = reasonCancelled;
            this.throttledUntil = throttledUntil;
        }

        public Status(StreamInput in) throws IOException {
            this.total = in.readVLong();
            this.updated = in.readVLong();
            this.created = in.readVLong();
            this.deleted = in.readVLong();
            this.batches = in.readVInt();
            this.versionConflicts = in.readVLong();
            this.noops = in.readVLong();
            this.bulkRetries = in.readVLong();
            this.searchRetries = in.readVLong();
            this.throttled = new TimeValue(in);
            this.requestsPerSecond = in.readFloat();
            this.reasonCancelled = in.readOptionalString();
            this.throttledUntil = new TimeValue(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.total);
            out.writeVLong(this.updated);
            out.writeVLong(this.created);
            out.writeVLong(this.deleted);
            out.writeVInt(this.batches);
            out.writeVLong(this.versionConflicts);
            out.writeVLong(this.noops);
            out.writeVLong(this.bulkRetries);
            out.writeVLong(this.searchRetries);
            this.throttled.writeTo(out);
            out.writeFloat(this.requestsPerSecond);
            out.writeOptionalString(this.reasonCancelled);
            this.throttledUntil.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.innerXContent(builder, params);
            return builder.endObject();
        }

        public XContentBuilder innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("total", this.total);
            if (params.paramAsBoolean(INCLUDE_UPDATED, true)) {
                builder.field("updated", this.updated);
            }
            if (params.paramAsBoolean(INCLUDE_CREATED, true)) {
                builder.field("created", this.created);
            }
            builder.field("deleted", this.deleted);
            builder.field("batches", this.batches);
            builder.field("version_conflicts", this.versionConflicts);
            builder.field("noops", this.noops);
            builder.startObject("retries");
            builder.field("bulk", this.bulkRetries);
            builder.field("search", this.searchRetries);
            builder.endObject();
            builder.timeValueField("throttled_millis", "throttled", this.throttled);
            builder.field("requests_per_second", this.requestsPerSecond == Float.POSITIVE_INFINITY ? -1.0f : this.requestsPerSecond);
            if (this.reasonCancelled != null) {
                builder.field("canceled", this.reasonCancelled);
            }
            builder.timeValueField("throttled_until_millis", "throttled_until", this.throttledUntil);
            return builder;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("BulkIndexByScrollResponse[");
            this.innerToString(builder);
            return builder.append(']').toString();
        }

        public void innerToString(StringBuilder builder) {
            builder.append("updated=").append(this.updated);
            builder.append(",created=").append(this.created);
            builder.append(",deleted=").append(this.deleted);
            builder.append(",batches=").append(this.batches);
            builder.append(",versionConflicts=").append(this.versionConflicts);
            builder.append(",noops=").append(this.noops);
            builder.append(",retries=").append(this.bulkRetries);
            if (this.reasonCancelled != null) {
                builder.append(",canceled=").append(this.reasonCancelled);
            }
            builder.append(",throttledUntil=").append(this.throttledUntil);
        }

        public String getWriteableName() {
            return NAME;
        }

        public long getTotal() {
            return this.total;
        }

        public long getUpdated() {
            return this.updated;
        }

        public long getCreated() {
            return this.created;
        }

        public long getDeleted() {
            return this.deleted;
        }

        public int getBatches() {
            return this.batches;
        }

        public long getVersionConflicts() {
            return this.versionConflicts;
        }

        public long getNoops() {
            return this.noops;
        }

        public long getBulkRetries() {
            return this.bulkRetries;
        }

        public long getSearchRetries() {
            return this.searchRetries;
        }

        public TimeValue getThrottled() {
            return this.throttled;
        }

        public float getRequestsPerSecond() {
            return this.requestsPerSecond;
        }

        public String getReasonCancelled() {
            return this.reasonCancelled;
        }

        public TimeValue getThrottledUntil() {
            return this.throttledUntil;
        }

        private int checkPositive(int value, String name) {
            if (value < 0) {
                throw new IllegalArgumentException(name + " must be greater than 0 but was [" + value + "]");
            }
            return value;
        }

        private long checkPositive(long value, String name) {
            if (value < 0L) {
                throw new IllegalArgumentException(name + " must be greater than 0 but was [" + value + "]");
            }
            return value;
        }
    }
}

