/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.io.IOException;
import java.util.Map;
import java.util.function.Consumer;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.reindex.AbstractBaseReindexRestHandler;
import org.elasticsearch.index.reindex.AbstractBulkByScrollRequest;
import org.elasticsearch.index.reindex.BulkIndexByScrollResponse;
import org.elasticsearch.indices.query.IndicesQueriesRegistry;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.search.RestSearchAction;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.search.aggregations.AggregatorParsers;
import org.elasticsearch.search.suggest.Suggesters;

public abstract class AbstractBulkByQueryRestHandler<Request extends AbstractBulkByScrollRequest<Request>, A extends GenericAction<Request, BulkIndexByScrollResponse>>
extends AbstractBaseReindexRestHandler<Request, A> {
    protected AbstractBulkByQueryRestHandler(Settings settings, IndicesQueriesRegistry indicesQueriesRegistry, AggregatorParsers aggParsers, Suggesters suggesters, ClusterService clusterService, A action) {
        super(settings, indicesQueriesRegistry, aggParsers, suggesters, clusterService, action);
    }

    protected void parseInternalRequest(Request internal, RestRequest restRequest, Map<String, Consumer<Object>> consumers) throws IOException {
        assert (internal != null) : "Request should not be null";
        assert (restRequest != null) : "RestRequest should not be null";
        SearchRequest searchRequest = ((AbstractBulkByScrollRequest)((Object)internal)).getSearchRequest();
        int scrollSize = searchRequest.source().size();
        searchRequest.source().size(-1);
        this.parseSearchRequest(searchRequest, restRequest, consumers);
        ((AbstractBulkByScrollRequest)((Object)internal)).setSize(searchRequest.source().size());
        searchRequest.source().size(restRequest.paramAsInt("scroll_size", scrollSize));
        String conflicts = restRequest.param("conflicts");
        if (conflicts != null) {
            ((AbstractBulkByScrollRequest)((Object)internal)).setConflicts(conflicts);
        }
        if (restRequest.hasParam("search_timeout")) {
            searchRequest.source().timeout(restRequest.paramAsTime("search_timeout", null));
        }
    }

    protected void parseSearchRequest(SearchRequest searchRequest, RestRequest restRequest, Map<String, Consumer<Object>> consumers) throws IOException {
        BytesReference content;
        assert (searchRequest != null) : "SearchRequest should not be null";
        assert (restRequest != null) : "RestRequest should not be null";
        BytesReference bytesReference = content = RestActions.hasBodyContent((RestRequest)restRequest) ? RestActions.getRestContent((RestRequest)restRequest) : null;
        if (content != null && consumers != null && consumers.size() > 0) {
            Tuple body = XContentHelper.convertToMap((BytesReference)content, (boolean)false);
            boolean modified = false;
            for (Map.Entry<String, Consumer<Object>> consumer : consumers.entrySet()) {
                Object value = ((Map)body.v2()).remove(consumer.getKey());
                if (value == null) continue;
                consumer.getValue().accept(value);
                modified = true;
            }
            if (modified) {
                try (XContentBuilder builder = XContentFactory.contentBuilder((XContentType)((XContentType)body.v1()));){
                    content = builder.map((Map)body.v2()).bytes();
                }
            }
        }
        RestSearchAction.parseSearchRequest((SearchRequest)searchRequest, (IndicesQueriesRegistry)this.indicesQueriesRegistry, (RestRequest)restRequest, (ParseFieldMatcher)this.parseFieldMatcher, (AggregatorParsers)this.aggParsers, (Suggesters)this.suggesters, (BytesReference)content);
    }
}

