/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.percolator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentLocation;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.mapper.BinaryFieldMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.BoostingQueryBuilder;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.DisMaxQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.index.query.functionscore.FunctionScoreQueryBuilder;
import org.elasticsearch.percolator.PercolateQuery;
import org.elasticsearch.percolator.QueryAnalyzer;

public class PercolatorFieldMapper
extends FieldMapper {
    public static final XContentType QUERY_BUILDER_CONTENT_TYPE = XContentType.SMILE;
    public static final Setting<Boolean> INDEX_MAP_UNMAPPED_FIELDS_AS_STRING_SETTING = Setting.boolSetting((String)"index.percolator.map_unmapped_fields_as_string", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope});
    public static final String CONTENT_TYPE = "percolator";
    private static final FieldType FIELD_TYPE = new FieldType();
    static final byte FIELD_VALUE_SEPARATOR = 0;
    static final String EXTRACTION_COMPLETE = "complete";
    static final String EXTRACTION_PARTIAL = "partial";
    static final String EXTRACTION_FAILED = "failed";
    public static final String EXTRACTED_TERMS_FIELD_NAME = "extracted_terms";
    public static final String EXTRACTION_RESULT_FIELD_NAME = "extraction_result";
    public static final String QUERY_BUILDER_FIELD_NAME = "query_builder_field";
    private final boolean mapUnmappedFieldAsString;
    private final Supplier<QueryShardContext> queryShardContext;
    private KeywordFieldMapper queryTermsField;
    private KeywordFieldMapper extractionResultField;
    private BinaryFieldMapper queryBuilderField;

    public PercolatorFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Supplier<QueryShardContext> queryShardContext, KeywordFieldMapper queryTermsField, KeywordFieldMapper extractionResultField, BinaryFieldMapper queryBuilderField) {
        super(simpleName, fieldType, defaultFieldType, indexSettings, multiFields, copyTo);
        this.queryShardContext = queryShardContext;
        this.queryTermsField = queryTermsField;
        this.extractionResultField = extractionResultField;
        this.queryBuilderField = queryBuilderField;
        this.mapUnmappedFieldAsString = (Boolean)INDEX_MAP_UNMAPPED_FIELDS_AS_STRING_SETTING.get(indexSettings);
    }

    public FieldMapper updateFieldType(Map<String, MappedFieldType> fullNameToFieldType) {
        PercolatorFieldMapper updated = (PercolatorFieldMapper)super.updateFieldType(fullNameToFieldType);
        KeywordFieldMapper queryTermsUpdated = (KeywordFieldMapper)this.queryTermsField.updateFieldType(fullNameToFieldType);
        KeywordFieldMapper extractionResultUpdated = (KeywordFieldMapper)this.extractionResultField.updateFieldType(fullNameToFieldType);
        BinaryFieldMapper queryBuilderUpdated = (BinaryFieldMapper)this.queryBuilderField.updateFieldType(fullNameToFieldType);
        if (updated == this && queryTermsUpdated == this.queryTermsField && extractionResultUpdated == this.extractionResultField && queryBuilderUpdated == this.queryBuilderField) {
            return this;
        }
        if (updated == this) {
            updated = (PercolatorFieldMapper)updated.clone();
        }
        updated.queryTermsField = queryTermsUpdated;
        updated.extractionResultField = extractionResultUpdated;
        updated.queryBuilderField = queryBuilderUpdated;
        return updated;
    }

    public Mapper parse(ParseContext context) throws IOException {
        QueryShardContext queryShardContext = this.queryShardContext.get();
        if (context.doc().getField(this.queryBuilderField.name()) != null) {
            throw new IllegalArgumentException("a document can only contain one percolator query");
        }
        XContentParser parser = context.parser();
        QueryBuilder queryBuilder = PercolatorFieldMapper.parseQueryBuilder(parser, parser.getTokenLocation());
        PercolatorFieldMapper.verifyQuery(queryBuilder);
        PlainActionFuture future = new PlainActionFuture();
        Rewriteable.rewriteAndFetch((Rewriteable)queryBuilder, (QueryRewriteContext)queryShardContext, (ActionListener)future);
        queryBuilder = (QueryBuilder)future.actionGet();
        try (XContentBuilder builder = XContentFactory.contentBuilder((XContentType)QUERY_BUILDER_CONTENT_TYPE);){
            queryBuilder.toXContent(builder, (ToXContent.Params)new ToXContent.MapParams(Collections.emptyMap()));
            builder.flush();
            byte[] queryBuilderAsBytes = BytesReference.toBytes((BytesReference)builder.bytes());
            context.doc().add((IndexableField)new Field(this.queryBuilderField.name(), queryBuilderAsBytes, (IndexableFieldType)this.queryBuilderField.fieldType()));
        }
        Query query = PercolatorFieldMapper.toQuery(queryShardContext, this.mapUnmappedFieldAsString, queryBuilder);
        this.processQuery(query, context);
        return null;
    }

    void processQuery(Query query, ParseContext context) {
        QueryAnalyzer.Result result;
        ParseContext.Document doc = context.doc();
        FieldType pft = (FieldType)this.fieldType();
        try {
            result = QueryAnalyzer.analyze(query);
        }
        catch (QueryAnalyzer.UnsupportedQueryException e) {
            doc.add((IndexableField)new Field(pft.extractionResultField.name(), EXTRACTION_FAILED, (IndexableFieldType)this.extractionResultField.fieldType()));
            return;
        }
        for (Term term : result.terms) {
            BytesRefBuilder builder = new BytesRefBuilder();
            builder.append(new BytesRef((CharSequence)term.field()));
            builder.append((byte)0);
            builder.append(term.bytes());
            doc.add((IndexableField)new Field(this.queryTermsField.name(), builder.toBytesRef(), (IndexableFieldType)this.queryTermsField.fieldType()));
        }
        if (result.verified) {
            doc.add((IndexableField)new Field(this.extractionResultField.name(), EXTRACTION_COMPLETE, (IndexableFieldType)this.extractionResultField.fieldType()));
        } else {
            doc.add((IndexableField)new Field(this.extractionResultField.name(), EXTRACTION_PARTIAL, (IndexableFieldType)this.extractionResultField.fieldType()));
        }
    }

    public static Query parseQuery(QueryShardContext context, boolean mapUnmappedFieldsAsString, XContentParser parser) throws IOException {
        return PercolatorFieldMapper.toQuery(context, mapUnmappedFieldsAsString, PercolatorFieldMapper.parseQueryBuilder(parser, parser.getTokenLocation()));
    }

    static Query toQuery(QueryShardContext context, boolean mapUnmappedFieldsAsString, QueryBuilder queryBuilder) throws IOException {
        context.setAllowUnmappedFields(false);
        context.setMapUnmappedFieldAsString(mapUnmappedFieldsAsString);
        return queryBuilder.toQuery(context);
    }

    private static QueryBuilder parseQueryBuilder(XContentParser parser, XContentLocation location) {
        try {
            return AbstractQueryBuilder.parseInnerQueryBuilder((XContentParser)parser);
        }
        catch (IOException e) {
            throw new ParsingException(location, "Failed to parse", (Throwable)e, new Object[0]);
        }
    }

    public Iterator<Mapper> iterator() {
        return Arrays.asList(this.queryTermsField, this.extractionResultField, this.queryBuilderField).iterator();
    }

    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        throw new UnsupportedOperationException("should not be invoked");
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    static void verifyQuery(QueryBuilder queryBuilder) {
        block5: {
            block8: {
                block7: {
                    block6: {
                        block4: {
                            if (queryBuilder.getName().equals("has_child")) {
                                throw new IllegalArgumentException("the [has_child] query is unsupported inside a percolator query");
                            }
                            if (queryBuilder.getName().equals("has_parent")) {
                                throw new IllegalArgumentException("the [has_parent] query is unsupported inside a percolator query");
                            }
                            if (!(queryBuilder instanceof BoolQueryBuilder)) break block4;
                            BoolQueryBuilder boolQueryBuilder = (BoolQueryBuilder)queryBuilder;
                            ArrayList clauses = new ArrayList();
                            clauses.addAll(boolQueryBuilder.filter());
                            clauses.addAll(boolQueryBuilder.must());
                            clauses.addAll(boolQueryBuilder.mustNot());
                            clauses.addAll(boolQueryBuilder.should());
                            for (QueryBuilder clause : clauses) {
                                PercolatorFieldMapper.verifyQuery(clause);
                            }
                            break block5;
                        }
                        if (!(queryBuilder instanceof ConstantScoreQueryBuilder)) break block6;
                        PercolatorFieldMapper.verifyQuery(((ConstantScoreQueryBuilder)queryBuilder).innerQuery());
                        break block5;
                    }
                    if (!(queryBuilder instanceof FunctionScoreQueryBuilder)) break block7;
                    PercolatorFieldMapper.verifyQuery(((FunctionScoreQueryBuilder)queryBuilder).query());
                    break block5;
                }
                if (!(queryBuilder instanceof BoostingQueryBuilder)) break block8;
                PercolatorFieldMapper.verifyQuery(((BoostingQueryBuilder)queryBuilder).negativeQuery());
                PercolatorFieldMapper.verifyQuery(((BoostingQueryBuilder)queryBuilder).positiveQuery());
                break block5;
            }
            if (!(queryBuilder instanceof DisMaxQueryBuilder)) break block5;
            DisMaxQueryBuilder disMaxQueryBuilder = (DisMaxQueryBuilder)queryBuilder;
            for (QueryBuilder innerQueryBuilder : disMaxQueryBuilder.innerQueries()) {
                PercolatorFieldMapper.verifyQuery(innerQueryBuilder);
            }
        }
    }

    public static class FieldType
    extends MappedFieldType {
        MappedFieldType queryTermsField;
        MappedFieldType extractionResultField;
        MappedFieldType queryBuilderField;

        public FieldType() {
            this.setIndexOptions(IndexOptions.NONE);
            this.setDocValuesType(DocValuesType.NONE);
            this.setStored(false);
        }

        public FieldType(FieldType ref) {
            super((MappedFieldType)ref);
            this.queryTermsField = ref.queryTermsField;
            this.extractionResultField = ref.extractionResultField;
            this.queryBuilderField = ref.queryBuilderField;
        }

        public MappedFieldType clone() {
            return new FieldType(this);
        }

        public String typeName() {
            return PercolatorFieldMapper.CONTENT_TYPE;
        }

        public Query termQuery(Object value, QueryShardContext context) {
            throw new QueryShardException(context, "Percolator fields are not searchable directly, use a percolate query instead", new Object[0]);
        }

        Query percolateQuery(PercolateQuery.QueryStore queryStore, BytesReference documentSource, IndexSearcher searcher) throws IOException {
            IndexReader indexReader = searcher.getIndexReader();
            Query candidateMatchesQuery = this.createCandidateQuery(indexReader);
            Object verifiedMatchesQuery = indexReader.maxDoc() == 1 ? new TermQuery(new Term(this.extractionResultField.name(), PercolatorFieldMapper.EXTRACTION_COMPLETE)) : new MatchNoDocsQuery("nested docs, so no verified matches");
            return new PercolateQuery(queryStore, documentSource, candidateMatchesQuery, searcher, (Query)verifiedMatchesQuery);
        }

        Query createCandidateQuery(IndexReader indexReader) throws IOException {
            ArrayList<BytesRef> extractedTerms = new ArrayList<BytesRef>();
            LeafReader reader = ((LeafReaderContext)indexReader.leaves().get(0)).reader();
            for (FieldInfo info : reader.getFieldInfos()) {
                Terms terms = reader.terms(info.name);
                if (terms == null) continue;
                BytesRef fieldBr = new BytesRef((CharSequence)info.name);
                TermsEnum tenum = terms.iterator();
                BytesRef term = tenum.next();
                while (term != null) {
                    BytesRefBuilder builder = new BytesRefBuilder();
                    builder.append(fieldBr);
                    builder.append((byte)0);
                    builder.append(term);
                    extractedTerms.add(builder.toBytesRef());
                    term = tenum.next();
                }
            }
            TermInSetQuery extractionSuccess = new TermInSetQuery(this.queryTermsField.name(), extractedTerms);
            TermQuery extractionFailure = new TermQuery(new Term(this.extractionResultField.name(), PercolatorFieldMapper.EXTRACTION_FAILED));
            return new BooleanQuery.Builder().add((Query)extractionSuccess, BooleanClause.Occur.SHOULD).add((Query)extractionFailure, BooleanClause.Occur.SHOULD).build();
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            return new Builder(name, parserContext.queryShardContextSupplier());
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder, PercolatorFieldMapper> {
        private final Supplier<QueryShardContext> queryShardContext;

        public Builder(String fieldName, Supplier<QueryShardContext> queryShardContext) {
            super(fieldName, (MappedFieldType)FIELD_TYPE, (MappedFieldType)FIELD_TYPE);
            this.queryShardContext = queryShardContext;
        }

        public PercolatorFieldMapper build(Mapper.BuilderContext context) {
            context.path().add(this.name());
            FieldType fieldType = (FieldType)this.fieldType;
            KeywordFieldMapper extractedTermsField = Builder.createExtractQueryFieldBuilder(PercolatorFieldMapper.EXTRACTED_TERMS_FIELD_NAME, context);
            fieldType.queryTermsField = extractedTermsField.fieldType();
            KeywordFieldMapper extractionResultField = Builder.createExtractQueryFieldBuilder(PercolatorFieldMapper.EXTRACTION_RESULT_FIELD_NAME, context);
            fieldType.extractionResultField = extractionResultField.fieldType();
            BinaryFieldMapper queryBuilderField = Builder.createQueryBuilderFieldBuilder(context);
            fieldType.queryBuilderField = queryBuilderField.fieldType();
            context.path().remove();
            this.setupFieldType(context);
            return new PercolatorFieldMapper(this.name(), fieldType, this.defaultFieldType, context.indexSettings(), this.multiFieldsBuilder.build((FieldMapper.Builder)this, context), this.copyTo, this.queryShardContext, extractedTermsField, extractionResultField, queryBuilderField);
        }

        static KeywordFieldMapper createExtractQueryFieldBuilder(String name, Mapper.BuilderContext context) {
            KeywordFieldMapper.Builder queryMetaDataFieldBuilder = new KeywordFieldMapper.Builder(name);
            queryMetaDataFieldBuilder.docValues(false);
            queryMetaDataFieldBuilder.store(false);
            queryMetaDataFieldBuilder.indexOptions(IndexOptions.DOCS);
            return queryMetaDataFieldBuilder.build(context);
        }

        static BinaryFieldMapper createQueryBuilderFieldBuilder(Mapper.BuilderContext context) {
            BinaryFieldMapper.Builder builder = new BinaryFieldMapper.Builder(PercolatorFieldMapper.QUERY_BUILDER_FIELD_NAME);
            builder.docValues(true);
            builder.indexOptions(IndexOptions.NONE);
            builder.store(false);
            builder.fieldType().setDocValuesType(DocValuesType.BINARY);
            return builder.build(context);
        }
    }
}

