/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.percolator;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.highlight.HighlightField;

@Deprecated
public class PercolateResponse
extends BroadcastResponse
implements Iterable<Match>,
ToXContent {
    public static final Match[] EMPTY = new Match[0];
    public static final float NO_SCORE = 0.0f;
    private long tookInMillis;
    private Match[] matches;
    private long count;
    private InternalAggregations aggregations;

    PercolateResponse(int totalShards, int successfulShards, int failedShards, List<ShardOperationFailedException> shardFailures, Match[] matches, long count, long tookInMillis, InternalAggregations aggregations) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        if (tookInMillis < 0L) {
            throw new IllegalArgumentException("tookInMillis must be positive but was: " + tookInMillis);
        }
        this.tookInMillis = tookInMillis;
        this.matches = matches;
        this.count = count;
        this.aggregations = aggregations;
    }

    PercolateResponse() {
    }

    public TimeValue getTook() {
        return new TimeValue(this.tookInMillis);
    }

    public long getTookInMillis() {
        return this.tookInMillis;
    }

    public Match[] getMatches() {
        return this.matches;
    }

    public long getCount() {
        return this.count;
    }

    public InternalAggregations getAggregations() {
        return this.aggregations;
    }

    @Override
    public Iterator<Match> iterator() {
        return Arrays.asList(this.matches).iterator();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("took", this.tookInMillis);
        RestActions.buildBroadcastShardsHeader((XContentBuilder)builder, (ToXContent.Params)params, (BroadcastResponse)this);
        builder.field("total", this.count);
        if (this.matches != null) {
            builder.startArray("matches");
            boolean justIds = "ids".equals(params.param("percolate_format"));
            if (justIds) {
                for (Match match : this.matches) {
                    builder.value(match.getId());
                }
            } else {
                for (Match match : this.matches) {
                    builder.startObject();
                    builder.field("_index", match.getIndex());
                    builder.field("_id", match.getId());
                    float score = match.getScore();
                    if (score != 0.0f) {
                        builder.field("_score", match.getScore());
                    }
                    if (!match.getHighlightFields().isEmpty()) {
                        builder.startObject("highlight");
                        for (HighlightField field : match.getHighlightFields().values()) {
                            builder.field(field.name());
                            if (field.fragments() == null) {
                                builder.nullValue();
                                continue;
                            }
                            builder.startArray();
                            for (Text fragment : field.fragments()) {
                                builder.value(fragment);
                            }
                            builder.endArray();
                        }
                        builder.endObject();
                    }
                    builder.endObject();
                }
            }
            builder.endArray();
        }
        if (this.aggregations != null) {
            this.aggregations.toXContent(builder, params);
        }
        return builder;
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.tookInMillis = in.readVLong();
        this.count = in.readVLong();
        int size = in.readVInt();
        if (size != -1) {
            this.matches = new Match[size];
            for (int i = 0; i < size; ++i) {
                this.matches[i] = new Match();
                this.matches[i].readFrom(in);
            }
        }
        this.aggregations = InternalAggregations.readOptionalAggregations((StreamInput)in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVLong(this.tookInMillis);
        out.writeVLong(this.count);
        if (this.matches == null) {
            out.writeVInt(-1);
        } else {
            out.writeVInt(this.matches.length);
            for (Match match : this.matches) {
                match.writeTo(out);
            }
        }
        out.writeOptionalStreamable((Streamable)this.aggregations);
    }

    static final class Fields {
        static final String TOOK = "took";
        static final String TOTAL = "total";
        static final String MATCHES = "matches";
        static final String _INDEX = "_index";
        static final String _ID = "_id";
        static final String _SCORE = "_score";
        static final String HIGHLIGHT = "highlight";

        Fields() {
        }
    }

    public static class Match
    implements Streamable {
        private Text index;
        private Text id;
        private float score;
        private Map<String, HighlightField> hl;

        public Match(Text index, Text id, float score, Map<String, HighlightField> hl) {
            this.id = id;
            this.score = score;
            this.index = index;
            this.hl = hl;
        }

        public Match(Text index, Text id, float score) {
            this.id = id;
            this.score = score;
            this.index = index;
        }

        Match() {
        }

        public Text getIndex() {
            return this.index;
        }

        public Text getId() {
            return this.id;
        }

        public float getScore() {
            return this.score;
        }

        @Nullable
        public Map<String, HighlightField> getHighlightFields() {
            return this.hl;
        }

        public void readFrom(StreamInput in) throws IOException {
            this.id = in.readText();
            this.index = in.readText();
            this.score = in.readFloat();
            int size = in.readVInt();
            if (size > 0) {
                this.hl = new HashMap<String, HighlightField>(size);
                for (int j = 0; j < size; ++j) {
                    this.hl.put(in.readString(), HighlightField.readHighlightField((StreamInput)in));
                }
            }
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeText(this.id);
            out.writeText(this.index);
            out.writeFloat(this.score);
            if (this.hl != null) {
                out.writeVInt(this.hl.size());
                for (Map.Entry<String, HighlightField> entry : this.hl.entrySet()) {
                    out.writeString(entry.getKey());
                    entry.getValue().writeTo(out);
                }
            } else {
                out.writeVInt(0);
            }
        }
    }
}

