/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.join.fetch;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.join.mapper.ParentIdFieldMapper;
import org.elasticsearch.join.mapper.ParentJoinFieldMapper;
import org.elasticsearch.search.SearchHitField;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.internal.SearchContext;

public final class ParentJoinFieldSubFetchPhase
implements FetchSubPhase {
    public void hitExecute(SearchContext context, FetchSubPhase.HitContext hitContext) {
        if (context.storedFieldsContext() != null && !context.storedFieldsContext().fetchFields()) {
            return;
        }
        if (context.mapperService().getIndexSettings().getIndexVersionCreated().before(Version.V_6_0_0_alpha2)) {
            return;
        }
        DocumentMapper docMapper = context.mapperService().documentMapper(hitContext.hit().getType());
        Tuple joinField = null;
        Tuple parentField = null;
        for (FieldMapper fieldMapper : docMapper.mappers()) {
            String joinName;
            if (!(fieldMapper instanceof ParentJoinFieldMapper) || (joinName = this.getSortedDocValue(fieldMapper.name(), hitContext.reader(), hitContext.docId())) == null) continue;
            ParentJoinFieldMapper joinFieldMapper = (ParentJoinFieldMapper)fieldMapper;
            joinField = new Tuple((Object)fieldMapper.name(), (Object)joinName);
            ParentIdFieldMapper parentMapper = joinFieldMapper.getParentIdFieldMapper(joinName, false);
            if (parentMapper == null) break;
            String parent = this.getSortedDocValue(parentMapper.name(), hitContext.reader(), hitContext.docId());
            parentField = new Tuple((Object)parentMapper.name(), (Object)parent);
            break;
        }
        if (joinField == null) {
            return;
        }
        HashMap<Object, SearchHitField> fields = hitContext.hit().fieldsOrNull();
        if (fields == null) {
            fields = new HashMap<Object, SearchHitField>();
            hitContext.hit().fields(fields);
        }
        fields.put(joinField.v1(), new SearchHitField((String)joinField.v1(), Collections.singletonList(joinField.v2())));
        if (parentField != null) {
            fields.put(parentField.v1(), new SearchHitField((String)parentField.v1(), Collections.singletonList(parentField.v2())));
        }
    }

    private String getSortedDocValue(String field, LeafReader reader, int docId) {
        try {
            SortedDocValues docValues = reader.getSortedDocValues(field);
            if (docValues == null || !docValues.advanceExact(docId)) {
                return null;
            }
            int ord = docValues.ordValue();
            BytesRef joinName = docValues.lookupOrd(ord);
            return joinName.utf8ToString();
        }
        catch (IOException e) {
            throw ExceptionsHelper.convertToElastic((Exception)e);
        }
    }
}

