/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.join.aggregations;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.common.util.LongObjectPagedHashMap;
import org.elasticsearch.join.aggregations.InternalChildren;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.bucket.SingleBucketAggregator;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.internal.SearchContext;

public class ParentToChildrenAggregator
extends SingleBucketAggregator {
    static final ParseField TYPE_FIELD = new ParseField("type", new String[0]);
    private final Weight childFilter;
    private final Weight parentFilter;
    private final ValuesSource.Bytes.WithOrdinals valuesSource;
    private final LongArray parentOrdToBuckets;
    private final LongObjectPagedHashMap<long[]> parentOrdToOtherBuckets;
    private boolean multipleBucketsPerParentOrd = false;

    public ParentToChildrenAggregator(String name, AggregatorFactories factories, SearchContext context, Aggregator parent, Query childFilter, Query parentFilter, ValuesSource.Bytes.WithOrdinals valuesSource, long maxOrd, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, factories, context, parent, pipelineAggregators, metaData);
        this.childFilter = context.searcher().createNormalizedWeight(childFilter, false);
        this.parentFilter = context.searcher().createNormalizedWeight(parentFilter, false);
        this.parentOrdToBuckets = context.bigArrays().newLongArray(maxOrd, false);
        this.parentOrdToBuckets.fill(0L, maxOrd, -1L);
        this.parentOrdToOtherBuckets = new LongObjectPagedHashMap(context.bigArrays());
        this.valuesSource = valuesSource;
    }

    public InternalAggregation buildAggregation(long owningBucketOrdinal) throws IOException {
        return new InternalChildren(this.name, this.bucketDocCount(owningBucketOrdinal), this.bucketAggregations(owningBucketOrdinal), this.pipelineAggregators(), this.metaData());
    }

    public InternalAggregation buildEmptyAggregation() {
        return new InternalChildren(this.name, 0L, this.buildEmptySubAggregations(), this.pipelineAggregators(), this.metaData());
    }

    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final SortedSetDocValues globalOrdinals = this.valuesSource.globalOrdinalsValues(ctx);
        Scorer parentScorer = this.parentFilter.scorer(ctx);
        final Bits parentDocs = Lucene.asSequentialAccessBits((int)ctx.reader().maxDoc(), (Scorer)parentScorer);
        return new LeafBucketCollector(){

            public void collect(int docId, long bucket) throws IOException {
                if (parentDocs.get(docId) && globalOrdinals.advanceExact(docId)) {
                    long globalOrdinal = globalOrdinals.nextOrd();
                    assert (globalOrdinals.nextOrd() == -1L);
                    if (globalOrdinal != -1L) {
                        if (ParentToChildrenAggregator.this.parentOrdToBuckets.get(globalOrdinal) == -1L) {
                            ParentToChildrenAggregator.this.parentOrdToBuckets.set(globalOrdinal, bucket);
                        } else {
                            long[] bucketOrds = (long[])ParentToChildrenAggregator.this.parentOrdToOtherBuckets.get(globalOrdinal);
                            if (bucketOrds != null) {
                                bucketOrds = Arrays.copyOf(bucketOrds, bucketOrds.length + 1);
                                bucketOrds[bucketOrds.length - 1] = bucket;
                                ParentToChildrenAggregator.this.parentOrdToOtherBuckets.put(globalOrdinal, (Object)bucketOrds);
                            } else {
                                ParentToChildrenAggregator.this.parentOrdToOtherBuckets.put(globalOrdinal, (Object)new long[]{bucket});
                            }
                            ParentToChildrenAggregator.this.multipleBucketsPerParentOrd = true;
                        }
                    }
                }
            }
        };
    }

    protected void doPostCollection() throws IOException {
        IndexReader indexReader = this.context().searcher().getIndexReader();
        for (LeafReaderContext ctx : indexReader.leaves()) {
            Scorer childDocsScorer = this.childFilter.scorer(ctx);
            if (childDocsScorer == null) continue;
            DocIdSetIterator childDocsIter = childDocsScorer.iterator();
            LeafBucketCollector sub = this.collectableSubAggregators.getLeafCollector(ctx);
            SortedSetDocValues globalOrdinals = this.valuesSource.globalOrdinalsValues(ctx);
            sub.setScorer((Scorer)new ConstantScoreScorer(null, 1.0f, childDocsIter));
            Bits liveDocs = ctx.reader().getLiveDocs();
            int docId = childDocsIter.nextDoc();
            while (docId != Integer.MAX_VALUE) {
                if ((liveDocs == null || liveDocs.get(docId)) && globalOrdinals.advanceExact(docId)) {
                    long globalOrdinal = globalOrdinals.nextOrd();
                    assert (globalOrdinals.nextOrd() == -1L);
                    long bucketOrd = this.parentOrdToBuckets.get(globalOrdinal);
                    if (bucketOrd != -1L) {
                        long[] otherBucketOrds;
                        this.collectBucket(sub, docId, bucketOrd);
                        if (this.multipleBucketsPerParentOrd && (otherBucketOrds = (long[])this.parentOrdToOtherBuckets.get(globalOrdinal)) != null) {
                            for (long otherBucketOrd : otherBucketOrds) {
                                this.collectBucket(sub, docId, otherBucketOrd);
                            }
                        }
                    }
                }
                docId = childDocsIter.nextDoc();
            }
        }
    }

    protected void doClose() {
        Releasables.close((Releasable[])new Releasable[]{this.parentOrdToBuckets, this.parentOrdToOtherBuckets});
    }
}

