/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.join;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.join.aggregations.ChildrenAggregationBuilder;
import org.elasticsearch.join.aggregations.InternalChildren;
import org.elasticsearch.join.fetch.ParentJoinFieldSubFetchPhase;
import org.elasticsearch.join.mapper.ParentJoinFieldMapper;
import org.elasticsearch.join.query.HasChildQueryBuilder;
import org.elasticsearch.join.query.HasParentQueryBuilder;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.SearchPlugin;
import org.elasticsearch.search.fetch.FetchSubPhase;

public class ParentJoinPlugin
extends Plugin
implements SearchPlugin,
MapperPlugin {
    public ParentJoinPlugin(Settings settings) {
    }

    public List<SearchPlugin.QuerySpec<?>> getQueries() {
        return Arrays.asList(new SearchPlugin.QuerySpec("has_child", HasChildQueryBuilder::new, HasChildQueryBuilder::fromXContent), new SearchPlugin.QuerySpec("has_parent", HasParentQueryBuilder::new, HasParentQueryBuilder::fromXContent));
    }

    public List<SearchPlugin.AggregationSpec> getAggregations() {
        return Collections.singletonList(new SearchPlugin.AggregationSpec("children", ChildrenAggregationBuilder::new, ChildrenAggregationBuilder::parse).addResultReader(InternalChildren::new));
    }

    public Map<String, Mapper.TypeParser> getMappers() {
        return Collections.singletonMap("join", new ParentJoinFieldMapper.TypeParser());
    }

    public List<FetchSubPhase> getFetchSubPhases(SearchPlugin.FetchPhaseConstructionContext context) {
        return Collections.singletonList(new ParentJoinFieldSubFetchPhase());
    }
}

