/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.mustache;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestStatusToXContentListener;
import org.elasticsearch.rest.action.search.RestSearchAction;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.script.mustache.SearchTemplateAction;
import org.elasticsearch.script.mustache.SearchTemplateRequest;

public class RestSearchTemplateAction
extends BaseRestHandler {
    private static final Set<String> RESPONSE_PARAMS = Collections.singleton("typed_keys");
    private static final ObjectParser<SearchTemplateRequest, Void> PARSER = new ObjectParser("search_template");

    public RestSearchTemplateAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_search/template", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/_search/template", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_search/template", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_search/template", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_search/template", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_search/template", (RestHandler)this);
    }

    public String getName() {
        return "search_template_action";
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        SearchTemplateRequest searchTemplateRequest;
        SearchRequest searchRequest = new SearchRequest();
        RestSearchAction.parseSearchRequest((SearchRequest)searchRequest, (RestRequest)request, null);
        try (XContentParser parser = request.contentOrSourceParamParser();){
            searchTemplateRequest = (SearchTemplateRequest)((Object)PARSER.parse(parser, (Object)new SearchTemplateRequest(), null));
        }
        searchTemplateRequest.setRequest(searchRequest);
        return channel -> client.execute((Action)SearchTemplateAction.INSTANCE, (ActionRequest)searchTemplateRequest, (ActionListener)new RestStatusToXContentListener(channel));
    }

    public static SearchTemplateRequest parse(XContentParser parser) throws IOException {
        return (SearchTemplateRequest)((Object)PARSER.parse(parser, (Object)new SearchTemplateRequest(), null));
    }

    protected Set<String> responseParams() {
        return RESPONSE_PARAMS;
    }

    static {
        PARSER.declareField((parser, request, s) -> request.setScriptParams(parser.map()), new ParseField("params", new String[0]), ObjectParser.ValueType.OBJECT);
        PARSER.declareString((request, s) -> {
            request.setScriptType(ScriptType.STORED);
            request.setScript((String)s);
        }, new ParseField("id", new String[0]));
        PARSER.declareBoolean(SearchTemplateRequest::setExplain, new ParseField("explain", new String[0]));
        PARSER.declareBoolean(SearchTemplateRequest::setProfile, new ParseField("profile", new String[0]));
        PARSER.declareField((parser, request, value) -> {
            block15: {
                request.setScriptType(ScriptType.INLINE);
                if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                    try (XContentBuilder builder = XContentFactory.jsonBuilder();){
                        request.setScript(builder.copyCurrentStructure(parser).string());
                        break block15;
                    }
                    catch (IOException e) {
                        throw new ParsingException(parser.getTokenLocation(), "Could not parse inline template", (Throwable)e, new Object[0]);
                    }
                }
                request.setScript(parser.text());
            }
        }, new ParseField("source", new String[]{"inline", "template"}), ObjectParser.ValueType.OBJECT_OR_STRING);
    }
}

