/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.mustache;

import java.util.Collections;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.TransportSearchAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.indices.query.IndicesQueriesRegistry;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.mustache.SearchTemplateRequest;
import org.elasticsearch.script.mustache.SearchTemplateResponse;
import org.elasticsearch.search.aggregations.AggregatorParsers;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.suggest.Suggesters;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportSearchTemplateAction
extends HandledTransportAction<SearchTemplateRequest, SearchTemplateResponse> {
    private static final String TEMPLATE_LANG = "mustache";
    private final ScriptService scriptService;
    private final TransportSearchAction searchAction;
    private final IndicesQueriesRegistry queryRegistry;
    private final AggregatorParsers aggsParsers;
    private final Suggesters suggesters;

    @Inject
    public TransportSearchTemplateAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver resolver, ScriptService scriptService, TransportSearchAction searchAction, IndicesQueriesRegistry indicesQueryRegistry, AggregatorParsers aggregatorParsers, Suggesters suggesters) {
        super(settings, "indices:data/read/search/template", threadPool, transportService, actionFilters, resolver, SearchTemplateRequest::new);
        this.scriptService = scriptService;
        this.searchAction = searchAction;
        this.queryRegistry = indicesQueryRegistry;
        this.aggsParsers = aggregatorParsers;
        this.suggesters = suggesters;
    }

    protected void doExecute(SearchTemplateRequest request, final ActionListener<SearchTemplateResponse> listener) {
        final SearchTemplateResponse response = new SearchTemplateResponse();
        try {
            Script script = new Script(request.getScript(), request.getScriptType(), TEMPLATE_LANG, request.getScriptParams());
            ExecutableScript executable = this.scriptService.executable(script, (ScriptContext)ScriptContext.Standard.SEARCH, Collections.emptyMap());
            BytesReference source = (BytesReference)executable.run();
            response.setSource(source);
            if (request.isSimulate()) {
                listener.onResponse((Object)response);
                return;
            }
            SearchRequest searchRequest = request.getRequest();
            try (XContentParser parser = XContentFactory.xContent((BytesReference)source).createParser(source);){
                SearchSourceBuilder builder = SearchSourceBuilder.searchSource();
                builder.parseXContent(new QueryParseContext(this.queryRegistry, parser, this.parseFieldMatcher), this.aggsParsers, this.suggesters);
                searchRequest.source(builder);
                this.searchAction.execute((ActionRequest)searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

                    public void onResponse(SearchResponse searchResponse) {
                        try {
                            response.setResponse(searchResponse);
                            listener.onResponse((Object)response);
                        }
                        catch (Exception t) {
                            listener.onFailure(t);
                        }
                    }

                    public void onFailure(Exception t) {
                        listener.onFailure(t);
                    }
                });
            }
        }
        catch (Exception t) {
            listener.onFailure(t);
        }
    }
}

