/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.io.Reader;
import org.apache.lucene.analysis.ja.JapaneseIterationMarkCharFilter;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractCharFilterFactory;
import org.elasticsearch.index.settings.IndexSettings;

public class KuromojiIterationMarkCharFilterFactory
extends AbstractCharFilterFactory {
    private final boolean normalizeKanji;
    private final boolean normalizeKana;

    @Inject
    public KuromojiIterationMarkCharFilterFactory(Index index, @IndexSettings Settings indexSettings, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, name);
        this.normalizeKanji = settings.getAsBoolean("normalize_kanji", Boolean.valueOf(true));
        this.normalizeKana = settings.getAsBoolean("normalize_kana", Boolean.valueOf(true));
    }

    public Reader create(Reader reader) {
        return new JapaneseIterationMarkCharFilter(reader, this.normalizeKanji, this.normalizeKana);
    }
}

