/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.ja.JapaneseAnalyzer;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.search.suggest.analyzing.SuggestStopFilter;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.Analysis;
import org.elasticsearch.index.settings.IndexSettings;

public class JapaneseStopTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final CharArraySet stopWords;
    private final boolean ignoreCase;
    private final boolean removeTrailing;

    @Inject
    public JapaneseStopTokenFilterFactory(Index index, @IndexSettings Settings indexSettings, Environment env, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, name, settings);
        this.ignoreCase = settings.getAsBoolean("ignore_case", Boolean.valueOf(false));
        this.removeTrailing = settings.getAsBoolean("remove_trailing", Boolean.valueOf(true));
        ImmutableMap namedStopWords = MapBuilder.newMapBuilder().put((Object)"_japanese_", (Object)JapaneseAnalyzer.getDefaultStopSet()).immutableMap();
        this.stopWords = Analysis.parseWords((Environment)env, (Settings)settings, (String)"stopwords", (CharArraySet)JapaneseAnalyzer.getDefaultStopSet(), (Map)namedStopWords, (boolean)this.ignoreCase);
    }

    public TokenStream create(TokenStream tokenStream) {
        if (this.removeTrailing) {
            return new StopFilter(tokenStream, this.stopWords);
        }
        return new SuggestStopFilter(tokenStream, this.stopWords);
    }

    public Set<?> stopWords() {
        return this.stopWords;
    }

    public boolean ignoreCase() {
        return this.ignoreCase;
    }
}

