/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import com.ibm.icu.text.Transliterator;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.icu.ICUTransformFilter;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.settings.IndexSettingsService;

public class IcuTransformTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final String id;
    private final int dir;
    private final Transliterator transliterator;

    @Inject
    public IcuTransformTokenFilterFactory(Index index, IndexSettingsService indexSettingsService, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettingsService.getSettings(), name, settings);
        this.id = settings.get("id", "Null");
        String s = settings.get("dir", "forward");
        this.dir = "forward".equals(s) ? 0 : 1;
        this.transliterator = Transliterator.getInstance((String)this.id, (int)this.dir);
    }

    public TokenStream create(TokenStream tokenStream) {
        return new ICUTransformFilter(tokenStream, this.transliterator);
    }
}

