/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.internal.SearchContext;

public abstract class ArrayValuesSourceAggregatorFactory<VS extends ValuesSource>
extends AggregatorFactory {
    protected Map<String, ValuesSourceConfig<VS>> configs;

    public ArrayValuesSourceAggregatorFactory(String name, Map<String, ValuesSourceConfig<VS>> configs, SearchContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metaData) throws IOException {
        super(name, context, parent, subFactoriesBuilder, metaData);
        this.configs = configs;
    }

    public Aggregator createInternal(Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        HashMap<String, ValuesSource> valuesSources = new HashMap<String, ValuesSource>();
        for (Map.Entry<String, ValuesSourceConfig<VS>> config : this.configs.entrySet()) {
            ValuesSource vs = config.getValue().toValuesSource(this.context.getQueryShardContext());
            if (vs == null) continue;
            valuesSources.put(config.getKey(), vs);
        }
        if (valuesSources.isEmpty()) {
            return this.createUnmapped(parent, pipelineAggregators, metaData);
        }
        return this.doCreateInternal(valuesSources, parent, collectsFromSingleBucket, pipelineAggregators, metaData);
    }

    protected abstract Aggregator createUnmapped(Aggregator var1, List<PipelineAggregator> var2, Map<String, Object> var3) throws IOException;

    protected abstract Aggregator doCreateInternal(Map<String, VS> var1, Aggregator var2, boolean var3, List<PipelineAggregator> var4, Map<String, Object> var5) throws IOException;
}

