/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.simdvec.internal;

import java.io.IOException;
import java.lang.foreign.MemorySegment;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.store.IndexInput;
import org.elasticsearch.nativeaccess.NativeAccess;
import org.elasticsearch.simdvec.internal.MemorySegmentES92PanamaInt7VectorsScorer;
import org.elasticsearch.simdvec.internal.Similarities;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class MemorySegmentES92Int7VectorsScorer
extends MemorySegmentES92PanamaInt7VectorsScorer {
    private static final boolean NATIVE_SUPPORTED = NativeAccess.instance().getVectorSimilarityFunctions().isPresent();

    public MemorySegmentES92Int7VectorsScorer(IndexInput in, int dimensions, MemorySegment memorySegment) {
        super(in, dimensions, memorySegment);
    }

    @Override
    public boolean hasNativeAccess() {
        return NATIVE_SUPPORTED;
    }

    @Override
    public long int7DotProduct(byte[] q) throws IOException {
        assert (q.length == this.dimensions);
        if (NATIVE_SUPPORTED) {
            return this.nativeInt7DotProduct(q);
        }
        return this.panamaInt7DotProduct(q);
    }

    private long nativeInt7DotProduct(byte[] q) throws IOException {
        MemorySegment segment = this.memorySegment.asSlice(this.in.getFilePointer(), this.dimensions);
        MemorySegment querySegment = MemorySegment.ofArray(q);
        long res = Similarities.dotProduct7u(segment, querySegment, this.dimensions);
        this.in.skipBytes((long)this.dimensions);
        return res;
    }

    @Override
    public void int7DotProductBulk(byte[] q, int count, float[] scores) throws IOException {
        assert (q.length == this.dimensions);
        if (NATIVE_SUPPORTED) {
            for (int i = 0; i < count; ++i) {
                scores[i] = this.nativeInt7DotProduct(q);
            }
        } else {
            this.panamaInt7DotProductBulk(q, count, scores);
        }
    }

    @Override
    public void scoreBulk(byte[] q, float queryLowerInterval, float queryUpperInterval, int queryComponentSum, float queryAdditionalCorrection, VectorSimilarityFunction similarityFunction, float centroidDp, float[] scores) throws IOException {
        this.int7DotProductBulk(q, 16, scores);
        this.applyCorrectionsBulk(queryLowerInterval, queryUpperInterval, queryComponentSum, queryAdditionalCorrection, similarityFunction, centroidDp, scores);
    }
}

