/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.nativeaccess.lib;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class LoaderHelper {
    public static final Path platformLibDir = LoaderHelper.findPlatformLibDir();

    private static Path findPlatformLibDir() {
        String path = System.getProperty("es.nativelibs.path");
        if (path != null) {
            return Paths.get(path, new String[0]);
        }
        Path platformDir = Paths.get("lib", "platform");
        String osname = System.getProperty("os.name");
        Object os = osname.startsWith("Windows") ? "windows" : (osname.startsWith("Linux") ? "linux" : (osname.startsWith("Mac OS") ? "darwin" : "unsupported_os[" + osname + "]"));
        String archname = System.getProperty("os.arch");
        Object arch = archname.equals("amd64") || archname.equals("x86_64") ? "x64" : (archname.equals("aarch64") ? archname : "unsupported_arch[" + archname + "]");
        return platformDir.resolve((String)os + "-" + (String)arch);
    }

    public static void loadLibrary(String libname) {
        Path libpath = platformLibDir.resolve(System.mapLibraryName(libname));
        if (!Files.exists(libpath, new LinkOption[0])) {
            throw new UnsatisfiedLinkError("Native library [" + libpath + "] does not exist");
        }
        System.load(libpath.toAbsolutePath().toString());
    }

    private LoaderHelper() {
    }
}

