/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cli;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.elasticsearch.core.SuppressForbidden;

public record ProcessInfo(Map<String, String> sysprops, Map<String, String> envVars, Path workingDir) {
    @SuppressForbidden(reason="get system process information")
    public static ProcessInfo fromSystem() {
        Properties props = System.getProperties();
        Map<String, String> sysprops = props.entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), e -> e.getValue().toString()));
        Map<String, String> envVars = Map.copyOf(System.getenv());
        Path workingDir = Paths.get("", new String[0]).toAbsolutePath();
        return new ProcessInfo(sysprops, envVars, workingDir);
    }
}

