/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.sparse.csc;

import java.util.Arrays;
import java.util.Random;
import org.ejml.data.DMatrixSparseCSC;
import org.ejml.sparse.csc.CommonOps_DSCC;

public class RandomMatrices_DSCC {
    public static DMatrixSparseCSC rectangle(int numRows, int numCols, int nz_total, double min, double max, Random rand) {
        int i;
        nz_total = Math.min(numCols * numRows, nz_total);
        int[] selected = RandomMatrices_DSCC.selectElements(numRows * numCols, nz_total, rand);
        DMatrixSparseCSC ret = new DMatrixSparseCSC(numRows, numCols, nz_total);
        ret.indicesSorted = true;
        int[] hist = new int[numCols];
        for (i = 0; i < nz_total; ++i) {
            int n = selected[i] / numRows;
            hist[n] = hist[n] + 1;
        }
        ret.colsum(hist);
        for (i = 0; i < nz_total; ++i) {
            int row;
            ret.nz_rows[i] = row = selected[i] % numRows;
            ret.nz_values[i] = rand.nextDouble() * (max - min) + min;
        }
        return ret;
    }

    private static int[] selectElements(int N, int nz_total, Random rand) {
        int i;
        if (N < 0) {
            throw new IllegalArgumentException("matrix size is too large");
        }
        int[] selected = new int[N];
        for (i = 0; i < N; ++i) {
            selected[i] = i;
        }
        for (i = 0; i < nz_total; ++i) {
            int swapIdx = rand.nextInt(N);
            int tmp = selected[swapIdx];
            selected[swapIdx] = selected[i];
            selected[i] = tmp;
        }
        Arrays.sort(selected, 0, nz_total);
        return selected;
    }

    public static DMatrixSparseCSC rectangle(int numRows, int numCols, int nz_total, Random rand) {
        return RandomMatrices_DSCC.rectangle(numRows, numCols, nz_total, -1.0, 1.0, rand);
    }

    public static DMatrixSparseCSC triangleLower(int dimen, int hessenberg, int nz_total, double min, double max, Random rand) {
        int diag_total = dimen - hessenberg;
        int[] rowStart = new int[dimen];
        int[] rowEnd = new int[dimen];
        int N = 0;
        for (int i = 0; i < dimen; ++i) {
            if (i < dimen - 1 + hessenberg) {
                rowStart[i] = N;
            }
            N += i < hessenberg ? dimen : dimen - 1 - i + hessenberg;
            if (i >= dimen - 1 + hessenberg) continue;
            rowEnd[i] = N;
        }
        nz_total = Math.min(N += dimen - hessenberg, nz_total);
        nz_total = Math.max(diag_total, nz_total);
        int off_total = nz_total - diag_total;
        int[] selected = RandomMatrices_DSCC.selectElements(N - diag_total, off_total, rand);
        DMatrixSparseCSC L = new DMatrixSparseCSC(dimen, dimen, nz_total);
        int[] hist = new int[dimen];
        int s_index = 0;
        for (int col = 0; col < dimen; ++col) {
            if (col >= hessenberg) {
                int n = col;
                hist[n] = hist[n] + 1;
            }
            while (s_index < off_total && selected[s_index] < rowEnd[col]) {
                int n = col;
                hist[n] = hist[n] + 1;
                ++s_index;
            }
        }
        L.colsum(hist);
        int nz_index = 0;
        s_index = 0;
        for (int col = 0; col < dimen; ++col) {
            int offset;
            int n = offset = col >= hessenberg ? col - hessenberg + 1 : 0;
            if (col >= hessenberg) {
                L.nz_rows[nz_index] = col - hessenberg;
                L.nz_values[nz_index++] = rand.nextDouble() * (max - min) + min;
            }
            while (s_index < off_total && selected[s_index] < rowEnd[col]) {
                int row;
                L.nz_rows[nz_index] = row = selected[s_index++] - rowStart[col] + offset;
                L.nz_values[nz_index++] = rand.nextDouble() * (max - min) + min;
            }
        }
        return L;
    }

    public static DMatrixSparseCSC triangleUpper(int dimen, int hessenberg, int nz_total, double min, double max, Random rand) {
        DMatrixSparseCSC L = RandomMatrices_DSCC.triangleLower(dimen, hessenberg, nz_total, min, max, rand);
        DMatrixSparseCSC U = (DMatrixSparseCSC)L.createLike();
        CommonOps_DSCC.transpose(L, U, null);
        return U;
    }
}

