/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.xml.model;

import java.util.HashSet;
import org.ehcache.xml.model.ListenersType;

public class ListenersConfig {
    private final int dispatcherConcurrency;
    private final String threadPool;
    private final Iterable<ListenersType.Listener> listeners;

    public ListenersConfig(ListenersType type, ListenersType ... others) {
        this.dispatcherConcurrency = type.getDispatcherConcurrency().intValue();
        String threadPool = type.getDispatcherThreadPool();
        HashSet<ListenersType.Listener> listenerSet = new HashSet<ListenersType.Listener>();
        listenerSet.addAll(type.getListener());
        for (ListenersType other : others) {
            if (threadPool == null && other.getDispatcherThreadPool() != null) {
                threadPool = other.getDispatcherThreadPool();
            }
            listenerSet.addAll(other.getListener());
        }
        this.threadPool = threadPool;
        this.listeners = !listenerSet.isEmpty() ? listenerSet : null;
    }

    public int dispatcherConcurrency() {
        return this.dispatcherConcurrency;
    }

    public String threadPool() {
        return this.threadPool;
    }

    public Iterable<ListenersType.Listener> listeners() {
        return this.listeners;
    }
}

