/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.xml;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.Configuration;
import org.ehcache.config.EvictionVeto;
import org.ehcache.config.ResourcePool;
import org.ehcache.config.builders.Builder;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheEventListenerConfigurationBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.builders.WriteBehindConfigurationBuilder;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.core.internal.util.ClassLoading;
import org.ehcache.event.EventFiring;
import org.ehcache.event.EventOrdering;
import org.ehcache.expiry.Duration;
import org.ehcache.expiry.Expirations;
import org.ehcache.expiry.Expiry;
import org.ehcache.impl.config.copy.DefaultCopierConfiguration;
import org.ehcache.impl.config.copy.DefaultCopyProviderConfiguration;
import org.ehcache.impl.config.event.CacheEventDispatcherFactoryConfiguration;
import org.ehcache.impl.config.event.DefaultCacheEventDispatcherConfiguration;
import org.ehcache.impl.config.executor.PooledExecutionServiceConfiguration;
import org.ehcache.impl.config.loaderwriter.DefaultCacheLoaderWriterConfiguration;
import org.ehcache.impl.config.loaderwriter.writebehind.WriteBehindProviderConfiguration;
import org.ehcache.impl.config.persistence.CacheManagerPersistenceConfiguration;
import org.ehcache.impl.config.serializer.DefaultSerializationProviderConfiguration;
import org.ehcache.impl.config.serializer.DefaultSerializerConfiguration;
import org.ehcache.impl.config.sizeof.DefaultSizeOfEngineConfiguration;
import org.ehcache.impl.config.sizeof.DefaultSizeOfEngineProviderConfiguration;
import org.ehcache.impl.config.store.disk.OffHeapDiskStoreConfiguration;
import org.ehcache.impl.config.store.disk.OffHeapDiskStoreProviderConfiguration;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceCreationConfiguration;
import org.ehcache.xml.ConfigurationParser;
import org.ehcache.xml.model.CopierType;
import org.ehcache.xml.model.EventType;
import org.ehcache.xml.model.SerializerType;
import org.ehcache.xml.model.ServiceType;
import org.ehcache.xml.model.ThreadPoolReferenceType;
import org.ehcache.xml.model.ThreadPoolsType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class XmlConfiguration
implements Configuration {
    private static final URL CORE_SCHEMA_URL = XmlConfiguration.class.getResource("/ehcache-core.xsd");
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlConfiguration.class);
    private final URL xml;
    private final ClassLoader classLoader;
    private final Map<String, ClassLoader> cacheClassLoaders;
    private final Collection<ServiceCreationConfiguration<?>> serviceConfigurations = new ArrayList();
    private final Map<String, CacheConfiguration<?, ?>> cacheConfigurations = new HashMap();
    private final Map<String, ConfigurationParser.CacheTemplate> templates = new HashMap<String, ConfigurationParser.CacheTemplate>();

    public XmlConfiguration(URL url) throws ClassNotFoundException, SAXException, InstantiationException, IllegalAccessException, IOException {
        this(url, ClassLoading.getDefaultClassLoader());
    }

    public XmlConfiguration(URL url, ClassLoader classLoader) throws ClassNotFoundException, SAXException, InstantiationException, IOException, IllegalAccessException {
        this(url, classLoader, Collections.emptyMap());
    }

    public XmlConfiguration(URL url, ClassLoader classLoader, Map<String, ClassLoader> cacheClassLoaders) throws ClassNotFoundException, SAXException, InstantiationException, IllegalAccessException, IOException {
        if (url == null) {
            throw new NullPointerException("The url can not be null");
        }
        if (classLoader == null) {
            throw new NullPointerException("The classLoader can not be null");
        }
        if (cacheClassLoaders == null) {
            throw new NullPointerException("The cacheClassLoaders map can not be null");
        }
        this.xml = url;
        this.classLoader = classLoader;
        this.cacheClassLoaders = new HashMap<String, ClassLoader>(cacheClassLoaders);
        this.parseConfiguration();
    }

    private void parseConfiguration() throws ClassNotFoundException, IOException, SAXException, InstantiationException, IllegalAccessException {
        DefaultSerializationProviderConfiguration configuration;
        LOGGER.info("Loading Ehcache XML configuration from {}.", (Object)this.xml.getPath());
        ConfigurationParser configurationParser = new ConfigurationParser(this.xml.toExternalForm(), CORE_SCHEMA_URL);
        ArrayList<Object> serviceConfigs = new ArrayList<Object>();
        for (ServiceType serviceType : configurationParser.getServiceElements()) {
            ServiceCreationConfiguration<?> serviceConfiguration = configurationParser.parseExtension((Element)serviceType.getAny());
            serviceConfigs.add(serviceConfiguration);
        }
        if (configurationParser.getDefaultSerializers() != null) {
            configuration = new DefaultSerializationProviderConfiguration();
            for (SerializerType.Serializer serializer : configurationParser.getDefaultSerializers().getSerializer()) {
                try {
                    configuration.addSerializerFor(XmlConfiguration.getClassForName(serializer.getType(), this.classLoader), XmlConfiguration.getClassForName(serializer.getValue(), this.classLoader));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            serviceConfigs.add(configuration);
        }
        if (configurationParser.getDefaultCopiers() != null) {
            configuration = new DefaultCopyProviderConfiguration();
            for (CopierType.Copier copier : configurationParser.getDefaultCopiers().getCopier()) {
                try {
                    configuration.addCopierFor(XmlConfiguration.getClassForName(copier.getType(), this.classLoader), XmlConfiguration.getClassForName(copier.getValue(), this.classLoader));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            serviceConfigs.add(configuration);
        }
        if (configurationParser.getHeapStore() != null) {
            if (configurationParser.getHeapStore().getMaxObjectSize().getUnit().value().equalsIgnoreCase("entries")) {
                throw new IllegalArgumentException("SizeOfEngine cannot be configured with entries.");
            }
            configuration = new DefaultSizeOfEngineProviderConfiguration(configurationParser.getHeapStore().getMaxObjectSize().getValue().longValue(), MemoryUnit.valueOf((String)configurationParser.getHeapStore().getMaxObjectSize().getUnit().value().toUpperCase()), configurationParser.getHeapStore().getMaxObjectGraphSize().getValue().longValue());
            serviceConfigs.add(configuration);
        }
        if (configurationParser.getPersistence() != null) {
            serviceConfigs.add(new CacheManagerPersistenceConfiguration(new File(configurationParser.getPersistence().getDirectory())));
        }
        if (configurationParser.getThreadPools() != null) {
            PooledExecutionServiceConfiguration poolsConfiguration = new PooledExecutionServiceConfiguration();
            for (ThreadPoolsType.ThreadPool pool : configurationParser.getThreadPools().getThreadPool()) {
                if (pool.isDefault()) {
                    poolsConfiguration.addDefaultPool(pool.getAlias(), pool.getMinSize().intValue(), pool.getMaxSize().intValue());
                    continue;
                }
                poolsConfiguration.addPool(pool.getAlias(), pool.getMinSize().intValue(), pool.getMaxSize().intValue());
            }
            serviceConfigs.add(poolsConfiguration);
        }
        if (configurationParser.getEventDispatch() != null) {
            ThreadPoolReferenceType eventDispatchThreading = configurationParser.getEventDispatch();
            serviceConfigs.add(new CacheEventDispatcherFactoryConfiguration(eventDispatchThreading.getThreadPool()));
        }
        if (configurationParser.getWriteBehind() != null) {
            ThreadPoolReferenceType writeBehindThreading = configurationParser.getWriteBehind();
            serviceConfigs.add(new WriteBehindProviderConfiguration(writeBehindThreading.getThreadPool()));
        }
        if (configurationParser.getDiskStore() != null) {
            ThreadPoolReferenceType diskStoreThreading = configurationParser.getDiskStore();
            serviceConfigs.add(new OffHeapDiskStoreProviderConfiguration(diskStoreThreading.getThreadPool()));
        }
        for (ServiceCreationConfiguration serviceConfiguration : Collections.unmodifiableList(serviceConfigs)) {
            this.serviceConfigurations.add(serviceConfiguration);
        }
        for (ConfigurationParser.CacheDefinition cacheDefinition : configurationParser.getCacheElements()) {
            String alias = cacheDefinition.id();
            ClassLoader cacheClassLoader = this.cacheClassLoaders.get(alias);
            boolean classLoaderConfigured = false;
            if (cacheClassLoader != null) {
                classLoaderConfigured = true;
            }
            if (cacheClassLoader == null) {
                cacheClassLoader = this.classLoader != null ? this.classLoader : ClassLoading.getDefaultClassLoader();
            }
            Class<?> keyType = XmlConfiguration.getClassForName(cacheDefinition.keyType(), cacheClassLoader);
            Class<?> valueType = XmlConfiguration.getClassForName(cacheDefinition.valueType(), cacheClassLoader);
            CacheConfigurationBuilder builder = CacheConfigurationBuilder.newCacheConfigurationBuilder(keyType, valueType);
            if (classLoaderConfigured) {
                builder = builder.withClassLoader(cacheClassLoader);
            }
            if (cacheDefinition.keySerializer() != null) {
                Class<?> keySerializer = XmlConfiguration.getClassForName(cacheDefinition.keySerializer(), cacheClassLoader);
                builder = builder.add((ServiceConfiguration)new DefaultSerializerConfiguration(keySerializer, DefaultSerializerConfiguration.Type.KEY));
            }
            if (cacheDefinition.keyCopier() != null) {
                Class<?> keyCopier = XmlConfiguration.getClassForName(cacheDefinition.keyCopier(), cacheClassLoader);
                builder = builder.add((ServiceConfiguration)new DefaultCopierConfiguration(keyCopier, DefaultCopierConfiguration.Type.KEY));
            }
            if (cacheDefinition.valueSerializer() != null) {
                Class<?> valueSerializer = XmlConfiguration.getClassForName(cacheDefinition.valueSerializer(), cacheClassLoader);
                builder = builder.add((ServiceConfiguration)new DefaultSerializerConfiguration(valueSerializer, DefaultSerializerConfiguration.Type.VALUE));
            }
            if (cacheDefinition.valueCopier() != null) {
                Class<?> valueCopier = XmlConfiguration.getClassForName(cacheDefinition.valueCopier(), cacheClassLoader);
                builder = builder.add((ServiceConfiguration)new DefaultCopierConfiguration(valueCopier, DefaultCopierConfiguration.Type.VALUE));
            }
            if (cacheDefinition.heapStoreSettings() != null) {
                builder = builder.add((ServiceConfiguration)new DefaultSizeOfEngineConfiguration(cacheDefinition.heapStoreSettings().getMaxObjectSize(), cacheDefinition.heapStoreSettings().getUnit(), cacheDefinition.heapStoreSettings().getMaxObjectGraphSize()));
            }
            EvictionVeto evictionVeto = XmlConfiguration.getInstanceOfName(cacheDefinition.evictionVeto(), cacheClassLoader, EvictionVeto.class);
            builder = builder.withEvictionVeto(evictionVeto);
            ConfigurationParser.Expiry parsedExpiry = cacheDefinition.expiry();
            if (parsedExpiry != null) {
                builder = builder.withExpiry(this.getExpiry(cacheClassLoader, parsedExpiry));
            }
            ResourcePoolsBuilder resourcePoolsBuilder = ResourcePoolsBuilder.newResourcePoolsBuilder();
            for (ResourcePool resourcePool : cacheDefinition.resourcePools()) {
                resourcePoolsBuilder = resourcePoolsBuilder.with(resourcePool.getType(), resourcePool.getSize(), resourcePool.getUnit(), resourcePool.isPersistent());
            }
            builder = builder.withResourcePools(resourcePoolsBuilder);
            ConfigurationParser.DiskStoreSettings parsedDiskStoreSettings = cacheDefinition.diskStoreSettings();
            if (parsedDiskStoreSettings != null) {
                builder = builder.add((ServiceConfiguration)new OffHeapDiskStoreConfiguration(parsedDiskStoreSettings.threadPool(), parsedDiskStoreSettings.writerConcurrency()));
            }
            for (ServiceConfiguration<?> serviceConfig : cacheDefinition.serviceConfigs()) {
                builder = builder.add(serviceConfig);
            }
            if (cacheDefinition.loaderWriter() != null) {
                Class<?> cacheLoaderWriterClass = XmlConfiguration.getClassForName(cacheDefinition.loaderWriter(), cacheClassLoader);
                builder = builder.add((ServiceConfiguration)new DefaultCacheLoaderWriterConfiguration(cacheLoaderWriterClass, new Object[0]));
                if (cacheDefinition.writeBehind() != null) {
                    WriteBehindConfigurationBuilder.UnBatchedWriteBehindConfigurationBuilder writeBehindConfigurationBuilder;
                    ConfigurationParser.WriteBehind writeBehind = cacheDefinition.writeBehind();
                    if (writeBehind.batching() == null) {
                        writeBehindConfigurationBuilder = WriteBehindConfigurationBuilder.newUnBatchedWriteBehindConfiguration();
                    } else {
                        ConfigurationParser.Batching batching = writeBehind.batching();
                        writeBehindConfigurationBuilder = WriteBehindConfigurationBuilder.newBatchedWriteBehindConfiguration((long)batching.maxDelay(), (TimeUnit)batching.maxDelayUnit(), (int)batching.batchSize());
                        if (batching.isCoalesced()) {
                            writeBehindConfigurationBuilder = ((WriteBehindConfigurationBuilder.BatchedWriteBehindConfigurationBuilder)writeBehindConfigurationBuilder).enableCoalescing();
                        }
                    }
                    builder = builder.add((Builder)writeBehindConfigurationBuilder.useThreadPool(writeBehind.threadPool()).concurrencyLevel(writeBehind.concurrency()).queueSize(writeBehind.maxQueueSize()));
                }
            }
            builder = this.handleListenersConfig(cacheDefinition.listenersConfig(), cacheClassLoader, builder);
            CacheConfiguration config = builder.build();
            this.cacheConfigurations.put(alias, config);
        }
        this.templates.putAll(configurationParser.getTemplates());
    }

    private Expiry<? super Object, ? super Object> getExpiry(ClassLoader cacheClassLoader, ConfigurationParser.Expiry parsedExpiry) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Expiry expiry = parsedExpiry.isUserDef() ? XmlConfiguration.getInstanceOfName(parsedExpiry.type(), cacheClassLoader, Expiry.class) : (parsedExpiry.isTTL() ? Expirations.timeToLiveExpiration((Duration)new Duration(parsedExpiry.value(), parsedExpiry.unit())) : (parsedExpiry.isTTI() ? Expirations.timeToIdleExpiration((Duration)new Duration(parsedExpiry.value(), parsedExpiry.unit())) : Expirations.noExpiration()));
        return expiry;
    }

    private static <T> T getInstanceOfName(String name, ClassLoader classLoader, Class<T> type) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (name == null) {
            return null;
        }
        Class<?> klazz = XmlConfiguration.getClassForName(name, classLoader);
        return klazz.asSubclass(type).newInstance();
    }

    private static Class<?> getClassForName(String name, ClassLoader classLoader) throws ClassNotFoundException {
        return Class.forName(name, true, classLoader);
    }

    public URL getURL() {
        return this.xml;
    }

    public CacheConfigurationBuilder<Object, Object> newCacheConfigurationBuilderFromTemplate(String name) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return this.newCacheConfigurationBuilderFromTemplate(name, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public <K, V> CacheConfigurationBuilder<K, V> newCacheConfigurationBuilderFromTemplate(String name, Class<K> keyType, Class<V> valueType) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String loaderWriter;
        ConfigurationParser.CacheTemplate cacheTemplate = this.templates.get(name);
        if (cacheTemplate == null) {
            return null;
        }
        ClassLoader defaultClassLoader = ClassLoading.getDefaultClassLoader();
        Class<K> keyClass = XmlConfiguration.getClassForName(cacheTemplate.keyType(), defaultClassLoader);
        Class<V> valueClass = XmlConfiguration.getClassForName(cacheTemplate.valueType(), defaultClassLoader);
        if (keyType != null && cacheTemplate.keyType() != null && !keyClass.isAssignableFrom(keyType)) {
            throw new IllegalArgumentException("CacheTemplate '" + name + "' declares key type of " + cacheTemplate.keyType());
        }
        if (valueType != null && cacheTemplate.valueType() != null && !valueClass.isAssignableFrom(valueType)) {
            throw new IllegalArgumentException("CacheTemplate '" + name + "' declares value type of " + cacheTemplate.valueType());
        }
        CacheConfigurationBuilder builder = CacheConfigurationBuilder.newCacheConfigurationBuilder(keyType, valueType);
        builder = builder.withEvictionVeto(XmlConfiguration.getInstanceOfName(cacheTemplate.evictionVeto(), defaultClassLoader, EvictionVeto.class));
        ConfigurationParser.Expiry parsedExpiry = cacheTemplate.expiry();
        if (parsedExpiry != null) {
            builder = builder.withExpiry(this.getExpiry(defaultClassLoader, parsedExpiry));
        }
        if (cacheTemplate.keySerializer() != null) {
            Class<?> keySerializer = XmlConfiguration.getClassForName(cacheTemplate.keySerializer(), defaultClassLoader);
            builder = builder.add((ServiceConfiguration)new DefaultSerializerConfiguration(keySerializer, DefaultSerializerConfiguration.Type.KEY));
        }
        if (cacheTemplate.keyCopier() != null) {
            Class<?> keyCopier = XmlConfiguration.getClassForName(cacheTemplate.keyCopier(), defaultClassLoader);
            builder = builder.add((ServiceConfiguration)new DefaultCopierConfiguration(keyCopier, DefaultCopierConfiguration.Type.KEY));
        }
        if (cacheTemplate.valueSerializer() != null) {
            Class<?> valueSerializer = XmlConfiguration.getClassForName(cacheTemplate.valueSerializer(), defaultClassLoader);
            builder = builder.add((ServiceConfiguration)new DefaultSerializerConfiguration(valueSerializer, DefaultSerializerConfiguration.Type.VALUE));
        }
        if (cacheTemplate.valueCopier() != null) {
            Class<?> valueCopier = XmlConfiguration.getClassForName(cacheTemplate.valueCopier(), defaultClassLoader);
            builder = builder.add((ServiceConfiguration)new DefaultCopierConfiguration(valueCopier, DefaultCopierConfiguration.Type.VALUE));
        }
        if (cacheTemplate.heapStoreSettings() != null) {
            builder = builder.add((ServiceConfiguration)new DefaultSizeOfEngineConfiguration(cacheTemplate.heapStoreSettings().getMaxObjectSize(), cacheTemplate.heapStoreSettings().getUnit(), cacheTemplate.heapStoreSettings().getMaxObjectGraphSize()));
        }
        if ((loaderWriter = cacheTemplate.loaderWriter()) != null) {
            Class<?> cacheLoaderWriterClass = XmlConfiguration.getClassForName(loaderWriter, defaultClassLoader);
            builder = builder.add((ServiceConfiguration)new DefaultCacheLoaderWriterConfiguration(cacheLoaderWriterClass, new Object[0]));
            if (cacheTemplate.writeBehind() != null) {
                void var13_16;
                ConfigurationParser.WriteBehind writeBehind = cacheTemplate.writeBehind();
                if (writeBehind.batching() == null) {
                    WriteBehindConfigurationBuilder.UnBatchedWriteBehindConfigurationBuilder unBatchedWriteBehindConfigurationBuilder = WriteBehindConfigurationBuilder.newUnBatchedWriteBehindConfiguration();
                } else {
                    ConfigurationParser.Batching batching = writeBehind.batching();
                    WriteBehindConfigurationBuilder.BatchedWriteBehindConfigurationBuilder batchedWriteBehindConfigurationBuilder = WriteBehindConfigurationBuilder.newBatchedWriteBehindConfiguration((long)batching.maxDelay(), (TimeUnit)batching.maxDelayUnit(), (int)batching.batchSize());
                    if (batching.isCoalesced()) {
                        WriteBehindConfigurationBuilder.BatchedWriteBehindConfigurationBuilder batchedWriteBehindConfigurationBuilder2 = batchedWriteBehindConfigurationBuilder.enableCoalescing();
                    }
                }
                builder = builder.add((Builder)var13_16.concurrencyLevel(writeBehind.concurrency()).queueSize(writeBehind.maxQueueSize()));
            }
        }
        builder = this.handleListenersConfig(cacheTemplate.listenersConfig(), defaultClassLoader, builder);
        ResourcePoolsBuilder resourcePoolsBuilder = ResourcePoolsBuilder.newResourcePoolsBuilder();
        for (ResourcePool resourcePool : cacheTemplate.resourcePools()) {
            resourcePoolsBuilder = resourcePoolsBuilder.with(resourcePool.getType(), resourcePool.getSize(), resourcePool.getUnit(), resourcePool.isPersistent());
        }
        builder = builder.withResourcePools(resourcePoolsBuilder);
        for (ServiceConfiguration serviceConfiguration : cacheTemplate.serviceConfigs()) {
            builder = builder.add(serviceConfiguration);
        }
        return builder;
    }

    private <K, V> CacheConfigurationBuilder<K, V> handleListenersConfig(ConfigurationParser.ListenersConfig listenersConfig, ClassLoader defaultClassLoader, CacheConfigurationBuilder<K, V> builder) throws ClassNotFoundException {
        if (listenersConfig != null) {
            if (listenersConfig.threadPool() != null) {
                builder = builder.add((ServiceConfiguration)new DefaultCacheEventDispatcherConfiguration(listenersConfig.threadPool()));
            }
            if (listenersConfig.listeners() != null) {
                for (ConfigurationParser.Listener listener : listenersConfig.listeners()) {
                    Class<?> cacheEventListenerClass = XmlConfiguration.getClassForName(listener.className(), defaultClassLoader);
                    List<EventType> eventListToFireOn = listener.fireOn();
                    HashSet<org.ehcache.event.EventType> eventSetToFireOn = new HashSet<org.ehcache.event.EventType>();
                    block8: for (EventType events : eventListToFireOn) {
                        switch (events) {
                            case CREATED: {
                                eventSetToFireOn.add(org.ehcache.event.EventType.CREATED);
                                continue block8;
                            }
                            case EVICTED: {
                                eventSetToFireOn.add(org.ehcache.event.EventType.EVICTED);
                                continue block8;
                            }
                            case EXPIRED: {
                                eventSetToFireOn.add(org.ehcache.event.EventType.EXPIRED);
                                continue block8;
                            }
                            case UPDATED: {
                                eventSetToFireOn.add(org.ehcache.event.EventType.UPDATED);
                                continue block8;
                            }
                            case REMOVED: {
                                eventSetToFireOn.add(org.ehcache.event.EventType.REMOVED);
                                continue block8;
                            }
                        }
                        throw new IllegalArgumentException("Invalid Event Type provided");
                    }
                    CacheEventListenerConfigurationBuilder listenerBuilder = CacheEventListenerConfigurationBuilder.newEventListenerConfiguration(cacheEventListenerClass, eventSetToFireOn).firingMode(EventFiring.valueOf((String)listener.eventFiring().value())).eventOrdering(EventOrdering.valueOf((String)listener.eventOrdering().value()));
                    builder = builder.add((Builder)listenerBuilder);
                }
            }
        }
        return builder;
    }

    public Map<String, CacheConfiguration<?, ?>> getCacheConfigurations() {
        return this.cacheConfigurations;
    }

    public Collection<ServiceCreationConfiguration<?>> getServiceCreationConfigurations() {
        return this.serviceConfigurations;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

