/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.xml;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import org.ehcache.config.ResourcePool;
import org.ehcache.config.ResourceType;
import org.ehcache.config.ResourceUnit;
import org.ehcache.config.units.EntryUnit;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.core.util.ClassLoading;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceCreationConfiguration;
import org.ehcache.xml.CacheManagerServiceConfigurationParser;
import org.ehcache.xml.CacheServiceConfigurationParser;
import org.ehcache.xml.JaxbHelper;
import org.ehcache.xml.model.BaseCacheType;
import org.ehcache.xml.model.CacheLoaderWriterType;
import org.ehcache.xml.model.CacheTemplateType;
import org.ehcache.xml.model.CacheType;
import org.ehcache.xml.model.ConfigType;
import org.ehcache.xml.model.CopierType;
import org.ehcache.xml.model.DiskStoreSettingsType;
import org.ehcache.xml.model.EventFiringType;
import org.ehcache.xml.model.EventOrderingType;
import org.ehcache.xml.model.EventType;
import org.ehcache.xml.model.ExpiryType;
import org.ehcache.xml.model.ListenersType;
import org.ehcache.xml.model.MemoryType;
import org.ehcache.xml.model.PersistableMemoryType;
import org.ehcache.xml.model.PersistenceType;
import org.ehcache.xml.model.ResourceType;
import org.ehcache.xml.model.ResourcesType;
import org.ehcache.xml.model.SerializerType;
import org.ehcache.xml.model.ServiceType;
import org.ehcache.xml.model.SizeofType;
import org.ehcache.xml.model.ThreadPoolReferenceType;
import org.ehcache.xml.model.ThreadPoolsType;
import org.ehcache.xml.model.TimeType;
import org.ehcache.xml.model.TimeUnit;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class ConfigurationParser {
    private static final SchemaFactory XSD_SCHEMA_FACTORY = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    private final Map<URI, CacheManagerServiceConfigurationParser<?>> xmlParsers = new HashMap();
    private final Map<URI, CacheServiceConfigurationParser<?>> cacheXmlParsers = new HashMap();
    private final ConfigType config;

    public ConfigurationParser(String xml, URL ... sources) throws IOException, SAXException {
        DocumentBuilder domBuilder;
        ArrayList<Source> schemaSources = new ArrayList<Source>();
        for (Object parser : ClassLoading.libraryServiceLoaderFor(CacheManagerServiceConfigurationParser.class)) {
            schemaSources.add(parser.getXmlSchema());
            this.xmlParsers.put(parser.getNamespace(), (CacheManagerServiceConfigurationParser<?>)parser);
        }
        for (Object parser : ClassLoading.libraryServiceLoaderFor(CacheServiceConfigurationParser.class)) {
            schemaSources.add(parser.getXmlSchema());
            this.cacheXmlParsers.put(parser.getNamespace(), (CacheServiceConfigurationParser<?>)parser);
        }
        for (URL source : sources) {
            schemaSources.add(new StreamSource(source.openStream()));
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setIgnoringComments(true);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setSchema(XSD_SCHEMA_FACTORY.newSchema(schemaSources.toArray(new Source[schemaSources.size()])));
        try {
            domBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new AssertionError((Object)e);
        }
        domBuilder.setErrorHandler(new FatalErrorHandler());
        Element config = domBuilder.parse(xml).getDocumentElement();
        try {
            Class<ConfigType> configTypeClass = ConfigType.class;
            JAXBContext jc = JAXBContext.newInstance((String)"org.ehcache.xml.model", (ClassLoader)configTypeClass.getClassLoader());
            Unmarshaller u = jc.createUnmarshaller();
            this.config = (ConfigType)u.unmarshal((Node)config, configTypeClass).getValue();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public Iterable<ServiceType> getServiceElements() {
        return this.config.getService();
    }

    public SerializerType getDefaultSerializers() {
        return this.config.getDefaultSerializers();
    }

    public CopierType getDefaultCopiers() {
        return this.config.getDefaultCopiers();
    }

    public PersistenceType getPersistence() {
        return this.config.getPersistence();
    }

    public ThreadPoolReferenceType getEventDispatch() {
        return this.config.getEventDispatch();
    }

    public ThreadPoolReferenceType getWriteBehind() {
        return this.config.getWriteBehind();
    }

    public ThreadPoolReferenceType getDiskStore() {
        return this.config.getDiskStore();
    }

    public ThreadPoolsType getThreadPools() {
        return this.config.getThreadPools();
    }

    public SizeofType getHeapStore() {
        return this.config.getHeapStore();
    }

    public Iterable<CacheDefinition> getCacheElements() {
        ArrayList<1> cacheCfgs = new ArrayList<1>();
        List<BaseCacheType> cacheOrCacheTemplate = this.config.getCacheOrCacheTemplate();
        for (BaseCacheType baseCacheType : cacheOrCacheTemplate) {
            if (!(baseCacheType instanceof CacheType)) continue;
            final CacheType cacheType = (CacheType)baseCacheType;
            final BaseCacheType[] sources = cacheType.getUsesTemplate() != null ? new BaseCacheType[]{cacheType, (BaseCacheType)cacheType.getUsesTemplate()} : new BaseCacheType[]{cacheType};
            cacheCfgs.add(new CacheDefinition(){

                @Override
                public String id() {
                    return cacheType.getAlias();
                }

                @Override
                public String keyType() {
                    String value = null;
                    for (BaseCacheType source : sources) {
                        String string = value = source.getKeyType() != null ? source.getKeyType().getValue() : null;
                        if (value != null) break;
                    }
                    if (value == null) {
                        BaseCacheType source;
                        BaseCacheType[] arr$ = sources;
                        int len$ = arr$.length;
                        for (int i$ = 0; i$ < len$ && (value = JaxbHelper.findDefaultValue(source = arr$[i$], "keyType")) == null; ++i$) {
                        }
                    }
                    return value;
                }

                @Override
                public String keySerializer() {
                    String value = null;
                    for (BaseCacheType source : sources) {
                        String string = value = source.getKeyType() != null ? source.getKeyType().getSerializer() : null;
                        if (value != null) break;
                    }
                    return value;
                }

                @Override
                public String keyCopier() {
                    String value = null;
                    for (BaseCacheType source : sources) {
                        String string = value = source.getKeyType() != null ? source.getKeyType().getCopier() : null;
                        if (value != null) break;
                    }
                    return value;
                }

                @Override
                public String valueType() {
                    String value = null;
                    for (BaseCacheType source : sources) {
                        String string = value = source.getValueType() != null ? source.getValueType().getValue() : null;
                        if (value != null) break;
                    }
                    if (value == null) {
                        BaseCacheType source;
                        BaseCacheType[] arr$ = sources;
                        int len$ = arr$.length;
                        for (int i$ = 0; i$ < len$ && (value = JaxbHelper.findDefaultValue(source = arr$[i$], "valueType")) == null; ++i$) {
                        }
                    }
                    return value;
                }

                @Override
                public String valueSerializer() {
                    String value = null;
                    for (BaseCacheType source : sources) {
                        String string = value = source.getValueType() != null ? source.getValueType().getSerializer() : null;
                        if (value != null) break;
                    }
                    return value;
                }

                @Override
                public String valueCopier() {
                    String value = null;
                    for (BaseCacheType source : sources) {
                        String string = value = source.getValueType() != null ? source.getValueType().getCopier() : null;
                        if (value != null) break;
                    }
                    return value;
                }

                @Override
                public String evictionVeto() {
                    BaseCacheType source;
                    String value = null;
                    BaseCacheType[] arr$ = sources;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$ && (value = (source = arr$[i$]).getEvictionVeto()) == null; ++i$) {
                    }
                    return value;
                }

                @Override
                public Expiry expiry() {
                    BaseCacheType source;
                    ExpiryType value = null;
                    BaseCacheType[] arr$ = sources;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$ && (value = (source = arr$[i$]).getExpiry()) == null; ++i$) {
                    }
                    if (value != null) {
                        return new XmlExpiry(value);
                    }
                    return null;
                }

                @Override
                public String loaderWriter() {
                    String configClass = null;
                    for (BaseCacheType source : sources) {
                        CacheLoaderWriterType loaderWriter = source.getLoaderWriter();
                        if (loaderWriter == null) continue;
                        configClass = loaderWriter.getClazz();
                        break;
                    }
                    return configClass;
                }

                @Override
                public ListenersConfig listenersConfig() {
                    ListenersType base = null;
                    ArrayList<ListenersType> additionals = new ArrayList<ListenersType>();
                    for (BaseCacheType source : sources) {
                        if (source.getListeners() == null) continue;
                        if (base == null) {
                            base = source.getListeners();
                            continue;
                        }
                        additionals.add(source.getListeners());
                    }
                    return base != null ? new XmlListenersConfig(base, additionals.toArray(new ListenersType[0])) : null;
                }

                @Override
                public Iterable<ServiceConfiguration<?>> serviceConfigs() {
                    ArrayList configs = new ArrayList();
                    for (BaseCacheType source : sources) {
                        for (Object child : source.getAny()) {
                            configs.add(ConfigurationParser.this.parseCacheExtension((Element)child));
                        }
                    }
                    return configs;
                }

                @Override
                public Iterable<ResourcePool> resourcePools() {
                    ArrayList<ResourcePool> resourcePools = new ArrayList<ResourcePool>();
                    for (BaseCacheType source : sources) {
                        PersistableMemoryType diskResource;
                        MemoryType offheapResource;
                        ResourceType directHeapResource = source.getHeap();
                        if (directHeapResource != null) {
                            resourcePools.add(new ResourcePoolImpl((org.ehcache.config.ResourceType)ResourceType.Core.HEAP, directHeapResource.getValue().longValue(), ConfigurationParser.this.parseUnit(directHeapResource), false));
                            continue;
                        }
                        ResourcesType resources = source.getResources();
                        if (resources == null) continue;
                        ResourceType heapResource = resources.getHeap();
                        if (heapResource != null) {
                            resourcePools.add(new ResourcePoolImpl((org.ehcache.config.ResourceType)ResourceType.Core.HEAP, heapResource.getValue().longValue(), ConfigurationParser.this.parseUnit(heapResource), false));
                        }
                        if ((offheapResource = resources.getOffheap()) != null) {
                            resourcePools.add(new ResourcePoolImpl((org.ehcache.config.ResourceType)ResourceType.Core.OFFHEAP, offheapResource.getValue().longValue(), (ResourceUnit)ConfigurationParser.this.parseMemory(offheapResource), false));
                        }
                        if ((diskResource = resources.getDisk()) == null) continue;
                        resourcePools.add(new ResourcePoolImpl((org.ehcache.config.ResourceType)ResourceType.Core.DISK, diskResource.getValue().longValue(), (ResourceUnit)ConfigurationParser.this.parseMemory(diskResource), diskResource.isPersistent()));
                    }
                    return resourcePools;
                }

                @Override
                public WriteBehind writeBehind() {
                    for (BaseCacheType source : sources) {
                        CacheLoaderWriterType.WriteBehind writebehind;
                        CacheLoaderWriterType loaderWriter = source.getLoaderWriter();
                        CacheLoaderWriterType.WriteBehind writeBehind = writebehind = loaderWriter != null ? loaderWriter.getWriteBehind() : null;
                        if (writebehind == null) continue;
                        return new XmlWriteBehind(writebehind);
                    }
                    return null;
                }

                @Override
                public DiskStoreSettings diskStoreSettings() {
                    BaseCacheType source;
                    DiskStoreSettingsType value = null;
                    BaseCacheType[] arr$ = sources;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$ && (value = (source = arr$[i$]).getDiskStoreSettings()) == null; ++i$) {
                    }
                    if (value != null) {
                        return new XmlDiskStoreSettings(value);
                    }
                    return null;
                }

                @Override
                public SizeOfEngineLimits heapStoreSettings() {
                    BaseCacheType source;
                    SizeofType sizeofType = null;
                    BaseCacheType[] arr$ = sources;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$ && (sizeofType = (source = arr$[i$]).getHeapStoreSettings()) == null; ++i$) {
                    }
                    return sizeofType != null ? new XmlSizeOfEngineLimits(sizeofType) : null;
                }
            });
        }
        return Collections.unmodifiableList(cacheCfgs);
    }

    public Map<String, CacheTemplate> getTemplates() {
        HashMap<String, 2> templates = new HashMap<String, 2>();
        List<BaseCacheType> cacheOrCacheTemplate = this.config.getCacheOrCacheTemplate();
        for (BaseCacheType baseCacheType : cacheOrCacheTemplate) {
            if (!(baseCacheType instanceof CacheTemplateType)) continue;
            final CacheTemplateType cacheTemplate = (CacheTemplateType)baseCacheType;
            templates.put(cacheTemplate.getName(), new CacheTemplate(){

                @Override
                public String keyType() {
                    String keyType;
                    String string = keyType = cacheTemplate.getKeyType() != null ? cacheTemplate.getKeyType().getValue() : null;
                    if (keyType == null) {
                        keyType = JaxbHelper.findDefaultValue(cacheTemplate, "keyType");
                    }
                    return keyType;
                }

                @Override
                public String keySerializer() {
                    return cacheTemplate.getKeyType() != null ? cacheTemplate.getKeyType().getSerializer() : null;
                }

                @Override
                public String keyCopier() {
                    return cacheTemplate.getKeyType() != null ? cacheTemplate.getKeyType().getCopier() : null;
                }

                @Override
                public String valueType() {
                    String valueType;
                    String string = valueType = cacheTemplate.getValueType() != null ? cacheTemplate.getValueType().getValue() : null;
                    if (valueType == null) {
                        valueType = JaxbHelper.findDefaultValue(cacheTemplate, "valueType");
                    }
                    return valueType;
                }

                @Override
                public String valueSerializer() {
                    return cacheTemplate.getValueType() != null ? cacheTemplate.getValueType().getSerializer() : null;
                }

                @Override
                public String valueCopier() {
                    return cacheTemplate.getValueType() != null ? cacheTemplate.getValueType().getCopier() : null;
                }

                @Override
                public String evictionVeto() {
                    return cacheTemplate.getEvictionVeto();
                }

                @Override
                public Expiry expiry() {
                    ExpiryType cacheTemplateExpiry = cacheTemplate.getExpiry();
                    if (cacheTemplateExpiry != null) {
                        return new XmlExpiry(cacheTemplateExpiry);
                    }
                    return null;
                }

                @Override
                public ListenersConfig listenersConfig() {
                    ListenersType integration = cacheTemplate.getListeners();
                    return integration != null ? new XmlListenersConfig(integration, new ListenersType[0]) : null;
                }

                @Override
                public String loaderWriter() {
                    CacheLoaderWriterType loaderWriter = cacheTemplate.getLoaderWriter();
                    return loaderWriter != null ? loaderWriter.getClazz() : null;
                }

                @Override
                public Iterable<ServiceConfiguration<?>> serviceConfigs() {
                    ArrayList configs = new ArrayList();
                    for (Object child : cacheTemplate.getAny()) {
                        configs.add((ServiceConfiguration)ConfigurationParser.this.parseExtension((Element)child));
                        configs.add(ConfigurationParser.this.parseCacheExtension((Element)child));
                    }
                    return configs;
                }

                @Override
                public Iterable<ResourcePool> resourcePools() {
                    ArrayList<ResourcePool> resourcePools = new ArrayList<ResourcePool>();
                    ResourceType directHeapResource = cacheTemplate.getHeap();
                    if (directHeapResource != null) {
                        resourcePools.add(new ResourcePoolImpl((org.ehcache.config.ResourceType)ResourceType.Core.HEAP, directHeapResource.getValue().longValue(), ConfigurationParser.this.parseUnit(directHeapResource), false));
                    } else {
                        ResourcesType resources = cacheTemplate.getResources();
                        if (resources != null) {
                            PersistableMemoryType diskResource;
                            MemoryType offheapResource;
                            ResourceType heapResource = resources.getHeap();
                            if (heapResource != null) {
                                resourcePools.add(new ResourcePoolImpl((org.ehcache.config.ResourceType)ResourceType.Core.HEAP, heapResource.getValue().longValue(), ConfigurationParser.this.parseUnit(heapResource), false));
                            }
                            if ((offheapResource = resources.getOffheap()) != null) {
                                resourcePools.add(new ResourcePoolImpl((org.ehcache.config.ResourceType)ResourceType.Core.OFFHEAP, offheapResource.getValue().longValue(), (ResourceUnit)ConfigurationParser.this.parseMemory(offheapResource), false));
                            }
                            if ((diskResource = resources.getDisk()) != null) {
                                resourcePools.add(new ResourcePoolImpl((org.ehcache.config.ResourceType)ResourceType.Core.DISK, diskResource.getValue().longValue(), (ResourceUnit)ConfigurationParser.this.parseMemory(diskResource), diskResource.isPersistent()));
                            }
                        }
                    }
                    return resourcePools;
                }

                @Override
                public WriteBehind writeBehind() {
                    CacheLoaderWriterType loaderWriter = cacheTemplate.getLoaderWriter();
                    CacheLoaderWriterType.WriteBehind writebehind = loaderWriter != null ? loaderWriter.getWriteBehind() : null;
                    return writebehind != null ? new XmlWriteBehind(writebehind) : null;
                }

                @Override
                public DiskStoreSettings diskStoreSettings() {
                    DiskStoreSettingsType diskStoreSettings = cacheTemplate.getDiskStoreSettings();
                    return diskStoreSettings == null ? null : new XmlDiskStoreSettings(diskStoreSettings);
                }

                @Override
                public SizeOfEngineLimits heapStoreSettings() {
                    SizeofType type = cacheTemplate.getHeapStoreSettings();
                    return type == null ? null : new XmlSizeOfEngineLimits(type);
                }
            });
        }
        return Collections.unmodifiableMap(templates);
    }

    private ResourceUnit parseUnit(ResourceType resourceType) {
        if (resourceType.getUnit().value().equalsIgnoreCase("entries")) {
            return EntryUnit.ENTRIES;
        }
        return MemoryUnit.valueOf((String)resourceType.getUnit().value().toUpperCase());
    }

    private MemoryUnit parseMemory(MemoryType memoryType) {
        return MemoryUnit.valueOf((String)memoryType.getUnit().value().toUpperCase());
    }

    ServiceCreationConfiguration<?> parseExtension(Element element) {
        URI namespace = URI.create(element.getNamespaceURI());
        CacheManagerServiceConfigurationParser<?> cacheManagerServiceConfigurationParser = this.xmlParsers.get(namespace);
        if (cacheManagerServiceConfigurationParser == null) {
            throw new IllegalArgumentException("Can't find parser for namespace: " + namespace);
        }
        return cacheManagerServiceConfigurationParser.parseServiceCreationConfiguration(element);
    }

    ServiceConfiguration<?> parseCacheExtension(Element element) {
        URI namespace = URI.create(element.getNamespaceURI());
        CacheServiceConfigurationParser<?> xmlConfigurationParser = this.cacheXmlParsers.get(namespace);
        if (xmlConfigurationParser == null) {
            throw new IllegalArgumentException("Can't find parser for namespace: " + namespace);
        }
        return xmlConfigurationParser.parseServiceConfiguration(element);
    }

    private static java.util.concurrent.TimeUnit convertToJavaTimeUnit(TimeUnit unit) {
        switch (unit) {
            case NANOS: {
                return java.util.concurrent.TimeUnit.NANOSECONDS;
            }
            case MICROS: {
                return java.util.concurrent.TimeUnit.MICROSECONDS;
            }
            case MILLIS: {
                return java.util.concurrent.TimeUnit.MILLISECONDS;
            }
            case SECONDS: {
                return java.util.concurrent.TimeUnit.SECONDS;
            }
            case MINUTES: {
                return java.util.concurrent.TimeUnit.MINUTES;
            }
            case HOURS: {
                return java.util.concurrent.TimeUnit.HOURS;
            }
            case DAYS: {
                return java.util.concurrent.TimeUnit.DAYS;
            }
        }
        throw new IllegalArgumentException("Unknown time unit: " + (Object)((Object)unit));
    }

    private static class XmlDiskStoreSettings
    implements DiskStoreSettings {
        private final DiskStoreSettingsType diskStoreSettings;

        private XmlDiskStoreSettings(DiskStoreSettingsType diskStoreSettings) {
            this.diskStoreSettings = diskStoreSettings;
        }

        @Override
        public int writerConcurrency() {
            return this.diskStoreSettings.getWriterThreads().intValue();
        }

        @Override
        public String threadPool() {
            return this.diskStoreSettings.getThreadPool();
        }
    }

    private static class XmlBatching
    implements Batching {
        private final CacheLoaderWriterType.WriteBehind.Batching batching;

        private XmlBatching(CacheLoaderWriterType.WriteBehind.Batching batching) {
            this.batching = batching;
        }

        @Override
        public boolean isCoalesced() {
            return this.batching.isCoalesce();
        }

        @Override
        public int batchSize() {
            return this.batching.getBatchSize().intValue();
        }

        @Override
        public long maxDelay() {
            return this.batching.getMaxWriteDelay().getValue().longValue();
        }

        @Override
        public java.util.concurrent.TimeUnit maxDelayUnit() {
            return ConfigurationParser.convertToJavaTimeUnit(this.batching.getMaxWriteDelay().getUnit());
        }
    }

    private static class XmlWriteBehind
    implements WriteBehind {
        private final CacheLoaderWriterType.WriteBehind writebehind;

        private XmlWriteBehind(CacheLoaderWriterType.WriteBehind writebehind) {
            this.writebehind = writebehind;
        }

        @Override
        public int maxQueueSize() {
            return this.writebehind.getSize().intValue();
        }

        @Override
        public int concurrency() {
            return this.writebehind.getConcurrency().intValue();
        }

        @Override
        public String threadPool() {
            return this.writebehind.getThreadPool();
        }

        @Override
        public Batching batching() {
            CacheLoaderWriterType.WriteBehind.Batching batching = this.writebehind.getBatching();
            if (batching == null) {
                return null;
            }
            return new XmlBatching(batching);
        }
    }

    private static class XmlSizeOfEngineLimits
    implements SizeOfEngineLimits {
        private final SizeofType sizeoflimits;

        private XmlSizeOfEngineLimits(SizeofType sizeoflimits) {
            this.sizeoflimits = sizeoflimits;
        }

        @Override
        public long getMaxObjectGraphSize() {
            return this.sizeoflimits.getMaxObjectGraphSize().getValue().longValue();
        }

        @Override
        public long getMaxObjectSize() {
            return this.sizeoflimits.getMaxObjectSize().getValue().longValue();
        }

        @Override
        public MemoryUnit getUnit() {
            return MemoryUnit.valueOf((String)this.sizeoflimits.getMaxObjectSize().getUnit().value().toUpperCase());
        }
    }

    private static class XmlExpiry
    implements Expiry {
        final ExpiryType type;

        private XmlExpiry(ExpiryType type) {
            this.type = type;
        }

        @Override
        public boolean isUserDef() {
            return this.type != null && this.type.getClazz() != null;
        }

        @Override
        public boolean isTTI() {
            return this.type != null && this.type.getTti() != null;
        }

        @Override
        public boolean isTTL() {
            return this.type != null && this.type.getTtl() != null;
        }

        @Override
        public String type() {
            return this.type.getClazz();
        }

        @Override
        public long value() {
            TimeType time = this.isTTI() ? this.type.getTti() : this.type.getTtl();
            return time == null ? 0L : time.getValue().longValue();
        }

        @Override
        public java.util.concurrent.TimeUnit unit() {
            TimeType time = this.isTTI() ? this.type.getTti() : this.type.getTtl();
            if (time != null) {
                return ConfigurationParser.convertToJavaTimeUnit(time.getUnit());
            }
            return null;
        }
    }

    private static class XmlListenersConfig
    implements ListenersConfig {
        final int parallelismLevel;
        final String threadPool;
        final Iterable<Listener> listeners;

        private XmlListenersConfig(ListenersType type, ListenersType ... others) {
            this.parallelismLevel = type.getParallelismLevel().intValue();
            String threadPool = type.getThreadPool();
            HashSet<Listener> listenerSet = new HashSet<Listener>();
            List<ListenersType.Listener> xmlListeners = type.getListener();
            this.extractListeners(listenerSet, xmlListeners);
            for (ListenersType other : others) {
                if (threadPool == null && other.getThreadPool() != null) {
                    threadPool = other.getThreadPool();
                }
                this.extractListeners(listenerSet, other.getListener());
            }
            this.threadPool = threadPool;
            this.listeners = !listenerSet.isEmpty() ? listenerSet : null;
        }

        private void extractListeners(Set<Listener> listenerSet, List<ListenersType.Listener> xmlListeners) {
            if (xmlListeners != null) {
                for (final ListenersType.Listener listener : xmlListeners) {
                    listenerSet.add(new Listener(){

                        @Override
                        public String className() {
                            return listener.getClazz();
                        }

                        @Override
                        public EventFiringType eventFiring() {
                            return listener.getEventFiringMode();
                        }

                        @Override
                        public EventOrderingType eventOrdering() {
                            return listener.getEventOrderingMode();
                        }

                        @Override
                        public List<EventType> fireOn() {
                            return listener.getEventsToFireOn();
                        }
                    });
                }
            }
        }

        @Override
        public int parallelismLevel() {
            return this.parallelismLevel;
        }

        @Override
        public String threadPool() {
            return this.threadPool;
        }

        @Override
        public Iterable<Listener> listeners() {
            return this.listeners;
        }
    }

    static interface SizeOfEngineLimits {
        public long getMaxObjectGraphSize();

        public long getMaxObjectSize();

        public MemoryUnit getUnit();
    }

    static interface DiskStoreSettings {
        public int writerConcurrency();

        public String threadPool();
    }

    static interface Batching {
        public boolean isCoalesced();

        public int batchSize();

        public long maxDelay();

        public java.util.concurrent.TimeUnit maxDelayUnit();
    }

    static interface WriteBehind {
        public int maxQueueSize();

        public int concurrency();

        public String threadPool();

        public Batching batching();
    }

    static interface Expiry {
        public boolean isUserDef();

        public boolean isTTI();

        public boolean isTTL();

        public String type();

        public long value();

        public java.util.concurrent.TimeUnit unit();
    }

    static interface Listener {
        public String className();

        public EventFiringType eventFiring();

        public EventOrderingType eventOrdering();

        public List<EventType> fireOn();
    }

    static interface ListenersConfig {
        public int parallelismLevel();

        public String threadPool();

        public Iterable<Listener> listeners();
    }

    static interface CacheDefinition
    extends CacheTemplate {
        public String id();
    }

    static interface CacheTemplate {
        public String keyType();

        public String keySerializer();

        public String keyCopier();

        public String valueType();

        public String valueSerializer();

        public String valueCopier();

        public String evictionVeto();

        public Expiry expiry();

        public String loaderWriter();

        public ListenersConfig listenersConfig();

        public Iterable<ServiceConfiguration<?>> serviceConfigs();

        public Iterable<ResourcePool> resourcePools();

        public WriteBehind writeBehind();

        public DiskStoreSettings diskStoreSettings();

        public SizeOfEngineLimits heapStoreSettings();
    }

    static class FatalErrorHandler
    implements ErrorHandler {
        FatalErrorHandler() {
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }
    }

    private static final class ResourcePoolImpl
    implements ResourcePool {
        private final org.ehcache.config.ResourceType type;
        private final long size;
        private final ResourceUnit unit;
        private final boolean persistent;

        public ResourcePoolImpl(org.ehcache.config.ResourceType type, long size, ResourceUnit unit, boolean persistent) {
            this.type = type;
            this.size = size;
            this.unit = unit;
            this.persistent = persistent;
        }

        public org.ehcache.config.ResourceType getType() {
            return this.type;
        }

        public long getSize() {
            return this.size;
        }

        public ResourceUnit getUnit() {
            return this.unit;
        }

        public boolean isPersistent() {
            return this.persistent;
        }
    }
}

