/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.registry;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.ehcache.Cache;
import org.ehcache.Status;
import org.ehcache.core.events.CacheManagerListener;
import org.ehcache.core.spi.service.CacheManagerProviderService;
import org.ehcache.core.spi.service.ExecutionService;
import org.ehcache.core.spi.store.InternalCacheManager;
import org.ehcache.core.spi.time.TimeSource;
import org.ehcache.core.spi.time.TimeSourceService;
import org.ehcache.impl.internal.executor.ExecutorUtil;
import org.ehcache.management.CollectorService;
import org.ehcache.management.ManagementRegistryService;
import org.ehcache.management.ManagementRegistryServiceConfiguration;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceDependencies;
import org.ehcache.spi.service.ServiceProvider;
import org.terracotta.management.model.notification.ContextualNotification;
import org.terracotta.management.registry.CapabilityManagementSupport;
import org.terracotta.management.registry.collect.DefaultStatisticCollector;

@ServiceDependencies(value={CacheManagerProviderService.class, ManagementRegistryService.class, ExecutionService.class, TimeSourceService.class})
public class DefaultCollectorService
implements CollectorService,
CacheManagerListener {
    private final CollectorService.Collector collector;
    private volatile ManagementRegistryService managementRegistry;
    private volatile ScheduledExecutorService scheduledExecutorService;
    private volatile InternalCacheManager cacheManager;
    private volatile ManagementRegistryServiceConfiguration configuration;
    private volatile DefaultStatisticCollector statisticCollector;

    public DefaultCollectorService() {
        this(CollectorService.Collector.EMPTY);
    }

    public DefaultCollectorService(CollectorService.Collector collector) {
        this.collector = collector;
    }

    public synchronized void start(ServiceProvider<Service> serviceProvider) {
        this.managementRegistry = (ManagementRegistryService)serviceProvider.getService(ManagementRegistryService.class);
        this.configuration = this.managementRegistry.getConfiguration();
        this.cacheManager = ((CacheManagerProviderService)serviceProvider.getService(CacheManagerProviderService.class)).getCacheManager();
        this.scheduledExecutorService = ((ExecutionService)serviceProvider.getService(ExecutionService.class)).getScheduledExecutor(this.configuration.getCollectorExecutorAlias());
        TimeSource timeSource = ((TimeSourceService)serviceProvider.getService(TimeSourceService.class)).getTimeSource();
        this.statisticCollector = new DefaultStatisticCollector((CapabilityManagementSupport)this.managementRegistry, this.scheduledExecutorService, this.collector::onStatistics, () -> ((TimeSource)timeSource).getTimeMillis());
        this.cacheManager.registerListener((CacheManagerListener)this);
    }

    public synchronized void stop() {
        this.collector.onNotification(new ContextualNotification(this.configuration.getContext(), EhcacheNotification.CACHE_MANAGER_CLOSED.name()));
        this.statisticCollector.stopStatisticCollector();
        ExecutorUtil.shutdownNow((ExecutorService)this.scheduledExecutorService);
    }

    public void cacheAdded(String alias, Cache<?, ?> cache) {
        this.collector.onNotification(new ContextualNotification(this.configuration.getContext().with("cacheName", alias), EhcacheNotification.CACHE_ADDED.name()));
    }

    public void cacheRemoved(String alias, Cache<?, ?> cache) {
        this.collector.onNotification(new ContextualNotification(this.configuration.getContext().with("cacheName", alias), EhcacheNotification.CACHE_REMOVED.name()));
    }

    public void stateTransition(Status from, Status to) {
        switch (to) {
            case AVAILABLE: {
                this.managementRegistry.register(this.statisticCollector);
                this.collector.onNotification(new ContextualNotification(this.configuration.getContext(), EhcacheNotification.CACHE_MANAGER_AVAILABLE.name()));
                break;
            }
            case MAINTENANCE: {
                this.collector.onNotification(new ContextualNotification(this.configuration.getContext(), EhcacheNotification.CACHE_MANAGER_MAINTENANCE.name()));
                break;
            }
            case UNINITIALIZED: {
                this.cacheManager.deregisterListener((CacheManagerListener)this);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported state: " + to));
            }
        }
    }

    private static enum EhcacheNotification {
        CACHE_ADDED,
        CACHE_REMOVED,
        CACHE_MANAGER_AVAILABLE,
        CACHE_MANAGER_MAINTENANCE,
        CACHE_MANAGER_CLOSED;

    }
}

