/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.providers.statistics;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.ehcache.core.spi.service.StatisticsService;
import org.ehcache.core.spi.time.TimeSource;
import org.ehcache.management.ManagementRegistryServiceConfiguration;
import org.ehcache.management.providers.CacheBinding;
import org.ehcache.management.providers.CacheBindingManagementProvider;
import org.ehcache.management.providers.ExposedCacheBinding;
import org.ehcache.management.providers.statistics.StandardEhcacheStatistics;
import org.terracotta.management.model.capabilities.descriptors.Descriptor;
import org.terracotta.management.model.capabilities.descriptors.StatisticDescriptor;
import org.terracotta.management.model.context.Context;
import org.terracotta.management.registry.DefaultStatisticsManagementProvider;
import org.terracotta.management.registry.Named;
import org.terracotta.management.registry.collect.StatisticProvider;
import org.terracotta.management.registry.collect.StatisticRegistry;
import org.terracotta.statistics.registry.Statistic;

@Named(value="StatisticsCapability")
@StatisticProvider
public class EhcacheStatisticsProvider
extends CacheBindingManagementProvider {
    private final StatisticsService statisticsService;
    private final TimeSource timeSource;

    public EhcacheStatisticsProvider(ManagementRegistryServiceConfiguration configuration, StatisticsService statisticsService, TimeSource timeSource) {
        super(configuration);
        this.statisticsService = Objects.requireNonNull(statisticsService);
        this.timeSource = Objects.requireNonNull(timeSource);
    }

    @Override
    protected ExposedCacheBinding wrap(CacheBinding cacheBinding) {
        return new StandardEhcacheStatistics(this.registryConfiguration, cacheBinding, this.statisticsService, this.timeSource);
    }

    public final Collection<? extends Descriptor> getDescriptors() {
        return super.getDescriptors().stream().map(d -> (StatisticDescriptor)d).sorted(STATISTIC_DESCRIPTOR_COMPARATOR).collect(Collectors.toList());
    }

    public Map<String, Statistic<? extends Serializable>> collectStatistics(Context context, Collection<String> statisticNames) {
        StandardEhcacheStatistics exposedObject = (StandardEhcacheStatistics)this.findExposedObject(context);
        if (exposedObject == null) {
            return Collections.emptyMap();
        }
        return DefaultStatisticsManagementProvider.collect((StatisticRegistry)exposedObject.getStatisticRegistry(), statisticNames);
    }
}

