/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.registry;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.ehcache.management.ManagementRegistryService;
import org.ehcache.management.config.DefaultStatisticsProviderConfiguration;
import org.ehcache.management.config.EhcacheStatisticsProviderConfiguration;
import org.ehcache.management.registry.DefaultManagementRegistryConfiguration;
import org.ehcache.management.registry.NodeListIterable;
import org.ehcache.spi.service.ServiceCreationConfiguration;
import org.ehcache.xml.CacheManagerServiceConfigurationParser;
import org.ehcache.xml.XmlModel;
import org.ehcache.xml.exceptions.XmlConfigurationException;
import org.terracotta.management.registry.ManagementProvider;
import org.w3c.dom.Element;

public class ManagementRegistryServiceConfigurationParser
implements CacheManagerServiceConfigurationParser<ManagementRegistryService> {
    private static final String NAMESPACE = "http://www.ehcache.org/v3/management";
    private static final URI NAMESPACE_URI = URI.create("http://www.ehcache.org/v3/management");
    private static final URL XML_SCHEMA = ManagementRegistryServiceConfigurationParser.class.getResource("/ehcache-management-ext.xsd");

    public Source getXmlSchema() throws IOException {
        return new StreamSource(XML_SCHEMA.openStream());
    }

    public URI getNamespace() {
        return NAMESPACE_URI;
    }

    public ServiceCreationConfiguration<ManagementRegistryService> parseServiceCreationConfiguration(Element fragment) {
        if ("management".equals(fragment.getLocalName())) {
            DefaultManagementRegistryConfiguration registryConfiguration = new DefaultManagementRegistryConfiguration();
            if (fragment.hasAttribute("cache-manager-alias")) {
                registryConfiguration.setCacheManagerAlias(ManagementRegistryServiceConfigurationParser.attr(fragment, "cache-manager-alias"));
            }
            if (fragment.hasAttribute("statistics-executor-alias")) {
                registryConfiguration.setStatisticsExecutorAlias(ManagementRegistryServiceConfigurationParser.attr(fragment, "statistics-executor-alias"));
            }
            if (fragment.hasAttribute("collector-executor-alias")) {
                registryConfiguration.setCollectorExecutorAlias(ManagementRegistryServiceConfigurationParser.attr(fragment, "collector-executor-alias"));
            }
            for (Element tags : NodeListIterable.elements(fragment, NAMESPACE, "tags")) {
                for (Element tag : NodeListIterable.elements(tags, NAMESPACE, "tag")) {
                    String val = ManagementRegistryServiceConfigurationParser.val(tag);
                    if (val == null || val.isEmpty()) continue;
                    registryConfiguration.addTag(val);
                }
            }
            for (Element statisticConfigurations : NodeListIterable.elements(fragment, NAMESPACE, "statistics-configurations")) {
                for (Element statisticConfiguration : NodeListIterable.elements(statisticConfigurations, NAMESPACE, "statistics-configuration")) {
                    Class<?> providerType;
                    try {
                        providerType = this.getClass().getClassLoader().loadClass(ManagementRegistryServiceConfigurationParser.attr(statisticConfiguration, "provider", EhcacheStatisticsProviderConfiguration.class.getName()));
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalStateException("Unable to load class " + statisticConfiguration.getAttribute("provider") + " : " + e.getMessage(), e);
                    }
                    if (!ManagementProvider.class.isAssignableFrom(providerType)) {
                        throw new IllegalStateException("Class " + statisticConfiguration.getAttribute("provider") + " is not a " + ManagementProvider.class.getSimpleName());
                    }
                    DefaultStatisticsProviderConfiguration providerConfiguration = new DefaultStatisticsProviderConfiguration(providerType.asSubclass(ManagementProvider.class));
                    for (Element averageWindow : NodeListIterable.elements(statisticConfiguration, NAMESPACE, "average-window")) {
                        providerConfiguration.setAverageWindowDuration(Long.parseLong(ManagementRegistryServiceConfigurationParser.val(averageWindow, String.valueOf(providerConfiguration.averageWindowDuration()))), ManagementRegistryServiceConfigurationParser.unit(averageWindow, providerConfiguration.averageWindowUnit()));
                    }
                    for (Element historyInterval : NodeListIterable.elements(statisticConfiguration, NAMESPACE, "history-interval")) {
                        providerConfiguration.setHistoryInterval(Long.parseLong(ManagementRegistryServiceConfigurationParser.val(historyInterval, String.valueOf(providerConfiguration.historyInterval()))), ManagementRegistryServiceConfigurationParser.unit(historyInterval, providerConfiguration.historyIntervalUnit()));
                    }
                    for (Element historySize : NodeListIterable.elements(statisticConfiguration, NAMESPACE, "history-size")) {
                        providerConfiguration.setHistorySize(Integer.parseInt(ManagementRegistryServiceConfigurationParser.val(historySize, String.valueOf(providerConfiguration.historySize()))));
                    }
                    for (Element timeToDisable : NodeListIterable.elements(statisticConfiguration, NAMESPACE, "time-to-disable")) {
                        providerConfiguration.setTimeToDisable(Long.parseLong(ManagementRegistryServiceConfigurationParser.val(timeToDisable, String.valueOf(providerConfiguration.timeToDisable()))), ManagementRegistryServiceConfigurationParser.unit(timeToDisable, providerConfiguration.timeToDisableUnit()));
                    }
                    registryConfiguration.addConfiguration(providerConfiguration);
                }
            }
            return registryConfiguration;
        }
        throw new XmlConfigurationException(String.format("XML configuration element <%s> in <%s> is not supported", fragment.getTagName(), fragment.getParentNode() == null ? "null" : fragment.getParentNode().getLocalName()));
    }

    private static String attr(Element element, String name, String def) {
        String s = element.getAttribute(name);
        return s == null || s.equals("") ? def : s;
    }

    private static String attr(Element element, String name) {
        return ManagementRegistryServiceConfigurationParser.attr(element, name, null);
    }

    private static String val(Element element) {
        return element.hasChildNodes() ? element.getFirstChild().getNodeValue() : null;
    }

    private static String val(Element element, String def) {
        return element.hasChildNodes() ? element.getFirstChild().getNodeValue() : def;
    }

    private static TimeUnit unit(Element element, TimeUnit def) {
        String s = ManagementRegistryServiceConfigurationParser.attr(element, "unit");
        return s == null ? def : XmlModel.convertToJavaTimeUnit((org.ehcache.xml.model.TimeUnit)org.ehcache.xml.model.TimeUnit.fromValue((String)s));
    }
}

