/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import org.ehcache.management.CapabilityManagementSupport;
import org.ehcache.management.ResultSet;
import org.ehcache.management.StatisticQuery;
import org.ehcache.management.providers.ManagementProvider;
import org.ehcache.management.registry.DefaultResultSet;
import org.terracotta.management.context.Context;
import org.terracotta.management.stats.ContextualStatistics;

final class DefaultStatisticQuery
implements StatisticQuery {
    private final CapabilityManagementSupport capabilityManagement;
    private final String capabilityName;
    private final Collection<String> statisticNames;
    private final Collection<Context> contexts;
    private final long since;

    DefaultStatisticQuery(CapabilityManagementSupport capabilityManagement, String capabilityName, Collection<String> statisticNames, Collection<Context> contexts, long since) {
        this.capabilityManagement = capabilityManagement;
        this.capabilityName = capabilityName;
        this.statisticNames = Collections.unmodifiableSet(new LinkedHashSet<String>(statisticNames));
        this.since = since;
        this.contexts = Collections.unmodifiableCollection(new ArrayList<Context>(contexts));
    }

    @Override
    public String getCapabilityName() {
        return this.capabilityName;
    }

    @Override
    public Collection<Context> getContexts() {
        return this.contexts;
    }

    @Override
    public Collection<String> getStatisticNames() {
        return this.statisticNames;
    }

    @Override
    public long getSince() {
        return this.since;
    }

    @Override
    public ResultSet<ContextualStatistics> execute() {
        for (Context context : this.contexts) {
            if (context.get("cacheManagerName") != null) continue;
            throw new IllegalArgumentException("Missing cache manager name from context " + context + " in context list " + this.contexts);
        }
        LinkedHashMap<Context, ContextualStatistics> contextualStatistics = new LinkedHashMap<Context, ContextualStatistics>(this.contexts.size());
        Collection<ManagementProvider<?>> managementProviders = this.capabilityManagement.getManagementProvidersByCapability(this.capabilityName);
        for (Context context : this.contexts) {
            HashMap statistics = new HashMap();
            for (ManagementProvider<?> managementProvider : managementProviders) {
                if (!managementProvider.supports(context)) continue;
                statistics.putAll(managementProvider.collectStatistics(context, this.statisticNames, this.since));
            }
            contextualStatistics.put(context, new ContextualStatistics(context, statistics));
        }
        return new DefaultResultSet<ContextualStatistics>(contextualStatistics);
    }
}

