/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.offheap;

import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.ehcache.core.spi.store.Store;
import org.ehcache.impl.internal.store.BinaryValueHolder;
import org.ehcache.impl.internal.store.offheap.OffHeapValueHolder;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.serialization.SerializerException;
import org.terracotta.offheapstore.storage.portability.WriteContext;

public final class LazyOffHeapValueHolder<V>
extends OffHeapValueHolder<V>
implements BinaryValueHolder {
    private final Serializer<V> valueSerializer;
    private final WriteContext writeContext;
    private Mode mode;
    private ByteBuffer binaryValue;
    private V value;

    public LazyOffHeapValueHolder(long id, ByteBuffer binaryValue, Serializer<V> serializer, long creationTime, long expireTime, long lastAccessTime, WriteContext writeContext) {
        super(id, creationTime, expireTime);
        this.setLastAccessTime(lastAccessTime, TIME_UNIT);
        this.binaryValue = binaryValue;
        this.valueSerializer = serializer;
        this.writeContext = writeContext;
        this.mode = Mode.ATTACHED;
    }

    public V get() {
        this.forceDeserialization();
        return this.value;
    }

    @Override
    public ByteBuffer getBinaryValue() throws IllegalStateException {
        if (this.isBinaryValueAvailable()) {
            return this.binaryValue.duplicate();
        }
        throw new IllegalStateException("This OffHeapValueHolder has not been prepared to hand off its binary form");
    }

    @Override
    public boolean isBinaryValueAvailable() {
        return this.mode == Mode.DETACHED;
    }

    @Override
    void updateMetadata(Store.ValueHolder<V> valueFlushed) {
        if (this.getId() != valueFlushed.getId()) {
            throw new IllegalArgumentException("Wrong id passed in [this.id != id] : " + this.getId() + " != " + valueFlushed.getId());
        }
        this.setLastAccessTime(valueFlushed.lastAccessTime(TIME_UNIT), TIME_UNIT);
        this.setExpirationTime(valueFlushed.expirationTime(TIME_UNIT), TIME_UNIT);
    }

    @Override
    void writeBack() {
        this.writeContext.setLong(16, this.lastAccessTime(TimeUnit.MILLISECONDS));
        this.writeContext.setLong(24, this.expirationTime(TimeUnit.MILLISECONDS));
        this.writeContext.flush();
    }

    @Override
    void forceDeserialization() {
        if (this.value == null) {
            try {
                this.value = this.valueSerializer.read(this.binaryValue.duplicate());
            }
            catch (ClassNotFoundException e) {
                throw new SerializerException((Throwable)e);
            }
            catch (SerializerException e) {
                throw new SerializerException("Seeing this exception and having no other serialization related issues is a red flag!", (Throwable)e);
            }
        }
    }

    @Override
    void detach() {
        if (this.mode != Mode.ATTACHED) {
            throw new IllegalStateException("OffHeapValueHolder in mode " + (Object)((Object)this.mode) + " cannot be prepared for delayed deserialization");
        }
        byte[] bytes = new byte[this.binaryValue.remaining()];
        this.binaryValue.get(bytes);
        this.binaryValue = ByteBuffer.wrap(bytes);
        this.mode = Mode.DETACHED;
    }

    private void writeObject(ObjectOutputStream out) {
        throw new UnsupportedOperationException("This subclass of AbstractValueHolder is NOT serializable");
    }

    private static enum Mode {
        ATTACHED,
        DETACHED;

    }
}

