/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.basic;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.ehcache.Cache;
import org.ehcache.core.CacheConfigurationChangeListener;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.spi.store.StoreAccessException;
import org.ehcache.core.spi.store.events.StoreEventFilter;
import org.ehcache.core.spi.store.events.StoreEventListener;
import org.ehcache.core.spi.store.events.StoreEventSource;
import org.ehcache.core.spi.store.tiering.AuthoritativeTier;
import org.ehcache.impl.internal.store.basic.EmptyValueHolder;

public class NopStore<K, V>
implements AuthoritativeTier<K, V> {
    public List<CacheConfigurationChangeListener> getConfigurationChangeListeners() {
        return Collections.emptyList();
    }

    public Store.ValueHolder<V> getAndFault(K key) throws StoreAccessException {
        return null;
    }

    public Store.ValueHolder<V> computeIfAbsentAndFault(K key, Function<? super K, ? extends V> mappingFunction) {
        return null;
    }

    public boolean flush(K key, Store.ValueHolder<V> valueHolder) {
        return false;
    }

    public void setInvalidationValve(AuthoritativeTier.InvalidationValve valve) {
    }

    public Store.ValueHolder<V> get(K key) {
        return null;
    }

    public boolean containsKey(K key) {
        return false;
    }

    public Store.PutStatus put(K key, V value) throws StoreAccessException {
        return Store.PutStatus.PUT;
    }

    public Store.ValueHolder<V> putIfAbsent(K key, V value) throws StoreAccessException {
        return EmptyValueHolder.empty();
    }

    public boolean remove(K key) throws StoreAccessException {
        return false;
    }

    public Store.RemoveStatus remove(K key, V value) throws StoreAccessException {
        return Store.RemoveStatus.KEY_MISSING;
    }

    public Store.ValueHolder<V> replace(K key, V value) throws StoreAccessException {
        return null;
    }

    public Store.ReplaceStatus replace(K key, V oldValue, V newValue) throws StoreAccessException {
        return Store.ReplaceStatus.MISS_NOT_PRESENT;
    }

    public void clear() {
    }

    public StoreEventSource<K, V> getStoreEventSource() {
        return new StoreEventSource<K, V>(){

            public void addEventListener(StoreEventListener<K, V> eventListener) {
            }

            public void removeEventListener(StoreEventListener<K, V> eventListener) {
            }

            public void addEventFilter(StoreEventFilter<K, V> eventFilter) {
            }

            public void setEventOrdering(boolean ordering) {
            }

            public boolean isEventOrdering() {
                return false;
            }
        };
    }

    public Store.Iterator<Cache.Entry<K, Store.ValueHolder<V>>> iterator() {
        return new Store.Iterator<Cache.Entry<K, Store.ValueHolder<V>>>(){

            public boolean hasNext() {
                return false;
            }

            public Cache.Entry<K, Store.ValueHolder<V>> next() {
                return null;
            }
        };
    }

    public Store.ValueHolder<V> compute(K key, BiFunction<? super K, ? super V, ? extends V> mappingFunction) {
        return EmptyValueHolder.empty();
    }

    public Store.ValueHolder<V> compute(K key, BiFunction<? super K, ? super V, ? extends V> mappingFunction, Supplier<Boolean> replaceEqual) {
        return null;
    }

    public Store.ValueHolder<V> computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return null;
    }

    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction) throws StoreAccessException {
        return this.bulkCompute(keys, remappingFunction, null);
    }

    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction, Supplier<Boolean> replaceEqual) {
        HashMap map = new HashMap(keys.size());
        for (K key : keys) {
            map.put(key, EmptyValueHolder.empty());
        }
        return map;
    }

    public Map<K, Store.ValueHolder<V>> bulkComputeIfAbsent(Set<? extends K> keys, Function<Iterable<? extends K>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> mappingFunction) {
        HashMap map = new HashMap(keys.size());
        for (K key : keys) {
            map.put(key, EmptyValueHolder.empty());
        }
        return map;
    }
}

