/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.events;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import org.ehcache.ValueSupplier;
import org.ehcache.core.spi.store.events.StoreEventFilter;
import org.ehcache.core.spi.store.events.StoreEventListener;
import org.ehcache.event.EventType;
import org.ehcache.impl.internal.events.CloseableStoreEventSink;
import org.ehcache.impl.internal.events.FireableStoreEventHolder;
import org.ehcache.impl.internal.events.StoreEvents;

class InvocationScopedEventSink<K, V>
implements CloseableStoreEventSink<K, V> {
    private final Set<StoreEventFilter<K, V>> filters;
    private final boolean ordered;
    private final BlockingQueue<FireableStoreEventHolder<K, V>>[] orderedQueues;
    private final Set<StoreEventListener<K, V>> listeners;
    private final Deque<FireableStoreEventHolder<K, V>> events = new ArrayDeque<FireableStoreEventHolder<K, V>>(4);

    InvocationScopedEventSink(Set<StoreEventFilter<K, V>> filters, boolean ordered, BlockingQueue<FireableStoreEventHolder<K, V>>[] orderedQueues, Set<StoreEventListener<K, V>> listeners) {
        this.filters = filters;
        this.ordered = ordered;
        this.orderedQueues = orderedQueues;
        this.listeners = listeners;
    }

    public void removed(K key, ValueSupplier<V> value) {
        Object removedValue = value.value();
        if (this.acceptEvent(EventType.REMOVED, key, removedValue, null)) {
            this.handleEvent(key, new FireableStoreEventHolder<K, Object>(StoreEvents.removeEvent(key, removedValue)));
        }
    }

    public void updated(K key, ValueSupplier<V> oldValue, V newValue) {
        Object oldValueValue = oldValue.value();
        if (this.acceptEvent(EventType.UPDATED, key, oldValueValue, newValue)) {
            this.handleEvent(key, new FireableStoreEventHolder<K, Object>(StoreEvents.updateEvent(key, oldValueValue, newValue)));
        }
    }

    public void expired(K key, ValueSupplier<V> value) {
        Object expired = value.value();
        if (this.acceptEvent(EventType.EXPIRED, key, expired, null)) {
            this.handleEvent(key, new FireableStoreEventHolder<K, Object>(StoreEvents.expireEvent(key, expired)));
        }
    }

    public void created(K key, V value) {
        if (this.acceptEvent(EventType.CREATED, key, null, value)) {
            this.handleEvent(key, new FireableStoreEventHolder<K, V>(StoreEvents.createEvent(key, value)));
        }
    }

    public void evicted(K key, ValueSupplier<V> value) {
        Object evicted = value.value();
        if (this.acceptEvent(EventType.EVICTED, key, evicted, null)) {
            this.handleEvent(key, new FireableStoreEventHolder<K, Object>(StoreEvents.evictEvent(key, evicted)));
        }
    }

    protected boolean acceptEvent(EventType type, K key, V oldValue, V newValue) {
        for (StoreEventFilter<K, V> filter : this.filters) {
            if (filter.acceptEvent(type, key, oldValue, newValue)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void close() {
        if (this.ordered) {
            this.fireOrdered(this.listeners, this.events);
        } else {
            for (FireableStoreEventHolder<K, V> fireableEvent : this.events) {
                for (StoreEventListener<K, V> listener : this.listeners) {
                    fireableEvent.fireOn(listener);
                }
            }
        }
    }

    @Override
    public void closeOnFailure() {
        for (FireableStoreEventHolder<K, V> fireableEvent : this.events) {
            fireableEvent.markFailed();
        }
        this.close();
    }

    @Override
    public void reset() {
        Iterator<FireableStoreEventHolder<K, V>> iterator = this.events.iterator();
        while (iterator.hasNext()) {
            FireableStoreEventHolder<K, V> next = iterator.next();
            if (this.ordered) {
                BlockingQueue<FireableStoreEventHolder<K, V>> orderedQueue = this.getOrderedQueue(next);
                orderedQueue.remove(next);
                this.fireWaiters(this.listeners, orderedQueue);
            }
            iterator.remove();
        }
    }

    protected Deque<FireableStoreEventHolder<K, V>> getEvents() {
        return this.events;
    }

    protected void handleEvent(K key, FireableStoreEventHolder<K, V> event) {
        this.events.add(event);
        if (this.ordered) {
            try {
                this.getOrderedQueue(event).put(event);
            }
            catch (InterruptedException e) {
                this.events.removeLast();
                Thread.currentThread().interrupt();
            }
        }
    }

    private BlockingQueue<FireableStoreEventHolder<K, V>> getOrderedQueue(FireableStoreEventHolder<K, V> event) {
        int i = Math.abs(event.eventKeyHash() % this.orderedQueues.length);
        return this.orderedQueues[i];
    }

    private void fireOrdered(Set<StoreEventListener<K, V>> listeners, Deque<FireableStoreEventHolder<K, V>> events) {
        for (FireableStoreEventHolder<K, V> fireableEvent : events) {
            fireableEvent.markFireable();
            BlockingQueue<FireableStoreEventHolder<K, V>> orderedQueue = this.getOrderedQueue(fireableEvent);
            FireableStoreEventHolder head = (FireableStoreEventHolder)orderedQueue.peek();
            if (head == fireableEvent) {
                if (head.markFired()) {
                    for (StoreEventListener<K, V> listener : listeners) {
                        head.fireOn(listener);
                    }
                    orderedQueue.poll();
                } else {
                    fireableEvent.waitTillFired();
                }
                this.fireWaiters(listeners, orderedQueue);
                continue;
            }
            fireableEvent.waitTillFired();
        }
    }

    private void fireWaiters(Set<StoreEventListener<K, V>> listeners, BlockingQueue<FireableStoreEventHolder<K, V>> orderedQueue) {
        FireableStoreEventHolder head;
        while ((head = (FireableStoreEventHolder)orderedQueue.peek()) != null && head.isFireable() && head.markFired()) {
            for (StoreEventListener<K, V> listener : listeners) {
                head.fireOn(listener);
            }
            orderedQueue.poll();
        }
    }
}

