/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.statistics;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.ehcache.Cache;
import org.ehcache.Status;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.core.InternalCache;
import org.ehcache.core.events.CacheManagerListener;
import org.ehcache.core.spi.service.CacheManagerProviderService;
import org.ehcache.core.spi.service.StatisticsService;
import org.ehcache.core.spi.store.InternalCacheManager;
import org.ehcache.impl.internal.statistics.CacheStatistics;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceDependencies;
import org.ehcache.spi.service.ServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceDependencies(value={CacheManagerProviderService.class})
public class DefaultStatisticsService
implements StatisticsService,
CacheManagerListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultStatisticsService.class);
    private final ConcurrentMap<String, CacheStatistics> cacheStatistics = new ConcurrentHashMap<String, CacheStatistics>();
    private volatile InternalCacheManager cacheManager;
    private volatile boolean started = false;

    private CacheStatistics getStatistics(String cacheName) {
        CacheStatistics stats = (CacheStatistics)this.cacheStatistics.get(cacheName);
        if (stats == null) {
            throw new IllegalArgumentException("Unknown cache: " + cacheName);
        }
        return stats;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void start(ServiceProvider<Service> serviceProvider) {
        LOGGER.debug("Starting service");
        CacheManagerProviderService cacheManagerProviderService = (CacheManagerProviderService)serviceProvider.getService(CacheManagerProviderService.class);
        this.cacheManager = cacheManagerProviderService.getCacheManager();
        this.cacheManager.registerListener((CacheManagerListener)this);
        this.started = true;
    }

    public void stop() {
        LOGGER.debug("Stopping service");
        this.cacheManager.deregisterListener((CacheManagerListener)this);
        this.cacheStatistics.clear();
        this.started = false;
    }

    public void stateTransition(Status from, Status to) {
        LOGGER.debug("Moving from " + from + " to " + to);
        switch (to) {
            case AVAILABLE: {
                this.registerAllCaches();
                break;
            }
            case UNINITIALIZED: {
                this.cacheManager.deregisterListener((CacheManagerListener)this);
                this.cacheStatistics.clear();
                break;
            }
            case MAINTENANCE: {
                throw new IllegalStateException("Should not be started in maintenance mode");
            }
            default: {
                throw new AssertionError((Object)("Unsupported state: " + to));
            }
        }
    }

    private void registerAllCaches() {
        for (Map.Entry entry : this.cacheManager.getRuntimeConfiguration().getCacheConfigurations().entrySet()) {
            String alias = (String)entry.getKey();
            CacheConfiguration configuration = (CacheConfiguration)entry.getValue();
            Cache cache = this.cacheManager.getCache(alias, configuration.getKeyType(), configuration.getValueType());
            this.cacheAdded(alias, cache);
        }
    }

    public void cacheAdded(String alias, Cache<?, ?> cache) {
        LOGGER.debug("Cache added " + alias);
        this.cacheStatistics.put(alias, new CacheStatistics((InternalCache)cache));
    }

    public void cacheRemoved(String alias, Cache<?, ?> cache) {
        LOGGER.debug("Cache removed " + alias);
        this.cacheStatistics.remove(alias);
    }

    public void clear(String cacheName) {
        this.getStatistics(cacheName).clear();
    }

    public long getCacheHits(String cacheName) {
        return this.getStatistics(cacheName).getCacheHits();
    }

    public float getCacheHitPercentage(String cacheName) {
        return this.getStatistics(cacheName).getCacheHitPercentage();
    }

    public long getCacheMisses(String cacheName) {
        return this.getStatistics(cacheName).getCacheMisses();
    }

    public float getCacheMissPercentage(String cacheName) {
        return this.getStatistics(cacheName).getCacheMissPercentage();
    }

    public long getCacheGets(String cacheName) {
        return this.getStatistics(cacheName).getCacheGets();
    }

    public long getCachePuts(String cacheName) {
        return this.getStatistics(cacheName).getCachePuts();
    }

    public long getCacheRemovals(String cacheName) {
        return this.getStatistics(cacheName).getCacheRemovals();
    }

    public long getCacheEvictions(String cacheName) {
        return this.getStatistics(cacheName).getCacheEvictions();
    }

    public float getAverageGetTime(String cacheName) {
        return this.getStatistics(cacheName).getAverageGetTime();
    }

    public float getAveragePutTime(String cacheName) {
        return this.getStatistics(cacheName).getAveragePutTime();
    }

    public float getAverageRemoveTime(String cacheName) {
        return this.getStatistics(cacheName).getAverageRemoveTime();
    }
}

