/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.heap;

import java.util.AbstractMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import org.ehcache.config.EvictionAdvisor;
import org.ehcache.core.spi.function.BiFunction;
import org.ehcache.core.spi.store.Store;
import org.ehcache.impl.internal.concurrent.ConcurrentHashMap;
import org.ehcache.impl.internal.store.heap.Backend;
import org.ehcache.impl.internal.store.heap.holders.CopiedOnHeapKey;
import org.ehcache.impl.internal.store.heap.holders.LookupOnlyOnHeapKey;
import org.ehcache.impl.internal.store.heap.holders.OnHeapKey;
import org.ehcache.impl.internal.store.heap.holders.OnHeapValueHolder;
import org.ehcache.spi.copy.Copier;

class KeyCopyBackend<K, V>
implements Backend<K, V> {
    private final ConcurrentHashMap<OnHeapKey<K>, OnHeapValueHolder<V>> keyCopyMap;
    private final boolean byteSized;
    private final Copier<K> keyCopier;
    private final AtomicLong byteSize = new AtomicLong(0L);

    KeyCopyBackend(boolean byteSized, Copier<K> keyCopier) {
        this.byteSized = byteSized;
        this.keyCopier = keyCopier;
        this.keyCopyMap = new ConcurrentHashMap();
    }

    @Override
    public boolean remove(K key, OnHeapValueHolder<V> value) {
        return this.keyCopyMap.remove(this.lookupOnlyKey(key), value);
    }

    @Override
    public Map.Entry<K, OnHeapValueHolder<V>> getEvictionCandidate(Random random, int size, Comparator<? super Store.ValueHolder<V>> prioritizer, EvictionAdvisor<Object, ? super OnHeapValueHolder<?>> evictionAdvisor) {
        Map.Entry<Object, OnHeapValueHolder<?>> candidate = this.keyCopyMap.getEvictionCandidate(random, size, prioritizer, evictionAdvisor);
        if (candidate == null) {
            return null;
        }
        return new AbstractMap.SimpleEntry(((OnHeapKey)candidate.getKey()).getActualKeyObject(), candidate.getValue());
    }

    @Override
    public long mappingCount() {
        return this.keyCopyMap.mappingCount();
    }

    @Override
    public long byteSize() {
        if (this.byteSized) {
            return this.byteSize.get();
        }
        throw new IllegalStateException("This store is not byte sized");
    }

    @Override
    public long naturalSize() {
        if (this.byteSized) {
            return this.byteSize.get();
        }
        return this.mappingCount();
    }

    @Override
    public void updateUsageInBytesIfRequired(long delta) {
        if (this.byteSized) {
            this.byteSize.addAndGet(delta);
        }
    }

    @Override
    public Iterable<K> keySet() {
        final Iterator iter = ((ConcurrentHashMap.KeySetView)this.keyCopyMap.keySet()).iterator();
        return new Iterable<K>(){

            @Override
            public Iterator<K> iterator() {
                return new Iterator<K>(){

                    @Override
                    public boolean hasNext() {
                        return iter.hasNext();
                    }

                    @Override
                    public K next() {
                        return ((OnHeapKey)iter.next()).getActualKeyObject();
                    }

                    @Override
                    public void remove() {
                        iter.remove();
                    }
                };
            }
        };
    }

    @Override
    public Iterator<Map.Entry<K, OnHeapValueHolder<V>>> entrySetIterator() {
        final Iterator<Map.Entry<OnHeapKey<K>, OnHeapValueHolder<V>>> iter = this.keyCopyMap.entrySet().iterator();
        return new Iterator<Map.Entry<K, OnHeapValueHolder<V>>>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public Map.Entry<K, OnHeapValueHolder<V>> next() {
                Map.Entry entry = (Map.Entry)iter.next();
                return new AbstractMap.SimpleEntry(((OnHeapKey)entry.getKey()).getActualKeyObject(), entry.getValue());
            }

            @Override
            public void remove() {
                iter.remove();
            }
        };
    }

    @Override
    public OnHeapValueHolder<V> compute(K key, final BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>> computeFunction) {
        return this.keyCopyMap.compute(this.makeKey(key), new BiFunction<OnHeapKey<K>, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

            public OnHeapValueHolder<V> apply(OnHeapKey<K> mappedKey, OnHeapValueHolder<V> mappedValue) {
                return (OnHeapValueHolder)computeFunction.apply(mappedKey.getActualKeyObject(), mappedValue);
            }
        });
    }

    @Override
    public Backend<K, V> clear() {
        return new KeyCopyBackend<K, V>(this.byteSized, this.keyCopier);
    }

    @Override
    public Map<K, OnHeapValueHolder<V>> removeAllWithHash(int hash) {
        HashMap<K, OnHeapValueHolder<V>> result = new HashMap<K, OnHeapValueHolder<V>>();
        Map<OnHeapKey<K>, OnHeapValueHolder<V>> removed = this.keyCopyMap.removeAllWithHash(hash);
        long delta = 0L;
        for (Map.Entry<OnHeapKey<K>, OnHeapValueHolder<V>> entry : removed.entrySet()) {
            delta -= entry.getValue().size();
            result.put(entry.getKey().getActualKeyObject(), entry.getValue());
        }
        this.updateUsageInBytesIfRequired(delta);
        return result;
    }

    @Override
    public OnHeapValueHolder<V> remove(K key) {
        return this.keyCopyMap.remove(this.lookupOnlyKey(key));
    }

    @Override
    public OnHeapValueHolder<V> computeIfPresent(K key, final BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>> computeFunction) {
        return this.keyCopyMap.computeIfPresent(this.makeKey(key), new BiFunction<OnHeapKey<K>, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

            public OnHeapValueHolder<V> apply(OnHeapKey<K> mappedKey, OnHeapValueHolder<V> mappedValue) {
                return (OnHeapValueHolder)computeFunction.apply(mappedKey.getActualKeyObject(), mappedValue);
            }
        });
    }

    private OnHeapKey<K> makeKey(K key) {
        return new CopiedOnHeapKey<K>(key, this.keyCopier);
    }

    private OnHeapKey<K> lookupOnlyKey(K key) {
        return new LookupOnlyOnHeapKey<K>(key);
    }

    @Override
    public OnHeapValueHolder<V> get(K key) {
        return this.keyCopyMap.get(this.lookupOnlyKey(key));
    }

    @Override
    public OnHeapValueHolder<V> putIfAbsent(K key, OnHeapValueHolder<V> valueHolder) {
        return this.keyCopyMap.putIfAbsent(this.makeKey(key), valueHolder);
    }

    @Override
    public boolean replace(K key, OnHeapValueHolder<V> oldValue, OnHeapValueHolder<V> newValue) {
        return this.keyCopyMap.replace(this.lookupOnlyKey(key), oldValue, newValue);
    }
}

