/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.shared.composites;

import java.nio.ByteBuffer;
import java.util.Map;
import org.ehcache.impl.internal.store.shared.composites.CompositeValue;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.serialization.SerializerException;

public class CompositeSerializer
implements Serializer<CompositeValue<?>> {
    private final Map<Integer, Serializer<?>> serializerMap;

    public CompositeSerializer(Map<Integer, Serializer<?>> serializerMap) {
        this.serializerMap = serializerMap;
    }

    public ByteBuffer serialize(CompositeValue<?> compositeValue) throws SerializerException {
        int id = compositeValue.getStoreId();
        ByteBuffer valueForm = this.serializerMap.get(id).serialize(compositeValue.getValue());
        ByteBuffer compositeForm = ByteBuffer.allocate(4 + valueForm.remaining());
        compositeForm.putInt(compositeValue.getStoreId());
        compositeForm.put(valueForm);
        compositeForm.flip();
        return compositeForm;
    }

    public CompositeValue<?> read(ByteBuffer binary) throws ClassNotFoundException, SerializerException {
        int id = binary.getInt();
        Serializer<?> serializer = this.serializerMap.get(id);
        if (serializer == null) {
            return new CompositeValue<Object>(id, null);
        }
        return new CompositeValue<Object>(id, serializer.read(binary));
    }

    public boolean equals(CompositeValue<?> object, ByteBuffer binary) throws ClassNotFoundException, SerializerException {
        int id = binary.getInt();
        if (id == object.getStoreId()) {
            Serializer<?> serializer = this.serializerMap.get(id);
            if (serializer == null) {
                return false;
            }
            return serializer.equals(object.getValue(), binary.slice());
        }
        return false;
    }
}

