/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.loaderwriter.writebehind;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import org.ehcache.core.spi.service.ExecutionService;
import org.ehcache.impl.internal.loaderwriter.writebehind.BatchingLocalHeapWriteBehindQueue;
import org.ehcache.impl.internal.loaderwriter.writebehind.NonBatchingLocalHeapWriteBehindQueue;
import org.ehcache.impl.internal.loaderwriter.writebehind.WriteBehind;
import org.ehcache.spi.loaderwriter.CacheLoaderWriter;
import org.ehcache.spi.loaderwriter.WriteBehindConfiguration;

public class StripedWriteBehind<K, V>
implements WriteBehind<K, V> {
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.rwLock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.rwLock.writeLock();
    private final List<WriteBehind<K, V>> stripes = new ArrayList<WriteBehind<K, V>>();

    public StripedWriteBehind(Consumer<K> keyCleanUpMethod, ExecutionService executionService, String defaultThreadPool, WriteBehindConfiguration<?> config, CacheLoaderWriter<K, V> cacheLoaderWriter) {
        int writeBehindConcurrency = config.getConcurrency();
        for (int i = 0; i < writeBehindConcurrency; ++i) {
            if (config.getBatchingConfiguration() == null) {
                this.stripes.add(new NonBatchingLocalHeapWriteBehindQueue<K, V>(keyCleanUpMethod, executionService, defaultThreadPool, config, cacheLoaderWriter));
                continue;
            }
            this.stripes.add(new BatchingLocalHeapWriteBehindQueue<K, V>(keyCleanUpMethod, executionService, defaultThreadPool, config, cacheLoaderWriter));
        }
    }

    private WriteBehind<K, V> getStripe(Object key) {
        return this.stripes.get(Math.abs(key.hashCode() % this.stripes.size()));
    }

    @Override
    public void start() {
        this.writeLock.lock();
        try {
            for (WriteBehind<K, V> queue : this.stripes) {
                queue.start();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public V load(K key) throws Exception {
        Object v;
        this.readLock.lock();
        try {
            v = this.getStripe(key).load(key);
        }
        finally {
            this.readLock.unlock();
        }
        return (V)v;
    }

    public void write(K key, V value) throws Exception {
        this.readLock.lock();
        try {
            this.getStripe(key).write(key, value);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void delete(K key) throws Exception {
        this.readLock.lock();
        try {
            this.getStripe(key).delete(key);
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void stop() {
        this.writeLock.lock();
        try {
            for (WriteBehind<K, V> queue : this.stripes) {
                queue.stop();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getQueueSize() {
        int size = 0;
        this.readLock.lock();
        try {
            for (WriteBehind<K, V> stripe : this.stripes) {
                size = (int)((long)size + stripe.getQueueSize());
            }
        }
        finally {
            this.readLock.unlock();
        }
        return size;
    }
}

