/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.shared;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.ehcache.config.ResourceType;
import org.ehcache.core.spi.store.Store;
import org.ehcache.impl.internal.store.shared.composites.CompositeValue;

public class AbstractPartition<S> {
    private final ResourceType<?> type;
    private final int id;
    private final S shared;

    public AbstractPartition(ResourceType<?> type, int id, S shared) {
        this.type = type;
        this.id = id;
        this.shared = shared;
    }

    public ResourceType<?> type() {
        return this.type;
    }

    public int id() {
        return this.id;
    }

    protected S shared() {
        return this.shared;
    }

    protected <T> CompositeValue<T> composite(T t) {
        return t == null ? null : new CompositeValue<T>(this.id, t);
    }

    protected <T> Store.ValueHolder<T> decode(Store.ValueHolder<CompositeValue<T>> value) {
        if (value instanceof MappingValueHolder) {
            return ((MappingValueHolder)value).getDelegate();
        }
        return value == null ? null : new MappingValueHolder<CompositeValue, Object>(value, CompositeValue::getValue);
    }

    protected <T> Store.ValueHolder<CompositeValue<T>> encode(Store.ValueHolder<T> valueHolder) {
        return valueHolder == null ? null : new MappingValueHolder<Object, CompositeValue>(valueHolder, this::composite);
    }

    protected <T> Set<CompositeValue<T>> compositeSet(Iterable<? extends T> keys) {
        HashSet compositeValueSet = new HashSet();
        keys.forEach(k -> compositeValueSet.add(this.composite(k)));
        return compositeValueSet;
    }

    private static class MappingValueHolder<T, U>
    implements Store.ValueHolder<U> {
        private final Store.ValueHolder<T> delegate;
        private final Function<T, U> mapping;

        private MappingValueHolder(Store.ValueHolder<T> valueHolder, Function<T, U> mapping) {
            this.delegate = valueHolder;
            this.mapping = mapping;
        }

        public Store.ValueHolder<T> getDelegate() {
            return this.delegate;
        }

        @Nonnull
        public U get() {
            return this.mapping.apply(this.delegate.get());
        }

        public long creationTime() {
            return this.delegate.creationTime();
        }

        public long expirationTime() {
            return this.delegate.expirationTime();
        }

        public boolean isExpired(long expirationTime) {
            return this.delegate.isExpired(expirationTime);
        }

        public long lastAccessTime() {
            return this.delegate.lastAccessTime();
        }

        public long getId() {
            return this.delegate.getId();
        }
    }
}

