/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.config.builders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import org.ehcache.Cache;
import org.ehcache.CachePersistenceException;
import org.ehcache.UserManagedCache;
import org.ehcache.config.Builder;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.EvictionAdvisor;
import org.ehcache.config.ResourcePools;
import org.ehcache.config.ResourceType;
import org.ehcache.config.ResourceUnit;
import org.ehcache.config.SizedResourcePool;
import org.ehcache.config.builders.CacheEventListenerConfigurationBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.builders.UserManagedCacheConfiguration;
import org.ehcache.config.units.EntryUnit;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.core.Ehcache;
import org.ehcache.core.EhcacheWithLoaderWriter;
import org.ehcache.core.PersistentUserManagedEhcache;
import org.ehcache.core.config.BaseCacheConfiguration;
import org.ehcache.core.events.CacheEventDispatcher;
import org.ehcache.core.events.CacheEventListenerConfiguration;
import org.ehcache.core.events.CacheEventListenerProvider;
import org.ehcache.core.internal.service.ServiceLocator;
import org.ehcache.core.internal.store.StoreConfigurationImpl;
import org.ehcache.core.internal.store.StoreSupport;
import org.ehcache.core.internal.util.ClassLoading;
import org.ehcache.core.spi.LifeCycled;
import org.ehcache.core.spi.LifeCycledAdapter;
import org.ehcache.core.spi.service.LocalPersistenceService;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.spi.store.heap.SizeOfEngineProvider;
import org.ehcache.event.CacheEventListener;
import org.ehcache.expiry.Expirations;
import org.ehcache.expiry.Expiry;
import org.ehcache.impl.config.copy.DefaultCopierConfiguration;
import org.ehcache.impl.config.serializer.DefaultSerializerConfiguration;
import org.ehcache.impl.config.store.heap.DefaultSizeOfEngineConfiguration;
import org.ehcache.impl.config.store.heap.DefaultSizeOfEngineProviderConfiguration;
import org.ehcache.impl.copy.SerializingCopier;
import org.ehcache.impl.events.CacheEventDispatcherImpl;
import org.ehcache.impl.internal.classes.ClassInstanceConfiguration;
import org.ehcache.impl.internal.events.DisabledCacheEventNotificationService;
import org.ehcache.impl.internal.spi.event.DefaultCacheEventListenerProvider;
import org.ehcache.spi.copy.Copier;
import org.ehcache.spi.loaderwriter.CacheLoaderWriter;
import org.ehcache.spi.serialization.SerializationProvider;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.serialization.UnsupportedTypeException;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceCreationConfiguration;
import org.ehcache.spi.service.ServiceDependencies;
import org.ehcache.spi.service.ServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserManagedCacheBuilder<K, V, T extends UserManagedCache<K, V>>
implements Builder<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserManagedCacheBuilder.class);
    private static final AtomicLong instanceId = new AtomicLong(0L);
    private final Class<K> keyType;
    private final Class<V> valueType;
    private String id;
    private final Set<Service> services = new HashSet<Service>();
    private final Set<ServiceCreationConfiguration<?>> serviceCreationConfigurations = new HashSet();
    private Expiry<? super K, ? super V> expiry = Expirations.noExpiration();
    private ClassLoader classLoader = ClassLoading.getDefaultClassLoader();
    private EvictionAdvisor<? super K, ? super V> evictionAdvisor;
    private CacheLoaderWriter<? super K, V> cacheLoaderWriter;
    private CacheEventDispatcher<K, V> eventDispatcher = new DisabledCacheEventNotificationService();
    private ResourcePools resourcePools = ResourcePoolsBuilder.newResourcePoolsBuilder().heap(Long.MAX_VALUE, (ResourceUnit)EntryUnit.ENTRIES).build();
    private Copier<K> keyCopier;
    private boolean useKeySerializingCopier;
    private Copier<V> valueCopier;
    private boolean useValueSerializingCopier;
    private Serializer<K> keySerializer;
    private Serializer<V> valueSerializer;
    private int dispatcherConcurrency = 4;
    private List<CacheEventListenerConfiguration> eventListenerConfigurations = new ArrayList<CacheEventListenerConfiguration>();
    private ExecutorService unOrderedExecutor;
    private ExecutorService orderedExecutor;
    private long objectGraphSize = 1000L;
    private long maxObjectSize = Long.MAX_VALUE;
    private MemoryUnit sizeOfUnit = DefaultSizeOfEngineConfiguration.DEFAULT_UNIT;

    UserManagedCacheBuilder(Class<K> keyType, Class<V> valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
    }

    private UserManagedCacheBuilder(UserManagedCacheBuilder<K, V, T> toCopy) {
        this.keyType = toCopy.keyType;
        this.valueType = toCopy.valueType;
        this.id = toCopy.id;
        this.services.addAll(toCopy.services);
        this.serviceCreationConfigurations.addAll(toCopy.serviceCreationConfigurations);
        this.expiry = toCopy.expiry;
        this.classLoader = toCopy.classLoader;
        this.evictionAdvisor = toCopy.evictionAdvisor;
        this.cacheLoaderWriter = toCopy.cacheLoaderWriter;
        this.eventDispatcher = toCopy.eventDispatcher;
        this.resourcePools = toCopy.resourcePools;
        this.keyCopier = toCopy.keyCopier;
        this.valueCopier = toCopy.valueCopier;
        this.keySerializer = toCopy.keySerializer;
        this.valueSerializer = toCopy.valueSerializer;
        this.useKeySerializingCopier = toCopy.useKeySerializingCopier;
        this.useValueSerializingCopier = toCopy.useValueSerializingCopier;
        this.eventListenerConfigurations = toCopy.eventListenerConfigurations;
        this.unOrderedExecutor = toCopy.unOrderedExecutor;
        this.orderedExecutor = toCopy.orderedExecutor;
        this.objectGraphSize = toCopy.objectGraphSize;
        this.maxObjectSize = toCopy.maxObjectSize;
        this.sizeOfUnit = toCopy.sizeOfUnit;
    }

    T build(ServiceLocator serviceLocator) throws IllegalStateException {
        this.validateListenerConfig();
        try {
            for (ServiceCreationConfiguration<?> serviceCreationConfig : this.serviceCreationConfigurations) {
                Service service = serviceLocator.getOrCreateServiceFor(serviceCreationConfig);
                if (service != null) continue;
                throw new IllegalArgumentException("Couldn't resolve Service " + serviceCreationConfig.getServiceType().getName());
            }
            serviceLocator.loadDependenciesOf(ServiceDeps.class);
            serviceLocator.startAllServices();
        }
        catch (Exception e) {
            throw new IllegalStateException("UserManagedCacheBuilder failed to build.", e);
        }
        ArrayList<ClassInstanceConfiguration> serviceConfigsList = new ArrayList<ClassInstanceConfiguration>();
        if (this.keyCopier != null) {
            serviceConfigsList.add(new DefaultCopierConfiguration<K>(this.keyCopier, DefaultCopierConfiguration.Type.KEY));
        } else if (this.useKeySerializingCopier) {
            serviceConfigsList.add(new DefaultCopierConfiguration(SerializingCopier.class, DefaultCopierConfiguration.Type.KEY));
        }
        if (this.valueCopier != null) {
            serviceConfigsList.add(new DefaultCopierConfiguration<V>(this.valueCopier, DefaultCopierConfiguration.Type.VALUE));
        } else if (this.useValueSerializingCopier) {
            serviceConfigsList.add(new DefaultCopierConfiguration(SerializingCopier.class, DefaultCopierConfiguration.Type.VALUE));
        }
        Set resources = this.resourcePools.getResourceTypeSet();
        boolean persistent = resources.contains(ResourceType.Core.DISK);
        if (persistent) {
            if (this.id == null) {
                throw new IllegalStateException("Persistent user managed caches must have an id set");
            }
            LocalPersistenceService persistenceService = (LocalPersistenceService)serviceLocator.getService(LocalPersistenceService.class);
            if (!((SizedResourcePool)this.resourcePools.getPoolForResource((ResourceType)ResourceType.Core.DISK)).isPersistent()) {
                try {
                    persistenceService.destroy(this.id);
                }
                catch (CachePersistenceException cpex) {
                    throw new RuntimeException("Unable to clean-up persistence space for non-restartable cache " + this.id, cpex);
                }
            }
            try {
                serviceConfigsList.add((ClassInstanceConfiguration)persistenceService.getOrCreatePersistenceSpace(this.id));
            }
            catch (CachePersistenceException cpex) {
                throw new RuntimeException("Unable to create persistence space for cache " + this.id, cpex);
            }
        }
        ArrayList<LifeCycled> lifeCycledList = new ArrayList<LifeCycled>();
        Serializer keySerializer = this.keySerializer;
        Serializer valueSerializer = this.valueSerializer;
        if (keySerializer != null) {
            serviceConfigsList.add(new DefaultSerializerConfiguration<K>(this.keySerializer, DefaultSerializerConfiguration.Type.KEY));
        }
        if (valueSerializer != null) {
            serviceConfigsList.add(new DefaultSerializerConfiguration<V>(this.valueSerializer, DefaultSerializerConfiguration.Type.VALUE));
        }
        ServiceConfiguration[] serviceConfigs = serviceConfigsList.toArray(new ServiceConfiguration[0]);
        final SerializationProvider serialization = (SerializationProvider)serviceLocator.getService(SerializationProvider.class);
        if (serialization != null) {
            try {
                if (keySerializer == null) {
                    final Serializer keySer = serialization.createKeySerializer(this.keyType, this.classLoader, serviceConfigs);
                    lifeCycledList.add((LifeCycled)new LifeCycledAdapter(){

                        public void close() throws Exception {
                            serialization.releaseSerializer(keySer);
                        }
                    });
                    keySerializer = keySer;
                }
                if (valueSerializer == null) {
                    final Serializer valueSer = serialization.createValueSerializer(this.valueType, this.classLoader, serviceConfigs);
                    lifeCycledList.add((LifeCycled)new LifeCycledAdapter(){

                        public void close() throws Exception {
                            serialization.releaseSerializer(valueSer);
                        }
                    });
                    valueSerializer = valueSer;
                }
            }
            catch (UnsupportedTypeException e) {
                if (resources.contains(ResourceType.Core.OFFHEAP) || resources.contains(ResourceType.Core.DISK)) {
                    throw new RuntimeException(e);
                }
                LOGGER.debug("Could not create serializers for user managed cache {}", (Object)this.id, (Object)e);
            }
        }
        final Store.Provider storeProvider = StoreSupport.selectStoreProvider((ServiceProvider)serviceLocator, (Set)resources, serviceConfigsList);
        StoreConfigurationImpl storeConfig = new StoreConfigurationImpl(this.keyType, this.valueType, this.evictionAdvisor, this.classLoader, this.expiry, this.resourcePools, this.dispatcherConcurrency, keySerializer, valueSerializer);
        final Store store = storeProvider.createStore((Store.Configuration)storeConfig, serviceConfigs);
        BaseCacheConfiguration cacheConfig = new BaseCacheConfiguration(this.keyType, this.valueType, this.evictionAdvisor, this.classLoader, this.expiry, this.resourcePools, new ServiceConfiguration[0]);
        lifeCycledList.add(new LifeCycled(){

            public void init() throws Exception {
                storeProvider.initStore(store);
            }

            public void close() throws Exception {
                storeProvider.releaseStore(store);
            }
        });
        if (this.eventDispatcher instanceof DisabledCacheEventNotificationService && this.orderedExecutor != null & this.unOrderedExecutor != null) {
            this.eventDispatcher = new CacheEventDispatcherImpl(this.unOrderedExecutor, this.orderedExecutor);
        }
        this.eventDispatcher.setStoreEventSource(store.getStoreEventSource());
        if (persistent) {
            LocalPersistenceService persistenceService = (LocalPersistenceService)serviceLocator.getService(LocalPersistenceService.class);
            if (persistenceService == null) {
                throw new IllegalStateException("No LocalPersistenceService could be found - did you configure one?");
            }
            PersistentUserManagedEhcache cache = new PersistentUserManagedEhcache((CacheConfiguration)cacheConfig, store, persistenceService, this.cacheLoaderWriter, this.eventDispatcher, this.id);
            this.registerListeners((Cache<K, V>)cache, (ServiceProvider<Service>)serviceLocator, (List<LifeCycled>)lifeCycledList);
            for (LifeCycled lifeCycled : lifeCycledList) {
                cache.addHook(lifeCycled);
            }
            return this.cast((UserManagedCache<K, V>)cache);
        }
        Object cache = this.cacheLoaderWriter == null ? new Ehcache((CacheConfiguration)cacheConfig, store, this.eventDispatcher, this.getLoggerFor(Ehcache.class)) : new EhcacheWithLoaderWriter((CacheConfiguration)cacheConfig, store, this.cacheLoaderWriter, this.eventDispatcher, this.getLoggerFor(EhcacheWithLoaderWriter.class));
        this.registerListeners((Cache<K, V>)cache, (ServiceProvider<Service>)serviceLocator, (List<LifeCycled>)lifeCycledList);
        for (LifeCycled lifeCycled : lifeCycledList) {
            cache.addHook(lifeCycled);
        }
        return this.cast((UserManagedCache<K, V>)cache);
    }

    private Logger getLoggerFor(Class clazz) {
        String loggerName = this.id != null ? clazz.getName() + "-" + this.id : clazz.getName() + "-UserManaged" + instanceId.incrementAndGet();
        return LoggerFactory.getLogger((String)loggerName);
    }

    private void validateListenerConfig() {
        if (!this.eventListenerConfigurations.isEmpty() && this.eventDispatcher instanceof DisabledCacheEventNotificationService && this.orderedExecutor == null && this.unOrderedExecutor == null) {
            throw new IllegalArgumentException("Listeners will not work unless Executors or EventDispatcher is configured.");
        }
    }

    private void registerListeners(Cache<K, V> cache, ServiceProvider<Service> serviceProvider, List<LifeCycled> lifeCycledList) {
        if (!this.eventListenerConfigurations.isEmpty()) {
            CacheEventListenerProvider provider = (CacheEventListenerProvider)serviceProvider.getService(CacheEventListenerProvider.class);
            Object listenerProvider = provider != null ? provider : new DefaultCacheEventListenerProvider();
            for (CacheEventListenerConfiguration config : this.eventListenerConfigurations) {
                CacheEventListener listener = listenerProvider.createEventListener(this.id, (ServiceConfiguration)config);
                if (listener == null) continue;
                cache.getRuntimeConfiguration().registerCacheEventListener(listener, config.orderingMode(), config.firingMode(), (Set)config.fireOn());
                lifeCycledList.add(new LifeCycled((CacheEventListenerProvider)listenerProvider, listener){
                    final /* synthetic */ CacheEventListenerProvider val$listenerProvider;
                    final /* synthetic */ CacheEventListener val$listener;
                    {
                        this.val$listenerProvider = cacheEventListenerProvider;
                        this.val$listener = cacheEventListener;
                    }

                    public void init() throws Exception {
                    }

                    public void close() throws Exception {
                        this.val$listenerProvider.releaseEventListener(this.val$listener);
                    }
                });
            }
        }
        this.eventDispatcher.setListenerSource(cache);
    }

    T cast(UserManagedCache<K, V> cache) {
        return (T)cache;
    }

    public final T build(boolean init) throws IllegalStateException {
        T build = this.build(new ServiceLocator(this.services.toArray(new Service[this.services.size()])));
        if (init) {
            build.init();
        }
        return build;
    }

    public T build() {
        return this.build(false);
    }

    public final <N extends T> UserManagedCacheBuilder<K, V, N> with(UserManagedCacheConfiguration<K, V, N> cfg) {
        return cfg.builder(this);
    }

    public final UserManagedCacheBuilder<K, V, T> identifier(String identifier) {
        UserManagedCacheBuilder<K, V, T> otherBuilder = new UserManagedCacheBuilder<K, V, T>(this);
        otherBuilder.id = identifier;
        return otherBuilder;
    }

    public final UserManagedCacheBuilder<K, V, T> withClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new NullPointerException("Null classloader");
        }
        UserManagedCacheBuilder<K, V, T> otherBuilder = new UserManagedCacheBuilder<K, V, T>(this);
        otherBuilder.classLoader = classLoader;
        return otherBuilder;
    }

    public final UserManagedCacheBuilder<K, V, T> withExpiry(Expiry<? super K, ? super V> expiry) {
        if (expiry == null) {
            throw new NullPointerException("Null expiry");
        }
        UserManagedCacheBuilder<K, V, T> otherBuilder = new UserManagedCacheBuilder<K, V, T>(this);
        otherBuilder.expiry = expiry;
        return otherBuilder;
    }

    public final UserManagedCacheBuilder<K, V, T> withEventDispatcher(CacheEventDispatcher<K, V> eventDispatcher) {
        UserManagedCacheBuilder<K, V, T> otherBuilder = new UserManagedCacheBuilder<K, V, T>(this);
        otherBuilder.orderedExecutor = null;
        otherBuilder.unOrderedExecutor = null;
        otherBuilder.eventDispatcher = eventDispatcher;
        return otherBuilder;
    }

    public final UserManagedCacheBuilder<K, V, T> withEventExecutors(ExecutorService orderedExecutor, ExecutorService unOrderedExecutor) {
        UserManagedCacheBuilder<K, V, T> otherBuilder = new UserManagedCacheBuilder<K, V, T>(this);
        otherBuilder.eventDispatcher = new DisabledCacheEventNotificationService();
        otherBuilder.orderedExecutor = orderedExecutor;
        otherBuilder.unOrderedExecutor = unOrderedExecutor;
        return otherBuilder;
    }

    public final UserManagedCacheBuilder<K, V, T> withEventListeners(CacheEventListenerConfigurationBuilder cacheEventListenerConfiguration) {
        return this.withEventListeners(cacheEventListenerConfiguration.build());
    }

    public final UserManagedCacheBuilder<K, V, T> withEventListeners(CacheEventListenerConfiguration ... cacheEventListenerConfigurations) {
        UserManagedCacheBuilder<K, V, T> otherBuilder = new UserManagedCacheBuilder<K, V, T>(this);
        otherBuilder.eventListenerConfigurations.addAll(Arrays.asList(cacheEventListenerConfigurations));
        return otherBuilder;
    }

    public final UserManagedCacheBuilder<K, V, T> withResourcePools(ResourcePools resourcePools) {
        UserManagedCacheBuilder<K, V, T> otherBuilder = new UserManagedCacheBuilder<K, V, T>(this);
        otherBuilder.resourcePools = resourcePools;
        return otherBuilder;
    }

    public final UserManagedCacheBuilder<K, V, T> withResourcePools(ResourcePoolsBuilder resourcePoolsBuilder) {
        return this.withResourcePools(resourcePoolsBuilder.build());
    }

    public final UserManagedCacheBuilder<K, V, T> withDispatcherConcurrency(int dispatcherConcurrency) {
        this.dispatcherConcurrency = dispatcherConcurrency;
        return this;
    }

    public UserManagedCacheBuilder<K, V, T> withEvictionAdvisor(EvictionAdvisor<K, V> evictionAdvisor) {
        if (evictionAdvisor == null) {
            throw new NullPointerException("Null eviction advisor");
        }
        UserManagedCacheBuilder<K, V, T> otherBuilder = new UserManagedCacheBuilder<K, V, T>(this);
        otherBuilder.evictionAdvisor = evictionAdvisor;
        return otherBuilder;
    }

    public UserManagedCacheBuilder<K, V, T> withLoaderWriter(CacheLoaderWriter<K, V> loaderWriter) {
        if (loaderWriter == null) {
            throw new NullPointerException("Null loaderWriter");
        }
        UserManagedCacheBuilder<K, V, T> otherBuilder = new UserManagedCacheBuilder<K, V, T>(this);
        otherBuilder.cacheLoaderWriter = loaderWriter;
        return otherBuilder;
    }

    public UserManagedCacheBuilder<K, V, T> withKeySerializingCopier() {
        UserManagedCacheBuilder<K, V, T> otherBuilder = new UserManagedCacheBuilder<K, V, T>(this);
        otherBuilder.keyCopier = null;
        otherBuilder.useKeySerializingCopier = true;
        return otherBuilder;
    }

    public UserManagedCacheBuilder<K, V, T> withValueSerializingCopier() {
        UserManagedCacheBuilder<K, V, T> otherBuilder = new UserManagedCacheBuilder<K, V, T>(this);
        otherBuilder.valueCopier = null;
        otherBuilder.useValueSerializingCopier = true;
        return otherBuilder;
    }

    public UserManagedCacheBuilder<K, V, T> withKeyCopier(Copier<K> keyCopier) {
        if (keyCopier == null) {
            throw new NullPointerException("Null key copier");
        }
        UserManagedCacheBuilder<K, V, T> otherBuilder = new UserManagedCacheBuilder<K, V, T>(this);
        otherBuilder.keyCopier = keyCopier;
        otherBuilder.useKeySerializingCopier = false;
        return otherBuilder;
    }

    public UserManagedCacheBuilder<K, V, T> withValueCopier(Copier<V> valueCopier) {
        if (valueCopier == null) {
            throw new NullPointerException("Null value copier");
        }
        UserManagedCacheBuilder<K, V, T> otherBuilder = new UserManagedCacheBuilder<K, V, T>(this);
        otherBuilder.valueCopier = valueCopier;
        otherBuilder.useValueSerializingCopier = false;
        return otherBuilder;
    }

    public UserManagedCacheBuilder<K, V, T> withKeySerializer(Serializer<K> keySerializer) {
        if (keySerializer == null) {
            throw new NullPointerException("Null key serializer");
        }
        UserManagedCacheBuilder<K, V, T> otherBuilder = new UserManagedCacheBuilder<K, V, T>(this);
        otherBuilder.keySerializer = keySerializer;
        return otherBuilder;
    }

    public UserManagedCacheBuilder<K, V, T> withValueSerializer(Serializer<V> valueSerializer) {
        if (valueSerializer == null) {
            throw new NullPointerException("Null value serializer");
        }
        UserManagedCacheBuilder<K, V, T> otherBuilder = new UserManagedCacheBuilder<K, V, T>(this);
        otherBuilder.valueSerializer = valueSerializer;
        return otherBuilder;
    }

    public UserManagedCacheBuilder<K, V, T> withSizeOfMaxObjectGraph(long size) {
        UserManagedCacheBuilder<K, V, T> otherBuilder = new UserManagedCacheBuilder<K, V, T>(this);
        UserManagedCacheBuilder.removeAnySizeOfEngine(otherBuilder);
        otherBuilder.objectGraphSize = size;
        otherBuilder.serviceCreationConfigurations.add(new DefaultSizeOfEngineProviderConfiguration(otherBuilder.maxObjectSize, otherBuilder.sizeOfUnit, otherBuilder.objectGraphSize));
        return otherBuilder;
    }

    public UserManagedCacheBuilder<K, V, T> withSizeOfMaxObjectSize(long size, MemoryUnit unit) {
        UserManagedCacheBuilder<K, V, T> otherBuilder = new UserManagedCacheBuilder<K, V, T>(this);
        UserManagedCacheBuilder.removeAnySizeOfEngine(otherBuilder);
        otherBuilder.maxObjectSize = size;
        otherBuilder.sizeOfUnit = unit;
        otherBuilder.serviceCreationConfigurations.add(new DefaultSizeOfEngineProviderConfiguration(otherBuilder.maxObjectSize, otherBuilder.sizeOfUnit, otherBuilder.objectGraphSize));
        return otherBuilder;
    }

    public static <K, V> UserManagedCacheBuilder<K, V, UserManagedCache<K, V>> newUserManagedCacheBuilder(Class<K> keyType, Class<V> valueType) {
        return new UserManagedCacheBuilder(keyType, valueType);
    }

    public UserManagedCacheBuilder<K, V, T> using(Service service) {
        UserManagedCacheBuilder<K, V, T> otherBuilder = new UserManagedCacheBuilder<K, V, T>(this);
        if (service instanceof SizeOfEngineProvider) {
            UserManagedCacheBuilder.removeAnySizeOfEngine(otherBuilder);
        }
        otherBuilder.services.add(service);
        return otherBuilder;
    }

    public UserManagedCacheBuilder<K, V, T> using(ServiceCreationConfiguration<?> serviceConfiguration) {
        UserManagedCacheBuilder<K, V, T> otherBuilder = new UserManagedCacheBuilder<K, V, T>(this);
        if (serviceConfiguration instanceof DefaultSizeOfEngineProviderConfiguration) {
            UserManagedCacheBuilder.removeAnySizeOfEngine(otherBuilder);
        }
        otherBuilder.serviceCreationConfigurations.add(serviceConfiguration);
        return otherBuilder;
    }

    private static void removeAnySizeOfEngine(UserManagedCacheBuilder builder) {
        builder.services.remove(ServiceLocator.findSingletonAmongst(SizeOfEngineProvider.class, builder.services));
        builder.serviceCreationConfigurations.remove(ServiceLocator.findSingletonAmongst(DefaultSizeOfEngineProviderConfiguration.class, builder.serviceCreationConfigurations));
    }

    @ServiceDependencies(value={Store.Provider.class})
    private static class ServiceDeps {
        private ServiceDeps() {
            throw new UnsupportedOperationException("This is an annotation placeholder, not to be instantiated");
        }
    }
}

