/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.config.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.Configuration;
import org.ehcache.config.builders.Builder;
import org.ehcache.core.config.DefaultConfiguration;
import org.ehcache.spi.service.ServiceCreationConfiguration;

class ConfigurationBuilder
implements Builder<Configuration> {
    private final Map<String, CacheConfiguration<?, ?>> caches;
    private final List<ServiceCreationConfiguration<?>> serviceConfigurations;
    private final ClassLoader classLoader;

    static ConfigurationBuilder newConfigurationBuilder() {
        return new ConfigurationBuilder();
    }

    private ConfigurationBuilder() {
        this.caches = Collections.emptyMap();
        this.serviceConfigurations = Collections.emptyList();
        this.classLoader = null;
    }

    private ConfigurationBuilder(ConfigurationBuilder builder, Map<String, CacheConfiguration<?, ?>> caches) {
        this.caches = Collections.unmodifiableMap(caches);
        this.serviceConfigurations = builder.serviceConfigurations;
        this.classLoader = builder.classLoader;
    }

    private ConfigurationBuilder(ConfigurationBuilder builder, List<ServiceCreationConfiguration<?>> serviceConfigurations) {
        this.caches = builder.caches;
        this.serviceConfigurations = Collections.unmodifiableList(serviceConfigurations);
        this.classLoader = builder.classLoader;
    }

    private ConfigurationBuilder(ConfigurationBuilder builder, ClassLoader classLoader) {
        this.caches = builder.caches;
        this.serviceConfigurations = builder.serviceConfigurations;
        this.classLoader = classLoader;
    }

    @Override
    public Configuration build() {
        return new DefaultConfiguration(this.caches, this.classLoader, this.serviceConfigurations.toArray(new ServiceCreationConfiguration[this.serviceConfigurations.size()]));
    }

    ConfigurationBuilder addCache(String alias, CacheConfiguration<?, ?> config) {
        HashMap newCaches = new HashMap(this.caches);
        newCaches.put(alias, config);
        return new ConfigurationBuilder(this, newCaches);
    }

    public ConfigurationBuilder removeCache(String alias) {
        HashMap newCaches = new HashMap(this.caches);
        newCaches.remove(alias);
        return new ConfigurationBuilder(this, newCaches);
    }

    ConfigurationBuilder addService(ServiceCreationConfiguration<?> serviceConfiguration) {
        if (this.findServiceByClass(serviceConfiguration.getClass()) != null) {
            throw new IllegalArgumentException("There is already a ServiceCreationConfiguration registered for service " + serviceConfiguration.getServiceType() + " of type " + serviceConfiguration.getClass());
        }
        ArrayList newServiceConfigurations = new ArrayList(this.serviceConfigurations);
        newServiceConfigurations.add(serviceConfiguration);
        return new ConfigurationBuilder(this, newServiceConfigurations);
    }

    <T> T findServiceByClass(Class<T> type) {
        for (ServiceCreationConfiguration<?> serviceConfiguration : this.serviceConfigurations) {
            if (!serviceConfiguration.getClass().equals(type)) continue;
            return (T)serviceConfiguration;
        }
        return null;
    }

    ConfigurationBuilder removeService(ServiceCreationConfiguration<?> serviceConfiguration) {
        ArrayList newServiceConfigurations = new ArrayList(this.serviceConfigurations);
        newServiceConfigurations.remove(serviceConfiguration);
        return new ConfigurationBuilder(this, newServiceConfigurations);
    }

    ConfigurationBuilder withClassLoader(ClassLoader classLoader) {
        return new ConfigurationBuilder(this, classLoader);
    }
}

