/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.heap;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.ehcache.config.EvictionVeto;
import org.ehcache.core.spi.cache.Store;
import org.ehcache.core.spi.function.BiFunction;
import org.ehcache.impl.internal.concurrent.ConcurrentHashMap;
import org.ehcache.impl.internal.store.heap.Backend;
import org.ehcache.impl.internal.store.heap.holders.OnHeapValueHolder;

class SimpleBackend<K, V>
implements Backend<K, V> {
    private final ConcurrentHashMap<K, OnHeapValueHolder<V>> realMap = new ConcurrentHashMap();

    SimpleBackend() {
    }

    @Override
    public boolean remove(K key, OnHeapValueHolder<V> value) {
        return this.realMap.remove(key, value);
    }

    @Override
    public Map.Entry<K, OnHeapValueHolder<V>> getEvictionCandidate(Random random, int size, Comparator<? super Store.ValueHolder<V>> prioritizer, EvictionVeto<Object, OnHeapValueHolder<?>> evictionVeto) {
        return this.realMap.getEvictionCandidate(random, size, prioritizer, evictionVeto);
    }

    @Override
    public int size() {
        return this.realMap.size();
    }

    @Override
    public Iterable<K> keySet() {
        return this.realMap.keySet();
    }

    @Override
    public Iterator<Map.Entry<K, OnHeapValueHolder<V>>> entrySetIterator() {
        return this.realMap.entrySet().iterator();
    }

    @Override
    public OnHeapValueHolder<V> compute(K key, BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>> computeFunction) {
        return this.realMap.compute(key, computeFunction);
    }

    @Override
    public void clear() {
        this.realMap.clear();
    }

    @Override
    public OnHeapValueHolder<V> remove(K key) {
        return this.realMap.remove(key);
    }

    @Override
    public OnHeapValueHolder<V> computeIfPresent(K key, BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>> computeFunction) {
        return this.realMap.computeIfPresent(key, computeFunction);
    }

    @Override
    public OnHeapValueHolder<V> get(K key) {
        return this.realMap.get(key);
    }

    @Override
    public OnHeapValueHolder<V> putIfAbsent(K key, OnHeapValueHolder<V> valueHolder) {
        return this.realMap.putIfAbsent(key, valueHolder);
    }

    @Override
    public boolean replace(K key, OnHeapValueHolder<V> oldValue, OnHeapValueHolder<V> newValue) {
        return this.realMap.replace(key, oldValue, newValue);
    }
}

