/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.heap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.ehcache.Cache;
import org.ehcache.config.Eviction;
import org.ehcache.config.EvictionVeto;
import org.ehcache.config.ResourcePool;
import org.ehcache.config.ResourcePools;
import org.ehcache.config.ResourceType;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.core.CacheConfigurationChangeEvent;
import org.ehcache.core.CacheConfigurationChangeListener;
import org.ehcache.core.CacheConfigurationProperty;
import org.ehcache.core.events.StoreEventDispatcher;
import org.ehcache.core.events.StoreEventSink;
import org.ehcache.core.exceptions.CachePassThroughException;
import org.ehcache.core.exceptions.LimitExceededException;
import org.ehcache.core.internal.util.ConcurrentWeakIdentityHashMap;
import org.ehcache.core.spi.cache.Store;
import org.ehcache.core.spi.cache.events.StoreEventSource;
import org.ehcache.core.spi.cache.tiering.BinaryValueHolder;
import org.ehcache.core.spi.cache.tiering.CachingTier;
import org.ehcache.core.spi.cache.tiering.HigherCachingTier;
import org.ehcache.core.spi.function.BiFunction;
import org.ehcache.core.spi.function.Function;
import org.ehcache.core.spi.function.NullaryFunction;
import org.ehcache.core.spi.sizeof.SizeOfEngine;
import org.ehcache.core.spi.sizeof.SizeOfEngineProvider;
import org.ehcache.core.spi.time.TimeSource;
import org.ehcache.core.spi.time.TimeSourceService;
import org.ehcache.core.statistics.CachingTierOperationOutcomes;
import org.ehcache.core.statistics.HigherCachingTierOperationOutcomes;
import org.ehcache.core.statistics.StoreOperationOutcomes;
import org.ehcache.exceptions.CacheAccessException;
import org.ehcache.expiry.Duration;
import org.ehcache.expiry.Expiry;
import org.ehcache.impl.copy.IdentityCopier;
import org.ehcache.impl.copy.SerializingCopier;
import org.ehcache.impl.internal.events.ScopedStoreEventDispatcher;
import org.ehcache.impl.internal.sizeof.NoopSizeOfEngine;
import org.ehcache.impl.internal.store.heap.Backend;
import org.ehcache.impl.internal.store.heap.KeyCopyBackend;
import org.ehcache.impl.internal.store.heap.SimpleBackend;
import org.ehcache.impl.internal.store.heap.holders.CopiedOnHeapValueHolder;
import org.ehcache.impl.internal.store.heap.holders.OnHeapValueHolder;
import org.ehcache.impl.internal.store.heap.holders.SerializedOnHeapValueHolder;
import org.ehcache.sizeof.annotations.IgnoreSizeOf;
import org.ehcache.spi.ServiceProvider;
import org.ehcache.spi.copy.Copier;
import org.ehcache.spi.copy.CopyProvider;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceDependencies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.context.annotations.ContextAttribute;
import org.terracotta.statistics.StatisticBuilder;
import org.terracotta.statistics.StatisticsManager;
import org.terracotta.statistics.observer.OperationObserver;

public class OnHeapStore<K, V>
implements Store<K, V>,
HigherCachingTier<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(OnHeapStore.class);
    private static final int ATTEMPT_RATIO = 4;
    private static final int EVICTION_RATIO = 2;
    private static final EvictionVeto<Object, OnHeapValueHolder<?>> EVICTION_VETO = new EvictionVeto<Object, OnHeapValueHolder<?>>(){

        public boolean vetoes(Object key, OnHeapValueHolder<?> value) {
            return value.veto();
        }
    };
    private static final Comparator<Store.ValueHolder<?>> EVICTION_PRIORITIZER = new Comparator<Store.ValueHolder<?>>(){

        @Override
        public int compare(Store.ValueHolder<?> t, Store.ValueHolder<?> u) {
            if (t instanceof Fault) {
                return -1;
            }
            if (u instanceof Fault) {
                return 1;
            }
            return Long.signum(t.lastAccessTime(TimeUnit.NANOSECONDS) - u.lastAccessTime(TimeUnit.NANOSECONDS));
        }
    };
    private static final CachingTier.InvalidationListener NULL_INVALIDATION_LISTENER = new CachingTier.InvalidationListener(){

        public void onInvalidation(Object key, Store.ValueHolder valueHolder) {
        }
    };
    static final int SAMPLE_SIZE = 8;
    private final Backend<K, V> map;
    private final Class<K> keyType;
    private final Class<V> valueType;
    private final Copier<V> valueCopier;
    private final SizeOfEngine sizeOfEngine;
    private final boolean byteSized;
    private final AtomicLong currentUsageinBytes = new AtomicLong(0L);
    private volatile long capacity;
    private final EvictionVeto<? super K, ? super V> evictionVeto;
    private final Expiry<? super K, ? super V> expiry;
    private final TimeSource timeSource;
    private final StoreEventDispatcher<K, V> storeEventDispatcher;
    private volatile CachingTier.InvalidationListener<K, V> invalidationListener = NULL_INVALIDATION_LISTENER;
    private CacheConfigurationChangeListener cacheConfigurationChangeListener = new CacheConfigurationChangeListener(){

        public void cacheConfigurationChange(CacheConfigurationChangeEvent event) {
            if (event.getProperty().equals((Object)CacheConfigurationProperty.UPDATE_SIZE)) {
                ResourcePools updatedPools = (ResourcePools)event.getNewValue();
                ResourcePools configuredPools = (ResourcePools)event.getOldValue();
                if (updatedPools.getPoolForResource((ResourceType)ResourceType.Core.HEAP).getSize() != configuredPools.getPoolForResource((ResourceType)ResourceType.Core.HEAP).getSize()) {
                    LOG.info("Setting size: " + updatedPools.getPoolForResource((ResourceType)ResourceType.Core.HEAP).getSize());
                    ResourcePool pool = updatedPools.getPoolForResource((ResourceType)ResourceType.Core.HEAP);
                    if (pool.getUnit() instanceof MemoryUnit) {
                        OnHeapStore.this.capacity = ((MemoryUnit)pool.getUnit()).toBytes(pool.getSize());
                    } else {
                        OnHeapStore.this.capacity = pool.getSize();
                    }
                }
            }
        }
    };
    private final OperationObserver<StoreOperationOutcomes.GetOutcome> getObserver;
    private final OperationObserver<StoreOperationOutcomes.PutOutcome> putObserver;
    private final OperationObserver<StoreOperationOutcomes.RemoveOutcome> removeObserver;
    private final OperationObserver<StoreOperationOutcomes.PutIfAbsentOutcome> putIfAbsentObserver;
    private final OperationObserver<StoreOperationOutcomes.ConditionalRemoveOutcome> conditionalRemoveObserver;
    private final OperationObserver<StoreOperationOutcomes.ReplaceOutcome> replaceObserver;
    private final OperationObserver<StoreOperationOutcomes.ConditionalReplaceOutcome> conditionalReplaceObserver;
    private final OperationObserver<StoreOperationOutcomes.ComputeOutcome> computeObserver;
    private final OperationObserver<StoreOperationOutcomes.ComputeIfAbsentOutcome> computeIfAbsentObserver;
    private final OperationObserver<StoreOperationOutcomes.ComputeIfPresentOutcome> computeIfPresentObserver;
    private final OperationObserver<StoreOperationOutcomes.EvictionOutcome> evictionObserver;
    private final OperationObserver<StoreOperationOutcomes.ExpirationOutcome> expirationObserver;
    private final OperationObserver<CachingTierOperationOutcomes.GetOrComputeIfAbsentOutcome> getOrComputeIfAbsentObserver;
    private final OperationObserver<CachingTierOperationOutcomes.InvalidateOutcome> invalidateObserver;
    private final OperationObserver<HigherCachingTierOperationOutcomes.SilentInvalidateOutcome> silentInvalidateObserver;
    private final OnHeapStoreStatsSettings onHeapStoreStatsSettings;
    private static final NullaryFunction<Boolean> REPLACE_EQUALS_TRUE = new NullaryFunction<Boolean>(){

        public Boolean apply() {
            return Boolean.TRUE;
        }
    };

    public OnHeapStore(Store.Configuration<K, V> config, TimeSource timeSource, Copier<K> keyCopier, Copier<V> valueCopier, SizeOfEngine sizeOfEngine, StoreEventDispatcher<K, V> eventDispatcher) {
        if (keyCopier == null) {
            throw new NullPointerException("keyCopier must not be null");
        }
        if (valueCopier == null) {
            throw new NullPointerException("valueCopier must not be null");
        }
        ResourcePool heapPool = config.getResourcePools().getPoolForResource((ResourceType)ResourceType.Core.HEAP);
        if (heapPool == null) {
            throw new IllegalArgumentException("OnHeap store must be configured with a resource of type 'heap'");
        }
        this.sizeOfEngine = sizeOfEngine;
        this.byteSized = !(this.sizeOfEngine instanceof NoopSizeOfEngine);
        this.capacity = this.byteSized ? ((MemoryUnit)heapPool.getUnit()).toBytes(heapPool.getSize()) : heapPool.getSize();
        this.timeSource = timeSource;
        this.evictionVeto = config.getEvictionVeto() == null ? Eviction.none() : config.getEvictionVeto();
        this.keyType = config.getKeyType();
        this.valueType = config.getValueType();
        this.expiry = config.getExpiry();
        this.valueCopier = valueCopier;
        this.storeEventDispatcher = eventDispatcher;
        this.map = keyCopier instanceof IdentityCopier ? new SimpleBackend() : new KeyCopyBackend(keyCopier);
        this.onHeapStoreStatsSettings = new OnHeapStoreStatsSettings(this);
        StatisticsManager.associate((Object)this.onHeapStoreStatsSettings).withParent((Object)this);
        this.getObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.GetOutcome.class).named("get")).of((Object)this)).tag(new String[]{"onheap-store"})).build();
        this.putObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.PutOutcome.class).named("put")).of((Object)this)).tag(new String[]{"onheap-store"})).build();
        this.removeObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.RemoveOutcome.class).named("remove")).of((Object)this)).tag(new String[]{"onheap-store"})).build();
        this.putIfAbsentObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.PutIfAbsentOutcome.class).named("putIfAbsent")).of((Object)this)).tag(new String[]{"onheap-store"})).build();
        this.conditionalRemoveObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.ConditionalRemoveOutcome.class).named("conditionalRemove")).of((Object)this)).tag(new String[]{"onheap-store"})).build();
        this.replaceObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.ReplaceOutcome.class).named("replace")).of((Object)this)).tag(new String[]{"onheap-store"})).build();
        this.conditionalReplaceObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.ConditionalReplaceOutcome.class).named("conditionalReplace")).of((Object)this)).tag(new String[]{"onheap-store"})).build();
        this.computeObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.ComputeOutcome.class).named("compute")).of((Object)this)).tag(new String[]{"onheap-store"})).build();
        this.computeIfAbsentObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.ComputeIfAbsentOutcome.class).named("computeIfAbsent")).of((Object)this)).tag(new String[]{"onheap-store"})).build();
        this.computeIfPresentObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.ComputeIfPresentOutcome.class).named("computeIfPresent")).of((Object)this)).tag(new String[]{"onheap-store"})).build();
        this.evictionObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.EvictionOutcome.class).named("eviction")).of((Object)this)).tag(new String[]{"onheap-store"})).build();
        this.expirationObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.ExpirationOutcome.class).named("expiration")).of((Object)this)).tag(new String[]{"onheap-store"})).build();
        this.getOrComputeIfAbsentObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(CachingTierOperationOutcomes.GetOrComputeIfAbsentOutcome.class).named("getOrComputeIfAbsent")).of((Object)this)).tag(new String[]{"onheap-store"})).build();
        this.invalidateObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(CachingTierOperationOutcomes.InvalidateOutcome.class).named("invalidate")).of((Object)this)).tag(new String[]{"onheap-store"})).build();
        this.silentInvalidateObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(HigherCachingTierOperationOutcomes.SilentInvalidateOutcome.class).named("silentInvalidate")).of((Object)this)).tag(new String[]{"onheap-store"})).build();
    }

    public Store.ValueHolder<V> get(K key) throws CacheAccessException {
        this.checkKey(key);
        return this.internalGet(key, true);
    }

    private OnHeapValueHolder<V> internalGet(K key, boolean updateAccess) throws CacheAccessException {
        this.getObserver.begin();
        StoreEventSink eventSink = null;
        try {
            OnHeapValueHolder<V> mapping = this.map.get(key);
            if (mapping == null) {
                this.getObserver.end((Enum)StoreOperationOutcomes.GetOutcome.MISS);
                return null;
            }
            if (mapping.isExpired(this.timeSource.getTimeMillis(), TimeUnit.MILLISECONDS)) {
                this.expireMapping(key, (Store.ValueHolder<V>)mapping);
                this.getObserver.end((Enum)StoreOperationOutcomes.GetOutcome.MISS);
                return null;
            }
            if (updateAccess) {
                eventSink = this.storeEventDispatcher.eventSink();
                mapping = this.setAccessTimeAndExpiryThenReturnMapping(key, mapping, this.timeSource.getTimeMillis(), eventSink);
                this.storeEventDispatcher.releaseEventSink(eventSink);
            }
            if (mapping != null) {
                this.getObserver.end((Enum)StoreOperationOutcomes.GetOutcome.HIT);
            } else {
                this.getObserver.end((Enum)StoreOperationOutcomes.GetOutcome.MISS);
            }
            return mapping;
        }
        catch (RuntimeException re) {
            if (eventSink != null) {
                this.storeEventDispatcher.releaseEventSinkAfterFailure(eventSink, (Throwable)re);
            }
            CachePassThroughException.handleRuntimeException((RuntimeException)re);
            return null;
        }
    }

    public boolean containsKey(K key) throws CacheAccessException {
        this.checkKey(key);
        return this.internalGet(key, false) != null;
    }

    public Store.PutStatus put(K key, V value) throws CacheAccessException {
        return this.putReturnHolder(key, value);
    }

    private Store.PutStatus putReturnHolder(final K key, final V value) throws CacheAccessException {
        this.putObserver.begin();
        this.checkKey(key);
        this.checkValue(value);
        final AtomicBoolean entryActuallyAdded = new AtomicBoolean();
        final long now = this.timeSource.getTimeMillis();
        final AtomicReference<Object> replacedValue = new AtomicReference<Object>(null);
        final StoreEventSink eventSink = this.storeEventDispatcher.eventSink();
        try {
            OnHeapValueHolder<V> valuePut = this.map.compute(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

                public OnHeapValueHolder<V> apply(K mappedKey, OnHeapValueHolder<V> mappedValue) {
                    if (mappedValue != null && mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                        mappedValue = null;
                    }
                    if (mappedValue == null) {
                        OnHeapValueHolder newValue = OnHeapStore.this.newCreateValueHolder(key, value, now, eventSink);
                        entryActuallyAdded.set(newValue != null);
                        return newValue;
                    }
                    OnHeapValueHolder newValue = OnHeapStore.this.newUpdateValueHolder(key, mappedValue, value, now, eventSink);
                    replacedValue.set(mappedValue);
                    return newValue;
                }
            });
            if (entryActuallyAdded.get()) {
                this.enforceCapacity(valuePut.size(), eventSink);
            } else {
                long replacedDelta = valuePut == null ? 0L : valuePut.size() - (replacedValue.get() == null ? 0L : ((OnHeapValueHolder)replacedValue.get()).size());
                this.replaceByteCapacity(replacedDelta, eventSink);
            }
            this.storeEventDispatcher.releaseEventSink(eventSink);
            if (replacedValue.get() != null) {
                this.putObserver.end((Enum)StoreOperationOutcomes.PutOutcome.REPLACED);
                return Store.PutStatus.UPDATE;
            }
            if (entryActuallyAdded.get()) {
                this.putObserver.end((Enum)StoreOperationOutcomes.PutOutcome.PUT);
                return Store.PutStatus.PUT;
            }
            this.putObserver.end((Enum)StoreOperationOutcomes.PutOutcome.REPLACED);
            return Store.PutStatus.NOOP;
        }
        catch (RuntimeException re) {
            this.storeEventDispatcher.releaseEventSinkAfterFailure(eventSink, (Throwable)re);
            CachePassThroughException.handleRuntimeException((RuntimeException)re);
            return Store.PutStatus.NOOP;
        }
    }

    public boolean remove(K key) throws CacheAccessException {
        this.removeObserver.begin();
        this.checkKey(key);
        final StoreEventSink eventSink = this.storeEventDispatcher.eventSink();
        final long now = this.timeSource.getTimeMillis();
        try {
            final AtomicReference removedValue = new AtomicReference();
            this.map.computeIfPresent(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

                public OnHeapValueHolder<V> apply(K mappedKey, OnHeapValueHolder<V> mappedValue) {
                    if (mappedValue != null && mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                        OnHeapStore.this.onExpiration(mappedKey, mappedValue, eventSink);
                        return null;
                    }
                    if (mappedValue != null) {
                        removedValue.set(mappedValue);
                        eventSink.removed(mappedKey, mappedValue.value());
                    }
                    return null;
                }
            });
            this.storeEventDispatcher.releaseEventSink(eventSink);
            OnHeapValueHolder removedValueHolder = (OnHeapValueHolder)((Object)removedValue.get());
            if (removedValueHolder != null) {
                this.removeObserver.end((Enum)StoreOperationOutcomes.RemoveOutcome.REMOVED);
                this.decrementCurrentUsageInBytesIfRequired(removedValueHolder.size());
            } else {
                this.removeObserver.end((Enum)StoreOperationOutcomes.RemoveOutcome.MISS);
            }
            return removedValueHolder != null;
        }
        catch (RuntimeException re) {
            this.storeEventDispatcher.releaseEventSinkAfterFailure(eventSink, (Throwable)re);
            CachePassThroughException.handleRuntimeException((RuntimeException)re);
            return false;
        }
    }

    public Store.ValueHolder<V> putIfAbsent(K key, V value) throws CacheAccessException {
        return this.putIfAbsent(key, value, false);
    }

    private OnHeapValueHolder<V> putIfAbsent(final K key, final V value, boolean returnInCacheHolder) throws CacheAccessException {
        this.putIfAbsentObserver.begin();
        this.checkKey(key);
        this.checkValue(value);
        final AtomicReference<Object> returnValue = new AtomicReference<Object>(null);
        final AtomicBoolean entryActuallyAdded = new AtomicBoolean();
        final long now = this.timeSource.getTimeMillis();
        final StoreEventSink eventSink = this.storeEventDispatcher.eventSink();
        try {
            OnHeapValueHolder<V> inCache = this.map.compute(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

                public OnHeapValueHolder<V> apply(K mappedKey, OnHeapValueHolder<V> mappedValue) {
                    if (mappedValue == null || mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                        OnHeapValueHolder holder;
                        if (mappedValue != null) {
                            OnHeapStore.this.onExpiration(mappedKey, mappedValue, eventSink);
                        }
                        entryActuallyAdded.set((holder = OnHeapStore.this.newCreateValueHolder(key, value, now, eventSink)) != null);
                        return holder;
                    }
                    returnValue.set(mappedValue);
                    return OnHeapStore.this.setAccessTimeAndExpiryThenReturnMapping(key, mappedValue, now, eventSink);
                }
            });
            if (entryActuallyAdded.get()) {
                this.enforceCapacity(inCache.size(), eventSink);
            }
            this.storeEventDispatcher.releaseEventSink(eventSink);
            if (entryActuallyAdded.get()) {
                this.putIfAbsentObserver.end((Enum)StoreOperationOutcomes.PutIfAbsentOutcome.PUT);
            } else {
                this.putIfAbsentObserver.end((Enum)StoreOperationOutcomes.PutIfAbsentOutcome.HIT);
            }
            if (returnInCacheHolder) {
                return inCache;
            }
        }
        catch (RuntimeException re) {
            this.storeEventDispatcher.releaseEventSinkAfterFailure(eventSink, (Throwable)re);
            CachePassThroughException.handleRuntimeException((RuntimeException)re);
        }
        return returnValue.get();
    }

    public Store.RemoveStatus remove(final K key, final V value) throws CacheAccessException {
        this.conditionalRemoveObserver.begin();
        this.checkKey(key);
        this.checkValue(value);
        final AtomicReference<Object> removedValue = new AtomicReference<Object>(null);
        final StoreEventSink eventSink = this.storeEventDispatcher.eventSink();
        final AtomicBoolean mappingExists = new AtomicBoolean();
        try {
            this.map.computeIfPresent(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

                public OnHeapValueHolder<V> apply(K mappedKey, OnHeapValueHolder<V> mappedValue) {
                    long now = OnHeapStore.this.timeSource.getTimeMillis();
                    if (mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                        OnHeapStore.this.onExpiration(mappedKey, mappedValue, eventSink);
                        return null;
                    }
                    if (value.equals(mappedValue.value())) {
                        removedValue.set(mappedValue);
                        eventSink.removed(mappedKey, mappedValue.value());
                        return null;
                    }
                    mappingExists.set(true);
                    return OnHeapStore.this.setAccessTimeAndExpiryThenReturnMapping(key, mappedValue, now, eventSink);
                }
            });
            this.storeEventDispatcher.releaseEventSink(eventSink);
            if (removedValue.get() != null) {
                this.conditionalRemoveObserver.end((Enum)StoreOperationOutcomes.ConditionalRemoveOutcome.REMOVED);
                this.decrementCurrentUsageInBytesIfRequired(((OnHeapValueHolder)removedValue.get()).size());
                return Store.RemoveStatus.REMOVED;
            }
            this.conditionalRemoveObserver.end((Enum)StoreOperationOutcomes.ConditionalRemoveOutcome.MISS);
            if (mappingExists.get()) {
                return Store.RemoveStatus.KEY_PRESENT;
            }
            return Store.RemoveStatus.KEY_MISSING;
        }
        catch (RuntimeException re) {
            this.storeEventDispatcher.releaseEventSinkAfterFailure(eventSink, (Throwable)re);
            CachePassThroughException.handleRuntimeException((RuntimeException)re);
            return Store.RemoveStatus.KEY_MISSING;
        }
    }

    public Store.ValueHolder<V> replace(final K key, final V value) throws CacheAccessException {
        this.replaceObserver.begin();
        this.checkKey(key);
        this.checkValue(value);
        final AtomicReference<Object> returnValue = new AtomicReference<Object>(null);
        final StoreEventSink eventSink = this.storeEventDispatcher.eventSink();
        try {
            OnHeapValueHolder<V> newValue = this.map.computeIfPresent(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

                public OnHeapValueHolder<V> apply(K mappedKey, OnHeapValueHolder<V> mappedValue) {
                    long now = OnHeapStore.this.timeSource.getTimeMillis();
                    if (mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                        OnHeapStore.this.onExpiration(mappedKey, mappedValue, eventSink);
                        return null;
                    }
                    returnValue.set(mappedValue);
                    return OnHeapStore.this.newUpdateValueHolder(key, mappedValue, value, now, eventSink);
                }
            });
            OnHeapValueHolder valueHolder = returnValue.get();
            if (valueHolder != null) {
                long replacedDelta = (newValue == null ? 0L : newValue.size()) - ((OnHeapValueHolder)returnValue.get()).size();
                this.replaceByteCapacity(replacedDelta, eventSink);
            }
            this.storeEventDispatcher.releaseEventSink(eventSink);
            if (valueHolder != null) {
                this.replaceObserver.end((Enum)StoreOperationOutcomes.ReplaceOutcome.REPLACED);
            } else {
                this.replaceObserver.end((Enum)StoreOperationOutcomes.ReplaceOutcome.MISS);
            }
        }
        catch (RuntimeException re) {
            this.storeEventDispatcher.releaseEventSinkAfterFailure(eventSink, (Throwable)re);
            CachePassThroughException.handleRuntimeException((RuntimeException)re);
        }
        return returnValue.get();
    }

    public Store.ReplaceStatus replace(final K key, final V oldValue, final V newValue) throws CacheAccessException {
        this.conditionalReplaceObserver.begin();
        this.checkKey(key);
        this.checkValue(oldValue);
        this.checkValue(newValue);
        final AtomicReference<Object> returnValueHolder = new AtomicReference<Object>(null);
        final StoreEventSink eventSink = this.storeEventDispatcher.eventSink();
        final AtomicBoolean mappingExists = new AtomicBoolean();
        try {
            OnHeapValueHolder<V> replacedValue = this.map.computeIfPresent(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

                public OnHeapValueHolder<V> apply(K mappedKey, OnHeapValueHolder<V> mappedValue) {
                    long now = OnHeapStore.this.timeSource.getTimeMillis();
                    Object existingValue = mappedValue.value();
                    if (mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                        OnHeapStore.this.onExpiration(mappedKey, mappedValue, eventSink);
                        return null;
                    }
                    if (oldValue.equals(existingValue)) {
                        returnValueHolder.set(mappedValue);
                        long expirationTime = mappedValue.expirationTime(OnHeapValueHolder.TIME_UNIT);
                        return OnHeapStore.this.newUpdateValueHolder(key, existingValue, newValue, now, expirationTime, eventSink);
                    }
                    mappingExists.set(true);
                    return OnHeapStore.this.setAccessTimeAndExpiryThenReturnMapping(key, mappedValue, now, eventSink);
                }
            });
            if (returnValueHolder.get() != null) {
                long replacedDelta = (replacedValue == null ? 0L : replacedValue.size()) - ((OnHeapValueHolder)returnValueHolder.get()).size();
                this.replaceByteCapacity(replacedDelta, eventSink);
            }
            this.storeEventDispatcher.releaseEventSink(eventSink);
            if (returnValueHolder.get() != null) {
                this.conditionalReplaceObserver.end((Enum)StoreOperationOutcomes.ConditionalReplaceOutcome.REPLACED);
                return Store.ReplaceStatus.HIT;
            }
            this.conditionalReplaceObserver.end((Enum)StoreOperationOutcomes.ConditionalReplaceOutcome.MISS);
            if (mappingExists.get()) {
                return Store.ReplaceStatus.MISS_PRESENT;
            }
            return Store.ReplaceStatus.MISS_NOT_PRESENT;
        }
        catch (RuntimeException re) {
            this.storeEventDispatcher.releaseEventSinkAfterFailure(eventSink, (Throwable)re);
            CachePassThroughException.handleRuntimeException((RuntimeException)re);
            return Store.ReplaceStatus.MISS_NOT_PRESENT;
        }
    }

    public void clear() throws CacheAccessException {
        try {
            long current = this.currentUsageinBytes.get();
            this.map.clear();
            current = this.currentUsageinBytes.addAndGet(-current);
            if (current < 0L) {
                this.currentUsageinBytes.addAndGet(current);
            }
        }
        catch (RuntimeException re) {
            CachePassThroughException.handleRuntimeException((RuntimeException)re);
        }
    }

    private void invalidate() {
        for (K key : this.map.keySet()) {
            try {
                this.invalidate(key);
            }
            catch (CacheAccessException cae) {
                LOG.warn("Failed to invalidate mapping for key {}", key, (Object)cae);
            }
        }
        this.map.clear();
    }

    public Store.Iterator<Cache.Entry<K, Store.ValueHolder<V>>> iterator() {
        final Iterator<Map.Entry<K, OnHeapValueHolder<V>>> it = this.map.entrySetIterator();
        return new Store.Iterator<Cache.Entry<K, Store.ValueHolder<V>>>(){
            private Map.Entry<K, OnHeapValueHolder<V>> next = null;
            private CacheAccessException prefetchFailure = null;
            {
                this.advance();
            }

            private void advance() {
                this.next = null;
                try {
                    while (this.next == null && it.hasNext()) {
                        Map.Entry entry = (Map.Entry)it.next();
                        long now = OnHeapStore.this.timeSource.getTimeMillis();
                        if (((OnHeapValueHolder)((Object)entry.getValue())).isExpired(now, TimeUnit.MILLISECONDS)) {
                            OnHeapStore.this.internalGet(entry.getKey(), false);
                            continue;
                        }
                        this.next = entry;
                    }
                }
                catch (RuntimeException re) {
                    this.prefetchFailure = new CacheAccessException((Throwable)re);
                }
                catch (CacheAccessException e) {
                    this.prefetchFailure = e;
                }
            }

            public boolean hasNext() {
                return this.next != null || this.prefetchFailure != null;
            }

            public Cache.Entry<K, Store.ValueHolder<V>> next() throws CacheAccessException {
                if (this.prefetchFailure != null) {
                    throw this.prefetchFailure;
                }
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                final Map.Entry thisEntry = this.next;
                this.advance();
                OnHeapStore.this.setAccessTimeAndExpiryThenReturnMapping(thisEntry.getKey(), thisEntry.getValue(), OnHeapStore.this.timeSource.getTimeMillis());
                return new Cache.Entry<K, Store.ValueHolder<V>>(){

                    public K getKey() {
                        return thisEntry.getKey();
                    }

                    public Store.ValueHolder<V> getValue() {
                        return (Store.ValueHolder)thisEntry.getValue();
                    }
                };
            }
        };
    }

    public Store.ValueHolder<V> getOrComputeIfAbsent(final K key, final Function<K, Store.ValueHolder<V>> source) throws CacheAccessException {
        try {
            Fault fault;
            this.getOrComputeIfAbsentObserver.begin();
            Backend backEnd = this.map;
            OnHeapValueHolder<V> cachedValue = backEnd.get(key);
            long now = this.timeSource.getTimeMillis();
            if (cachedValue == null && (cachedValue = backEnd.putIfAbsent(key, fault = new Fault(new NullaryFunction<Store.ValueHolder<V>>(){

                public Store.ValueHolder<V> apply() {
                    return (Store.ValueHolder)source.apply(key);
                }
            }))) == null) {
                try {
                    OnHeapValueHolder<V> newValue;
                    Store.ValueHolder value = fault.get();
                    if (value != null) {
                        try {
                            newValue = this.importValueFromLowerTier(key, value, now);
                        }
                        catch (RuntimeException re) {
                            LOG.error("Expiry computation caused an exception - Expiry duration will be 0 ", (Throwable)re);
                            this.invalidateInGetorComputeIfAbsent(backEnd, key, value, fault, now);
                            this.getOrComputeIfAbsentObserver.end((Enum)CachingTierOperationOutcomes.GetOrComputeIfAbsentOutcome.FAULT_FAILED);
                            return null;
                        }
                        catch (LimitExceededException e) {
                            LOG.warn(e.getMessage());
                            OnHeapValueHolder<V> toReturn = this.invalidateInGetorComputeIfAbsent(backEnd, key, value, fault, now);
                            this.getOrComputeIfAbsentObserver.end((Enum)CachingTierOperationOutcomes.GetOrComputeIfAbsentOutcome.FAULT_FAILED);
                            return toReturn;
                        }
                    } else {
                        backEnd.remove(key, fault);
                        this.getOrComputeIfAbsentObserver.end((Enum)CachingTierOperationOutcomes.GetOrComputeIfAbsentOutcome.MISS);
                        return null;
                    }
                    if (backEnd.replace(key, fault, newValue)) {
                        this.getOrComputeIfAbsentObserver.end((Enum)CachingTierOperationOutcomes.GetOrComputeIfAbsentOutcome.FAULTED);
                        this.enforceCapacity(newValue.size());
                        return this.getValue((Store.ValueHolder<V>)newValue);
                    }
                    final AtomicReference invalidatedValue = new AtomicReference();
                    backEnd.computeIfPresent(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

                        public OnHeapValueHolder<V> apply(K mappedKey, OnHeapValueHolder<V> mappedValue) {
                            OnHeapStore.this.notifyInvalidation(key, mappedValue);
                            invalidatedValue.set(mappedValue);
                            return null;
                        }
                    });
                    Store.ValueHolder<V> p = this.getValue((Store.ValueHolder)invalidatedValue.get());
                    if (p != null) {
                        if (p.isExpired(now, TimeUnit.MILLISECONDS)) {
                            this.getOrComputeIfAbsentObserver.end((Enum)CachingTierOperationOutcomes.GetOrComputeIfAbsentOutcome.FAULT_FAILED_MISS);
                            return null;
                        }
                        this.getOrComputeIfAbsentObserver.end((Enum)CachingTierOperationOutcomes.GetOrComputeIfAbsentOutcome.FAULT_FAILED);
                        return p;
                    }
                    this.getOrComputeIfAbsentObserver.end((Enum)CachingTierOperationOutcomes.GetOrComputeIfAbsentOutcome.FAULT_FAILED);
                    return newValue;
                }
                catch (Throwable e) {
                    backEnd.remove(key, fault);
                    throw new CacheAccessException(e);
                }
            }
            if (!(cachedValue instanceof Fault)) {
                if (cachedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                    this.expireMapping(key, (Store.ValueHolder<V>)cachedValue);
                    this.getOrComputeIfAbsentObserver.end((Enum)CachingTierOperationOutcomes.GetOrComputeIfAbsentOutcome.MISS);
                    return null;
                }
                if (this.setAccessTimeAndExpiryThenReturnMapping(key, cachedValue, now) == null) {
                    this.getOrComputeIfAbsentObserver.end((Enum)CachingTierOperationOutcomes.GetOrComputeIfAbsentOutcome.MISS);
                    return null;
                }
            }
            this.getOrComputeIfAbsentObserver.end((Enum)CachingTierOperationOutcomes.GetOrComputeIfAbsentOutcome.HIT);
            return this.getValue((Store.ValueHolder<V>)cachedValue);
        }
        catch (RuntimeException re) {
            CachePassThroughException.handleRuntimeException((RuntimeException)re);
            return null;
        }
    }

    private OnHeapValueHolder<V> invalidateInGetorComputeIfAbsent(Backend<K, V> map, final K key, final Store.ValueHolder<V> value, final Fault<V> fault, final long now) {
        final AtomicReference toInvalidate = new AtomicReference();
        map.computeIfPresent(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

            public OnHeapValueHolder<V> apply(K mappedKey, OnHeapValueHolder<V> mappedValue) {
                if (mappedValue.equals((Object)fault)) {
                    try {
                        toInvalidate.set(OnHeapStore.this.cloneValueHolder(key, value, now, Duration.ZERO, false));
                    }
                    catch (LimitExceededException ex) {
                        throw new AssertionError((Object)"Sizing is not expected to happen.");
                    }
                    OnHeapStore.this.invalidationListener.onInvalidation(key, (Store.ValueHolder)toInvalidate.get());
                    return null;
                }
                return mappedValue;
            }
        });
        return (OnHeapValueHolder)((Object)toInvalidate.get());
    }

    public void invalidate(final K key) throws CacheAccessException {
        this.invalidateObserver.begin();
        this.checkKey(key);
        try {
            final AtomicReference<Object> invalidatedValue = new AtomicReference<Object>(null);
            this.map.computeIfPresent(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

                public OnHeapValueHolder<V> apply(K k, OnHeapValueHolder<V> present) {
                    if (!(present instanceof Fault)) {
                        OnHeapStore.this.notifyInvalidation(key, present);
                        invalidatedValue.set(present);
                    }
                    return null;
                }
            });
            OnHeapValueHolder invalidated = null;
            invalidated = invalidatedValue.get();
            if (invalidated != null) {
                this.invalidateObserver.end((Enum)CachingTierOperationOutcomes.InvalidateOutcome.REMOVED);
                this.decrementCurrentUsageInBytesIfRequired(invalidated.size());
            } else {
                this.invalidateObserver.end((Enum)CachingTierOperationOutcomes.InvalidateOutcome.MISS);
            }
        }
        catch (RuntimeException re) {
            CachePassThroughException.handleRuntimeException((RuntimeException)re);
        }
    }

    public void silentInvalidate(K key, final Function<Store.ValueHolder<V>, Void> function) throws CacheAccessException {
        this.silentInvalidateObserver.begin();
        this.checkKey(key);
        try {
            final AtomicReference<Object> invalidatedValue = new AtomicReference<Object>(null);
            this.map.compute(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

                public OnHeapValueHolder<V> apply(K k, OnHeapValueHolder<V> onHeapValueHolder) {
                    if (onHeapValueHolder != null) {
                        invalidatedValue.set(onHeapValueHolder);
                    }
                    OnHeapValueHolder holderToPass = onHeapValueHolder;
                    if (onHeapValueHolder instanceof Fault) {
                        holderToPass = null;
                        invalidatedValue.set(null);
                    }
                    function.apply(holderToPass);
                    return null;
                }
            });
            OnHeapValueHolder invalidated = null;
            invalidated = invalidatedValue.get();
            if (invalidated != null) {
                this.silentInvalidateObserver.end((Enum)HigherCachingTierOperationOutcomes.SilentInvalidateOutcome.REMOVED);
                this.decrementCurrentUsageInBytesIfRequired(invalidated.size());
            } else {
                this.silentInvalidateObserver.end((Enum)HigherCachingTierOperationOutcomes.SilentInvalidateOutcome.MISS);
            }
        }
        catch (RuntimeException re) {
            CachePassThroughException.handleRuntimeException((RuntimeException)re);
        }
    }

    private void notifyInvalidation(K key, Store.ValueHolder<V> p) {
        CachingTier.InvalidationListener<K, V> invalidationListener = this.invalidationListener;
        if (invalidationListener != null) {
            invalidationListener.onInvalidation(key, p);
        }
    }

    public void setInvalidationListener(final CachingTier.InvalidationListener<K, V> providedInvalidationListener) {
        this.invalidationListener = new CachingTier.InvalidationListener<K, V>(){

            public void onInvalidation(K key, Store.ValueHolder<V> valueHolder) {
                if (!(valueHolder instanceof Fault)) {
                    providedInvalidationListener.onInvalidation(key, valueHolder);
                }
            }
        };
    }

    private Store.ValueHolder<V> getValue(Store.ValueHolder<V> cachedValue) {
        if (cachedValue instanceof Fault) {
            return ((Fault)cachedValue).get();
        }
        return cachedValue;
    }

    private long getSizeOfKeyValuePairs(K key, OnHeapValueHolder<V> holder) throws LimitExceededException {
        return this.sizeOfEngine.sizeof(key, holder);
    }

    public Store.ValueHolder<V> compute(K key, BiFunction<? super K, ? super V, ? extends V> mappingFunction) throws CacheAccessException {
        return this.compute(key, mappingFunction, REPLACE_EQUALS_TRUE);
    }

    public Store.ValueHolder<V> compute(final K key, final BiFunction<? super K, ? super V, ? extends V> mappingFunction, final NullaryFunction<Boolean> replaceEqual) throws CacheAccessException {
        this.computeObserver.begin();
        this.checkKey(key);
        final long now = this.timeSource.getTimeMillis();
        final StoreEventSink eventSink = this.storeEventDispatcher.eventSink();
        try {
            final AtomicBoolean write = new AtomicBoolean(false);
            final AtomicReference<Object> replacedOrRemovedValue = new AtomicReference<Object>(null);
            OnHeapValueHolder<V> computeResult = this.map.compute(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

                public OnHeapValueHolder<V> apply(K mappedKey, OnHeapValueHolder<V> mappedValue) {
                    Object existingValue;
                    Object computedValue;
                    replacedOrRemovedValue.set(mappedValue);
                    if (mappedValue != null && mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                        OnHeapStore.this.onExpiration(mappedKey, mappedValue, eventSink);
                        mappedValue = null;
                    }
                    if ((computedValue = mappingFunction.apply(mappedKey, existingValue = mappedValue == null ? null : mappedValue.value())) == null) {
                        if (existingValue != null) {
                            write.set(true);
                            eventSink.removed(mappedKey, mappedValue.value());
                        }
                        return null;
                    }
                    if (OnHeapStore.eq(existingValue, computedValue) && !((Boolean)replaceEqual.apply()).booleanValue() && mappedValue != null) {
                        return OnHeapStore.this.setAccessTimeAndExpiryThenReturnMapping(key, mappedValue, now, eventSink);
                    }
                    OnHeapStore.this.checkValue(computedValue);
                    write.set(true);
                    if (mappedValue != null) {
                        long expirationTime = mappedValue.expirationTime(OnHeapValueHolder.TIME_UNIT);
                        return OnHeapStore.this.newUpdateValueHolder(key, existingValue, computedValue, now, expirationTime, eventSink);
                    }
                    return OnHeapStore.this.newCreateValueHolder(key, computedValue, now, eventSink);
                }
            });
            if (computeResult == null) {
                if (write.get() && replacedOrRemovedValue.get() != null) {
                    this.decrementCurrentUsageInBytesIfRequired(((OnHeapValueHolder)replacedOrRemovedValue.get()).size());
                }
            } else if (write.get()) {
                long delta = replacedOrRemovedValue.get() == null ? computeResult.size() : computeResult.size() - ((OnHeapValueHolder)replacedOrRemovedValue.get()).size();
                this.replaceByteCapacity(delta, eventSink);
            }
            this.storeEventDispatcher.releaseEventSink(eventSink);
            if (computeResult == null) {
                if (write.get()) {
                    this.computeObserver.end((Enum)StoreOperationOutcomes.ComputeOutcome.REMOVED);
                } else {
                    this.computeObserver.end((Enum)StoreOperationOutcomes.ComputeOutcome.MISS);
                }
            } else if (write.get()) {
                this.computeObserver.end((Enum)StoreOperationOutcomes.ComputeOutcome.PUT);
            } else {
                this.computeObserver.end((Enum)StoreOperationOutcomes.ComputeOutcome.HIT);
            }
            return computeResult;
        }
        catch (RuntimeException re) {
            this.storeEventDispatcher.releaseEventSinkAfterFailure(eventSink, (Throwable)re);
            CachePassThroughException.handleRuntimeException((RuntimeException)re);
            return null;
        }
    }

    public Store.ValueHolder<V> computeIfAbsent(final K key, final Function<? super K, ? extends V> mappingFunction) throws CacheAccessException {
        this.computeIfAbsentObserver.begin();
        this.checkKey(key);
        final StoreEventSink eventSink = this.storeEventDispatcher.eventSink();
        try {
            final long now = this.timeSource.getTimeMillis();
            final AtomicBoolean write = new AtomicBoolean(false);
            OnHeapValueHolder<V> computeResult = this.map.compute(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

                public OnHeapValueHolder<V> apply(K mappedKey, OnHeapValueHolder<V> mappedValue) {
                    if (mappedValue == null || mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                        if (mappedValue != null) {
                            OnHeapStore.this.onExpiration(mappedKey, mappedValue, eventSink);
                        }
                        write.set(true);
                        Object computedValue = mappingFunction.apply(mappedKey);
                        if (computedValue == null) {
                            return null;
                        }
                        OnHeapStore.this.checkValue(computedValue);
                        return OnHeapStore.this.newCreateValueHolder(key, computedValue, now, eventSink);
                    }
                    return OnHeapStore.this.setAccessTimeAndExpiryThenReturnMapping(key, mappedValue, now, eventSink);
                }
            });
            if (write.get() && computeResult != null) {
                this.enforceCapacity(computeResult.size(), eventSink);
            }
            this.storeEventDispatcher.releaseEventSink(eventSink);
            if (write.get()) {
                if (computeResult != null) {
                    this.computeIfAbsentObserver.end((Enum)StoreOperationOutcomes.ComputeIfAbsentOutcome.PUT);
                } else {
                    this.computeIfAbsentObserver.end((Enum)StoreOperationOutcomes.ComputeIfAbsentOutcome.NOOP);
                }
            } else {
                this.computeIfAbsentObserver.end((Enum)StoreOperationOutcomes.ComputeIfAbsentOutcome.HIT);
            }
            return computeResult;
        }
        catch (RuntimeException re) {
            this.storeEventDispatcher.releaseEventSinkAfterFailure(eventSink, (Throwable)re);
            CachePassThroughException.handleRuntimeException((RuntimeException)re);
            return null;
        }
    }

    public Store.ValueHolder<V> computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) throws CacheAccessException {
        return this.computeIfPresent(key, remappingFunction, REPLACE_EQUALS_TRUE);
    }

    public Store.ValueHolder<V> computeIfPresent(final K key, final BiFunction<? super K, ? super V, ? extends V> remappingFunction, final NullaryFunction<Boolean> replaceEqual) throws CacheAccessException {
        this.computeIfPresentObserver.begin();
        this.checkKey(key);
        final StoreEventSink eventSink = this.storeEventDispatcher.eventSink();
        try {
            final AtomicBoolean write = new AtomicBoolean(false);
            final AtomicReference<Object> replacedOrRemovedValue = new AtomicReference<Object>(null);
            OnHeapValueHolder<V> computeResult = this.map.computeIfPresent(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

                public OnHeapValueHolder<V> apply(K mappedKey, OnHeapValueHolder<V> mappedValue) {
                    long now = OnHeapStore.this.timeSource.getTimeMillis();
                    replacedOrRemovedValue.set(mappedValue);
                    if (mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                        OnHeapStore.this.onExpiration(mappedKey, mappedValue, eventSink);
                        return null;
                    }
                    Object existingValue = mappedValue.value();
                    Object computedValue = remappingFunction.apply(mappedKey, existingValue);
                    if (computedValue == null) {
                        write.set(true);
                        eventSink.removed(mappedKey, mappedValue.value());
                        return null;
                    }
                    if (OnHeapStore.eq(existingValue, computedValue) && !((Boolean)replaceEqual.apply()).booleanValue()) {
                        return OnHeapStore.this.setAccessTimeAndExpiryThenReturnMapping(key, mappedValue, now, eventSink);
                    }
                    OnHeapStore.this.checkValue(computedValue);
                    long expirationTime = mappedValue.expirationTime(OnHeapValueHolder.TIME_UNIT);
                    write.set(true);
                    return OnHeapStore.this.newUpdateValueHolder(key, existingValue, computedValue, now, expirationTime, eventSink);
                }
            });
            if (computeResult == null) {
                if (write.get()) {
                    this.decrementCurrentUsageInBytesIfRequired(((OnHeapValueHolder)replacedOrRemovedValue.get()).size());
                }
            } else if (write.get()) {
                long delta = computeResult.size() - ((OnHeapValueHolder)replacedOrRemovedValue.get()).size();
                this.replaceByteCapacity(delta, eventSink);
            }
            this.storeEventDispatcher.releaseEventSink(eventSink);
            if (computeResult == null) {
                if (write.get()) {
                    this.computeIfPresentObserver.end((Enum)StoreOperationOutcomes.ComputeIfPresentOutcome.REMOVED);
                } else {
                    this.computeIfPresentObserver.end((Enum)StoreOperationOutcomes.ComputeIfPresentOutcome.MISS);
                }
            } else if (write.get()) {
                this.computeIfPresentObserver.end((Enum)StoreOperationOutcomes.ComputeIfPresentOutcome.PUT);
            } else {
                this.computeIfPresentObserver.end((Enum)StoreOperationOutcomes.ComputeIfPresentOutcome.HIT);
            }
            return computeResult;
        }
        catch (RuntimeException re) {
            this.storeEventDispatcher.releaseEventSinkAfterFailure(eventSink, (Throwable)re);
            CachePassThroughException.handleRuntimeException((RuntimeException)re);
            return null;
        }
    }

    public Map<K, Store.ValueHolder<V>> bulkComputeIfAbsent(Set<? extends K> keys, final Function<Iterable<? extends K>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> mappingFunction) throws CacheAccessException {
        HashMap<K, Store.ValueHolder<V>> result = new HashMap<K, Store.ValueHolder<V>>();
        for (K key : keys) {
            Store.ValueHolder<V> newValue = this.computeIfAbsent(key, new Function<K, V>(){

                public V apply(K k) {
                    Set keySet = Collections.singleton(k);
                    Iterable entries = (Iterable)mappingFunction.apply(keySet);
                    Iterator iterator = entries.iterator();
                    Map.Entry next = (Map.Entry)iterator.next();
                    Object computedKey = next.getKey();
                    Object computedValue = next.getValue();
                    OnHeapStore.this.checkKey(computedKey);
                    if (computedValue == null) {
                        return null;
                    }
                    OnHeapStore.this.checkValue(computedValue);
                    return computedValue;
                }
            });
            result.put(key, newValue);
        }
        return result;
    }

    public List<CacheConfigurationChangeListener> getConfigurationChangeListeners() {
        ArrayList<CacheConfigurationChangeListener> configurationChangeListenerList = new ArrayList<CacheConfigurationChangeListener>();
        configurationChangeListenerList.add(this.cacheConfigurationChangeListener);
        return configurationChangeListenerList;
    }

    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction) throws CacheAccessException {
        return this.bulkCompute(keys, remappingFunction, REPLACE_EQUALS_TRUE);
    }

    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, final Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction, NullaryFunction<Boolean> replaceEqual) throws CacheAccessException {
        HashMap<K, Store.ValueHolder<V>> result = new HashMap<K, Store.ValueHolder<V>>();
        for (K key : keys) {
            this.checkKey(key);
            Store.ValueHolder<V> newValue = this.compute(key, new BiFunction<K, V, V>(){

                public V apply(K k, V oldValue) {
                    Set entrySet = Collections.singletonMap(k, oldValue).entrySet();
                    Iterable entries = (Iterable)remappingFunction.apply(entrySet);
                    Iterator iterator = entries.iterator();
                    Map.Entry next = (Map.Entry)iterator.next();
                    Object key = next.getKey();
                    Object value = next.getValue();
                    OnHeapStore.this.checkKey(key);
                    if (value != null) {
                        OnHeapStore.this.checkValue(value);
                    }
                    return value;
                }
            }, replaceEqual);
            result.put(key, newValue);
        }
        return result;
    }

    public StoreEventSource<K, V> getStoreEventSource() {
        return this.storeEventDispatcher;
    }

    private OnHeapValueHolder<V> setAccessTimeAndExpiryThenReturnMapping(K key, OnHeapValueHolder<V> valueHolder, long now) {
        Duration duration;
        try {
            duration = this.expiry.getExpiryForAccess(key, valueHolder.value());
        }
        catch (RuntimeException re) {
            LOG.error("Expiry computation caused an exception - Expiry duration will be 0 ", (Throwable)re);
            this.expireMapping(key, (Store.ValueHolder<V>)valueHolder);
            return null;
        }
        valueHolder.accessed(now, duration);
        return valueHolder;
    }

    private OnHeapValueHolder<V> setAccessTimeAndExpiryThenReturnMapping(K key, OnHeapValueHolder<V> valueHolder, long now, StoreEventSink<K, V> eventSink) {
        Duration duration;
        try {
            duration = this.expiry.getExpiryForAccess(key, valueHolder.value());
        }
        catch (RuntimeException re) {
            LOG.error("Expiry computation caused an exception - Expiry duration will be 0 ", (Throwable)re);
            this.onExpiration(key, (Store.ValueHolder<V>)valueHolder, eventSink);
            return null;
        }
        valueHolder.accessed(now, duration);
        return valueHolder;
    }

    private void expireMapping(final K key, final Store.ValueHolder<V> value) {
        final StoreEventSink eventSink = this.storeEventDispatcher.eventSink();
        try {
            final AtomicReference<Object> expiredValue = new AtomicReference<Object>(null);
            OnHeapValueHolder<V> presentValue = this.map.computeIfPresent(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

                public OnHeapValueHolder<V> apply(K mappedKey, OnHeapValueHolder<V> mappedValue) {
                    if (mappedValue.equals(value)) {
                        OnHeapStore.this.onExpiration(key, value, eventSink);
                        expiredValue.set(mappedValue);
                        return null;
                    }
                    return mappedValue;
                }
            });
            if (presentValue == null) {
                this.decrementCurrentUsageInBytesIfRequired(((OnHeapValueHolder)expiredValue.get()).size());
            }
            this.storeEventDispatcher.releaseEventSink(eventSink);
        }
        catch (RuntimeException re) {
            this.storeEventDispatcher.releaseEventSinkAfterFailure(eventSink, (Throwable)re);
            throw re;
        }
    }

    private OnHeapValueHolder<V> newUpdateValueHolder(K key, OnHeapValueHolder<V> oldValue, V newValue, long now, StoreEventSink<K, V> eventSink) {
        if (oldValue == null) {
            throw new NullPointerException();
        }
        return this.newUpdateValueHolder(key, oldValue.value(), newValue, now, oldValue.expirationTime(OnHeapValueHolder.TIME_UNIT), eventSink);
    }

    private OnHeapValueHolder<V> newUpdateValueHolder(K key, V oldValue, V newValue, long now, long oldExpirationTime, StoreEventSink<K, V> eventSink) {
        if (newValue == null) {
            throw new NullPointerException();
        }
        Duration duration = Duration.ZERO;
        try {
            duration = this.expiry.getExpiryForUpdate(key, oldValue, newValue);
        }
        catch (RuntimeException re) {
            LOG.error("Expiry computation caused an exception - Expiry duration will be 0 ", (Throwable)re);
        }
        if (Duration.ZERO.equals((Object)duration)) {
            eventSink.removed(key, oldValue);
            return null;
        }
        long expirationTime = duration == null ? oldExpirationTime : (duration.isForever() ? -1L : OnHeapStore.safeExpireTime(now, duration));
        OnHeapValueHolder<V> holder = null;
        try {
            holder = this.makeValue(key, newValue, now, expirationTime, this.valueCopier);
            eventSink.updated(key, oldValue, newValue);
        }
        catch (LimitExceededException e) {
            LOG.warn(e.getMessage());
            eventSink.removed(key, oldValue);
        }
        return holder;
    }

    private OnHeapValueHolder<V> newCreateValueHolder(K key, V value, long now, StoreEventSink<K, V> eventSink) {
        Duration duration;
        if (value == null) {
            throw new NullPointerException();
        }
        try {
            duration = this.expiry.getExpiryForCreation(key, value);
        }
        catch (RuntimeException re) {
            LOG.error("Expiry computation caused an exception - Expiry duration will be 0 ", (Throwable)re);
            return null;
        }
        if (Duration.ZERO.equals((Object)duration)) {
            return null;
        }
        long expirationTime = duration.isForever() ? -1L : OnHeapStore.safeExpireTime(now, duration);
        OnHeapValueHolder<V> holder = null;
        try {
            holder = this.makeValue(key, value, now, expirationTime, this.valueCopier);
            eventSink.created(key, value);
        }
        catch (LimitExceededException e) {
            LOG.warn(e.getMessage());
        }
        return holder;
    }

    private OnHeapValueHolder<V> importValueFromLowerTier(K key, Store.ValueHolder<V> valueHolder, long now) throws LimitExceededException {
        Object realValue = valueHolder.value();
        Duration expiration = this.expiry.getExpiryForAccess(key, realValue);
        return this.cloneValueHolder(key, valueHolder, now, expiration, true);
    }

    private OnHeapValueHolder<V> cloneValueHolder(K key, Store.ValueHolder<V> valueHolder, long now, Duration expiration, boolean sizingEnabled) throws LimitExceededException {
        Object realValue = valueHolder.value();
        boolean veto = this.checkVeto(key, realValue);
        OnHeapValueHolder clonedValueHolder = null;
        clonedValueHolder = this.valueCopier instanceof SerializingCopier ? (valueHolder instanceof BinaryValueHolder && ((BinaryValueHolder)valueHolder).isBinaryValueAvailable() ? new SerializedOnHeapValueHolder<V>(valueHolder, ((BinaryValueHolder)valueHolder).getBinaryValue(), veto, ((SerializingCopier)this.valueCopier).getSerializer(), now, expiration) : new SerializedOnHeapValueHolder<Object>(valueHolder, realValue, veto, ((SerializingCopier)this.valueCopier).getSerializer(), now, expiration)) : new CopiedOnHeapValueHolder<Object>(valueHolder, realValue, veto, this.valueCopier, now, expiration);
        if (sizingEnabled) {
            clonedValueHolder.setSize(this.getSizeOfKeyValuePairs(key, clonedValueHolder));
        }
        return clonedValueHolder;
    }

    private OnHeapValueHolder<V> makeValue(K key, V value, long creationTime, long expirationTime, Copier<V> valueCopier) throws LimitExceededException {
        boolean veto = this.checkVeto(key, value);
        OnHeapValueHolder valueHolder = null;
        valueHolder = valueCopier instanceof SerializingCopier ? new SerializedOnHeapValueHolder<V>(value, creationTime, expirationTime, veto, ((SerializingCopier)valueCopier).getSerializer()) : new CopiedOnHeapValueHolder<V>(value, creationTime, expirationTime, veto, valueCopier);
        valueHolder.setSize(this.getSizeOfKeyValuePairs(key, valueHolder));
        return valueHolder;
    }

    private boolean checkVeto(K key, V value) {
        try {
            return this.evictionVeto.vetoes(key, value);
        }
        catch (Exception e) {
            LOG.error("Exception raised while running eviction veto - Eviction will assume entry is NOT vetoed", (Throwable)e);
            return false;
        }
    }

    private static long safeExpireTime(long now, Duration duration) {
        long millis = OnHeapValueHolder.TIME_UNIT.convert(duration.getAmount(), duration.getTimeUnit());
        if (millis == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        long result = now + millis;
        if (result < 0L) {
            return Long.MAX_VALUE;
        }
        return result;
    }

    private void enforceByteCapacity(StoreEventSink<K, V> eventSink) {
        while (this.capacity < this.currentUsageinBytes.get()) {
            this.evict(eventSink);
        }
    }

    private void incrementCurrentUsageInBytesIfRequired(long delta) {
        if (this.byteSized) {
            this.currentUsageinBytes.addAndGet(delta);
        }
    }

    private void decrementCurrentUsageInBytesIfRequired(long delta) {
        long current;
        if (this.byteSized && (current = this.currentUsageinBytes.addAndGet(-delta)) < 0L) {
            throw new AssertionError((Object)"Current usage can never be negative");
        }
    }

    protected long getCurrentUsageInBytes() {
        if (this.byteSized) {
            return this.currentUsageinBytes.get();
        }
        return 0L;
    }

    private void enforceCapacity(long delta) {
        StoreEventSink eventSink = this.storeEventDispatcher.eventSink();
        try {
            this.enforceCapacity(delta, eventSink);
            this.storeEventDispatcher.releaseEventSink(eventSink);
        }
        catch (RuntimeException re) {
            this.storeEventDispatcher.releaseEventSinkAfterFailure(eventSink, (Throwable)re);
            throw re;
        }
    }

    protected void enforceCapacity(long delta, StoreEventSink<K, V> eventSink) {
        if (this.byteSized) {
            this.incrementCurrentUsageInBytesIfRequired(delta);
            this.enforceByteCapacity(eventSink);
            return;
        }
        int attempts = 0;
        int evicted = 0;
        while ((long)attempts < 4L * delta && (long)evicted < 2L * delta && this.capacity < (long)this.map.size()) {
            if (this.evict(eventSink)) {
                ++evicted;
            }
            ++attempts;
        }
    }

    private void replaceByteCapacity(long delta, StoreEventSink<K, V> eventSink) {
        if (delta < 0L) {
            this.decrementCurrentUsageInBytesIfRequired(Math.abs(delta));
        } else {
            this.enforceCapacity(delta, eventSink);
        }
    }

    boolean evict(final StoreEventSink<K, V> eventSink) {
        this.evictionObserver.begin();
        Random random = new Random();
        Map.Entry<K, OnHeapValueHolder<V>> candidate = this.map.getEvictionCandidate(random, 8, EVICTION_PRIORITIZER, EVICTION_VETO);
        if (candidate == null) {
            candidate = this.map.getEvictionCandidate(random, 8, EVICTION_PRIORITIZER, Eviction.none());
        }
        if (candidate == null) {
            return false;
        }
        final Map.Entry<K, OnHeapValueHolder<V>> evictionCandidate = candidate;
        final AtomicBoolean removed = new AtomicBoolean(false);
        this.map.computeIfPresent(evictionCandidate.getKey(), new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

            public OnHeapValueHolder<V> apply(K mappedKey, OnHeapValueHolder<V> mappedValue) {
                if (mappedValue.equals(evictionCandidate.getValue())) {
                    removed.set(true);
                    if (!(evictionCandidate.getValue() instanceof Fault)) {
                        eventSink.evicted(evictionCandidate.getKey(), ((OnHeapValueHolder)((Object)evictionCandidate.getValue())).value());
                        OnHeapStore.this.invalidationListener.onInvalidation(mappedKey, (Store.ValueHolder)evictionCandidate.getValue());
                    }
                    return null;
                }
                return mappedValue;
            }
        });
        if (removed.get()) {
            this.evictionObserver.end((Enum)StoreOperationOutcomes.EvictionOutcome.SUCCESS);
            this.decrementCurrentUsageInBytesIfRequired(evictionCandidate.getValue().size());
            return true;
        }
        this.evictionObserver.end((Enum)StoreOperationOutcomes.EvictionOutcome.FAILURE);
        return false;
    }

    private void checkKey(K keyObject) {
        if (keyObject == null) {
            throw new NullPointerException();
        }
        if (!this.keyType.isAssignableFrom(keyObject.getClass())) {
            throw new ClassCastException("Invalid key type, expected : " + this.keyType.getName() + " but was : " + keyObject.getClass().getName());
        }
    }

    private void checkValue(V valueObject) {
        if (valueObject == null) {
            throw new NullPointerException();
        }
        if (!this.valueType.isAssignableFrom(valueObject.getClass())) {
            throw new ClassCastException("Invalid value type, expected : " + this.valueType.getName() + " but was : " + valueObject.getClass().getName());
        }
    }

    private void onExpiration(K mappedKey, Store.ValueHolder<V> mappedValue, StoreEventSink<K, V> eventSink) {
        this.expirationObserver.begin();
        this.expirationObserver.end((Enum)StoreOperationOutcomes.ExpirationOutcome.SUCCESS);
        eventSink.expired(mappedKey, mappedValue.value());
        this.invalidationListener.onInvalidation(mappedKey, mappedValue);
    }

    private static boolean eq(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    private static final class OnHeapStoreStatsSettings {
        @ContextAttribute(value="tags")
        private final Set<String> tags = new HashSet<String>(Arrays.asList("store"));
        @ContextAttribute(value="cachingTier")
        private final CachingTier<?, ?> cachingTier = null;
        @ContextAttribute(value="authoritativeTier")
        private final OnHeapStore<?, ?> authoritativeTier;

        OnHeapStoreStatsSettings(OnHeapStore<?, ?> onHeapStore) {
            this.authoritativeTier = onHeapStore;
        }
    }

    @ServiceDependencies(value={TimeSourceService.class, CopyProvider.class, SizeOfEngineProvider.class})
    public static class Provider
    implements Store.Provider,
    CachingTier.Provider,
    HigherCachingTier.Provider {
        private volatile ServiceProvider<Service> serviceProvider;
        private final Set<Store<?, ?>> createdStores = Collections.newSetFromMap(new ConcurrentWeakIdentityHashMap());

        public <K, V> OnHeapStore<K, V> createStore(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?> ... serviceConfigs) {
            return this.createStoreInternal(storeConfig, new ScopedStoreEventDispatcher(storeConfig.getOrderedEventParallelism()), serviceConfigs);
        }

        public <K, V> OnHeapStore<K, V> createStoreInternal(Store.Configuration<K, V> storeConfig, StoreEventDispatcher<K, V> eventDispatcher, ServiceConfiguration<?> ... serviceConfigs) {
            TimeSource timeSource = ((TimeSourceService)this.serviceProvider.getService(TimeSourceService.class)).getTimeSource();
            CopyProvider copyProvider = (CopyProvider)this.serviceProvider.getService(CopyProvider.class);
            Copier keyCopier = copyProvider.createKeyCopier(storeConfig.getKeyType(), storeConfig.getKeySerializer(), serviceConfigs);
            Copier valueCopier = copyProvider.createValueCopier(storeConfig.getValueType(), storeConfig.getValueSerializer(), serviceConfigs);
            SizeOfEngineProvider sizeOfEngineProvider = (SizeOfEngineProvider)this.serviceProvider.getService(SizeOfEngineProvider.class);
            SizeOfEngine sizeOfEngine = sizeOfEngineProvider.createSizeOfEngine(storeConfig.getResourcePools().getPoolForResource((ResourceType)ResourceType.Core.HEAP).getUnit(), serviceConfigs);
            OnHeapStore<K, V> onHeapStore = new OnHeapStore<K, V>(storeConfig, timeSource, keyCopier, valueCopier, sizeOfEngine, eventDispatcher);
            this.createdStores.add(onHeapStore);
            return onHeapStore;
        }

        public void releaseStore(Store<?, ?> resource) {
            if (!this.createdStores.remove(resource)) {
                throw new IllegalArgumentException("Given store is not managed by this provider : " + resource);
            }
            OnHeapStore onHeapStore = (OnHeapStore)resource;
            Provider.close(onHeapStore);
        }

        static void close(OnHeapStore onHeapStore) {
            onHeapStore.map.clear();
        }

        public void initStore(Store<?, ?> resource) {
            this.checkResource(resource);
        }

        private void checkResource(Object resource) {
            if (!this.createdStores.contains(resource)) {
                throw new IllegalArgumentException("Given store is not managed by this provider : " + resource);
            }
        }

        public void start(ServiceProvider<Service> serviceProvider) {
            this.serviceProvider = serviceProvider;
        }

        public void stop() {
            this.serviceProvider = null;
            this.createdStores.clear();
        }

        /*
         * Exception decompiling
         */
        public <K, V> CachingTier<K, V> createCachingTier(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?> ... serviceConfigs) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
             *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void releaseCachingTier(CachingTier<?, ?> resource) {
            this.checkResource(resource);
            ((OnHeapStore)resource).invalidate();
            this.releaseStore((Store)resource);
        }

        public void initCachingTier(CachingTier<?, ?> resource) {
            this.initStore((Store)resource);
        }

        public <K, V> HigherCachingTier<K, V> createHigherCachingTier(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?> ... serviceConfigs) {
            return this.createStore((Store.Configuration)storeConfig, (ServiceConfiguration[])serviceConfigs);
        }

        public void releaseHigherCachingTier(HigherCachingTier<?, ?> resource) {
            this.releaseCachingTier((CachingTier<?, ?>)resource);
        }

        public void initHigherCachingTier(HigherCachingTier<?, ?> resource) {
            this.initStore((Store)resource);
        }
    }

    private static class Fault<V>
    extends OnHeapValueHolder<V> {
        private static final int FAULT_ID = -1;
        @IgnoreSizeOf
        private final NullaryFunction<Store.ValueHolder<V>> source;
        private Store.ValueHolder<V> value;
        private Throwable throwable;
        private boolean complete;

        public Fault(NullaryFunction<Store.ValueHolder<V>> source) {
            super(-1L, 0L, true);
            this.source = source;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void complete(Store.ValueHolder<V> value) {
            Fault fault = this;
            synchronized (fault) {
                this.value = value;
                this.complete = true;
                ((Object)((Object)this)).notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Store.ValueHolder<V> get() {
            Fault fault = this;
            synchronized (fault) {
                if (!this.complete) {
                    try {
                        this.complete((Store.ValueHolder)this.source.apply());
                    }
                    catch (Throwable e) {
                        this.fail(e);
                    }
                }
            }
            return this.throwOrReturn();
        }

        public long getId() {
            throw new UnsupportedOperationException("You should NOT call that?!");
        }

        private Store.ValueHolder<V> throwOrReturn() {
            if (this.throwable != null) {
                if (this.throwable instanceof RuntimeException) {
                    throw (RuntimeException)this.throwable;
                }
                throw new RuntimeException("Faulting from repository failed", this.throwable);
            }
            return this.value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fail(Throwable t) {
            Fault fault = this;
            synchronized (fault) {
                this.throwable = t;
                this.complete = true;
                ((Object)((Object)this)).notifyAll();
            }
            this.throwOrReturn();
        }

        public V value() {
            throw new UnsupportedOperationException();
        }

        public long creationTime(TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        public void setExpirationTime(long expirationTime, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        public long expirationTime(TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        public boolean isExpired(long expirationTime, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        public long lastAccessTime(TimeUnit unit) {
            return Long.MAX_VALUE;
        }

        public void setLastAccessTime(long lastAccessTime, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "[Fault : " + (this.complete ? (this.throwable == null ? this.value.toString() : this.throwable.getMessage()) : "???") + "]";
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this;
        }
    }
}

