/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.heap;

import java.util.AbstractMap;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.ehcache.config.EvictionVeto;
import org.ehcache.core.spi.cache.Store;
import org.ehcache.core.spi.function.BiFunction;
import org.ehcache.impl.internal.concurrent.ConcurrentHashMap;
import org.ehcache.impl.internal.store.heap.Backend;
import org.ehcache.impl.internal.store.heap.holders.CopiedOnHeapKey;
import org.ehcache.impl.internal.store.heap.holders.LookupOnlyOnHeapKey;
import org.ehcache.impl.internal.store.heap.holders.OnHeapKey;
import org.ehcache.impl.internal.store.heap.holders.OnHeapValueHolder;
import org.ehcache.spi.copy.Copier;

class KeyCopyBackend<K, V>
implements Backend<K, V> {
    private final ConcurrentHashMap<OnHeapKey<K>, OnHeapValueHolder<V>> keyCopyMap;
    private final Copier<K> keyCopier;

    KeyCopyBackend(Copier<K> keyCopier) {
        this.keyCopier = keyCopier;
        this.keyCopyMap = new ConcurrentHashMap();
    }

    @Override
    public boolean remove(K key, OnHeapValueHolder<V> value) {
        return this.keyCopyMap.remove(this.lookupOnlyKey(key), value);
    }

    @Override
    public Map.Entry<K, OnHeapValueHolder<V>> getEvictionCandidate(Random random, int size, Comparator<? super Store.ValueHolder<V>> prioritizer, EvictionVeto<Object, OnHeapValueHolder<?>> evictionVeto) {
        Map.Entry<Object, OnHeapValueHolder<?>> candidate = this.keyCopyMap.getEvictionCandidate(random, size, prioritizer, evictionVeto);
        if (candidate == null) {
            return null;
        }
        return new AbstractMap.SimpleEntry(((OnHeapKey)candidate.getKey()).getActualKeyObject(), candidate.getValue());
    }

    @Override
    public int size() {
        return this.keyCopyMap.size();
    }

    @Override
    public Iterable<K> keySet() {
        final Iterator iter = ((ConcurrentHashMap.KeySetView)this.keyCopyMap.keySet()).iterator();
        return new Iterable<K>(){

            @Override
            public Iterator<K> iterator() {
                return new Iterator<K>(){

                    @Override
                    public boolean hasNext() {
                        return iter.hasNext();
                    }

                    @Override
                    public K next() {
                        return ((OnHeapKey)iter.next()).getActualKeyObject();
                    }

                    @Override
                    public void remove() {
                        iter.remove();
                    }
                };
            }
        };
    }

    @Override
    public Iterator<Map.Entry<K, OnHeapValueHolder<V>>> entrySetIterator() {
        final Iterator<Map.Entry<OnHeapKey<K>, OnHeapValueHolder<V>>> iter = this.keyCopyMap.entrySet().iterator();
        return new Iterator<Map.Entry<K, OnHeapValueHolder<V>>>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public Map.Entry<K, OnHeapValueHolder<V>> next() {
                Map.Entry entry = (Map.Entry)iter.next();
                return new AbstractMap.SimpleEntry(((OnHeapKey)entry.getKey()).getActualKeyObject(), entry.getValue());
            }

            @Override
            public void remove() {
                iter.remove();
            }
        };
    }

    @Override
    public OnHeapValueHolder<V> compute(K key, final BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>> computeFunction) {
        return this.keyCopyMap.compute(this.makeKey(key), new BiFunction<OnHeapKey<K>, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

            public OnHeapValueHolder<V> apply(OnHeapKey<K> mappedKey, OnHeapValueHolder<V> mappedValue) {
                return (OnHeapValueHolder)((Object)computeFunction.apply(mappedKey.getActualKeyObject(), mappedValue));
            }
        });
    }

    @Override
    public void clear() {
        this.keyCopyMap.clear();
    }

    @Override
    public OnHeapValueHolder<V> remove(K key) {
        return this.keyCopyMap.remove(this.lookupOnlyKey(key));
    }

    @Override
    public OnHeapValueHolder<V> computeIfPresent(K key, final BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>> computeFunction) {
        return this.keyCopyMap.computeIfPresent(this.makeKey(key), new BiFunction<OnHeapKey<K>, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

            public OnHeapValueHolder<V> apply(OnHeapKey<K> mappedKey, OnHeapValueHolder<V> mappedValue) {
                return (OnHeapValueHolder)((Object)computeFunction.apply(mappedKey.getActualKeyObject(), mappedValue));
            }
        });
    }

    private OnHeapKey<K> makeKey(K key) {
        return new CopiedOnHeapKey<K>(key, this.keyCopier);
    }

    private OnHeapKey<K> lookupOnlyKey(K key) {
        return new LookupOnlyOnHeapKey<K>(key);
    }

    @Override
    public OnHeapValueHolder<V> get(K key) {
        return this.keyCopyMap.get(this.lookupOnlyKey(key));
    }

    @Override
    public OnHeapValueHolder<V> putIfAbsent(K key, OnHeapValueHolder<V> valueHolder) {
        return this.keyCopyMap.putIfAbsent(this.makeKey(key), valueHolder);
    }

    @Override
    public boolean replace(K key, OnHeapValueHolder<V> oldValue, OnHeapValueHolder<V> newValue) {
        return this.keyCopyMap.replace(this.lookupOnlyKey(key), oldValue, newValue);
    }
}

