/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.disk;

import java.io.IOException;
import java.io.ObjectInput;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.ehcache.config.EvictionVeto;
import org.ehcache.core.spi.function.BiFunction;
import org.ehcache.core.spi.function.Function;
import org.ehcache.impl.internal.store.disk.factories.EhcachePersistentSegmentFactory;
import org.ehcache.impl.internal.store.offheap.EhcacheOffHeapBackingMap;
import org.terracotta.offheapstore.MetadataTuple;
import org.terracotta.offheapstore.disk.persistent.AbstractPersistentConcurrentOffHeapCache;

public class EhcachePersistentConcurrentOffHeapClockCache<K, V>
extends AbstractPersistentConcurrentOffHeapCache<K, V>
implements EhcacheOffHeapBackingMap<K, V> {
    private final EvictionVeto<? super K, ? super V> evictionVeto;
    private final AtomicLong[] counters;

    public EhcachePersistentConcurrentOffHeapClockCache(ObjectInput input, EvictionVeto<? super K, ? super V> evictionVeto, EhcachePersistentSegmentFactory<K, V> segmentFactory) throws IOException {
        this(evictionVeto, segmentFactory, EhcachePersistentConcurrentOffHeapClockCache.readSegmentCount((ObjectInput)input));
    }

    public EhcachePersistentConcurrentOffHeapClockCache(EvictionVeto<? super K, ? super V> evictionVeto, EhcachePersistentSegmentFactory<K, V> segmentFactory, int concurrency) {
        super(segmentFactory, concurrency);
        this.evictionVeto = evictionVeto;
        this.counters = new AtomicLong[this.segments.length];
        for (int i = 0; i < this.segments.length; ++i) {
            this.counters[i] = new AtomicLong();
        }
    }

    @Override
    public V compute(K key, final BiFunction<K, V, V> mappingFunction, final boolean pin) {
        MetadataTuple result = this.computeWithMetadata(key, new org.terracotta.offheapstore.jdk8.BiFunction<K, MetadataTuple<V>, MetadataTuple<V>>(){

            public MetadataTuple<V> apply(K k, MetadataTuple<V> current) {
                Object oldValue = current == null ? null : current.value();
                Object newValue = mappingFunction.apply(k, oldValue);
                if (newValue == null) {
                    return null;
                }
                if (oldValue == newValue) {
                    return MetadataTuple.metadataTuple((Object)newValue, (int)((pin ? 0x40000000 : 0) | current.metadata()));
                }
                return MetadataTuple.metadataTuple((Object)newValue, (int)((pin ? 0x40000000 : 0) | (EhcachePersistentConcurrentOffHeapClockCache.this.evictionVeto.vetoes(k, newValue) ? 0x20000000 : 0)));
            }
        });
        return (V)(result == null ? null : result.value());
    }

    @Override
    public V computeIfPresent(K key, final BiFunction<K, V, V> mappingFunction) {
        MetadataTuple result = this.computeIfPresentWithMetadata(key, new org.terracotta.offheapstore.jdk8.BiFunction<K, MetadataTuple<V>, MetadataTuple<V>>(){

            public MetadataTuple<V> apply(K k, MetadataTuple<V> current) {
                Object oldValue = current.value();
                Object newValue = mappingFunction.apply(k, oldValue);
                if (newValue == null) {
                    return null;
                }
                if (oldValue == newValue) {
                    return current;
                }
                return MetadataTuple.metadataTuple((Object)newValue, (int)(EhcachePersistentConcurrentOffHeapClockCache.this.evictionVeto.vetoes(k, newValue) ? 0x20000000 : 0));
            }
        });
        return (V)(result == null ? null : result.value());
    }

    @Override
    public V computeIfPresentAndPin(K key, final BiFunction<K, V, V> mappingFunction) {
        MetadataTuple result = this.computeIfPresentWithMetadata(key, new org.terracotta.offheapstore.jdk8.BiFunction<K, MetadataTuple<V>, MetadataTuple<V>>(){

            public MetadataTuple<V> apply(K k, MetadataTuple<V> current) {
                Object oldValue = current.value();
                Object newValue = mappingFunction.apply(k, oldValue);
                if (newValue == null) {
                    return null;
                }
                if (oldValue == newValue) {
                    return MetadataTuple.metadataTuple((Object)newValue, (int)(0x40000000 | current.metadata()));
                }
                return MetadataTuple.metadataTuple((Object)newValue, (int)(0x40000000 | (EhcachePersistentConcurrentOffHeapClockCache.this.evictionVeto.vetoes(k, newValue) ? 0x20000000 : 0)));
            }
        });
        return (V)(result == null ? null : result.value());
    }

    @Override
    public boolean computeIfPinned(K key, final BiFunction<K, V, V> remappingFunction, final Function<V, Boolean> unpinFunction) {
        final AtomicBoolean unpin = new AtomicBoolean();
        this.computeIfPresentWithMetadata(key, new org.terracotta.offheapstore.jdk8.BiFunction<K, MetadataTuple<V>, MetadataTuple<V>>(){

            public MetadataTuple<V> apply(K k, MetadataTuple<V> current) {
                if ((current.metadata() & 0x40000000) != 0) {
                    Object oldValue = current.value();
                    Object newValue = remappingFunction.apply(k, oldValue);
                    Boolean unpinLocal = (Boolean)unpinFunction.apply(oldValue);
                    if (newValue == null) {
                        unpin.set(true);
                        return null;
                    }
                    if (oldValue == newValue) {
                        unpin.set(unpinLocal);
                        return MetadataTuple.metadataTuple((Object)oldValue, (int)(current.metadata() & (unpinLocal != false ? -1073741825 : -1)));
                    }
                    unpin.set(false);
                    return MetadataTuple.metadataTuple((Object)newValue, (int)(EhcachePersistentConcurrentOffHeapClockCache.this.evictionVeto.vetoes(k, newValue) ? 0x20000000 : 0));
                }
                return current;
            }
        });
        return unpin.get();
    }

    @Override
    public long nextIdFor(K key) {
        return this.counters[this.getIndexFor(key.hashCode())].getAndIncrement();
    }
}

