/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.spi.serialization;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.ehcache.core.internal.util.ConcurrentWeakIdentityHashMap;
import org.ehcache.core.spi.ServiceLocator;
import org.ehcache.core.spi.service.FileBasedPersistenceContext;
import org.ehcache.core.spi.service.LocalPersistenceService;
import org.ehcache.exceptions.CachePersistenceException;
import org.ehcache.impl.config.serializer.DefaultSerializationProviderConfiguration;
import org.ehcache.impl.config.serializer.DefaultSerializerConfiguration;
import org.ehcache.impl.serialization.CharSerializer;
import org.ehcache.impl.serialization.CompactJavaSerializer;
import org.ehcache.impl.serialization.CompactPersistentJavaSerializer;
import org.ehcache.impl.serialization.DoubleSerializer;
import org.ehcache.impl.serialization.FloatSerializer;
import org.ehcache.impl.serialization.IntegerSerializer;
import org.ehcache.impl.serialization.LongSerializer;
import org.ehcache.impl.serialization.StringSerializer;
import org.ehcache.spi.ServiceProvider;
import org.ehcache.spi.serialization.SerializationProvider;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.serialization.UnsupportedTypeException;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSerializationProvider
implements SerializationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSerializationProvider.class);
    private final TransientProvider transientProvider;
    private final PersistentProvider persistentProvider;
    protected final ConcurrentWeakIdentityHashMap<Serializer<?>, AtomicInteger> providedVsCount = new ConcurrentWeakIdentityHashMap();

    public DefaultSerializationProvider(DefaultSerializationProviderConfiguration configuration) {
        if (configuration != null) {
            this.transientProvider = new TransientProvider(configuration.getTransientSerializers());
            this.persistentProvider = new PersistentProvider(configuration.getPersistentSerializers());
        } else {
            this.transientProvider = new TransientProvider(Collections.<Class<?>, Class<Serializer<?>>>emptyMap());
            this.persistentProvider = new PersistentProvider(Collections.emptyMap());
        }
    }

    public <T> Serializer<T> createKeySerializer(Class<T> clazz, ClassLoader classLoader, ServiceConfiguration<?> ... configs) throws UnsupportedTypeException {
        Serializer<T> serializer = ServiceLocator.findSingletonAmongst(LocalPersistenceService.PersistenceSpaceIdentifier.class, (Object[])configs) == null ? this.transientProvider.createKeySerializer(clazz, classLoader, configs) : this.persistentProvider.createKeySerializer(clazz, classLoader, configs);
        this.updateProvidedInstanceCounts(serializer);
        return serializer;
    }

    public <T> Serializer<T> createValueSerializer(Class<T> clazz, ClassLoader classLoader, ServiceConfiguration<?> ... configs) throws UnsupportedTypeException {
        Serializer<T> serializer = ServiceLocator.findSingletonAmongst(LocalPersistenceService.PersistenceSpaceIdentifier.class, (Object[])configs) == null ? this.transientProvider.createValueSerializer(clazz, classLoader, configs) : this.persistentProvider.createValueSerializer(clazz, classLoader, configs);
        this.updateProvidedInstanceCounts(serializer);
        return serializer;
    }

    private void updateProvidedInstanceCounts(Serializer<?> serializer) {
        AtomicInteger currentCount = (AtomicInteger)this.providedVsCount.putIfAbsent(serializer, (Object)new AtomicInteger(1));
        if (currentCount != null) {
            currentCount.incrementAndGet();
        }
    }

    public void releaseSerializer(Serializer<?> serializer) throws IOException {
        AtomicInteger currentCount = (AtomicInteger)this.providedVsCount.get(serializer);
        if (currentCount != null) {
            if (currentCount.decrementAndGet() < 0) {
                currentCount.incrementAndGet();
                throw new IllegalArgumentException("Given serializer:" + serializer.getClass().getName() + " is not managed by this provider");
            }
        } else {
            throw new IllegalArgumentException("Given serializer:" + serializer.getClass().getName() + " is not managed by this provider");
        }
        if (serializer instanceof Closeable) {
            ((Closeable)serializer).close();
        }
    }

    public void start(ServiceProvider<Service> serviceProvider) {
        this.transientProvider.start(serviceProvider);
        this.persistentProvider.start(serviceProvider);
    }

    public void stop() {
        this.transientProvider.stop();
        this.persistentProvider.stop();
    }

    private static <T> DefaultSerializerConfiguration<T> find(DefaultSerializerConfiguration.Type type, ServiceConfiguration<?> ... serviceConfigurations) {
        DefaultSerializerConfiguration result = null;
        Collection serializationProviderConfigurations = ServiceLocator.findAmongst(DefaultSerializerConfiguration.class, (Object[])serviceConfigurations);
        for (DefaultSerializerConfiguration serializationProviderConfiguration : serializationProviderConfigurations) {
            if (serializationProviderConfiguration.getType() != type) continue;
            if (result != null) {
                throw new IllegalArgumentException("Duplicate " + (Object)((Object)type) + " serialization provider : " + serializationProviderConfiguration);
            }
            result = serializationProviderConfiguration;
        }
        return result;
    }

    static abstract class AbstractProvider
    implements SerializationProvider {
        protected final Map<Class<?>, Class<? extends Serializer<?>>> serializers;

        private AbstractProvider(Map<Class<?>, Class<? extends Serializer<?>>> serializers) {
            this.serializers = new LinkedHashMap(serializers);
        }

        public <T> Serializer<T> createKeySerializer(Class<T> clazz, ClassLoader classLoader, ServiceConfiguration<?> ... configs) throws UnsupportedTypeException {
            DefaultSerializerConfiguration conf = DefaultSerializationProvider.find(DefaultSerializerConfiguration.Type.KEY, configs);
            Serializer<T> instance = AbstractProvider.getUserProvidedSerializer(conf);
            if (instance != null) {
                return instance;
            }
            return this.createSerializer("-Key", clazz, classLoader, conf, configs);
        }

        public <T> Serializer<T> createValueSerializer(Class<T> clazz, ClassLoader classLoader, ServiceConfiguration<?> ... configs) throws UnsupportedTypeException {
            DefaultSerializerConfiguration conf = DefaultSerializationProvider.find(DefaultSerializerConfiguration.Type.VALUE, configs);
            Serializer<T> instance = AbstractProvider.getUserProvidedSerializer(conf);
            if (instance != null) {
                return instance;
            }
            return this.createSerializer("-Value", clazz, classLoader, conf, configs);
        }

        private static <T> Serializer<T> getUserProvidedSerializer(DefaultSerializerConfiguration<T> conf) {
            Serializer instance;
            if (conf != null && (instance = (Serializer)conf.getInstance()) != null) {
                return instance;
            }
            return null;
        }

        protected abstract <T> Serializer<T> createSerializer(String var1, Class<T> var2, ClassLoader var3, DefaultSerializerConfiguration<T> var4, ServiceConfiguration<?> ... var5) throws UnsupportedTypeException;

        protected <T> Class<? extends Serializer<T>> getClassFor(Class<T> clazz, DefaultSerializerConfiguration<T> config, ClassLoader classLoader) throws UnsupportedTypeException {
            Class configured;
            if (config != null && (configured = config.getClazz()) != null) {
                return configured;
            }
            Class<? extends Serializer<?>> direct = this.serializers.get(clazz);
            if (direct != null) {
                return direct;
            }
            for (Map.Entry<Class<?>, Class<Serializer<?>>> entry : this.serializers.entrySet()) {
                if (!entry.getKey().isAssignableFrom(clazz)) continue;
                return entry.getValue();
            }
            throw new UnsupportedTypeException("No serializer found for type '" + clazz.getName() + "'");
        }

        protected <T> Serializer<T> constructSerializer(Class<T> clazz, Constructor<? extends Serializer<T>> constructor, Object ... args) {
            try {
                Serializer<T> serializer = constructor.newInstance(args);
                LOG.info("Serializer for <{}> : {}", (Object)clazz.getName(), serializer);
                return serializer;
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new AssertionError((Object)e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        public void stop() {
        }

        public void releaseSerializer(Serializer<?> serializer) {
        }
    }

    static class PersistentProvider
    extends AbstractProvider {
        private volatile LocalPersistenceService persistence;

        private PersistentProvider(Map<Class<?>, Class<? extends Serializer<?>>> serializers) {
            super(serializers);
        }

        @Override
        protected <T> Serializer<T> createSerializer(String suffix, Class<T> clazz, ClassLoader classLoader, DefaultSerializerConfiguration<T> config, ServiceConfiguration<?> ... configs) throws UnsupportedTypeException {
            Class<Serializer<T>> klazz = this.getClassFor(clazz, config, classLoader);
            try {
                Constructor<Serializer<T>> constructor = klazz.getConstructor(ClassLoader.class, FileBasedPersistenceContext.class);
                LocalPersistenceService.PersistenceSpaceIdentifier space = (LocalPersistenceService.PersistenceSpaceIdentifier)ServiceLocator.findSingletonAmongst(LocalPersistenceService.PersistenceSpaceIdentifier.class, (Object[])configs);
                FileBasedPersistenceContext context = this.persistence.createPersistenceContextWithin(space, DefaultSerializationProvider.class.getSimpleName() + suffix);
                return this.constructSerializer(clazz, constructor, classLoader, context);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (CachePersistenceException e) {
                throw new RuntimeException(e);
            }
        }

        public void start(ServiceProvider<Service> serviceProvider) {
            this.persistence = (LocalPersistenceService)serviceProvider.getService(LocalPersistenceService.class);
            if (!this.serializers.containsKey(Serializable.class)) {
                this.serializers.put(Serializable.class, CompactPersistentJavaSerializer.class);
            }
        }
    }

    static class TransientProvider
    extends AbstractProvider {
        public TransientProvider(Map<Class<?>, Class<? extends Serializer<?>>> serializers) {
            super(serializers);
        }

        @Override
        protected <T> Serializer<T> createSerializer(String suffix, Class<T> clazz, ClassLoader classLoader, DefaultSerializerConfiguration<T> config, ServiceConfiguration<?> ... configs) throws UnsupportedTypeException {
            try {
                Class<Serializer<T>> klazz = this.getClassFor(clazz, config, classLoader);
                return this.constructSerializer(clazz, klazz.getConstructor(ClassLoader.class), classLoader);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }

        public void start(ServiceProvider<Service> serviceProvider) {
            if (!this.serializers.containsKey(Serializable.class)) {
                this.serializers.put(Serializable.class, CompactJavaSerializer.class);
            }
            if (!this.serializers.containsKey(Long.class)) {
                this.serializers.put(Long.class, LongSerializer.class);
            }
            if (!this.serializers.containsKey(Integer.class)) {
                this.serializers.put(Integer.class, IntegerSerializer.class);
            }
            if (!this.serializers.containsKey(Float.class)) {
                this.serializers.put(Float.class, FloatSerializer.class);
            }
            if (!this.serializers.containsKey(Double.class)) {
                this.serializers.put(Double.class, DoubleSerializer.class);
            }
            if (!this.serializers.containsKey(Character.class)) {
                this.serializers.put(Character.class, CharSerializer.class);
            }
            if (!this.serializers.containsKey(String.class)) {
                this.serializers.put(String.class, StringSerializer.class);
            }
        }
    }
}

