/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.config.builders;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.ehcache.CacheManager;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.Configuration;
import org.ehcache.config.builders.Builder;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerConfiguration;
import org.ehcache.config.builders.ConfigurationBuilder;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.core.EhcacheManager;
import org.ehcache.core.config.persistence.PersistenceConfiguration;
import org.ehcache.core.config.sizeof.SizeOfEngineProviderConfiguration;
import org.ehcache.impl.config.copy.DefaultCopyProviderConfiguration;
import org.ehcache.impl.config.event.CacheEventDispatcherFactoryConfiguration;
import org.ehcache.impl.config.loaderwriter.writebehind.WriteBehindProviderConfiguration;
import org.ehcache.impl.config.persistence.CacheManagerPersistenceConfiguration;
import org.ehcache.impl.config.serializer.DefaultSerializationProviderConfiguration;
import org.ehcache.impl.config.sizeof.DefaultSizeOfEngineConfiguration;
import org.ehcache.impl.config.sizeof.DefaultSizeOfEngineProviderConfiguration;
import org.ehcache.impl.config.store.disk.OffHeapDiskStoreProviderConfiguration;
import org.ehcache.spi.copy.Copier;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceCreationConfiguration;

public class CacheManagerBuilder<T extends CacheManager>
implements Builder<T> {
    private final ConfigurationBuilder configBuilder;
    private final Set<Service> services;

    public T build(boolean init) {
        T cacheManager = this.newCacheManager(this.services, this.configBuilder.build());
        if (init) {
            cacheManager.init();
        }
        return cacheManager;
    }

    @Override
    public T build() {
        return this.build(false);
    }

    private CacheManagerBuilder() {
        this.configBuilder = ConfigurationBuilder.newConfigurationBuilder();
        this.services = Collections.emptySet();
    }

    private CacheManagerBuilder(CacheManagerBuilder<T> builder, Set<Service> services) {
        this.configBuilder = builder.configBuilder;
        this.services = Collections.unmodifiableSet(services);
    }

    private CacheManagerBuilder(CacheManagerBuilder<T> builder, ConfigurationBuilder configBuilder) {
        this.configBuilder = configBuilder;
        this.services = builder.services;
    }

    public static CacheManager newCacheManager(Configuration configuration) {
        return new EhcacheManager(configuration);
    }

    T newCacheManager(Collection<Service> services, Configuration configuration) {
        EhcacheManager ehcacheManager = new EhcacheManager(configuration, services);
        return this.cast(ehcacheManager);
    }

    T cast(EhcacheManager ehcacheManager) {
        return (T)ehcacheManager;
    }

    public <K, V> CacheManagerBuilder<T> withCache(String alias, CacheConfiguration<K, V> configuration) {
        return new CacheManagerBuilder<T>(this, this.configBuilder.addCache(alias, configuration));
    }

    public <K, V> CacheManagerBuilder<T> withCache(String alias, CacheConfigurationBuilder<K, V> configurationBuilder) {
        return this.withCache(alias, configurationBuilder.build());
    }

    public <N extends T> CacheManagerBuilder<N> with(CacheManagerConfiguration<N> cfg) {
        return cfg.builder(this);
    }

    public CacheManagerBuilder<T> using(Service service) {
        HashSet<Service> newServices = new HashSet<Service>(this.services);
        newServices.add(service);
        return new CacheManagerBuilder<T>(this, newServices);
    }

    public <C> CacheManagerBuilder<T> withCopier(Class<C> clazz, Class<? extends Copier<C>> copier) {
        DefaultCopyProviderConfiguration service = this.configBuilder.findServiceByClass(DefaultCopyProviderConfiguration.class);
        if (service == null) {
            service = new DefaultCopyProviderConfiguration();
            service.addCopierFor(clazz, copier);
            return new CacheManagerBuilder<T>(this, this.configBuilder.addService(service));
        }
        DefaultCopyProviderConfiguration newConfig = new DefaultCopyProviderConfiguration(service);
        newConfig.addCopierFor(clazz, copier, true);
        return new CacheManagerBuilder<T>(this, this.configBuilder.removeService(service).addService(newConfig));
    }

    public <C> CacheManagerBuilder<T> withSerializer(Class<C> clazz, Class<? extends Serializer<C>> serializer) {
        DefaultSerializationProviderConfiguration service = this.configBuilder.findServiceByClass(DefaultSerializationProviderConfiguration.class);
        if (service == null) {
            service = new DefaultSerializationProviderConfiguration();
            service.addSerializerFor(clazz, serializer);
            return new CacheManagerBuilder<T>(this, this.configBuilder.addService(service));
        }
        DefaultSerializationProviderConfiguration newConfig = new DefaultSerializationProviderConfiguration(service);
        newConfig.addSerializerFor(clazz, serializer, true);
        return new CacheManagerBuilder<T>(this, this.configBuilder.removeService(service).addService(newConfig));
    }

    public CacheManagerBuilder<T> withDefaultSizeOfMaxObjectGraph(long size) {
        SizeOfEngineProviderConfiguration configuration = this.configBuilder.findServiceByClass(DefaultSizeOfEngineProviderConfiguration.class);
        if (configuration == null) {
            return new CacheManagerBuilder<T>(this, this.configBuilder.addService((ServiceCreationConfiguration<?>)new DefaultSizeOfEngineProviderConfiguration(Long.MAX_VALUE, DefaultSizeOfEngineConfiguration.DEFAULT_UNIT, size)));
        }
        ConfigurationBuilder builder = this.configBuilder.removeService((ServiceCreationConfiguration<?>)configuration);
        return new CacheManagerBuilder<T>(this, builder.addService((ServiceCreationConfiguration<?>)new DefaultSizeOfEngineProviderConfiguration(configuration.getMaxObjectSize(), configuration.getUnit(), size)));
    }

    public CacheManagerBuilder<T> withDefaultSizeOfMaxObjectSize(long size, MemoryUnit unit) {
        SizeOfEngineProviderConfiguration configuration = this.configBuilder.findServiceByClass(DefaultSizeOfEngineProviderConfiguration.class);
        if (configuration == null) {
            return new CacheManagerBuilder<T>(this, this.configBuilder.addService((ServiceCreationConfiguration<?>)new DefaultSizeOfEngineProviderConfiguration(size, unit, 1000L)));
        }
        ConfigurationBuilder builder = this.configBuilder.removeService((ServiceCreationConfiguration<?>)configuration);
        return new CacheManagerBuilder<T>(this, builder.addService((ServiceCreationConfiguration<?>)new DefaultSizeOfEngineProviderConfiguration(size, unit, configuration.getMaxObjectGraphSize())));
    }

    public CacheManagerBuilder<T> withDefaultWriteBehindThreadPool(String threadPoolAlias) {
        WriteBehindProviderConfiguration config = this.configBuilder.findServiceByClass(WriteBehindProviderConfiguration.class);
        if (config == null) {
            return new CacheManagerBuilder<T>(this, this.configBuilder.addService(new WriteBehindProviderConfiguration(threadPoolAlias)));
        }
        ConfigurationBuilder builder = this.configBuilder.removeService(config);
        return new CacheManagerBuilder<T>(this, builder.addService(new WriteBehindProviderConfiguration(threadPoolAlias)));
    }

    public CacheManagerBuilder<T> withDefaultDiskStoreThreadPool(String threadPoolAlias) {
        OffHeapDiskStoreProviderConfiguration config = this.configBuilder.findServiceByClass(OffHeapDiskStoreProviderConfiguration.class);
        if (config == null) {
            return new CacheManagerBuilder<T>(this, this.configBuilder.addService(new OffHeapDiskStoreProviderConfiguration(threadPoolAlias)));
        }
        ConfigurationBuilder builder = this.configBuilder.removeService(config);
        return new CacheManagerBuilder<T>(this, builder.addService(new OffHeapDiskStoreProviderConfiguration(threadPoolAlias)));
    }

    public CacheManagerBuilder<T> withDefaultEventListenersThreadPool(String threadPoolAlias) {
        CacheEventDispatcherFactoryConfiguration config = this.configBuilder.findServiceByClass(CacheEventDispatcherFactoryConfiguration.class);
        if (config == null) {
            return new CacheManagerBuilder<T>(this, this.configBuilder.addService(new CacheEventDispatcherFactoryConfiguration(threadPoolAlias)));
        }
        ConfigurationBuilder builder = this.configBuilder.removeService(config);
        return new CacheManagerBuilder<T>(this, builder.addService(new CacheEventDispatcherFactoryConfiguration(threadPoolAlias)));
    }

    public CacheManagerBuilder<T> using(ServiceCreationConfiguration<?> serviceConfiguration) {
        return new CacheManagerBuilder<T>(this, this.configBuilder.addService(serviceConfiguration));
    }

    public CacheManagerBuilder<T> replacing(ServiceCreationConfiguration<?> overwriteServiceConfiguration) {
        ServiceCreationConfiguration existingConfiguration = (ServiceCreationConfiguration)this.configBuilder.findServiceByClass(overwriteServiceConfiguration.getClass());
        return new CacheManagerBuilder<T>(this, this.configBuilder.removeService(existingConfiguration).addService(overwriteServiceConfiguration));
    }

    public CacheManagerBuilder<T> withClassLoader(ClassLoader classLoader) {
        return new CacheManagerBuilder<T>(this, this.configBuilder.withClassLoader(classLoader));
    }

    public static CacheManagerBuilder<CacheManager> newCacheManagerBuilder() {
        return new CacheManagerBuilder<CacheManager>();
    }

    public static PersistenceConfiguration persistence(String location) {
        return new CacheManagerPersistenceConfiguration(new File(location));
    }
}

