/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.loaderwriter.writebehind.operations;

import java.util.ArrayList;
import java.util.List;
import org.ehcache.loaderwriter.writebehind.operations.BatchOperation;
import org.ehcache.loaderwriter.writebehind.operations.DeleteAllOperation;
import org.ehcache.loaderwriter.writebehind.operations.SingleOperation;
import org.ehcache.spi.loaderwriter.CacheLoaderWriter;

public class DeleteOperation<K, V>
implements SingleOperation<K, V> {
    private final K key;
    private final long creationTime;

    public DeleteOperation(K key) {
        this(key, System.nanoTime());
    }

    public DeleteOperation(K key, long creationTime) {
        this.key = key;
        this.creationTime = creationTime;
    }

    @Override
    public void performSingleOperation(CacheLoaderWriter<K, V> cacheLoaderWriter) throws Exception {
        cacheLoaderWriter.delete(this.key);
    }

    @Override
    public BatchOperation<K, V> createBatchOperation(List<? extends SingleOperation<K, V>> operations) {
        ArrayList keys = new ArrayList();
        for (SingleOperation<K, V> operation : operations) {
            keys.add(operation.getKey());
        }
        return new DeleteAllOperation(keys);
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof DeleteOperation) {
            return this.getCreationTime() == ((DeleteOperation)other).getCreationTime() && this.getKey().equals(((DeleteOperation)other).getKey());
        }
        return false;
    }
}

