/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.internal.store.offheap;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ehcache.CacheConfigurationChangeListener;
import org.ehcache.config.EvictionVeto;
import org.ehcache.config.ResourcePool;
import org.ehcache.config.ResourceType;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.exceptions.CacheAccessException;
import org.ehcache.function.Predicate;
import org.ehcache.function.Predicates;
import org.ehcache.internal.TimeSource;
import org.ehcache.internal.TimeSourceService;
import org.ehcache.internal.store.offheap.AbstractOffHeapStore;
import org.ehcache.internal.store.offheap.EhcacheConcurrentOffHeapClockCache;
import org.ehcache.internal.store.offheap.EhcacheOffHeapBackingMap;
import org.ehcache.internal.store.offheap.HeuristicConfiguration;
import org.ehcache.internal.store.offheap.OffHeapStoreUtils;
import org.ehcache.internal.store.offheap.OffHeapValueHolder;
import org.ehcache.internal.store.offheap.factories.EhcacheSegmentFactory;
import org.ehcache.internal.store.offheap.portability.OffHeapValueHolderPortability;
import org.ehcache.internal.store.offheap.portability.SerializerPortability;
import org.ehcache.spi.ServiceProvider;
import org.ehcache.spi.cache.Store;
import org.ehcache.spi.cache.tiering.AuthoritativeTier;
import org.ehcache.spi.cache.tiering.LowerCachingTier;
import org.ehcache.spi.serialization.SerializationProvider;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceDependencies;
import org.ehcache.util.ConcurrentWeakIdentityHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.offheapstore.paging.PageSource;
import org.terracotta.offheapstore.paging.UpfrontAllocatingPageSource;
import org.terracotta.offheapstore.storage.OffHeapBufferStorageEngine;
import org.terracotta.offheapstore.storage.PointerSize;
import org.terracotta.offheapstore.util.Factory;

public class OffHeapStore<K, V>
extends AbstractOffHeapStore<K, V> {
    private final Predicate<Map.Entry<K, OffHeapValueHolder<V>>> evictionVeto;
    private final Serializer<K> keySerializer;
    private final Serializer<V> valueSerializer;
    private final long sizeInBytes;
    private volatile EhcacheConcurrentOffHeapClockCache<K, OffHeapValueHolder<V>> map;

    public OffHeapStore(Store.Configuration<K, V> config, TimeSource timeSource, long sizeInBytes) {
        super("local-offheap", config, timeSource);
        EvictionVeto veto = config.getEvictionVeto();
        this.evictionVeto = veto != null ? OffHeapStore.wrap(veto, timeSource) : Predicates.none();
        this.keySerializer = config.getKeySerializer();
        this.valueSerializer = config.getValueSerializer();
        this.sizeInBytes = sizeInBytes;
    }

    public List<CacheConfigurationChangeListener> getConfigurationChangeListeners() {
        return Collections.emptyList();
    }

    private EhcacheConcurrentOffHeapClockCache<K, OffHeapValueHolder<V>> createBackingMap(long size, Serializer<K> keySerializer, Serializer<V> valueSerializer, Predicate<Map.Entry<K, OffHeapValueHolder<V>>> evictionVeto) {
        HeuristicConfiguration config = new HeuristicConfiguration(size);
        UpfrontAllocatingPageSource source = new UpfrontAllocatingPageSource(OffHeapStoreUtils.getBufferSource(), config.getMaximumSize(), config.getMaximumChunkSize(), config.getMinimumChunkSize());
        SerializerPortability<K> keyPortability = new SerializerPortability<K>(keySerializer);
        OffHeapValueHolderPortability<V> elementPortability = new OffHeapValueHolderPortability<V>(valueSerializer);
        Factory storageEngineFactory = OffHeapBufferStorageEngine.createFactory((PointerSize)PointerSize.INT, (PageSource)source, (int)config.getSegmentDataPageSize(), keyPortability, elementPortability, (boolean)false, (boolean)true);
        EhcacheSegmentFactory<K, OffHeapValueHolder<V>> segmentFactory = new EhcacheSegmentFactory<K, OffHeapValueHolder<V>>((PageSource)source, storageEngineFactory, config.getInitialSegmentTableSize(), evictionVeto, this.mapEvictionListener);
        return new EhcacheConcurrentOffHeapClockCache(segmentFactory, config.getConcurrency());
    }

    @Override
    protected EhcacheOffHeapBackingMap<K, OffHeapValueHolder<V>> backingMap() {
        return this.map;
    }

    @ServiceDependencies(value={TimeSourceService.class, SerializationProvider.class})
    public static class Provider
    implements Store.Provider,
    AuthoritativeTier.Provider,
    LowerCachingTier.Provider {
        private static final Logger LOGGER = LoggerFactory.getLogger(Provider.class);
        private volatile ServiceProvider serviceProvider;
        private final Set<Store<?, ?>> createdStores = Collections.newSetFromMap(new ConcurrentWeakIdentityHashMap());

        public <K, V> OffHeapStore<K, V> createStore(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?> ... serviceConfigs) {
            if (this.serviceProvider == null) {
                throw new NullPointerException("ServiceProvider is null in OffHeapStore.Provider.");
            }
            TimeSource timeSource = ((TimeSourceService)this.serviceProvider.getService(TimeSourceService.class)).getTimeSource();
            ResourcePool offHeapPool = storeConfig.getResourcePools().getPoolForResource((ResourceType)ResourceType.Core.OFFHEAP);
            if (!(offHeapPool.getUnit() instanceof MemoryUnit)) {
                throw new IllegalArgumentException("OffHeapStore only supports resources with memory unit");
            }
            MemoryUnit unit = (MemoryUnit)offHeapPool.getUnit();
            OffHeapStore<K, V> offHeapStore = new OffHeapStore<K, V>(storeConfig, timeSource, unit.toBytes(offHeapPool.getSize()));
            this.createdStores.add((Store<?, ?>)offHeapStore);
            return offHeapStore;
        }

        public void releaseStore(Store<?, ?> resource) {
            if (!this.createdStores.contains(resource)) {
                throw new IllegalArgumentException("Given store is not managed by this provider : " + resource);
            }
            Provider.close((OffHeapStore)resource);
        }

        static void close(OffHeapStore resource) {
            EhcacheConcurrentOffHeapClockCache localMap = resource.map;
            if (localMap != null) {
                resource.map = null;
                localMap.destroy();
            }
        }

        public void initStore(Store<?, ?> resource) {
            if (!this.createdStores.contains(resource)) {
                throw new IllegalArgumentException("Given store is not managed by this provider : " + resource);
            }
            Provider.init((OffHeapStore)resource);
        }

        static <K, V> void init(OffHeapStore<K, V> resource) {
            ((OffHeapStore)resource).map = ((OffHeapStore)resource).createBackingMap(((OffHeapStore)resource).sizeInBytes, ((OffHeapStore)resource).keySerializer, ((OffHeapStore)resource).valueSerializer, ((OffHeapStore)resource).evictionVeto);
        }

        public void start(ServiceProvider serviceProvider) {
            this.serviceProvider = serviceProvider;
        }

        public void stop() {
            this.serviceProvider = null;
            this.createdStores.clear();
        }

        public <K, V> AuthoritativeTier<K, V> createAuthoritativeTier(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?> ... serviceConfigs) {
            return this.createStore(storeConfig, serviceConfigs);
        }

        public void releaseAuthoritativeTier(AuthoritativeTier<?, ?> resource) {
            this.releaseStore((Store<?, ?>)resource);
        }

        public void initAuthoritativeTier(AuthoritativeTier<?, ?> resource) {
            this.initStore((Store<?, ?>)resource);
        }

        public <K, V> LowerCachingTier<K, V> createCachingTier(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?> ... serviceConfigs) {
            return this.createStore(storeConfig, serviceConfigs);
        }

        public void releaseCachingTier(LowerCachingTier<?, ?> resource) {
            if (!this.createdStores.contains(resource)) {
                throw new IllegalArgumentException("Given caching tier is not managed by this provider : " + resource);
            }
            this.flushToLowerTier((OffHeapStore)resource);
            this.releaseStore((Store)resource);
        }

        private void flushToLowerTier(OffHeapStore<Object, ?> resource) {
            CacheAccessException lastFailure = null;
            int failureCount = 0;
            OffHeapStore<Object, ?> offheapStore = resource;
            Set keys = offheapStore.backingMap().keySet();
            for (Object key : keys) {
                try {
                    offheapStore.invalidate(key);
                }
                catch (CacheAccessException cae) {
                    lastFailure = cae;
                    ++failureCount;
                    LOGGER.warn("Error flushing '{}' to lower tier", key, (Object)cae);
                }
            }
            if (lastFailure != null) {
                throw new RuntimeException("Failed to flush some mappings to lower tier, " + failureCount + " could not be flushed. This error represents the last failure.", lastFailure);
            }
        }

        public void initCachingTier(LowerCachingTier<?, ?> resource) {
            if (!this.createdStores.contains(resource)) {
                throw new IllegalArgumentException("Given caching tier is not managed by this provider : " + resource);
            }
            this.initStore((Store)resource);
        }
    }
}

