/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.internal.store.heap;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.ehcache.Cache;
import org.ehcache.CacheConfigurationChangeEvent;
import org.ehcache.CacheConfigurationChangeListener;
import org.ehcache.CacheConfigurationProperty;
import org.ehcache.config.Eviction;
import org.ehcache.config.EvictionPrioritizer;
import org.ehcache.config.ResourcePool;
import org.ehcache.config.ResourcePools;
import org.ehcache.config.ResourceType;
import org.ehcache.config.units.EntryUnit;
import org.ehcache.events.CacheEvents;
import org.ehcache.events.StoreEventListener;
import org.ehcache.exceptions.CacheAccessException;
import org.ehcache.exceptions.CachePassThroughException;
import org.ehcache.expiry.Duration;
import org.ehcache.expiry.Expiry;
import org.ehcache.function.BiFunction;
import org.ehcache.function.Function;
import org.ehcache.function.NullaryFunction;
import org.ehcache.function.Predicate;
import org.ehcache.function.Predicates;
import org.ehcache.internal.TimeSource;
import org.ehcache.internal.TimeSourceService;
import org.ehcache.internal.concurrent.ConcurrentHashMap;
import org.ehcache.internal.copy.SerializingCopier;
import org.ehcache.internal.store.heap.holders.CopiedOnHeapKey;
import org.ehcache.internal.store.heap.holders.CopiedOnHeapValueHolder;
import org.ehcache.internal.store.heap.holders.LookupOnlyOnHeapKey;
import org.ehcache.internal.store.heap.holders.OnHeapKey;
import org.ehcache.internal.store.heap.holders.OnHeapValueHolder;
import org.ehcache.internal.store.heap.holders.SerializedOnHeapValueHolder;
import org.ehcache.spi.ServiceProvider;
import org.ehcache.spi.cache.CacheStoreHelper;
import org.ehcache.spi.cache.Store;
import org.ehcache.spi.cache.tiering.CachingTier;
import org.ehcache.spi.cache.tiering.HigherCachingTier;
import org.ehcache.spi.copy.Copier;
import org.ehcache.spi.copy.CopyProvider;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceDependencies;
import org.ehcache.statistics.CachingTierOperationOutcomes;
import org.ehcache.statistics.HigherCachingTierOperationOutcomes;
import org.ehcache.statistics.StoreOperationOutcomes;
import org.ehcache.util.ConcurrentWeakIdentityHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.context.annotations.ContextAttribute;
import org.terracotta.statistics.StatisticBuilder;
import org.terracotta.statistics.StatisticsManager;
import org.terracotta.statistics.observer.OperationObserver;

public class OnHeapStore<K, V>
implements Store<K, V>,
HigherCachingTier<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(OnHeapStore.class);
    private static final int ATTEMPT_RATIO = 4;
    private static final int EVICTION_RATIO = 2;
    static final int SAMPLE_SIZE = 8;
    private final MapWrapper<K, V> map;
    private final Class<K> keyType;
    private final Class<V> valueType;
    private final Copier<K> keyCopier;
    private final Copier<V> valueCopier;
    private volatile long capacity;
    private final Predicate<? extends Map.Entry<? super K, ? extends OnHeapValueHolder<? super V>>> evictionVeto;
    private final Comparator<? extends Map.Entry<? super K, ? extends OnHeapValueHolder<? super V>>> evictionPrioritizer;
    private final Expiry<? super K, ? super V> expiry;
    private final TimeSource timeSource;
    private volatile StoreEventListener<K, V> eventListener = CacheEvents.nullStoreEventListener();
    private volatile CachingTier.InvalidationListener<K, V> invalidationListener;
    private CacheConfigurationChangeListener cacheConfigurationChangeListener = new CacheConfigurationChangeListener(){

        public void cacheConfigurationChange(CacheConfigurationChangeEvent event) {
            if (event.getProperty().equals((Object)CacheConfigurationProperty.UPDATESIZE)) {
                ResourcePools updatedPools = (ResourcePools)event.getNewValue();
                ResourcePools configuredPools = (ResourcePools)event.getOldValue();
                if (updatedPools.getPoolForResource((ResourceType)ResourceType.Core.HEAP).getSize() != configuredPools.getPoolForResource((ResourceType)ResourceType.Core.HEAP).getSize()) {
                    LOG.info("Setting size: " + updatedPools.getPoolForResource((ResourceType)ResourceType.Core.HEAP).getSize());
                    OnHeapStore.this.capacity = updatedPools.getPoolForResource((ResourceType)ResourceType.Core.HEAP).getSize();
                }
            }
        }
    };
    private final OperationObserver<StoreOperationOutcomes.GetOutcome> getObserver;
    private final OperationObserver<StoreOperationOutcomes.PutOutcome> putObserver;
    private final OperationObserver<StoreOperationOutcomes.RemoveOutcome> removeObserver;
    private final OperationObserver<StoreOperationOutcomes.PutIfAbsentOutcome> putIfAbsentObserver;
    private final OperationObserver<StoreOperationOutcomes.ConditionalRemoveOutcome> conditionalRemoveObserver;
    private final OperationObserver<StoreOperationOutcomes.ReplaceOutcome> replaceObserver;
    private final OperationObserver<StoreOperationOutcomes.ConditionalReplaceOutcome> conditionalReplaceObserver;
    private final OperationObserver<StoreOperationOutcomes.ComputeOutcome> computeObserver;
    private final OperationObserver<StoreOperationOutcomes.ComputeIfAbsentOutcome> computeIfAbsentObserver;
    private final OperationObserver<StoreOperationOutcomes.ComputeIfPresentOutcome> computeIfPresentObserver;
    private final OperationObserver<StoreOperationOutcomes.EvictionOutcome> evictionObserver;
    private final OperationObserver<StoreOperationOutcomes.ExpirationOutcome> expirationObserver;
    private final OperationObserver<CachingTierOperationOutcomes.GetOrComputeIfAbsentOutcome> getOrComputeIfAbsentObserver;
    private final OperationObserver<CachingTierOperationOutcomes.InvalidateOutcome> invalidateObserver;
    private final OperationObserver<HigherCachingTierOperationOutcomes.SilentInvalidateOutcome> silentInvalidateObserver;
    private final OnHeapStoreStatsSettings onHeapStoreStatsSettings;
    private static final NullaryFunction<Boolean> REPLACE_EQUALS_TRUE = new NullaryFunction<Boolean>(){

        public Boolean apply() {
            return Boolean.TRUE;
        }
    };

    public OnHeapStore(Store.Configuration<K, V> config, TimeSource timeSource, Copier<K> keyCopier, Copier<V> valueCopier) {
        if (keyCopier == null) {
            throw new NullPointerException("keyCopier must not be null");
        }
        if (valueCopier == null) {
            throw new NullPointerException("valueCopier must not be null");
        }
        ResourcePool heapPool = config.getResourcePools().getPoolForResource((ResourceType)ResourceType.Core.HEAP);
        if (heapPool == null) {
            throw new IllegalArgumentException("OnHeap store must be configured with a resource of type 'heap'");
        }
        if (!heapPool.getUnit().equals(EntryUnit.ENTRIES)) {
            throw new IllegalArgumentException("OnHeap store only handles resource unit 'entries'");
        }
        this.capacity = heapPool.getSize();
        EvictionPrioritizer prioritizer = config.getEvictionPrioritizer();
        if (prioritizer == null) {
            prioritizer = Eviction.Prioritizer.LRU;
        }
        this.timeSource = timeSource;
        this.evictionVeto = OnHeapStore.wrap(config.getEvictionVeto(), timeSource);
        this.evictionPrioritizer = OnHeapStore.wrap(prioritizer, timeSource);
        this.keyType = config.getKeyType();
        this.valueType = config.getValueType();
        this.expiry = config.getExpiry();
        this.keyCopier = keyCopier;
        this.valueCopier = valueCopier;
        this.map = new MapWrapper(this.keyCopier);
        this.onHeapStoreStatsSettings = new OnHeapStoreStatsSettings(this);
        StatisticsManager.associate((Object)this.onHeapStoreStatsSettings).withParent((Object)this);
        this.getObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.GetOutcome.class).named("get")).of((Object)this)).tag(new String[]{"onheap-store"})).build();
        this.putObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.PutOutcome.class).named("put")).of((Object)this)).tag(new String[]{"onheap-store"})).build();
        this.removeObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.RemoveOutcome.class).named("remove")).of((Object)this)).tag(new String[]{"onheap-store"})).build();
        this.putIfAbsentObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.PutIfAbsentOutcome.class).named("putIfAbsent")).of((Object)this)).tag(new String[]{"onheap-store"})).build();
        this.conditionalRemoveObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.ConditionalRemoveOutcome.class).named("conditionalRemove")).of((Object)this)).tag(new String[]{"onheap-store"})).build();
        this.replaceObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.ReplaceOutcome.class).named("replace")).of((Object)this)).tag(new String[]{"onheap-store"})).build();
        this.conditionalReplaceObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.ConditionalReplaceOutcome.class).named("conditionalReplace")).of((Object)this)).tag(new String[]{"onheap-store"})).build();
        this.computeObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.ComputeOutcome.class).named("compute")).of((Object)this)).tag(new String[]{"onheap-store"})).build();
        this.computeIfAbsentObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.ComputeIfAbsentOutcome.class).named("computeIfAbsent")).of((Object)this)).tag(new String[]{"onheap-store"})).build();
        this.computeIfPresentObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.ComputeIfPresentOutcome.class).named("computeIfPresent")).of((Object)this)).tag(new String[]{"onheap-store"})).build();
        this.evictionObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.EvictionOutcome.class).named("eviction")).of((Object)this)).tag(new String[]{"onheap-store"})).build();
        this.expirationObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.ExpirationOutcome.class).named("expiration")).of((Object)this)).tag(new String[]{"onheap-store"})).build();
        this.getOrComputeIfAbsentObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(CachingTierOperationOutcomes.GetOrComputeIfAbsentOutcome.class).named("getOrComputeIfAbsent")).of((Object)this)).tag(new String[]{"onheap-store"})).build();
        this.invalidateObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(CachingTierOperationOutcomes.InvalidateOutcome.class).named("invalidate")).of((Object)this)).tag(new String[]{"onheap-store"})).build();
        this.silentInvalidateObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(HigherCachingTierOperationOutcomes.SilentInvalidateOutcome.class).named("silentInvalidate")).of((Object)this)).tag(new String[]{"onheap-store"})).build();
    }

    public Store.ValueHolder<V> get(K key) throws CacheAccessException {
        this.checkKey(key);
        return this.internalGet(key, true);
    }

    private OnHeapValueHolder<V> internalGet(final K key, final boolean updateAccess) throws CacheAccessException {
        this.getObserver.begin();
        try {
            OnHeapValueHolder<V> result = this.map.computeIfPresent(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

                public OnHeapValueHolder<V> apply(K mappedKey, OnHeapValueHolder<V> mappedValue) {
                    long now = OnHeapStore.this.timeSource.getTimeMillis();
                    if (mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                        OnHeapStore.this.onExpiration(mappedKey, mappedValue);
                        return null;
                    }
                    if (updateAccess) {
                        return OnHeapStore.this.setAccessTimeAndExpiryThenReturnMapping(key, mappedValue, now, false);
                    }
                    return mappedValue;
                }
            });
            if (result == null) {
                this.getObserver.end((Enum)StoreOperationOutcomes.GetOutcome.MISS);
            } else {
                this.getObserver.end((Enum)StoreOperationOutcomes.GetOutcome.HIT);
            }
            return result;
        }
        catch (RuntimeException re) {
            CachePassThroughException.handleRuntimeException((RuntimeException)re);
            return null;
        }
    }

    public boolean containsKey(K key) throws CacheAccessException {
        this.checkKey(key);
        return this.internalGet(key, false) != null;
    }

    public void put(K key, V value) throws CacheAccessException {
        this.putReturnHolder(key, value);
    }

    private OnHeapValueHolder<V> putReturnHolder(final K key, final V value) throws CacheAccessException {
        this.putObserver.begin();
        this.checkKey(key);
        this.checkValue(value);
        final AtomicBoolean entryActuallyAdded = new AtomicBoolean();
        final long now = this.timeSource.getTimeMillis();
        try {
            OnHeapValueHolder<V> valuePut = this.map.compute(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

                public OnHeapValueHolder<V> apply(K mappedKey, OnHeapValueHolder<V> mappedValue) {
                    entryActuallyAdded.set(mappedValue == null);
                    if (mappedValue != null && mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                        mappedValue = null;
                    }
                    if (mappedValue == null) {
                        return OnHeapStore.this.newCreateValueHolder(key, value, now);
                    }
                    return OnHeapStore.this.newUpdateValueHolder(key, mappedValue, value, now);
                }
            });
            if (entryActuallyAdded.get()) {
                this.putObserver.end((Enum)StoreOperationOutcomes.PutOutcome.PUT);
                this.enforceCapacity(1);
            } else {
                this.putObserver.end((Enum)StoreOperationOutcomes.PutOutcome.REPLACED);
            }
            return valuePut;
        }
        catch (RuntimeException re) {
            CachePassThroughException.handleRuntimeException((RuntimeException)re);
            return null;
        }
    }

    public void remove(K key) throws CacheAccessException {
        this.removeObserver.begin();
        this.checkKey(key);
        try {
            if (this.map.remove(key) != null) {
                this.removeObserver.end((Enum)StoreOperationOutcomes.RemoveOutcome.REMOVED);
            } else {
                this.removeObserver.end((Enum)StoreOperationOutcomes.RemoveOutcome.MISS);
            }
        }
        catch (RuntimeException re) {
            CachePassThroughException.handleRuntimeException((RuntimeException)re);
        }
    }

    OnHeapValueHolder<V> putIfAbsentReturnHolder(K key, V value) throws CacheAccessException {
        return this.putIfAbsent(key, value, true);
    }

    public Store.ValueHolder<V> putIfAbsent(K key, V value) throws CacheAccessException {
        return this.putIfAbsent(key, value, false);
    }

    private OnHeapValueHolder<V> putIfAbsent(final K key, final V value, boolean returnInCacheHolder) throws CacheAccessException {
        this.putIfAbsentObserver.begin();
        this.checkKey(key);
        this.checkValue(value);
        final AtomicReference<Object> returnValue = new AtomicReference<Object>(null);
        final AtomicBoolean entryActuallyAdded = new AtomicBoolean();
        final long now = this.timeSource.getTimeMillis();
        try {
            OnHeapValueHolder<V> inCache = this.map.compute(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

                public OnHeapValueHolder<V> apply(K mappedKey, OnHeapValueHolder<V> mappedValue) {
                    if (mappedValue == null || mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                        if (mappedValue != null) {
                            OnHeapStore.this.onExpiration(mappedKey, mappedValue);
                        }
                        entryActuallyAdded.set(true);
                        return OnHeapStore.this.newCreateValueHolder(key, value, now);
                    }
                    returnValue.set(mappedValue);
                    return OnHeapStore.this.setAccessTimeAndExpiryThenReturnMapping(key, mappedValue, now, false);
                }
            });
            if (entryActuallyAdded.get()) {
                this.putIfAbsentObserver.end((Enum)StoreOperationOutcomes.PutIfAbsentOutcome.PUT);
                this.enforceCapacity(1);
            } else {
                this.putIfAbsentObserver.end((Enum)StoreOperationOutcomes.PutIfAbsentOutcome.HIT);
            }
            if (returnInCacheHolder) {
                return inCache;
            }
        }
        catch (RuntimeException re) {
            CachePassThroughException.handleRuntimeException((RuntimeException)re);
        }
        return returnValue.get();
    }

    public boolean remove(final K key, final V value) throws CacheAccessException {
        this.conditionalRemoveObserver.begin();
        this.checkKey(key);
        this.checkValue(value);
        final AtomicBoolean removed = new AtomicBoolean(false);
        try {
            this.map.computeIfPresent(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

                public OnHeapValueHolder<V> apply(K mappedKey, OnHeapValueHolder<V> mappedValue) {
                    long now = OnHeapStore.this.timeSource.getTimeMillis();
                    if (mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                        OnHeapStore.this.onExpiration(mappedKey, mappedValue);
                        return null;
                    }
                    if (value.equals(mappedValue.value())) {
                        removed.set(true);
                        return null;
                    }
                    return OnHeapStore.this.setAccessTimeAndExpiryThenReturnMapping(key, mappedValue, now, false);
                }
            });
            if (removed.get()) {
                this.conditionalRemoveObserver.end((Enum)StoreOperationOutcomes.ConditionalRemoveOutcome.REMOVED);
                return true;
            }
            this.conditionalRemoveObserver.end((Enum)StoreOperationOutcomes.ConditionalRemoveOutcome.MISS);
            return false;
        }
        catch (RuntimeException re) {
            CachePassThroughException.handleRuntimeException((RuntimeException)re);
            return removed.get();
        }
    }

    public Store.ValueHolder<V> replace(final K key, final V value) throws CacheAccessException {
        this.replaceObserver.begin();
        this.checkKey(key);
        this.checkValue(value);
        final AtomicReference<Object> returnValue = new AtomicReference<Object>(null);
        try {
            this.map.computeIfPresent(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

                public OnHeapValueHolder<V> apply(K mappedKey, OnHeapValueHolder<V> mappedValue) {
                    long now = OnHeapStore.this.timeSource.getTimeMillis();
                    if (mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                        OnHeapStore.this.onExpiration(mappedKey, mappedValue);
                        return null;
                    }
                    returnValue.set(mappedValue);
                    return OnHeapStore.this.newUpdateValueHolder(key, mappedValue, value, now);
                }
            });
            OnHeapValueHolder valueHolder = returnValue.get();
            if (valueHolder != null) {
                this.replaceObserver.end((Enum)StoreOperationOutcomes.ReplaceOutcome.REPLACED);
            } else {
                this.replaceObserver.end((Enum)StoreOperationOutcomes.ReplaceOutcome.MISS);
            }
        }
        catch (RuntimeException re) {
            CachePassThroughException.handleRuntimeException((RuntimeException)re);
        }
        return returnValue.get();
    }

    public boolean replace(final K key, final V oldValue, final V newValue) throws CacheAccessException {
        this.conditionalReplaceObserver.begin();
        this.checkKey(key);
        this.checkValue(oldValue);
        this.checkValue(newValue);
        final AtomicBoolean returnValue = new AtomicBoolean(false);
        try {
            this.map.computeIfPresent(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

                public OnHeapValueHolder<V> apply(K mappedKey, OnHeapValueHolder<V> mappedValue) {
                    long now = OnHeapStore.this.timeSource.getTimeMillis();
                    Object existingValue = mappedValue.value();
                    if (mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                        OnHeapStore.this.onExpiration(mappedKey, mappedValue);
                        return null;
                    }
                    if (oldValue.equals(existingValue)) {
                        returnValue.set(true);
                        long expirationTime = mappedValue.expirationTime(OnHeapValueHolder.TIME_UNIT);
                        return OnHeapStore.this.newUpdateValueHolder(key, existingValue, newValue, now, expirationTime);
                    }
                    return OnHeapStore.this.setAccessTimeAndExpiryThenReturnMapping(key, mappedValue, now, false);
                }
            });
            if (returnValue.get()) {
                this.conditionalReplaceObserver.end((Enum)StoreOperationOutcomes.ConditionalReplaceOutcome.REPLACED);
                return true;
            }
            this.conditionalReplaceObserver.end((Enum)StoreOperationOutcomes.ConditionalReplaceOutcome.MISS);
            return false;
        }
        catch (RuntimeException re) {
            CachePassThroughException.handleRuntimeException((RuntimeException)re);
            return false;
        }
    }

    public void clear() throws CacheAccessException {
        try {
            this.map.clear();
        }
        catch (RuntimeException re) {
            CachePassThroughException.handleRuntimeException((RuntimeException)re);
        }
    }

    private void invalidate() {
        if (((MapWrapper)this.map).keyCopyMap != null) {
            for (OnHeapKey key : ((MapWrapper)this.map).keyCopyMap.keySet()) {
                try {
                    this.invalidate(key.getActualKeyObject());
                }
                catch (CacheAccessException cae) {
                    LOG.warn("Failed to invalidate mapping for key {}", (Object)key, (Object)cae);
                }
            }
        }
        this.map.clear();
    }

    public Store.Iterator<Cache.Entry<K, Store.ValueHolder<V>>> iterator() {
        final Iterator<Map.Entry<K, OnHeapValueHolder<V>>> it = this.map.entrySetIterator();
        return new Store.Iterator<Cache.Entry<K, Store.ValueHolder<V>>>(){
            private Map.Entry<K, OnHeapValueHolder<V>> next = null;
            private CacheAccessException prefetchFailure = null;
            {
                this.advance();
            }

            private void advance() {
                this.next = null;
                try {
                    while (this.next == null && it.hasNext()) {
                        Map.Entry entry = (Map.Entry)it.next();
                        long now = OnHeapStore.this.timeSource.getTimeMillis();
                        if (((OnHeapValueHolder)((Object)entry.getValue())).isExpired(now, TimeUnit.MILLISECONDS)) {
                            OnHeapStore.this.internalGet(entry.getKey(), false);
                            continue;
                        }
                        this.next = entry;
                    }
                }
                catch (RuntimeException re) {
                    this.prefetchFailure = new CacheAccessException((Throwable)re);
                }
                catch (CacheAccessException e) {
                    this.prefetchFailure = e;
                }
            }

            public boolean hasNext() {
                return this.next != null || this.prefetchFailure != null;
            }

            public Cache.Entry<K, Store.ValueHolder<V>> next() throws CacheAccessException {
                if (this.prefetchFailure != null) {
                    throw this.prefetchFailure;
                }
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                final Map.Entry thisEntry = this.next;
                this.advance();
                OnHeapStore.this.setAccessTimeAndExpiryThenReturnMapping(thisEntry.getKey(), thisEntry.getValue(), OnHeapStore.this.timeSource.getTimeMillis(), true);
                return new Cache.Entry<K, Store.ValueHolder<V>>(){

                    public K getKey() {
                        return thisEntry.getKey();
                    }

                    public Store.ValueHolder<V> getValue() {
                        return (Store.ValueHolder)thisEntry.getValue();
                    }

                    public long getCreationTime(TimeUnit unit) {
                        return ((OnHeapValueHolder)((Object)thisEntry.getValue())).creationTime(unit);
                    }

                    public long getLastAccessTime(TimeUnit unit) {
                        return ((OnHeapValueHolder)((Object)thisEntry.getValue())).lastAccessTime(unit);
                    }

                    public float getHitRate(TimeUnit unit) {
                        long now = OnHeapStore.this.timeSource.getTimeMillis();
                        return ((OnHeapValueHolder)((Object)thisEntry.getValue())).hitRate(now, unit);
                    }
                };
            }
        };
    }

    public Store.ValueHolder<V> getOrComputeIfAbsent(final K key, final Function<K, Store.ValueHolder<V>> source) throws CacheAccessException {
        try {
            Fault fault;
            this.getOrComputeIfAbsentObserver.begin();
            MapWrapper backEnd = this.map;
            OnHeapValueHolder<V> cachedValue = backEnd.get(key);
            final long now = this.timeSource.getTimeMillis();
            if (cachedValue == null && (cachedValue = backEnd.putIfAbsent(key, fault = new Fault(new NullaryFunction<Store.ValueHolder<V>>(){

                public Store.ValueHolder<V> apply() {
                    return (Store.ValueHolder)source.apply(key);
                }
            }))) == null) {
                this.enforceCapacity(1);
                try {
                    OnHeapValueHolder<V> newValue;
                    final Store.ValueHolder value = fault.get();
                    if (value != null) {
                        try {
                            newValue = this.importValueFromLowerTier(key, value, now);
                        }
                        catch (RuntimeException re) {
                            LOG.error("Expiry computation caused an exception - Expiry duration will be 0 ", (Throwable)re);
                            this.map.computeIfPresent(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

                                public OnHeapValueHolder<V> apply(K mappedKey, OnHeapValueHolder<V> mappedValue) {
                                    if (mappedValue.equals((Object)fault)) {
                                        OnHeapStore.this.onExpiration(key, (Store.ValueHolder)OnHeapStore.this.cloneValueHolder(key, value, now, Duration.ZERO));
                                        return null;
                                    }
                                    return mappedValue;
                                }
                            });
                            this.getOrComputeIfAbsentObserver.end((Enum)CachingTierOperationOutcomes.GetOrComputeIfAbsentOutcome.FAULT_FAILED);
                            return null;
                        }
                    } else {
                        backEnd.remove(key, fault);
                        this.getOrComputeIfAbsentObserver.end((Enum)CachingTierOperationOutcomes.GetOrComputeIfAbsentOutcome.MISS);
                        return null;
                    }
                    if (backEnd.replace(key, fault, newValue)) {
                        this.getOrComputeIfAbsentObserver.end((Enum)CachingTierOperationOutcomes.GetOrComputeIfAbsentOutcome.FAULTED);
                        return this.getValue((Store.ValueHolder<V>)newValue);
                    }
                    Store.ValueHolder<V> p = this.getValue((Store.ValueHolder<V>)backEnd.remove(key));
                    if (p != null) {
                        this.notifyInvalidation(key, p);
                        if (p.isExpired(now, TimeUnit.MILLISECONDS)) {
                            this.getOrComputeIfAbsentObserver.end((Enum)CachingTierOperationOutcomes.GetOrComputeIfAbsentOutcome.FAULT_FAILED_MISS);
                            return null;
                        }
                        this.getOrComputeIfAbsentObserver.end((Enum)CachingTierOperationOutcomes.GetOrComputeIfAbsentOutcome.FAULT_FAILED);
                        return p;
                    }
                    this.getOrComputeIfAbsentObserver.end((Enum)CachingTierOperationOutcomes.GetOrComputeIfAbsentOutcome.FAULT_FAILED);
                    return newValue;
                }
                catch (Throwable e) {
                    backEnd.remove(key, fault);
                    throw new CacheAccessException(e);
                }
            }
            if (!(cachedValue instanceof Fault)) {
                if (cachedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                    this.expireMapping(key, (Store.ValueHolder<V>)cachedValue);
                    this.getOrComputeIfAbsentObserver.end((Enum)CachingTierOperationOutcomes.GetOrComputeIfAbsentOutcome.MISS);
                    return null;
                }
                if (this.setAccessTimeAndExpiryThenReturnMapping(key, cachedValue, now, true) == null) {
                    this.getOrComputeIfAbsentObserver.end((Enum)CachingTierOperationOutcomes.GetOrComputeIfAbsentOutcome.MISS);
                    return null;
                }
            }
            this.getOrComputeIfAbsentObserver.end((Enum)CachingTierOperationOutcomes.GetOrComputeIfAbsentOutcome.HIT);
            return this.getValue((Store.ValueHolder<V>)cachedValue);
        }
        catch (RuntimeException re) {
            CachePassThroughException.handleRuntimeException((RuntimeException)re);
            return null;
        }
    }

    public void invalidate(final K key) throws CacheAccessException {
        this.invalidateObserver.begin();
        this.checkKey(key);
        try {
            final AtomicBoolean removed = new AtomicBoolean(false);
            this.map.computeIfPresent(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

                public OnHeapValueHolder<V> apply(K k, OnHeapValueHolder<V> present) {
                    if (!(present instanceof Fault)) {
                        OnHeapStore.this.notifyInvalidation(key, present);
                    }
                    removed.set(true);
                    return null;
                }
            });
            if (removed.get()) {
                this.invalidateObserver.end((Enum)CachingTierOperationOutcomes.InvalidateOutcome.REMOVED);
            } else {
                this.invalidateObserver.end((Enum)CachingTierOperationOutcomes.InvalidateOutcome.MISS);
            }
        }
        catch (RuntimeException re) {
            CachePassThroughException.handleRuntimeException((RuntimeException)re);
        }
    }

    public void silentInvalidate(K key, final Function<Store.ValueHolder<V>, Void> function) throws CacheAccessException {
        this.silentInvalidateObserver.begin();
        this.checkKey(key);
        try {
            final AtomicBoolean removed = new AtomicBoolean(false);
            this.map.compute(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

                public OnHeapValueHolder<V> apply(K k, OnHeapValueHolder<V> onHeapValueHolder) {
                    if (onHeapValueHolder != null) {
                        removed.set(true);
                    }
                    OnHeapValueHolder holderToPass = onHeapValueHolder;
                    if (onHeapValueHolder instanceof Fault) {
                        holderToPass = null;
                    }
                    function.apply(holderToPass);
                    return null;
                }
            });
            if (removed.get()) {
                this.silentInvalidateObserver.end((Enum)HigherCachingTierOperationOutcomes.SilentInvalidateOutcome.REMOVED);
            } else {
                this.silentInvalidateObserver.end((Enum)HigherCachingTierOperationOutcomes.SilentInvalidateOutcome.MISS);
            }
        }
        catch (RuntimeException re) {
            CachePassThroughException.handleRuntimeException((RuntimeException)re);
        }
    }

    private void notifyInvalidation(K key, Store.ValueHolder<V> p) {
        CachingTier.InvalidationListener<K, V> invalidationListener = this.invalidationListener;
        if (invalidationListener != null) {
            invalidationListener.onInvalidation(key, p);
        }
    }

    public void setInvalidationListener(final CachingTier.InvalidationListener<K, V> providedInvalidationListener) {
        this.invalidationListener = new CachingTier.InvalidationListener<K, V>(){

            public void onInvalidation(K key, Store.ValueHolder<V> valueHolder) {
                if (!(valueHolder instanceof Fault)) {
                    providedInvalidationListener.onInvalidation(key, valueHolder);
                }
            }
        };
        this.eventListener = new StoreEventListener<K, V>(){

            public void onEviction(K key, Store.ValueHolder<V> valueHolder) {
                OnHeapStore.this.invalidationListener.onInvalidation(key, valueHolder);
            }

            public void onExpiration(K key, Store.ValueHolder<V> valueHolder) {
                OnHeapStore.this.invalidationListener.onInvalidation(key, valueHolder);
            }
        };
    }

    private Store.ValueHolder<V> getValue(Store.ValueHolder<V> cachedValue) {
        if (cachedValue instanceof Fault) {
            return ((Fault)cachedValue).get();
        }
        return cachedValue;
    }

    public Store.ValueHolder<V> compute(K key, BiFunction<? super K, ? super V, ? extends V> mappingFunction) throws CacheAccessException {
        return this.compute(key, mappingFunction, REPLACE_EQUALS_TRUE);
    }

    public Store.ValueHolder<V> compute(final K key, final BiFunction<? super K, ? super V, ? extends V> mappingFunction, final NullaryFunction<Boolean> replaceEqual) throws CacheAccessException {
        this.computeObserver.begin();
        this.checkKey(key);
        final long now = this.timeSource.getTimeMillis();
        try {
            final AtomicBoolean write = new AtomicBoolean(false);
            OnHeapValueHolder<V> computeResult = this.map.compute(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

                public OnHeapValueHolder<V> apply(K mappedKey, OnHeapValueHolder<V> mappedValue) {
                    Object existingValue;
                    Object computedValue;
                    if (mappedValue != null && mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                        OnHeapStore.this.onExpiration(mappedKey, mappedValue);
                        mappedValue = null;
                    }
                    if ((computedValue = mappingFunction.apply(mappedKey, existingValue = mappedValue == null ? null : mappedValue.value())) == null) {
                        if (existingValue != null) {
                            write.set(true);
                        }
                        return null;
                    }
                    if (OnHeapStore.eq(existingValue, computedValue) && !((Boolean)replaceEqual.apply()).booleanValue() && mappedValue != null) {
                        return OnHeapStore.this.setAccessTimeAndExpiryThenReturnMapping(key, mappedValue, now, false);
                    }
                    OnHeapStore.this.checkValue(computedValue);
                    write.set(true);
                    if (mappedValue != null) {
                        long expirationTime = mappedValue.expirationTime(OnHeapValueHolder.TIME_UNIT);
                        return OnHeapStore.this.newUpdateValueHolder(key, existingValue, computedValue, now, expirationTime);
                    }
                    return OnHeapStore.this.newCreateValueHolder(key, computedValue, now);
                }
            });
            if (computeResult == null) {
                if (write.get()) {
                    this.computeObserver.end((Enum)StoreOperationOutcomes.ComputeOutcome.REMOVED);
                } else {
                    this.computeObserver.end((Enum)StoreOperationOutcomes.ComputeOutcome.MISS);
                }
            } else if (write.get()) {
                this.computeObserver.end((Enum)StoreOperationOutcomes.ComputeOutcome.PUT);
            } else {
                this.computeObserver.end((Enum)StoreOperationOutcomes.ComputeOutcome.HIT);
            }
            return this.enforceCapacityIfValueNotNull(computeResult);
        }
        catch (RuntimeException re) {
            CachePassThroughException.handleRuntimeException((RuntimeException)re);
            return null;
        }
    }

    public Store.ValueHolder<V> computeIfAbsent(final K key, final Function<? super K, ? extends V> mappingFunction) throws CacheAccessException {
        this.computeIfAbsentObserver.begin();
        this.checkKey(key);
        try {
            final long now = this.timeSource.getTimeMillis();
            final AtomicBoolean write = new AtomicBoolean(false);
            OnHeapValueHolder<V> computeResult = this.map.compute(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

                public OnHeapValueHolder<V> apply(K mappedKey, OnHeapValueHolder<V> mappedValue) {
                    if (mappedValue == null || mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                        if (mappedValue != null) {
                            OnHeapStore.this.onExpiration(mappedKey, mappedValue);
                        }
                        write.set(true);
                        Object computedValue = mappingFunction.apply(mappedKey);
                        if (computedValue == null) {
                            return null;
                        }
                        OnHeapStore.this.checkValue(computedValue);
                        return OnHeapStore.this.newCreateValueHolder(key, computedValue, now);
                    }
                    return OnHeapStore.this.setAccessTimeAndExpiryThenReturnMapping(key, mappedValue, now, false);
                }
            });
            if (write.get()) {
                if (computeResult != null) {
                    this.computeIfAbsentObserver.end((Enum)StoreOperationOutcomes.ComputeIfAbsentOutcome.PUT);
                } else {
                    this.computeIfAbsentObserver.end((Enum)StoreOperationOutcomes.ComputeIfAbsentOutcome.NOOP);
                }
            } else {
                this.computeIfAbsentObserver.end((Enum)StoreOperationOutcomes.ComputeIfAbsentOutcome.HIT);
            }
            return this.enforceCapacityIfValueNotNull(computeResult);
        }
        catch (RuntimeException re) {
            CachePassThroughException.handleRuntimeException((RuntimeException)re);
            return null;
        }
    }

    Store.ValueHolder<V> enforceCapacityIfValueNotNull(OnHeapValueHolder<V> computeResult) {
        if (computeResult != null) {
            this.enforceCapacity(1);
        }
        return computeResult;
    }

    public Store.ValueHolder<V> computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) throws CacheAccessException {
        return this.computeIfPresent(key, remappingFunction, REPLACE_EQUALS_TRUE);
    }

    public Store.ValueHolder<V> computeIfPresent(final K key, final BiFunction<? super K, ? super V, ? extends V> remappingFunction, final NullaryFunction<Boolean> replaceEqual) throws CacheAccessException {
        this.computeIfPresentObserver.begin();
        this.checkKey(key);
        try {
            final AtomicBoolean write = new AtomicBoolean(false);
            OnHeapValueHolder<V> computeResult = this.map.computeIfPresent(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

                public OnHeapValueHolder<V> apply(K mappedKey, OnHeapValueHolder<V> mappedValue) {
                    long now = OnHeapStore.this.timeSource.getTimeMillis();
                    if (mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                        OnHeapStore.this.onExpiration(mappedKey, mappedValue);
                        return null;
                    }
                    Object existingValue = mappedValue.value();
                    Object computedValue = remappingFunction.apply(mappedKey, existingValue);
                    if (computedValue == null) {
                        write.set(true);
                        return null;
                    }
                    if (OnHeapStore.eq(existingValue, computedValue) && !((Boolean)replaceEqual.apply()).booleanValue()) {
                        return OnHeapStore.this.setAccessTimeAndExpiryThenReturnMapping(key, mappedValue, now, false);
                    }
                    OnHeapStore.this.checkValue(computedValue);
                    long expirationTime = mappedValue.expirationTime(OnHeapValueHolder.TIME_UNIT);
                    write.set(true);
                    return OnHeapStore.this.newUpdateValueHolder(key, existingValue, computedValue, now, expirationTime);
                }
            });
            if (computeResult == null) {
                if (write.get()) {
                    this.computeIfPresentObserver.end((Enum)StoreOperationOutcomes.ComputeIfPresentOutcome.REMOVED);
                } else {
                    this.computeIfPresentObserver.end((Enum)StoreOperationOutcomes.ComputeIfPresentOutcome.MISS);
                }
            } else if (write.get()) {
                this.computeIfPresentObserver.end((Enum)StoreOperationOutcomes.ComputeIfPresentOutcome.PUT);
            } else {
                this.computeIfPresentObserver.end((Enum)StoreOperationOutcomes.ComputeIfPresentOutcome.HIT);
            }
            return computeResult;
        }
        catch (RuntimeException re) {
            CachePassThroughException.handleRuntimeException((RuntimeException)re);
            return null;
        }
    }

    public Map<K, Store.ValueHolder<V>> bulkComputeIfAbsent(Set<? extends K> keys, final Function<Iterable<? extends K>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> mappingFunction) throws CacheAccessException {
        HashMap<K, Store.ValueHolder<V>> result = new HashMap<K, Store.ValueHolder<V>>();
        for (K key : keys) {
            Store.ValueHolder<V> newValue = this.computeIfAbsent(key, new Function<K, V>(){

                public V apply(K k) {
                    Set keySet = Collections.singleton(k);
                    Iterable entries = (Iterable)mappingFunction.apply(keySet);
                    Iterator iterator = entries.iterator();
                    Map.Entry next = (Map.Entry)iterator.next();
                    Object computedKey = next.getKey();
                    Object computedValue = next.getValue();
                    OnHeapStore.this.checkKey(computedKey);
                    if (computedValue == null) {
                        return null;
                    }
                    OnHeapStore.this.checkValue(computedValue);
                    return computedValue;
                }
            });
            result.put(key, newValue);
        }
        return result;
    }

    public List<CacheConfigurationChangeListener> getConfigurationChangeListeners() {
        ArrayList<CacheConfigurationChangeListener> configurationChangeListenerList = new ArrayList<CacheConfigurationChangeListener>();
        configurationChangeListenerList.add(this.cacheConfigurationChangeListener);
        return configurationChangeListenerList;
    }

    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction) throws CacheAccessException {
        return this.bulkCompute(keys, remappingFunction, REPLACE_EQUALS_TRUE);
    }

    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, final Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction, NullaryFunction<Boolean> replaceEqual) throws CacheAccessException {
        HashMap<K, Store.ValueHolder<V>> result = new HashMap<K, Store.ValueHolder<V>>();
        for (K key : keys) {
            this.checkKey(key);
            Store.ValueHolder<V> newValue = this.compute(key, new BiFunction<K, V, V>(){

                public V apply(K k, V oldValue) {
                    Set entrySet = Collections.singletonMap(k, oldValue).entrySet();
                    Iterable entries = (Iterable)remappingFunction.apply(entrySet);
                    Iterator iterator = entries.iterator();
                    Map.Entry next = (Map.Entry)iterator.next();
                    Object key = next.getKey();
                    Object value = next.getValue();
                    OnHeapStore.this.checkKey(key);
                    if (value != null) {
                        OnHeapStore.this.checkValue(value);
                    }
                    return value;
                }
            }, replaceEqual);
            result.put(key, newValue);
        }
        return result;
    }

    public void enableStoreEventNotifications(StoreEventListener<K, V> listener) {
        this.eventListener = listener;
    }

    public void disableStoreEventNotifications() {
        this.eventListener = CacheEvents.nullStoreEventListener();
    }

    private OnHeapValueHolder<V> setAccessTimeAndExpiryThenReturnMapping(K key, OnHeapValueHolder<V> valueHolder, long now, boolean requiresLock) {
        Duration duration;
        try {
            duration = this.expiry.getExpiryForAccess(key, valueHolder.value());
        }
        catch (RuntimeException re) {
            LOG.error("Expiry computation caused an exception - Expiry duration will be 0 ", (Throwable)re);
            if (requiresLock) {
                this.expireMapping(key, (Store.ValueHolder<V>)valueHolder);
            } else {
                this.onExpiration(key, (Store.ValueHolder<V>)valueHolder);
            }
            return null;
        }
        valueHolder.accessed(now, duration);
        return valueHolder;
    }

    private void expireMapping(final K key, final Store.ValueHolder<V> value) {
        this.map.computeIfPresent(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

            public OnHeapValueHolder<V> apply(K mappedKey, OnHeapValueHolder<V> mappedValue) {
                if (mappedValue.equals(value)) {
                    OnHeapStore.this.onExpiration(key, value);
                    return null;
                }
                return mappedValue;
            }
        });
    }

    private OnHeapValueHolder<V> newUpdateValueHolder(K key, OnHeapValueHolder<V> oldValue, V newValue, long now) {
        if (oldValue == null) {
            throw new NullPointerException();
        }
        return this.newUpdateValueHolder(key, oldValue.value(), newValue, now, oldValue.expirationTime(OnHeapValueHolder.TIME_UNIT));
    }

    private OnHeapValueHolder<V> newUpdateValueHolder(K key, V oldValue, V newValue, long now, long oldExpirationTime) {
        Duration duration;
        if (newValue == null) {
            throw new NullPointerException();
        }
        try {
            duration = this.expiry.getExpiryForUpdate(key, oldValue, newValue);
        }
        catch (RuntimeException re) {
            LOG.error("Expiry computation caused an exception - Expiry duration will be 0 ", (Throwable)re);
            return null;
        }
        if (Duration.ZERO.equals((Object)duration)) {
            return null;
        }
        long expirationTime = duration == null ? oldExpirationTime : (duration.isForever() ? -1L : OnHeapStore.safeExpireTime(now, duration));
        return this.makeValue(newValue, now, expirationTime, this.valueCopier);
    }

    private OnHeapValueHolder<V> newCreateValueHolder(K key, V value, long now) {
        Duration duration;
        if (value == null) {
            throw new NullPointerException();
        }
        try {
            duration = this.expiry.getExpiryForCreation(key, value);
        }
        catch (RuntimeException re) {
            LOG.error("Expiry computation caused an exception - Expiry duration will be 0 ", (Throwable)re);
            return null;
        }
        if (Duration.ZERO.equals((Object)duration)) {
            return null;
        }
        long expirationTime = duration.isForever() ? -1L : OnHeapStore.safeExpireTime(now, duration);
        return this.makeValue(value, now, expirationTime, this.valueCopier);
    }

    private OnHeapValueHolder<V> importValueFromLowerTier(K key, Store.ValueHolder<V> valueHolder, long now) {
        Object realValue = valueHolder.value();
        Duration expiration = this.expiry.getExpiryForAccess(key, realValue);
        return this.cloneValueHolder(key, valueHolder, now, expiration);
    }

    private OnHeapValueHolder<V> cloneValueHolder(K key, Store.ValueHolder<V> valueHolder, long now, Duration expiration) {
        Object realValue = valueHolder.value();
        if (this.valueCopier instanceof SerializingCopier) {
            return new SerializedOnHeapValueHolder<Object>(valueHolder, realValue, ((SerializingCopier)this.valueCopier).getSerializer(), now, expiration);
        }
        return new CopiedOnHeapValueHolder<Object>(valueHolder, realValue, this.valueCopier, now, expiration);
    }

    private OnHeapValueHolder<V> makeValue(V value, long creationTime, long expirationTime, Copier<V> valueCopier) {
        if (valueCopier instanceof SerializingCopier) {
            return this.makeSerializedValue(value, creationTime, expirationTime, ((SerializingCopier)valueCopier).getSerializer());
        }
        return this.makeCopiedValue(value, creationTime, expirationTime, valueCopier);
    }

    private OnHeapValueHolder<V> makeSerializedValue(V value, long creationTime, long expirationTime, Serializer<V> valueSerializer) {
        return new SerializedOnHeapValueHolder<V>(value, creationTime, expirationTime, valueSerializer);
    }

    private OnHeapValueHolder<V> makeCopiedValue(V value, long creationTime, long expirationTime, Copier<V> valueCopier) {
        return new CopiedOnHeapValueHolder<V>(value, creationTime, expirationTime, valueCopier);
    }

    private static long safeExpireTime(long now, Duration duration) {
        long millis = OnHeapValueHolder.TIME_UNIT.convert(duration.getAmount(), duration.getTimeUnit());
        if (millis == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        long result = now + millis;
        if (result < 0L) {
            return Long.MAX_VALUE;
        }
        return result;
    }

    private void enforceCapacity(int delta) {
        int evicted = 0;
        for (int attempts = 0; attempts < 4 * delta && evicted < 2 * delta && this.capacity < (long)this.map.size(); ++attempts) {
            if (!this.evict()) continue;
            ++evicted;
        }
    }

    boolean evict() {
        Map.Entry<K, OnHeapValueHolder<V>> tmpEvict;
        this.evictionObserver.begin();
        Random random = new Random();
        Set<Map.Entry<K, OnHeapValueHolder<V>>> values = this.map.getRandomValues(random, 8, this.evictionVeto);
        if (values.isEmpty()) {
            values = this.map.getRandomValues(random, 8, Predicates.none());
        }
        if (values.isEmpty()) {
            return false;
        }
        try {
            tmpEvict = Collections.max(values, this.evictionPrioritizer);
        }
        catch (Exception e) {
            LOG.error("Exception raised when prioritizing eviction candidates - eviction will continue simply picking first candidate", (Throwable)e);
            tmpEvict = values.iterator().next();
        }
        final Map.Entry<K, OnHeapValueHolder<V>> evictionCandidate = tmpEvict;
        final AtomicBoolean removed = new AtomicBoolean(false);
        this.map.computeIfPresent(evictionCandidate.getKey(), new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

            public OnHeapValueHolder<V> apply(K mappedKey, OnHeapValueHolder<V> mappedValue) {
                if (mappedValue.equals(evictionCandidate.getValue())) {
                    removed.set(true);
                    OnHeapStore.this.eventListener.onEviction(evictionCandidate.getKey(), (Store.ValueHolder)evictionCandidate.getValue());
                    return null;
                }
                return mappedValue;
            }
        });
        if (removed.get()) {
            this.evictionObserver.end((Enum)StoreOperationOutcomes.EvictionOutcome.SUCCESS);
            return true;
        }
        this.evictionObserver.end((Enum)StoreOperationOutcomes.EvictionOutcome.FAILURE);
        return false;
    }

    private void checkKey(K keyObject) {
        if (keyObject == null) {
            throw new NullPointerException();
        }
        if (!this.keyType.isAssignableFrom(keyObject.getClass())) {
            throw new ClassCastException("Invalid key type, expected : " + this.keyType.getName() + " but was : " + keyObject.getClass().getName());
        }
    }

    private void checkValue(V valueObject) {
        if (valueObject == null) {
            throw new NullPointerException();
        }
        if (!this.valueType.isAssignableFrom(valueObject.getClass())) {
            throw new ClassCastException("Invalid value type, expected : " + this.valueType.getName() + " but was : " + valueObject.getClass().getName());
        }
    }

    private void onExpiration(K mappedKey, Store.ValueHolder<V> mappedValue) {
        this.expirationObserver.begin();
        this.expirationObserver.end((Enum)StoreOperationOutcomes.ExpirationOutcome.SUCCESS);
        this.eventListener.onExpiration(mappedKey, mappedValue);
    }

    private static boolean eq(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    private static <K, V> Predicate<Map.Entry<K, OnHeapValueHolder<V>>> wrap(final Predicate<Cache.Entry<K, V>> predicate, final TimeSource timeSource) {
        if (predicate == null) {
            return Predicates.none();
        }
        return new Predicate<Map.Entry<K, OnHeapValueHolder<V>>>(){

            public boolean test(Map.Entry<K, OnHeapValueHolder<V>> argument) {
                try {
                    return argument.getValue() instanceof Fault || predicate.test((Object)OnHeapStore.wrap(argument, timeSource));
                }
                catch (Exception e) {
                    LOG.error("Exception raised while running eviction veto - Eviction will assume entry is NOT vetoed", (Throwable)e);
                    return false;
                }
            }
        };
    }

    private static <K, V> Comparator<Map.Entry<K, OnHeapValueHolder<V>>> wrap(final Comparator<Cache.Entry<K, V>> comparator, final TimeSource timeSource) {
        return new Comparator<Map.Entry<K, OnHeapValueHolder<V>>>(){

            @Override
            public int compare(Map.Entry<K, OnHeapValueHolder<V>> t, Map.Entry<K, OnHeapValueHolder<V>> u) {
                if (t.getValue() instanceof Fault) {
                    return -1;
                }
                if (u.getValue() instanceof Fault) {
                    return 1;
                }
                return comparator.compare(OnHeapStore.wrap(t, timeSource), OnHeapStore.wrap(u, timeSource));
            }
        };
    }

    private static <K, V> Cache.Entry<K, V> wrap(Map.Entry<K, OnHeapValueHolder<V>> value, TimeSource timeSource) {
        return CacheStoreHelper.cacheEntry(value.getKey(), (Store.ValueHolder)((Store.ValueHolder)value.getValue()), (TimeSource)timeSource);
    }

    private static final class OnHeapStoreStatsSettings {
        @ContextAttribute(value="tags")
        private final Set<String> tags = new HashSet<String>(Arrays.asList("store"));
        @ContextAttribute(value="cachingTier")
        private final CachingTier<?, ?> cachingTier = null;
        @ContextAttribute(value="authoritativeTier")
        private final OnHeapStore<?, ?> authoritativeTier;

        OnHeapStoreStatsSettings(OnHeapStore<?, ?> onHeapStore) {
            this.authoritativeTier = onHeapStore;
        }
    }

    private static class MapWrapper<K, V> {
        private final ConcurrentHashMap<OnHeapKey<K>, OnHeapValueHolder<V>> keyCopyMap;
        private final Copier<K> keyCopier;

        MapWrapper(Copier<K> keyCopier) {
            this.keyCopier = keyCopier;
            this.keyCopyMap = new ConcurrentHashMap();
        }

        boolean remove(K key, OnHeapValueHolder<V> value) {
            return this.keyCopyMap.remove(this.lookupOnlyKey(key), value);
        }

        Set<Map.Entry<K, OnHeapValueHolder<V>>> getRandomValues(Random random, int size, final Predicate<Map.Entry<K, OnHeapValueHolder<V>>> veto) {
            Set<Map.Entry<OnHeapKey<K>, OnHeapValueHolder<V>>> values = this.keyCopyMap.getRandomValues(random, size, new Predicate<Map.Entry<OnHeapKey<K>, OnHeapValueHolder<V>>>(){

                public boolean test(Map.Entry<OnHeapKey<K>, OnHeapValueHolder<V>> entry) {
                    return veto.test(new AbstractMap.SimpleEntry(entry.getKey().getActualKeyObject(), entry.getValue()));
                }
            });
            LinkedHashSet<Map.Entry<K, OnHeapValueHolder<V>>> rv = new LinkedHashSet<Map.Entry<K, OnHeapValueHolder<V>>>(values.size());
            for (Map.Entry<OnHeapKey<K>, OnHeapValueHolder<V>> entry : values) {
                rv.add(new AbstractMap.SimpleEntry<K, OnHeapValueHolder<V>>(entry.getKey().getActualKeyObject(), entry.getValue()));
            }
            return rv;
        }

        int size() {
            return this.keyCopyMap.size();
        }

        Iterator<Map.Entry<K, OnHeapValueHolder<V>>> entrySetIterator() {
            final Iterator<Map.Entry<OnHeapKey<K>, OnHeapValueHolder<V>>> iter = this.keyCopyMap.entrySet().iterator();
            return new Iterator<Map.Entry<K, OnHeapValueHolder<V>>>(){

                @Override
                public boolean hasNext() {
                    return iter.hasNext();
                }

                @Override
                public Map.Entry<K, OnHeapValueHolder<V>> next() {
                    Map.Entry entry = (Map.Entry)iter.next();
                    return new AbstractMap.SimpleEntry(((OnHeapKey)entry.getKey()).getActualKeyObject(), entry.getValue());
                }

                @Override
                public void remove() {
                    iter.remove();
                }
            };
        }

        OnHeapValueHolder<V> compute(final K key, final BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>> computeFunction) {
            return this.keyCopyMap.compute(this.makeKey(key), new BiFunction<OnHeapKey<K>, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

                public OnHeapValueHolder<V> apply(OnHeapKey<K> mappedKey, OnHeapValueHolder<V> mappedValue) {
                    return (OnHeapValueHolder)((Object)computeFunction.apply(key, mappedValue));
                }
            });
        }

        void clear() {
            this.keyCopyMap.clear();
        }

        OnHeapValueHolder<V> remove(K key) {
            return this.keyCopyMap.remove(this.lookupOnlyKey(key));
        }

        OnHeapValueHolder<V> computeIfPresent(final K key, final BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>> computeFunction) {
            return this.keyCopyMap.computeIfPresent(this.lookupOnlyKey(key), new BiFunction<OnHeapKey<K>, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

                public OnHeapValueHolder<V> apply(OnHeapKey<K> mappedKey, OnHeapValueHolder<V> mappedValue) {
                    return (OnHeapValueHolder)((Object)computeFunction.apply(key, mappedValue));
                }
            });
        }

        private OnHeapKey<K> makeKey(K key) {
            return new CopiedOnHeapKey<K>(key, this.keyCopier);
        }

        private OnHeapKey<K> lookupOnlyKey(K key) {
            return new LookupOnlyOnHeapKey<K>(key);
        }

        public OnHeapValueHolder<V> get(K key) {
            return this.keyCopyMap.get(this.lookupOnlyKey(key));
        }

        public OnHeapValueHolder<V> putIfAbsent(K key, OnHeapValueHolder<V> valueHolder) {
            return this.keyCopyMap.putIfAbsent(this.makeKey(key), valueHolder);
        }

        public boolean replace(K key, OnHeapValueHolder<V> oldValue, OnHeapValueHolder<V> newValue) {
            return this.keyCopyMap.replace(this.lookupOnlyKey(key), oldValue, newValue);
        }
    }

    @ServiceDependencies(value={TimeSourceService.class, CopyProvider.class})
    public static class Provider
    implements Store.Provider,
    CachingTier.Provider,
    HigherCachingTier.Provider {
        private volatile ServiceProvider serviceProvider;
        private final Set<Store<?, ?>> createdStores = Collections.newSetFromMap(new ConcurrentWeakIdentityHashMap());

        public <K, V> OnHeapStore<K, V> createStore(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?> ... serviceConfigs) {
            TimeSource timeSource = ((TimeSourceService)this.serviceProvider.getService(TimeSourceService.class)).getTimeSource();
            CopyProvider copyProvider = (CopyProvider)this.serviceProvider.getService(CopyProvider.class);
            Copier keyCopier = copyProvider.createKeyCopier(storeConfig.getKeyType(), storeConfig.getKeySerializer(), serviceConfigs);
            Copier valueCopier = copyProvider.createValueCopier(storeConfig.getValueType(), storeConfig.getValueSerializer(), serviceConfigs);
            OnHeapStore<K, V> onHeapStore = new OnHeapStore<K, V>(storeConfig, timeSource, keyCopier, valueCopier);
            this.createdStores.add(onHeapStore);
            return onHeapStore;
        }

        public void releaseStore(Store<?, ?> resource) {
            if (!this.createdStores.remove(resource)) {
                throw new IllegalArgumentException("Given store is not managed by this provider : " + resource);
            }
            OnHeapStore onHeapStore = (OnHeapStore)resource;
            Provider.close(onHeapStore);
        }

        static void close(OnHeapStore onHeapStore) {
            onHeapStore.map.clear();
            onHeapStore.disableStoreEventNotifications();
        }

        public void initStore(Store<?, ?> resource) {
            this.checkResource(resource);
        }

        private void checkResource(Object resource) {
            if (!this.createdStores.contains(resource)) {
                throw new IllegalArgumentException("Given store is not managed by this provider : " + resource);
            }
        }

        public void start(ServiceProvider serviceProvider) {
            this.serviceProvider = serviceProvider;
        }

        public void stop() {
            this.serviceProvider = null;
            this.createdStores.clear();
        }

        public <K, V> CachingTier<K, V> createCachingTier(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?> ... serviceConfigs) {
            return this.createStore((Store.Configuration)storeConfig, (ServiceConfiguration[])serviceConfigs);
        }

        public void releaseCachingTier(CachingTier<?, ?> resource) {
            this.checkResource(resource);
            ((OnHeapStore)resource).invalidate();
            this.releaseStore((Store)resource);
        }

        public void initCachingTier(CachingTier<?, ?> resource) {
            this.initStore((Store)resource);
        }

        public <K, V> HigherCachingTier<K, V> createHigherCachingTier(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?> ... serviceConfigs) {
            return this.createStore((Store.Configuration)storeConfig, (ServiceConfiguration[])serviceConfigs);
        }

        public void releaseHigherCachingTier(HigherCachingTier<?, ?> resource) {
            this.releaseCachingTier((CachingTier<?, ?>)resource);
        }

        public void initHigherCachingTier(HigherCachingTier<?, ?> resource) {
            this.initStore((Store)resource);
        }
    }

    private static class Fault<V>
    extends OnHeapValueHolder<V> {
        private static final int FAULT_ID = -1;
        private final NullaryFunction<Store.ValueHolder<V>> source;
        private Store.ValueHolder<V> value;
        private Throwable throwable;
        private boolean complete;

        public Fault(NullaryFunction<Store.ValueHolder<V>> source) {
            super(-1L, 0L);
            this.source = source;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void complete(Store.ValueHolder<V> value) {
            Fault fault = this;
            synchronized (fault) {
                this.value = value;
                this.complete = true;
                ((Object)((Object)this)).notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Store.ValueHolder<V> get() {
            Fault fault = this;
            synchronized (fault) {
                if (!this.complete) {
                    try {
                        this.complete((Store.ValueHolder)this.source.apply());
                    }
                    catch (Throwable e) {
                        this.fail(e);
                    }
                }
            }
            return this.throwOrReturn();
        }

        public long getId() {
            throw new UnsupportedOperationException("You should NOT call that?!");
        }

        private Store.ValueHolder<V> throwOrReturn() {
            if (this.throwable != null) {
                if (this.throwable instanceof RuntimeException) {
                    throw (RuntimeException)this.throwable;
                }
                throw new RuntimeException("Faulting from repository failed", this.throwable);
            }
            return this.value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fail(Throwable t) {
            Fault fault = this;
            synchronized (fault) {
                this.throwable = t;
                this.complete = true;
                ((Object)((Object)this)).notifyAll();
            }
            this.throwOrReturn();
        }

        public V value() {
            throw new UnsupportedOperationException();
        }

        public long creationTime(TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        public void setExpirationTime(long expirationTime, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        public long expirationTime(TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        public boolean isExpired(long expirationTime, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        public long lastAccessTime(TimeUnit unit) {
            return Long.MAX_VALUE;
        }

        public void setLastAccessTime(long lastAccessTime, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "[Fault : " + (this.complete ? (this.throwable == null ? this.value.toString() : this.throwable.getMessage()) : "???") + "]";
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this;
        }
    }
}

