/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.internal.store.disk;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.ehcache.CacheConfigurationChangeListener;
import org.ehcache.Status;
import org.ehcache.config.EvictionVeto;
import org.ehcache.config.ResourcePool;
import org.ehcache.config.ResourceType;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.exceptions.CachePersistenceException;
import org.ehcache.function.Predicate;
import org.ehcache.function.Predicates;
import org.ehcache.internal.TimeSource;
import org.ehcache.internal.TimeSourceService;
import org.ehcache.internal.store.disk.DiskWriteThreadPool;
import org.ehcache.internal.store.disk.EhcachePersistentConcurrentOffHeapClockCache;
import org.ehcache.internal.store.disk.factories.EhcachePersistentSegmentFactory;
import org.ehcache.internal.store.offheap.AbstractOffHeapStore;
import org.ehcache.internal.store.offheap.EhcacheOffHeapBackingMap;
import org.ehcache.internal.store.offheap.OffHeapValueHolder;
import org.ehcache.internal.store.offheap.portability.OffHeapValueHolderPortability;
import org.ehcache.internal.store.offheap.portability.SerializerPortability;
import org.ehcache.spi.ServiceLocator;
import org.ehcache.spi.ServiceProvider;
import org.ehcache.spi.cache.Store;
import org.ehcache.spi.cache.tiering.AuthoritativeTier;
import org.ehcache.spi.serialization.SerializationProvider;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.service.FileBasedPersistenceContext;
import org.ehcache.spi.service.LocalPersistenceService;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceDependencies;
import org.ehcache.spi.service.SupplementaryService;
import org.ehcache.util.ConcurrentWeakIdentityHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.offheapstore.disk.paging.MappedPageSource;
import org.terracotta.offheapstore.disk.persistent.Persistent;
import org.terracotta.offheapstore.disk.persistent.PersistentPortability;
import org.terracotta.offheapstore.disk.storage.FileBackedStorageEngine;
import org.terracotta.offheapstore.storage.portability.Portability;
import org.terracotta.offheapstore.util.Factory;

public class OffHeapDiskStore<K, V>
extends AbstractOffHeapStore<K, V>
implements AuthoritativeTier<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OffHeapDiskStore.class);
    protected final AtomicReference<Status> status = new AtomicReference<Status>(Status.UNINITIALIZED);
    private final Predicate<Map.Entry<K, OffHeapValueHolder<V>>> evictionVeto;
    private final Serializer<K> keySerializer;
    private final Serializer<V> valueSerializer;
    private final long sizeInBytes;
    private final FileBasedPersistenceContext fileBasedPersistenceContext;
    private volatile EhcachePersistentConcurrentOffHeapClockCache<K, OffHeapValueHolder<V>> map;

    public OffHeapDiskStore(FileBasedPersistenceContext fileBasedPersistenceContext, Store.Configuration<K, V> config, TimeSource timeSource, long sizeInBytes) {
        super("local-disk", config, timeSource);
        this.fileBasedPersistenceContext = fileBasedPersistenceContext;
        EvictionVeto veto = config.getEvictionVeto();
        this.evictionVeto = veto != null ? OffHeapDiskStore.wrap(veto, timeSource) : Predicates.none();
        this.keySerializer = config.getKeySerializer();
        this.valueSerializer = config.getValueSerializer();
        this.sizeInBytes = sizeInBytes;
        if (!this.status.compareAndSet(Status.UNINITIALIZED, Status.AVAILABLE)) {
            throw new AssertionError();
        }
    }

    public List<CacheConfigurationChangeListener> getConfigurationChangeListeners() {
        return Collections.emptyList();
    }

    private EhcachePersistentConcurrentOffHeapClockCache<K, OffHeapValueHolder<V>> getBackingMap(long size, Serializer<K> keySerializer, Serializer<V> valueSerializer, Predicate<Map.Entry<K, OffHeapValueHolder<V>>> evictionVeto) {
        File dataFile = this.getDataFile();
        File indexFile = this.getIndexFile();
        if (dataFile.isFile() && indexFile.isFile()) {
            try {
                return this.recoverBackingMap(size, keySerializer, valueSerializer, evictionVeto);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.createBackingMap(size, keySerializer, valueSerializer, evictionVeto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EhcachePersistentConcurrentOffHeapClockCache<K, OffHeapValueHolder<V>> recoverBackingMap(long size, Serializer<K> keySerializer, Serializer<V> valueSerializer, Predicate<Map.Entry<K, OffHeapValueHolder<V>>> evictionVeto) throws IOException {
        File dataFile = this.getDataFile();
        File indexFile = this.getIndexFile();
        FileInputStream fin = new FileInputStream(indexFile);
        try {
            ObjectInputStream input = new ObjectInputStream(fin);
            long dataTimestampFromIndex = input.readLong();
            long dataTimestampFromFile = dataFile.lastModified();
            long delta = dataTimestampFromFile - dataTimestampFromIndex;
            if (delta < 0L) {
                LOGGER.info("The index for data file {} is more recent than the data file itself by {}ms : this is harmless.", (Object)dataFile.getName(), (Object)(-delta));
            } else {
                if (delta > TimeUnit.SECONDS.toMillis(1L)) {
                    LOGGER.warn("The index for data file {} is out of date by {}ms, probably due to an unclean shutdown. Creating a new empty store.", (Object)dataFile.getName(), (Object)delta);
                    EhcachePersistentConcurrentOffHeapClockCache<K, OffHeapValueHolder<V>> ehcachePersistentConcurrentOffHeapClockCache = this.createBackingMap(size, keySerializer, valueSerializer, evictionVeto);
                    return ehcachePersistentConcurrentOffHeapClockCache;
                }
                if (delta > 0L) {
                    LOGGER.info("The index for data file {} is out of date by {}ms, assuming this small delta is a result of the OS/filesystem.", (Object)dataFile.getName(), (Object)delta);
                }
            }
            MappedPageSource source = new MappedPageSource(dataFile, false, size);
            try {
                PersistentPortability<K> keyPortability = OffHeapDiskStore.persistent(new SerializerPortability<K>(keySerializer));
                PersistentPortability<V> elementPortability = OffHeapDiskStore.persistent(new OffHeapValueHolderPortability<V>(valueSerializer));
                DiskWriteThreadPool writeWorkers = new DiskWriteThreadPool("identifier", 1);
                Factory storageEngineFactory = FileBackedStorageEngine.createFactory((MappedPageSource)source, keyPortability, elementPortability, (Factory)writeWorkers, (boolean)false);
                EhcachePersistentSegmentFactory<K, OffHeapValueHolder<V>> factory = new EhcachePersistentSegmentFactory<K, OffHeapValueHolder<V>>(source, storageEngineFactory, 64, evictionVeto, this.mapEvictionListener, false);
                EhcachePersistentConcurrentOffHeapClockCache<K, OffHeapValueHolder<V>> m = new EhcachePersistentConcurrentOffHeapClockCache<K, OffHeapValueHolder<V>>(input, factory);
                m.bootstrap(input);
                EhcachePersistentConcurrentOffHeapClockCache<K, OffHeapValueHolder<V>> ehcachePersistentConcurrentOffHeapClockCache = m;
                return ehcachePersistentConcurrentOffHeapClockCache;
            }
            catch (IOException e) {
                try {
                    source.close();
                    throw e;
                }
                catch (Exception e2) {
                    LOGGER.info("Index file was corrupt. Deleting data file " + dataFile.getAbsolutePath() + ". " + e2.getMessage());
                    LOGGER.debug("Exception during recovery", (Throwable)e2);
                    EhcachePersistentConcurrentOffHeapClockCache<K, OffHeapValueHolder<V>> ehcachePersistentConcurrentOffHeapClockCache = this.createBackingMap(size, keySerializer, valueSerializer, evictionVeto);
                    return ehcachePersistentConcurrentOffHeapClockCache;
                }
            }
        }
        finally {
            fin.close();
        }
    }

    private EhcachePersistentConcurrentOffHeapClockCache<K, OffHeapValueHolder<V>> createBackingMap(long size, Serializer<K> keySerializer, Serializer<V> valueSerializer, Predicate<Map.Entry<K, OffHeapValueHolder<V>>> evictionVeto) {
        MappedPageSource source;
        try {
            source = new MappedPageSource(this.getDataFile(), size);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        PersistentPortability<K> keyPortability = OffHeapDiskStore.persistent(new SerializerPortability<K>(keySerializer));
        PersistentPortability<V> elementPortability = OffHeapDiskStore.persistent(new OffHeapValueHolderPortability<V>(valueSerializer));
        DiskWriteThreadPool writeWorkers = new DiskWriteThreadPool("identifier", 1);
        Factory storageEngineFactory = FileBackedStorageEngine.createFactory((MappedPageSource)source, keyPortability, elementPortability, (Factory)writeWorkers, (boolean)true);
        EhcachePersistentSegmentFactory<K, OffHeapValueHolder<V>> factory = new EhcachePersistentSegmentFactory<K, OffHeapValueHolder<V>>(source, storageEngineFactory, 64, evictionVeto, this.mapEvictionListener, true);
        return new EhcachePersistentConcurrentOffHeapClockCache<K, OffHeapValueHolder<V>>(factory, 16);
    }

    @Override
    protected EhcacheOffHeapBackingMap<K, OffHeapValueHolder<V>> backingMap() {
        return this.map;
    }

    private File getDataFile() {
        return new File(this.fileBasedPersistenceContext.getDirectory(), "ehcache-disk-store.data");
    }

    private File getIndexFile() {
        return new File(this.fileBasedPersistenceContext.getDirectory(), "ehcache-disk-store.index");
    }

    public static <T> PersistentPortability<T> persistent(final Portability<T> normal) {
        Class<?> normalKlazz = normal.getClass();
        Class<?>[] delegateInterfaces = normalKlazz.getInterfaces();
        Class<?>[] proxyInterfaces = Arrays.copyOf(delegateInterfaces, delegateInterfaces.length + 1);
        proxyInterfaces[delegateInterfaces.length] = PersistentPortability.class;
        return (PersistentPortability)Proxy.newProxyInstance(normal.getClass().getClassLoader(), proxyInterfaces, new InvocationHandler(){

            @Override
            public Object invoke(Object o, Method method, Object[] os) throws Throwable {
                if (method.getDeclaringClass().equals(Persistent.class)) {
                    return null;
                }
                return method.invoke((Object)normal, os);
            }
        });
    }

    @SupplementaryService
    @ServiceDependencies(value={TimeSourceService.class, SerializationProvider.class})
    public static class Provider
    implements Store.Provider,
    AuthoritativeTier.Provider {
        private volatile ServiceProvider serviceProvider;
        private final Set<Store<?, ?>> createdStores = Collections.newSetFromMap(new ConcurrentWeakIdentityHashMap());

        public <K, V> OffHeapDiskStore<K, V> createStore(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?> ... serviceConfigs) {
            if (this.serviceProvider == null) {
                throw new NullPointerException("ServiceProvider is null in OffHeapDiskStore.Provider.");
            }
            TimeSource timeSource = ((TimeSourceService)this.serviceProvider.getService(TimeSourceService.class)).getTimeSource();
            ResourcePool offHeapPool = storeConfig.getResourcePools().getPoolForResource((ResourceType)ResourceType.Core.DISK);
            if (!(offHeapPool.getUnit() instanceof MemoryUnit)) {
                throw new IllegalArgumentException("OffHeapDiskStore only supports resources configuration expressed in \"memory\" unit");
            }
            MemoryUnit unit = (MemoryUnit)offHeapPool.getUnit();
            LocalPersistenceService localPersistenceService = (LocalPersistenceService)this.serviceProvider.getService(LocalPersistenceService.class);
            if (localPersistenceService == null) {
                throw new IllegalStateException("No LocalPersistenceService could be found - did you configure it at the CacheManager level?");
            }
            LocalPersistenceService.PersistenceSpaceIdentifier space = (LocalPersistenceService.PersistenceSpaceIdentifier)ServiceLocator.findSingletonAmongst(LocalPersistenceService.PersistenceSpaceIdentifier.class, (Object[])serviceConfigs);
            try {
                FileBasedPersistenceContext persistenceContext = localPersistenceService.createPersistenceContextWithin(space, "offheap-disk-store");
                OffHeapDiskStore<K, V> offHeapStore = new OffHeapDiskStore<K, V>(persistenceContext, storeConfig, timeSource, unit.toBytes(offHeapPool.getSize()));
                this.createdStores.add((Store<?, ?>)offHeapStore);
                return offHeapStore;
            }
            catch (CachePersistenceException cpex) {
                throw new RuntimeException("Unable to create persistence context in " + space, cpex);
            }
        }

        public void releaseStore(Store<?, ?> resource) {
            if (!this.createdStores.contains(resource)) {
                throw new IllegalArgumentException("Given store is not managed by this provider : " + resource);
            }
            try {
                Provider.close((OffHeapDiskStore)resource);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static <K, V> void close(OffHeapDiskStore<K, V> resource) throws IOException {
            EhcachePersistentConcurrentOffHeapClockCache localMap = ((OffHeapDiskStore)resource).map;
            if (localMap != null) {
                ((OffHeapDiskStore)resource).map = null;
                localMap.flush();
                ObjectOutputStream output = new ObjectOutputStream(new FileOutputStream(((OffHeapDiskStore)resource).getIndexFile()));
                try {
                    output.writeLong(System.currentTimeMillis());
                    localMap.persist(output);
                }
                finally {
                    output.close();
                }
                localMap.close();
            }
        }

        public void initStore(Store<?, ?> resource) {
            if (!this.createdStores.contains(resource)) {
                throw new IllegalArgumentException("Given store is not managed by this provider : " + resource);
            }
            Provider.init((OffHeapDiskStore)resource);
        }

        static <K, V> void init(OffHeapDiskStore<K, V> resource) {
            ((OffHeapDiskStore)resource).map = ((OffHeapDiskStore)resource).getBackingMap(((OffHeapDiskStore)resource).sizeInBytes, ((OffHeapDiskStore)resource).keySerializer, ((OffHeapDiskStore)resource).valueSerializer, ((OffHeapDiskStore)resource).evictionVeto);
        }

        public void start(ServiceProvider serviceProvider) {
            this.serviceProvider = serviceProvider;
        }

        public void stop() {
            this.serviceProvider = null;
            this.createdStores.clear();
        }

        public <K, V> AuthoritativeTier<K, V> createAuthoritativeTier(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?> ... serviceConfigs) {
            return this.createStore(storeConfig, serviceConfigs);
        }

        public void releaseAuthoritativeTier(AuthoritativeTier<?, ?> resource) {
            this.releaseStore((Store<?, ?>)resource);
        }

        public void initAuthoritativeTier(AuthoritativeTier<?, ?> resource) {
            this.initStore((Store<?, ?>)resource);
        }
    }
}

