/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.internal.store.disk;

import java.io.IOException;
import java.io.ObjectInput;
import java.util.concurrent.atomic.AtomicLong;
import org.ehcache.function.BiFunction;
import org.ehcache.function.Function;
import org.ehcache.internal.store.disk.factories.EhcachePersistentSegmentFactory;
import org.ehcache.internal.store.offheap.EhcacheOffHeapBackingMap;
import org.terracotta.offheapstore.disk.persistent.AbstractPersistentConcurrentOffHeapCache;

public class EhcachePersistentConcurrentOffHeapClockCache<K, V>
extends AbstractPersistentConcurrentOffHeapCache<K, V>
implements EhcacheOffHeapBackingMap<K, V> {
    private final AtomicLong[] counters;

    public EhcachePersistentConcurrentOffHeapClockCache(ObjectInput input, EhcachePersistentSegmentFactory<K, V> segmentFactory) throws IOException {
        this(segmentFactory, EhcachePersistentConcurrentOffHeapClockCache.readSegmentCount((ObjectInput)input));
    }

    public EhcachePersistentConcurrentOffHeapClockCache(EhcachePersistentSegmentFactory<K, V> segmentFactory, int concurrency) {
        super(segmentFactory, concurrency);
        this.counters = new AtomicLong[this.segments.length];
        for (int i = 0; i < this.segments.length; ++i) {
            this.counters[i] = new AtomicLong();
        }
    }

    @Override
    public V compute(K key, BiFunction<K, V, V> mappingFunction, boolean pin) {
        EhcachePersistentSegmentFactory.EhcachePersistentSegment segment = (EhcachePersistentSegmentFactory.EhcachePersistentSegment)this.segmentFor(key);
        return segment.compute(key, mappingFunction, pin);
    }

    @Override
    public V computeIfPresent(K key, BiFunction<K, V, V> mappingFunction) {
        EhcachePersistentSegmentFactory.EhcachePersistentSegment segment = (EhcachePersistentSegmentFactory.EhcachePersistentSegment)this.segmentFor(key);
        return segment.computeIfPresent(key, mappingFunction);
    }

    @Override
    public boolean computeIfPinned(K key, BiFunction<K, V, V> remappingFunction, Function<V, Boolean> pinningFunction) {
        EhcachePersistentSegmentFactory.EhcachePersistentSegment segment = (EhcachePersistentSegmentFactory.EhcachePersistentSegment)this.segmentFor(key);
        return segment.computeIfPinned(key, remappingFunction, pinningFunction);
    }

    @Override
    public long nextIdFor(K key) {
        return this.counters[this.getIndexFor(key.hashCode())].getAndIncrement();
    }
}

