/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.spi.serialization;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.ehcache.config.SerializerConfiguration;
import org.ehcache.config.serializer.DefaultSerializationProviderConfiguration;
import org.ehcache.config.serializer.DefaultSerializerConfiguration;
import org.ehcache.internal.classes.ClassInstanceProvider;
import org.ehcache.internal.serialization.JavaSerializer;
import org.ehcache.spi.ServiceLocator;
import org.ehcache.spi.ServiceProvider;
import org.ehcache.spi.serialization.SerializationProvider;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.service.ServiceConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSerializationProvider
extends ClassInstanceProvider<Serializer<?>>
implements SerializationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSerializationProvider.class);

    public DefaultSerializationProvider(DefaultSerializationProviderConfiguration configuration) {
        super(configuration, DefaultSerializerConfiguration.class);
    }

    public <T> Serializer<T> createKeySerializer(Class<T> clazz, ClassLoader classLoader, ServiceConfiguration<?> ... configs) {
        DefaultSerializerConfiguration<T> conf = DefaultSerializationProvider.find(SerializerConfiguration.Type.KEY, configs);
        return this.createSerializer(clazz, classLoader, conf);
    }

    public <T> Serializer<T> createValueSerializer(Class<T> clazz, ClassLoader classLoader, ServiceConfiguration<?> ... configs) {
        DefaultSerializerConfiguration<T> conf = DefaultSerializationProvider.find(SerializerConfiguration.Type.VALUE, configs);
        return this.createSerializer(clazz, classLoader, conf);
    }

    private <T> Serializer<T> createSerializer(Class<T> clazz, ClassLoader classLoader, DefaultSerializerConfiguration<T> config) {
        String alias = config != null ? null : clazz.getName();
        Serializer serializer = (Serializer)this.newInstance(alias, (ServiceConfiguration<?>)config, new ClassInstanceProvider.ConstructorArgument<ClassLoader>(ClassLoader.class, classLoader));
        if (serializer == null) {
            throw new IllegalArgumentException("No serializer found for type '" + alias + "'");
        }
        LOG.info("Serializer for <{}> : {}", (Object)clazz.getName(), (Object)serializer);
        return serializer;
    }

    @Override
    protected Class<? extends Serializer<?>> getPreconfigured(String alias, ClassInstanceProvider.ConstructorArgument<?> ... ctorArgs) {
        Class<?> targetSerializedClass;
        Class direct = (Class)this.preconfiguredLoaders.get(alias);
        if (direct != null) {
            return direct;
        }
        ClassLoader classLoader = (ClassLoader)ctorArgs[0].getVal();
        try {
            targetSerializedClass = Class.forName(alias, true, classLoader);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalArgumentException("Configured type class '" + alias + "' not found", cnfe);
        }
        for (Map.Entry entry : this.preconfiguredLoaders.entrySet()) {
            try {
                Class<?> configuredSerializedClass = Class.forName((String)entry.getKey(), true, classLoader);
                if (!configuredSerializedClass.isAssignableFrom(targetSerializedClass)) continue;
                return (Class)entry.getValue();
            }
            catch (ClassNotFoundException cnfe) {
                throw new IllegalArgumentException("Configured type class '" + (String)entry.getKey() + "' for serializer '" + entry.getValue() + "' not found", cnfe);
            }
        }
        return null;
    }

    @Override
    public void start(ServiceProvider serviceProvider) {
        super.start(serviceProvider);
        this.addDefaultSerializer();
    }

    protected void addDefaultSerializer() {
        if (!this.preconfiguredLoaders.containsKey(Serializable.class.getName())) {
            this.preconfiguredLoaders.put(Serializable.class.getName(), JavaSerializer.class);
        }
    }

    private static <T> DefaultSerializerConfiguration<T> find(SerializerConfiguration.Type type, ServiceConfiguration<?> ... serviceConfigurations) {
        DefaultSerializerConfiguration result = null;
        Collection serializationProviderConfigurations = ServiceLocator.findAmongst(DefaultSerializerConfiguration.class, (Object[])serviceConfigurations);
        for (DefaultSerializerConfiguration serializationProviderConfiguration : serializationProviderConfigurations) {
            if (serializationProviderConfiguration.getType() != type) continue;
            if (result != null) {
                throw new IllegalArgumentException("Duplicate " + type + " serialization provider : " + serializationProviderConfiguration);
            }
            result = serializationProviderConfiguration;
        }
        return result;
    }
}

